/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.global.tools.attributesetter;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeType;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeTypeDataType;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IValueRange;
import com.arcway.cockpit.client.base.interfaces.frame.gui.ISWTControlModifiedListener;
import com.arcway.cockpit.frame.client.global.Messages;
import java.util.Collections;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class AttributeSetterChooseValueWizardPage
extends WizardPage {
    private static final String PAGENAME_VALUEPREFIX = "value.";
    private final IAttributeType attributeType;
    private Object attributeValue;
    private IAttributeTypeDataType.ISWTControlForModification valueControl;

    static String getPageName(IAttributeType attributeType) {
        return PAGENAME_VALUEPREFIX + attributeType.getAttributeTypeID().getUID();
    }

    public AttributeSetterChooseValueWizardPage(IAttributeType attributeType, int nrOfSelectedElements) {
        super(AttributeSetterChooseValueWizardPage.getPageName(attributeType));
        this.attributeType = attributeType;
        this.setTitle(Messages.getString("AttributeSetterChooseValueWizardPage.Title"));
        this.setDescription(NLS.bind((String)Messages.getString("AttributeSetterChooseValueWizardPage.Description"), (Object)nrOfSelectedElements));
    }

    public Object getAttributeValue() {
        return this.attributeValue;
    }

    public void createControl(Composite parent) {
        Composite base = new Composite(parent, 0);
        base.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = false;
        base.setLayout((Layout)layout);
        Label valueLabel = new Label(base, 64);
        valueLabel.setText(Messages.getString("AttributeSetterChooseValueWizardPage.Value"));
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 16384;
        gridData.verticalAlignment = 128;
        valueLabel.setLayoutData((Object)gridData);
        Composite valueComposite = new Composite(base, 0);
        valueComposite.setLayout((Layout)new GridLayout());
        gridData = new GridData(4, 4, true, true);
        valueComposite.setLayoutData((Object)gridData);
        IAttributeTypeDataType dataType = this.attributeType.getDataType();
        IValueRange valueRange = this.attributeType.getValueRange();
        this.attributeValue = dataType.getDefaultValue();
        this.valueControl = dataType.createSWTControlForModifying(valueComposite, Collections.singleton(new ISWTControlModifiedListener(){

            public void modified(Object newValue, Object additionalInfo) {
                AttributeSetterChooseValueWizardPage.this.attributeValue = newValue;
            }

            public void setModificationInProgress(boolean modificationInProgress) {
            }
        }), this.attributeValue, valueRange);
        gridData = new GridData();
        gridData.verticalAlignment = dataType.getSWTVerticalFillHint();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = gridData.verticalAlignment == 4;
        gridData.heightHint = dataType.getSWTHeightHint();
        this.valueControl.getControl().setLayoutData((Object)gridData);
        this.setControl((Control)base);
    }

    public IWizardPage getPreviousPage() {
        return this.getWizard().getPage("attribute");
    }

    public IWizardPage getNextPage() {
        return null;
    }

    public void disposeResources() {
        this.valueControl.dispose();
    }
}

