/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.global.tools.attributesetter;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeType;
import com.arcway.cockpit.frame.client.global.Messages;
import com.arcway.cockpit.frame.client.global.tools.attributesetter.AttributeSetterChooseValueWizardPage;
import java.util.List;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public class AttributeSetterChooseAttributeWizardPage
extends WizardPage {
    public static final String PAGENAME = "attribute";
    private static final String LAST_FLAG_ATTRIBUTE_TYPE_ID = "com.arcway.cockpit.frame.modelelementidtool.last_attribute_type_id";
    private final List<IAttributeType> attributeTypes;
    private IAttributeType attributeType;

    public AttributeSetterChooseAttributeWizardPage(List<IAttributeType> attributeTypes, int nrOfSelectedElements) {
        super(PAGENAME);
        this.attributeTypes = attributeTypes;
        this.setTitle(Messages.getString("AttributeSetterChooseAttributeWizardPage.Title"));
        this.setDescription(NLS.bind((String)Messages.getString("AttributeSetterChooseAttributeWizardPage.Description"), (Object)nrOfSelectedElements));
    }

    public IAttributeType getAttributeType() {
        return this.attributeType;
    }

    public void createControl(Composite parent) {
        Composite base = new Composite(parent, 0);
        base.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = false;
        base.setLayout((Layout)layout);
        Label attributeLabel = new Label(base, 64);
        attributeLabel.setText(Messages.getString("AttributeSetterChooseAttributeWizardPage.Property"));
        GridData gridData = new GridData(1);
        attributeLabel.setLayoutData((Object)gridData);
        String lastAttributeTypeId = PlatformUI.getPreferenceStore().getString(LAST_FLAG_ATTRIBUTE_TYPE_ID);
        int lastAttributeTypeIndex = -1;
        final Combo attributeCombo = new Combo(base, 2056);
        gridData = new GridData(768);
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        attributeCombo.setLayoutData((Object)gridData);
        for (IAttributeType currentAttributeType : this.attributeTypes) {
            int currentIndex = attributeCombo.getItemCount();
            attributeCombo.add(currentAttributeType.getDisplayName());
            attributeCombo.setData(Integer.toString(currentIndex), (Object)currentAttributeType);
            if (!currentAttributeType.getHumanReadableID().equals(lastAttributeTypeId)) continue;
            lastAttributeTypeIndex = currentIndex;
        }
        if (lastAttributeTypeIndex == -1 && attributeCombo.getItemCount() > 0) {
            lastAttributeTypeIndex = 0;
        }
        if (lastAttributeTypeIndex > -1) {
            attributeCombo.select(lastAttributeTypeIndex);
            this.attributeType = (IAttributeType)attributeCombo.getData(Integer.toString(lastAttributeTypeIndex));
        }
        attributeCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                int index = attributeCombo.getSelectionIndex();
                if (index > -1) {
                    String strIndex = Integer.toString(index);
                    AttributeSetterChooseAttributeWizardPage.this.attributeType = (IAttributeType)attributeCombo.getData(strIndex);
                    PlatformUI.getPreferenceStore().setValue(AttributeSetterChooseAttributeWizardPage.LAST_FLAG_ATTRIBUTE_TYPE_ID, AttributeSetterChooseAttributeWizardPage.this.attributeType.getHumanReadableID());
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.setControl((Control)base);
    }

    public IWizardPage getNextPage() {
        return this.getWizard().getPage(AttributeSetterChooseValueWizardPage.getPageName(this.attributeType));
    }
}

