/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.global.selection;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.stakeholders.IStakeholderManager;
import com.arcway.cockpit.client.base.interfaces.frame.propertychanges.IPropertyChanges;
import com.arcway.cockpit.client.base.interfaces.frame.propertychanges.IPropertyChangesListener;
import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.global.selection.CockpitSelectionManager;
import com.arcway.cockpit.frame.client.global.selection.IFrameProjectSwitchListener;
import com.arcway.cockpit.frame.client.global.selection.IFrameSelectionService;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.IProjectAgent;
import com.arcway.cockpit.frame.client.project.IProjectOpenListener;
import com.arcway.cockpit.frame.client.project.ProjectAgent;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.IUniqueElement;
import com.arcway.cockpit.frame.client.project.modules.IModuleProjectAgent;
import com.arcway.cockpit.frame.client.project.modules.IProjectCloseListener;
import com.arcway.cockpit.frame.client.project.modules.selection.IModuleSelectionService;
import com.arcway.cockpit.frame.client.project.planagents.IPlanAgentProjectAgent;
import com.arcway.cockpit.frame.client.project.planeditors.IExternalPlanEditorControllerExtension;
import com.arcway.cockpit.frame.client.project.planeditors.PlanEditorControllerExtension;
import com.arcway.cockpit.frame.client.project.planeditors.PlanEditorManager;
import com.arcway.cockpit.frame.client.project.planeditors.PlanElement;
import com.arcway.cockpit.frame.shared.message.EOLink;
import com.arcway.cockpit.frame.shared.message.IUniqueElementOccurrence;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.frontend.definition.lib.ui.editor.repository.RepositoryEditorFactory;
import com.arcway.lib.java.ObjectWrapper;
import com.arcway.planagent.controllinginterface.planagent.IPlanAgentPlanElement;
import com.arcway.planagent.controllinginterface.planeditor.IPlanEditorControllerExtension;
import com.arcway.planagent.controllinginterface.planeditor.IPlanEditorPlan;
import com.arcway.planagent.controllinginterface.planeditor.IPlanEditorPlanElement;
import com.arcway.repository.clientadapter.implementation.adapter.PlatformAdapterObject;
import com.arcway.repository.interFace.data.object.IRepositoryObject;
import com.arcway.repository.interFace.dataaccess.EXNotReproducibleSnapshot;
import com.arcway.repository.interFace.dataaccess.IRepositorySnapshotRO;
import de.plans.lib.eclipse.Delayer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbenchPart;

public class CockpitSelectionService
implements IFrameSelectionService,
IModuleSelectionService,
IPropertyChangesListener,
IProjectOpenListener,
IProjectCloseListener {
    private static final String ALL = "all";
    protected static final int MODE_STANDARD = 1;
    protected static final int MODE_POST = 2;
    private final ISelectionService selectionService;
    private final Map<ISelectionListener, String> selectionListeners = new HashMap<ISelectionListener, String>();
    private final Map<ISelectionListener, String> postSelectionListeners = new HashMap<ISelectionListener, String>();
    private final SelectionServiceListener standardSelectionServiceListener = new SelectionServiceListener(1);
    private final SelectionServiceListener postSelectionServiceListener = new SelectionServiceListener(2);
    private IWorkbenchPart activePart;
    private final List<String> editorPartIDs = new ArrayList<String>();
    private IStructuredSelection lastSelection;
    private ISelection lastPureSelection;
    private IProjectAgent currentProjectAgent = null;
    private IProjectAgent isPropertyChangesAndProjectCloseListenerRegistered = null;
    private final HashSet<IFrameProjectSwitchListener> projectSwitchListeners;
    private final HashSet<IFrameProjectSwitchListener> toBeAddedProjectSwitchListeners;
    private final HashSet<IFrameProjectSwitchListener> toBeRemovedProjectSwitchListeners;
    private boolean isCurrentlyInformingProjectSwitchListeners;

    public CockpitSelectionService(ISelectionService selectionService) {
        assert (selectionService != null) : "selectionService can't be null";
        this.selectionService = selectionService;
        selectionService.addSelectionListener((ISelectionListener)this.standardSelectionServiceListener);
        selectionService.addPostSelectionListener((ISelectionListener)this.postSelectionServiceListener);
        this.projectSwitchListeners = new HashSet();
        this.toBeAddedProjectSwitchListeners = new HashSet();
        this.toBeRemovedProjectSwitchListeners = new HashSet();
        ProjectAgent.addProjectOpenListener(this);
    }

    public void addSelectionListener(ISelectionListener listener) {
        assert (listener != null) : "listener can't be null";
        if (!this.selectionListeners.containsKey(listener)) {
            this.selectionListeners.put(listener, ALL);
        }
    }

    public void addSelectionListener(String partId, ISelectionListener listener) {
        assert (partId != null) : "partId can't be null";
        assert (listener != null) : "listener can't be null";
        if (!this.selectionListeners.containsKey(listener)) {
            this.selectionListeners.put(listener, partId);
        }
    }

    public void addPostSelectionListener(ISelectionListener listener) {
        assert (listener != null) : "listener can't be null";
        if (!this.postSelectionListeners.containsKey(listener)) {
            this.postSelectionListeners.put(listener, ALL);
        }
    }

    public void addPostSelectionListener(String partId, ISelectionListener listener) {
        assert (listener != null) : "listener can't be null";
        if (this.postSelectionListeners.containsKey(listener)) {
            this.postSelectionListeners.put(listener, partId);
        }
    }

    public ISelection getSelection() {
        ISelection selection = this.selectionService.getSelection();
        if (selection != null) {
            selection = new StructuredSelection(CockpitSelectionService.translateSelection(selection));
        }
        return selection;
    }

    public static Object translateSelectedItem(Object selectedItem) {
        if (selectedItem instanceof IPlanEditorPlan) {
            IPlanEditorPlan planEditorPlan = (IPlanEditorPlan)selectedItem;
            IPlanEditorControllerExtension planControllerExtension = planEditorPlan.getPlanEditorControllerExtension();
            if (planControllerExtension instanceof PlanEditorControllerExtension) {
                return ((PlanEditorControllerExtension)planControllerExtension).getPlan();
            }
        } else if (selectedItem instanceof IPlanEditorPlanElement) {
            IPlanEditorPlanElement planEditorPlanElement = (IPlanEditorPlanElement)selectedItem;
            IPlanEditorControllerExtension planControllerExtension = planEditorPlanElement.getPlanEditorControllerExtension();
            if (planControllerExtension instanceof PlanEditorControllerExtension) {
                PlanEditorControllerExtension framePlanControllerExtension = (PlanEditorControllerExtension)planControllerExtension;
                IUniqueElement modelElement = framePlanControllerExtension.findUniqueElement((IPlanAgentPlanElement)planEditorPlanElement);
                if (modelElement != null) {
                    return modelElement;
                }
                return new PlanElement((IPlanAgentPlanElement)planEditorPlanElement, framePlanControllerExtension.getPlanUID(), framePlanControllerExtension.getProjectAgent().getProjectUID());
            }
        } else if (selectedItem instanceof RepositoryEditorFactory.Input) {
            RepositoryEditorFactory.Input formsEditorInput = (RepositoryEditorFactory.Input)selectedItem;
            final ObjectWrapper referencedCockpitItem = new ObjectWrapper(null);
            formsEditorInput.doWithReferencedObject(new RepositoryEditorFactory.Input.IReferencedObjectProcessor(){

                public void doWithReferencedObject(IRepositoryObject object) throws EXNotReproducibleSnapshot {
                    PlatformAdapterObject platformAdapterObject = (PlatformAdapterObject)object;
                    referencedCockpitItem.setWrappedObject((Object)platformAdapterObject.getCockpitData());
                }

                public void interfaceNotFound() {
                }

                public void objectNotFound(IRepositorySnapshotRO snapshotRO) throws EXNotReproducibleSnapshot {
                }
            });
            if (referencedCockpitItem.getWrappedObject() != null) {
                return referencedCockpitItem.getWrappedObject();
            }
        } else {
            if (selectedItem instanceof EOLink) {
                EOLink link = (EOLink)selectedItem;
                ProjectAgent projectAgent = ProjectMgr.getProjectMgr().getProjectAgent(link.getProjectUID());
                return projectAgent.getPlanAgentLinkManager().getModuleDataItem(link);
            }
            if (selectedItem instanceof PlatformAdapterObject) {
                ((PlatformAdapterObject)selectedItem).getCockpitData();
            }
        }
        return selectedItem;
    }

    public IPlanAgentProjectAgent getPlanAgentProjectAgent() {
        return (IPlanAgentProjectAgent)this.getLastSelectedProjectAgent();
    }

    public IFrameProjectAgent getFrameProjectAgent() {
        return (IFrameProjectAgent)this.getLastSelectedProjectAgent();
    }

    private IProjectAgent getLastSelectedProjectAgent() {
        if (this.currentProjectAgent != null && ProjectMgr.getProjectMgr().getProjectAgent(this.currentProjectAgent.getProjectUID()) != null) {
            return this.currentProjectAgent;
        }
        return null;
    }

    public ISelection getSelection(String partId) {
        assert (partId != null) : "partId can't be null";
        ISelection selection = this.selectionService.getSelection();
        if (this.editorPartIDs.contains(partId)) {
            return null;
        }
        return selection;
    }

    public IStructuredSelection getLastSelection() {
        return this.lastSelection;
    }

    public void removeSelectionListener(ISelectionListener listener) {
        assert (listener != null) : "listener can't be null";
        this.selectionListeners.remove(listener);
        this.removeSelectionServiceIfNoLongerUsed();
    }

    public void removeSelectionListener(String partId, ISelectionListener listener) {
        String containedPartId;
        assert (listener != null) : "listener can't be null";
        if (this.selectionListeners.containsKey(listener) && (containedPartId = this.selectionListeners.get(listener)).equals(partId)) {
            this.selectionListeners.remove(listener);
            this.removeSelectionServiceIfNoLongerUsed();
        }
    }

    public void removePostSelectionListener(ISelectionListener listener) {
        assert (listener != null) : "listener can't be null";
        this.postSelectionListeners.remove(listener);
        this.removeSelectionServiceIfNoLongerUsed();
    }

    public void removePostSelectionListener(String partId, ISelectionListener listener) {
        String containedPartId;
        assert (listener != null) : "listener can't be null";
        if (this.postSelectionListeners.containsKey(listener) && (containedPartId = this.postSelectionListeners.get(listener)).equals(partId)) {
            this.postSelectionListeners.remove(listener);
            this.removeSelectionServiceIfNoLongerUsed();
        }
    }

    private void removeSelectionServiceIfNoLongerUsed() {
        if (this.selectionListeners.isEmpty() && this.postSelectionListeners.isEmpty()) {
            this.selectionService.removeSelectionListener((ISelectionListener)this.standardSelectionServiceListener);
            this.selectionService.removePostSelectionListener((ISelectionListener)this.postSelectionServiceListener);
            this.dispose();
            CockpitSelectionManager.removeSelectionService(this.selectionService);
        }
    }

    private void fireListeners(IWorkbenchPart part, ISelection selection, int mode) {
        assert (part != null);
        assert (selection != null);
        SelectionPropagationContext psm = new SelectionPropagationContext(part, selection, mode);
        Display.getCurrent().asyncExec((Runnable)new Delayer<SelectionPropagationContext>(psm){

            public void run(SelectionPropagationContext context) {
                CockpitSelectionService.this.fireListeners_delayed(context.getPart(), context.getSelection(), context.getMode());
            }
        });
    }

    protected void fireListeners_delayed(IWorkbenchPart part, ISelection selection, int mode) {
        block14: {
            String containedPartId;
            ISelectionListener listener;
            ArrayList<ISelectionListener> registeredListeners;
            String partId;
            block13: {
                assert (part != null) : "part can't be null";
                assert (selection != null) : "selection can't be null";
                partId = part.getSite().getId();
                if (selection instanceof IStructuredSelection) {
                    this.lastSelection = (IStructuredSelection)selection;
                    for (Object o : this.lastSelection) {
                        if (o == null) continue;
                        String projectUID = null;
                        if (o instanceof ICockpitProjectData) {
                            ICockpitProjectData data = (ICockpitProjectData)o;
                            projectUID = data.getProjectUID();
                        } else if (o instanceof IStakeholderManager) {
                            IStakeholderManager mgr = (IStakeholderManager)o;
                            projectUID = mgr.getProjectUID();
                        }
                        if (projectUID == null) continue;
                        ProjectAgent pa = ProjectMgr.getProjectMgr().getProjectAgent(projectUID);
                        if (pa == this.currentProjectAgent) break;
                        if (this.currentProjectAgent != null && this.currentProjectAgent.isOpened()) {
                            this.deregisterPropertyChangesListener();
                        }
                        this.currentProjectAgent = pa;
                        if (this.currentProjectAgent.isOpened()) {
                            this.registerPropertyChangesListener();
                        }
                        this.informProjectSwitchListeners();
                        break;
                    }
                }
                if (mode != 1) break block13;
                registeredListeners = new ArrayList<ISelectionListener>(this.selectionListeners.keySet());
                int i = 0;
                while (i < registeredListeners.size()) {
                    listener = (ISelectionListener)registeredListeners.get(i);
                    containedPartId = this.selectionListeners.get(listener);
                    if (containedPartId.equals(ALL) || containedPartId.equals(partId)) {
                        listener.selectionChanged(part, selection);
                    }
                    ++i;
                }
                break block14;
            }
            if (mode != 2) break block14;
            registeredListeners = new ArrayList<ISelectionListener>(this.postSelectionListeners.keySet());
            int i = 0;
            while (i < registeredListeners.size()) {
                listener = (ISelectionListener)registeredListeners.get(i);
                containedPartId = this.postSelectionListeners.get(listener);
                if (containedPartId.equals(ALL) || containedPartId.equals(partId)) {
                    listener.selectionChanged(part, selection);
                }
                ++i;
            }
        }
    }

    private void registerPropertyChangesListener() {
        assert (this.isPropertyChangesAndProjectCloseListenerRegistered == null);
        this.isPropertyChangesAndProjectCloseListenerRegistered = this.currentProjectAgent;
        this.currentProjectAgent.getPropertyChangesListenerManager().register((IPropertyChangesListener)this, IUniqueElementOccurrence.class);
        ((IFrameProjectAgent)this.currentProjectAgent).addProjectCloseListener(this);
    }

    private void deregisterPropertyChangesListener() {
        assert (this.isPropertyChangesAndProjectCloseListenerRegistered == this.currentProjectAgent);
        this.isPropertyChangesAndProjectCloseListenerRegistered = null;
        this.currentProjectAgent.getPropertyChangesListenerManager().deregister((IPropertyChangesListener)this);
        ((IFrameProjectAgent)this.currentProjectAgent).removeProjectCloseListener(this);
    }

    @Override
    public void closeProject(IFrameProjectAgent projectAgent) {
        this.deregisterPropertyChangesListener();
    }

    @Override
    public void projectOpened(IProjectAgent projectAgent) {
        if (projectAgent == this.currentProjectAgent) {
            this.registerPropertyChangesListener();
        }
    }

    private void dispose() {
        if (this.currentProjectAgent != null && this.currentProjectAgent.isOpened()) {
            this.deregisterPropertyChangesListener();
        }
        ProjectAgent.removeProjectOpenListener(this);
    }

    private static ArrayList<Object> translateSelection(ISelection selection) {
        ArrayList<Object> selectedItems = new ArrayList<Object>();
        HashSet<String> duplicateCheckForSelectedElements = new HashSet<String>();
        for (Object selectedItem : ((IStructuredSelection)selection).toList()) {
            Object translatedItem = CockpitSelectionService.translateSelectedItem(selectedItem);
            boolean isDuplicate = false;
            if (translatedItem instanceof ICockpitProjectData) {
                boolean bl = isDuplicate = !duplicateCheckForSelectedElements.add(String.valueOf(((ICockpitProjectData)translatedItem).getProjectUID()) + "\n" + ((ICockpitProjectData)translatedItem).getUID());
            }
            if (isDuplicate) continue;
            selectedItems.add(translatedItem);
        }
        return selectedItems;
    }

    public IWorkbenchPart getPartOfLastSelection() {
        return this.activePart;
    }

    public void fireSelection(Collection<?> elements, IWorkbenchPart workbenchPart) {
        StructuredSelection sel = new StructuredSelection(elements.toArray());
        this.fireSelection((ISelection)sel, workbenchPart);
    }

    public void fireSelection(ICockpitProjectData element, IWorkbenchPart workbenchPart) {
        StructuredSelection sel = new StructuredSelection((Object)element);
        this.fireListeners(workbenchPart, (ISelection)sel, 1);
    }

    public void fireSelection(ISelection selection, IWorkbenchPart workbenchPart) {
        this.fireListeners(workbenchPart, selection, 1);
    }

    public void modelRefreshed(IPropertyChanges<?> changes, Class<?> clazz, String projectUID) {
        boolean doResend = false;
        if (this.activePart instanceof IEditorPart) {
            IUniqueElementOccurrence ceo;
            Object o;
            Iterator i = changes.getCreatedElements().iterator();
            while (i.hasNext() && !doResend) {
                o = i.next();
                if (!(o instanceof IUniqueElementOccurrence) || !this.isInLastSelection(ceo = (IUniqueElementOccurrence)o)) continue;
                doResend = true;
            }
            i = changes.getDeletedElements().iterator();
            while (i.hasNext() && !doResend) {
                o = i.next();
                if (!(o instanceof IUniqueElementOccurrence) || !this.isInLastSelection(ceo = (IUniqueElementOccurrence)o)) continue;
                doResend = true;
            }
        }
        if (doResend) {
            this.standardSelectionServiceListener.selectionChanged(this.activePart, this.lastPureSelection);
        }
    }

    private boolean isInLastSelection(IUniqueElementOccurrence ceo) {
        IExternalPlanEditorControllerExtension ctrl;
        boolean found = false;
        if (this.activePart instanceof IEditorPart && (ctrl = PlanEditorManager.findPlanEditorControllerExtensionInAllProjects((IEditorPart)this.activePart)) != null && this.lastPureSelection instanceof IStructuredSelection) {
            IStructuredSelection sel = (IStructuredSelection)this.lastPureSelection;
            Iterator i = sel.iterator();
            while (i.hasNext() && !found) {
                IPlanAgentPlanElement pe;
                Object o = i.next();
                if (!(o instanceof IPlanAgentPlanElement) || !(pe = (IPlanAgentPlanElement)o).getPlanElementUID().equals(ceo.getPlanElementUID()) || !ctrl.getPlanUID().equals(ceo.getPlanUID()) || !ctrl.getProjectAgent().getProjectUID().equals(ceo.getProjectUID())) continue;
                found = true;
            }
        }
        return found;
    }

    @Override
    public IModuleProjectAgent getModuleProjectAgent() {
        return (IModuleProjectAgent)this.getLastSelectedProjectAgent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProjectSwitchListener(IFrameProjectSwitchListener listener) {
        HashSet<IFrameProjectSwitchListener> hashSet = this.projectSwitchListeners;
        synchronized (hashSet) {
            if (!this.isCurrentlyInformingProjectSwitchListeners) {
                this.projectSwitchListeners.add(listener);
            } else {
                this.toBeAddedProjectSwitchListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeProjectSwitchListener(IFrameProjectSwitchListener listener) {
        HashSet<IFrameProjectSwitchListener> hashSet = this.projectSwitchListeners;
        synchronized (hashSet) {
            if (!this.isCurrentlyInformingProjectSwitchListeners) {
                this.projectSwitchListeners.remove(listener);
            } else {
                this.toBeRemovedProjectSwitchListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void informProjectSwitchListeners() {
        HashSet<IFrameProjectSwitchListener> hashSet = this.projectSwitchListeners;
        synchronized (hashSet) {
            this.isCurrentlyInformingProjectSwitchListeners = true;
            for (IFrameProjectSwitchListener listener : this.projectSwitchListeners) {
                listener.projectSwitched(this.currentProjectAgent);
            }
            this.isCurrentlyInformingProjectSwitchListeners = false;
            this.projectSwitchListeners.addAll(this.toBeAddedProjectSwitchListeners);
            this.toBeAddedProjectSwitchListeners.clear();
            this.projectSwitchListeners.removeAll(this.toBeRemovedProjectSwitchListeners);
            this.toBeRemovedProjectSwitchListeners.clear();
        }
    }

    private class SelectionPropagationContext {
        private final IWorkbenchPart part;
        private final ISelection selection;
        private final int mode;

        SelectionPropagationContext(IWorkbenchPart part, ISelection selection, int mode) {
            this.part = part;
            this.selection = selection;
            this.mode = mode;
        }

        IWorkbenchPart getPart() {
            return this.part;
        }

        ISelection getSelection() {
            return this.selection;
        }

        int getMode() {
            return this.mode;
        }
    }

    private class SelectionServiceListener
    implements ISelectionListener {
        private final int mode;

        public SelectionServiceListener(int mode) {
            this.mode = mode;
        }

        public void selectionChanged(IWorkbenchPart part, ISelection selection) {
            if (part != null && selection != null && selection instanceof IStructuredSelection) {
                CockpitSelectionService.this.activePart = part;
                CockpitSelectionService.this.lastPureSelection = selection;
                ArrayList selectedItems = CockpitSelectionService.translateSelection(selection);
                if (part instanceof IEditorPart) {
                    IEditorPart editorPart = (IEditorPart)part;
                    IExternalPlanEditorControllerExtension ctrl = PlanEditorManager.findPlanEditorControllerExtensionInAllProjects(editorPart);
                    if (ctrl != null) {
                        if (!CockpitSelectionService.this.editorPartIDs.contains(editorPart.getSite().getId())) {
                            CockpitSelectionService.this.editorPartIDs.add(editorPart.getSite().getId());
                        }
                        ProjectAgent projectAgent = ProjectMgr.getProjectMgr().getProjectAgent(ctrl.getPlan().getProjectUID());
                        projectAgent.getPlanEditorManager().deleteSelectionOnPlansInProjectionMode(ctrl.getPlan(), CockpitSelectionService.this.activePart.getSite().getWorkbenchWindow());
                        selectedItems.add(ctrl.getPlan());
                    }
                } else if (!selectedItems.isEmpty()) {
                    Object firstSelectedItem = selectedItems.get(0);
                    String projectUID = null;
                    if (firstSelectedItem instanceof ICockpitProjectData) {
                        ICockpitProjectData cockpitItem = (ICockpitProjectData)firstSelectedItem;
                        projectUID = cockpitItem.getProjectUID();
                    } else if (firstSelectedItem instanceof IStakeholderManager) {
                        IStakeholderManager stakeholderManager = (IStakeholderManager)firstSelectedItem;
                        projectUID = stakeholderManager.getProjectUID();
                    }
                    ProjectAgent projectAgent = null;
                    if (projectUID != null) {
                        projectAgent = ProjectMgr.getProjectMgr().getProjectAgent(projectUID);
                    }
                    if (projectAgent != null && projectAgent.isOpened()) {
                        projectAgent.getPlanEditorManager().deleteSelectionOnPlansInProjectionMode(CockpitSelectionService.this.activePart.getSite().getWorkbenchWindow());
                    }
                }
                CockpitSelectionService.this.fireListeners(part, (ISelection)new StructuredSelection((List)selectedItems), this.mode);
            }
        }
    }
}

