/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.global.selection;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.stakeholders.IStakeholderManager;
import com.arcway.cockpit.frame.client.global.selection.CockpitSelectionService;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.ISelectionService;

public class CockpitSelectionManager {
    private static Map selectionServices = new HashMap();

    public static CockpitSelectionService getSelectionService(ISelectionService selectionService) {
        assert (selectionService != null) : "selectionService can't be null";
        if (selectionServices.containsKey(selectionService)) {
            return (CockpitSelectionService)selectionServices.get(selectionService);
        }
        CockpitSelectionService newSelectionService = new CockpitSelectionService(selectionService);
        selectionServices.put(selectionService, newSelectionService);
        return newSelectionService;
    }

    protected static void removeSelectionService(ISelectionService selectionService) {
        assert (selectionService != null) : "selectionService can't be null";
        selectionServices.remove(selectionService);
    }

    public static String getProjectUID(ISelection selection) {
        assert (selection != null) : "selection can't be null";
        IStructuredSelection structuredSelection = (IStructuredSelection)selection;
        List selectedObjects = structuredSelection.toList();
        int i = 0;
        while (i < selectedObjects.size()) {
            Object obj = selectedObjects.get(i);
            if (obj instanceof ICockpitProjectData) {
                return ((ICockpitProjectData)obj).getProjectUID();
            }
            if (obj instanceof IStakeholderManager) {
                return ((IStakeholderManager)obj).getProjectUID();
            }
            ++i;
        }
        return null;
    }

    public static List getObjectsOfType(ISelection selection, String typeID) {
        assert (selection != null) : "selection can't be null";
        assert (typeID != null) : "typeID can't be null";
        IStructuredSelection structuredSelection = (IStructuredSelection)selection;
        List selectedObjects = structuredSelection.toList();
        ArrayList retrievedObjects = new ArrayList();
        int i = 0;
        while (i < selectedObjects.size()) {
            Object obj = selectedObjects.get(i);
            if (obj instanceof ICockpitProjectData && ((ICockpitProjectData)obj).getTypeID().equals(typeID)) {
                retrievedObjects.add(obj);
            }
            ++i;
        }
        return retrievedObjects;
    }
}

