/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.global.license;

import com.arcway.cockpit.frame.client.global.license.IClientModuleLicenseType;
import com.arcway.cockpit.frame.client.global.license.IClientProductLicenseType;
import com.arcway.cockpit.frame.client.global.license.Messages;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.osgi.util.NLS;

public class ClientProductLicenseTypes {
    private static final String PRODUCT_ID_COCKPIT_CS_FULL = "COCKPIT-3.6";
    private static final String PRODUCT_ID_COCKPIT_SA_FULL = "COCKPIT-3.6-Standalone";
    private static final String PRODUCT_ID_COCKPIT_CS_READER = "COCKPIT-3.6-Reader";
    private static final String PRODUCT_ID_COCKPIT_SA_READER = "COCKPIT-3.6-Standalone-Reader";
    private static final String PRODUCT_ID_COCKPIT_DESIGNER = "COCKPIT-3.6-Standalone-Designer";
    private static final String PRODUCT_ID_COCKPIT_DESIGNER_READER = "COCKPIT-3.6-Standalone-Designer-Reader";
    private static final String PRODUCT_ID_COCKPIT_COMMUNITYEDITION = "COCKPIT-3.6-Community-Edition";
    private static final Collection<IClientProductLicenseType> knownProductTypes = new ArrayList<IClientProductLicenseType>();
    private static final Map<String, IClientModuleLicenseType> knownModuleTypes = new HashMap<String, IClientModuleLicenseType>();
    public static final IClientProductLicenseType FULL_LICENSE = new IClientProductLicenseType(){

        @Override
        public String getProductID() {
            return ClientProductLicenseTypes.PRODUCT_ID_COCKPIT_CS_FULL;
        }

        @Override
        public String getBaseProductID() {
            return ClientProductLicenseTypes.PRODUCT_ID_COCKPIT_CS_FULL;
        }

        @Override
        public String getDisplayName() {
            return Messages.getString("IUserLicenseType.full_license");
        }

        @Override
        public String getDescription() {
            return Messages.getString("IUserLicenseType.full_license_description");
        }

        @Override
        public boolean isClientServerVersionAllowed() {
            return true;
        }

        @Override
        public boolean isStandaloneVersionAllowed() {
            return false;
        }
    };
    public static final IClientProductLicenseType FULL_LICENSE_SA = new IClientProductLicenseType(){

        @Override
        public String getProductID() {
            return ClientProductLicenseTypes.PRODUCT_ID_COCKPIT_SA_FULL;
        }

        @Override
        public String getBaseProductID() {
            return ClientProductLicenseTypes.PRODUCT_ID_COCKPIT_SA_FULL;
        }

        @Override
        public String getDisplayName() {
            return Messages.getString("IUserLicenseType.full_license");
        }

        @Override
        public String getDescription() {
            return Messages.getString("IUserLicenseType.full_license_description");
        }

        @Override
        public boolean isClientServerVersionAllowed() {
            return false;
        }

        @Override
        public boolean isStandaloneVersionAllowed() {
            return true;
        }
    };
    public static final IClientProductLicenseType READER_LICENSE_CS = new IClientProductLicenseType(){

        @Override
        public String getProductID() {
            return ClientProductLicenseTypes.PRODUCT_ID_COCKPIT_CS_READER;
        }

        @Override
        public String getBaseProductID() {
            return ClientProductLicenseTypes.PRODUCT_ID_COCKPIT_CS_FULL;
        }

        @Override
        public String getDisplayName() {
            return Messages.getString("IUserLicenseType.reader_license");
        }

        @Override
        public String getDescription() {
            return Messages.getString("IUserLicenseType.reader_license_description");
        }

        @Override
        public boolean isClientServerVersionAllowed() {
            return true;
        }

        @Override
        public boolean isStandaloneVersionAllowed() {
            return false;
        }
    };
    public static final IClientProductLicenseType READER_LICENSE_SA = new IClientProductLicenseType(){

        @Override
        public String getProductID() {
            return ClientProductLicenseTypes.PRODUCT_ID_COCKPIT_SA_READER;
        }

        @Override
        public String getBaseProductID() {
            return ClientProductLicenseTypes.PRODUCT_ID_COCKPIT_SA_FULL;
        }

        @Override
        public String getDisplayName() {
            return Messages.getString("IUserLicenseType.reader_license");
        }

        @Override
        public String getDescription() {
            return Messages.getString("IUserLicenseType.reader_license_description");
        }

        @Override
        public boolean isClientServerVersionAllowed() {
            return false;
        }

        @Override
        public boolean isStandaloneVersionAllowed() {
            return true;
        }
    };
    public static final IClientProductLicenseType DESIGNER_LICENSE = new IClientProductLicenseType(){

        @Override
        public String getProductID() {
            return ClientProductLicenseTypes.PRODUCT_ID_COCKPIT_DESIGNER;
        }

        @Override
        public String getBaseProductID() {
            return ClientProductLicenseTypes.PRODUCT_ID_COCKPIT_SA_FULL;
        }

        @Override
        public String getDisplayName() {
            return Messages.getString("ProductLicenseType.PersonalArchitect.Name");
        }

        @Override
        public String getDescription() {
            return Messages.getString("ProductLicenseType.PersonalArchitect.Description");
        }

        @Override
        public boolean isClientServerVersionAllowed() {
            return false;
        }

        @Override
        public boolean isStandaloneVersionAllowed() {
            return true;
        }
    };
    public static final IClientProductLicenseType DESIGNER_READER_LICENSE = new IClientProductLicenseType(){

        @Override
        public String getProductID() {
            return ClientProductLicenseTypes.PRODUCT_ID_COCKPIT_DESIGNER_READER;
        }

        @Override
        public String getBaseProductID() {
            return ClientProductLicenseTypes.PRODUCT_ID_COCKPIT_SA_FULL;
        }

        @Override
        public String getDisplayName() {
            return Messages.getString("ProductLicenseType.PersonalArchitectReader.Name");
        }

        @Override
        public String getDescription() {
            return Messages.getString("ProductLicenseType.PersonalArchitectReader.Description");
        }

        @Override
        public boolean isClientServerVersionAllowed() {
            return false;
        }

        @Override
        public boolean isStandaloneVersionAllowed() {
            return true;
        }
    };
    public static final IClientProductLicenseType COMMUNITY_EDITION_LICENSE = new IClientProductLicenseType(){

        @Override
        public String getProductID() {
            return ClientProductLicenseTypes.PRODUCT_ID_COCKPIT_COMMUNITYEDITION;
        }

        @Override
        public String getBaseProductID() {
            return ClientProductLicenseTypes.PRODUCT_ID_COCKPIT_SA_FULL;
        }

        @Override
        public String getDisplayName() {
            return Messages.getString("UserLicenseTypes.community_edition");
        }

        @Override
        public String getDescription() {
            return Messages.getString("UserLicenseTypes.description");
        }

        @Override
        public boolean isClientServerVersionAllowed() {
            return false;
        }

        @Override
        public boolean isStandaloneVersionAllowed() {
            return true;
        }
    };
    private static final String MODULE_ID_RQM = "requirementsmodule3";
    public static final IClientModuleLicenseType MODULE_LICENSE_RQM = new IClientModuleLicenseType(){

        @Override
        public String getModuleID() {
            return ClientProductLicenseTypes.MODULE_ID_RQM;
        }

        @Override
        public String getDisplayName() {
            return Messages.getString("ModuleTypeRQM.Name");
        }

        @Override
        public String getDescription() {
            return Messages.getString("ModuleTypeRQM.Description");
        }
    };

    static {
        knownProductTypes.add(FULL_LICENSE);
        knownProductTypes.add(FULL_LICENSE_SA);
        knownProductTypes.add(READER_LICENSE_CS);
        knownProductTypes.add(READER_LICENSE_SA);
        knownProductTypes.add(DESIGNER_LICENSE);
        knownProductTypes.add(DESIGNER_READER_LICENSE);
        knownProductTypes.add(COMMUNITY_EDITION_LICENSE);
        knownModuleTypes.put(MODULE_ID_RQM, MODULE_LICENSE_RQM);
    }

    public static Collection<IClientProductLicenseType> getAllProductTypes() {
        return knownProductTypes;
    }

    public static IClientProductLicenseType getProductLicenseTypeForProductID(String productID) {
        for (IClientProductLicenseType type : knownProductTypes) {
            if (!type.getProductID().equals(productID)) continue;
            return type;
        }
        return null;
    }

    public static IClientModuleLicenseType getModuleLicenseTypeForModuleID(final String moduleID) {
        IClientModuleLicenseType type = knownModuleTypes.get(moduleID);
        if (type == null) {
            type = new IClientModuleLicenseType(){

                @Override
                public String getModuleID() {
                    return moduleID;
                }

                @Override
                public String getDisplayName() {
                    return NLS.bind((String)Messages.getString("UnknownModuleType.Name"), (Object)moduleID);
                }

                @Override
                public String getDescription() {
                    return NLS.bind((String)Messages.getString("UnknownModuleType.Description"), (Object)moduleID);
                }
            };
        }
        return type;
    }
}

