/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.global.license;

import com.arcway.cockpit.frame.client.global.FramePlugin;
import com.arcway.lib.eclipse.platformurl.PlatformURLHelper;
import com.arcway.lib.extensioning.IPlugin;
import com.arcway.lib.io.DataCopyHelper;
import com.arcway.lib.io.FileHelper;
import com.arcway.lib.java.collectionmaps.MapMap;
import com.arcway.lib.java.tuples.Tuple;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.network.HostNameRetriever;
import com.arcway.lib.resource.JvmExternalResourceInteractionException;
import de.plans.fmca.client.FMCAPlugin;
import de.plans.lib.lic.LicenseFileReader;
import de.plans.lib.lic.ModuleLicense;
import de.plans.lib.lic.UserLicense;
import de.plans.lib.lic.ValidityHelper;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import org.eclipse.core.runtime.FileLocator;

public class ClientLicenseFilesManager {
    private static final ILogger logger = Logger.getLogger(ClientLicenseFilesManager.class);
    public static final String LICENSE_FILE_EXTENSION = "license";
    public static final int LOAD_FILE_RESULT_NOT_LOADED = -1;
    public static final int LOAD_FILE_RESULT_INSTALL_DIR = 1;
    public static final int LOAD_FILE_RESULT_WS_DIR = 2;
    public static final String INDEPENDANT_ADDITIONAL_MODULE_ID = "independant-additional-module";
    private static final String PROPERTY_ID_INSTALLDATE = "clfm-basetimestamp";
    private static final File licenseInstallDir;
    private static final File wsDir;
    private static ClientLicenseFilesManager singletonInstance;
    private HashMap<String, UserLicense> allowedNumberOfUsersMap;
    private MapMap<String, String, ModuleLicense> allowedModuleMap;
    private String currentLicenseFilesStatusAsHTMLSnippet;

    static {
        File dir = null;
        try {
            URL installLocationLicensesPlatformURL = PlatformURLHelper.createPlatformBaseURL((String)"Licenses");
            URL installLocationLicensesJavaLibURL = FileLocator.resolve((URL)installLocationLicensesPlatformURL);
            File installLocationLicensesDir = new File(installLocationLicensesJavaLibURL.getFile());
            if (installLocationLicensesDir.isDirectory()) {
                dir = installLocationLicensesDir;
            } else {
                URL framePluginLicensesPlatformURL = PlatformURLHelper.createPlatformPluginURL((IPlugin)FramePlugin.getDefault(), (String)"Licenses");
                URL framePluginLicensesJavaLibURL = FileLocator.resolve((URL)framePluginLicensesPlatformURL);
                File framePluginLicensesDir = new File(framePluginLicensesJavaLibURL.getFile());
                if (framePluginLicensesDir.isDirectory()) {
                    dir = framePluginLicensesDir;
                } else {
                    logger.warn("Unable to determine License install directory");
                }
            }
        }
        catch (IOException e) {
            logger.warn("Could not determine License install directory", (Throwable)e);
        }
        licenseInstallDir = dir;
        wsDir = new File(FMCAPlugin.getWorkspaceRootDirectory(), "Licenses");
    }

    private ClientLicenseFilesManager() {
        this.loadAllLicenseFiles();
    }

    public static ClientLicenseFilesManager getDefault() {
        if (singletonInstance == null) {
            singletonInstance = new ClientLicenseFilesManager();
        }
        return singletonInstance;
    }

    public boolean hasUserLicense(String applicationID) {
        UserLicense license = this.allowedNumberOfUsersMap.get(applicationID);
        if (license == null) {
            return false;
        }
        if (license.getLicenseCount() == 0) {
            return false;
        }
        Timestamp currentTime = new Timestamp(System.currentTimeMillis());
        Timestamp startDate = license.getValidFromDateForSingleLicense();
        if (startDate == null || startDate != ValidityHelper.VALID_SINCE_EVER_TIMESTAMP && startDate.after(currentTime)) {
            return false;
        }
        Timestamp endDate = license.getExpiryDateForSingleLicense();
        return endDate != null && (endDate == ValidityHelper.EXPIRES_NEVER_TIMESTAMP || !endDate.before(currentTime));
    }

    public UserLicense getUserLicense(String applicationID) {
        UserLicense license = null;
        if (this.hasUserLicense(applicationID)) {
            license = this.allowedNumberOfUsersMap.get(applicationID);
        }
        return license;
    }

    public Collection<ModuleLicense> getModuleLicenses(String applicationID) {
        return this.allowedModuleMap.getAllValues((Object)applicationID);
    }

    public Tuple<Integer, LicenseFileReader.LicenseFileReaderLicenseFileStatus> importLicenseFile(File licenseFile) {
        boolean disallowWindowsVistaOr7VirtualStore;
        LicenseFileReader.LicenseFileReaderLicenseFileStatus status = null;
        int location = -1;
        if (licenseInstallDir != null) {
            try {
                disallowWindowsVistaOr7VirtualStore = true;
                status = this.importLicenseFile(licenseFile, licenseInstallDir, disallowWindowsVistaOr7VirtualStore);
                location = 1;
            }
            catch (IOException ioE) {
                this.logLicenseNotLoadedIntoInstallDir(licenseFile.toString(), ioE);
            }
            catch (JvmExternalResourceInteractionException jeriE) {
                this.logLicenseNotLoadedIntoInstallDir(licenseFile.toString(), (Exception)((Object)jeriE));
            }
        } else {
            logger.warn("Could not import new license file into preferred license file install directory.");
        }
        if (location == -1) {
            try {
                disallowWindowsVistaOr7VirtualStore = false;
                status = this.importLicenseFile(licenseFile, wsDir, disallowWindowsVistaOr7VirtualStore);
                location = 2;
            }
            catch (IOException ioE2) {
                this.logLicenseNotLoadedIntoWorkspace(licenseFile.toString(), ioE2);
            }
            catch (JvmExternalResourceInteractionException jeriE) {
                this.logLicenseNotLoadedIntoWorkspace(licenseFile.toString(), (Exception)((Object)jeriE));
            }
        }
        return new Tuple((Object)location, (Object)status);
    }

    private void logLicenseNotLoadedIntoInstallDir(String licenseFile, Exception exception) {
        logger.warn("Could not import new license file into preferred license file install directory (install-license-directory=\"" + licenseInstallDir.toString() + "\"" + ", " + "license-file=\"" + licenseFile + "\"" + ").", (Throwable)exception);
    }

    private void logLicenseNotLoadedIntoWorkspace(String licenseFile, Exception exception) {
        logger.warn("Could not import new license file at all. Even importing it into the workspace license file install directory failed (workspace-license-directory=\"" + wsDir.toString() + "\"" + ", " + "license-file=\"" + licenseFile + "\"" + ").", (Throwable)exception);
    }

    private LicenseFileReader.LicenseFileReaderLicenseFileStatus importLicenseFile(File licenseFile, File licenseDirectory, boolean disallowWindowsVistaOr7VirtualStore) throws IOException, JvmExternalResourceInteractionException {
        if (!licenseDirectory.exists()) {
            FileHelper.ensureDirectoryExistance((File)licenseDirectory);
        }
        if (!licenseDirectory.exists()) {
            throw new IOException("Can not create dir " + licenseDirectory.getAbsolutePath());
        }
        if (disallowWindowsVistaOr7VirtualStore && FileHelper.isDirectoryInWindowsVistaOr7VirtualStore((File)licenseDirectory)) {
            throw new IOException("License File Directory " + licenseDirectory + " is subject to windows Vista/7 Filesystem virtualisation. Will not import License to this directory.");
        }
        File targetFile = new File(licenseDirectory, licenseFile.getName());
        int i = 1;
        while (targetFile.exists()) {
            targetFile = new File(licenseDirectory, String.valueOf(licenseFile.getName()) + "_" + i++);
        }
        DataCopyHelper.copyFile((File)licenseFile, (File)targetFile);
        LicenseFileReader.LicenseFileReaderStatus status = this.loadAllLicenseFiles();
        return status.getStatusForSpecificFile(targetFile);
    }

    private LicenseFileReader.LicenseFileReaderStatus loadAllLicenseFiles() {
        this.allowedNumberOfUsersMap = new HashMap();
        this.allowedModuleMap = new MapMap();
        long installTimestamp = FMCAPlugin.getDefault().getPluginPreferences().getLong(PROPERTY_ID_INSTALLDATE);
        if (installTimestamp == 0L) {
            installTimestamp = System.currentTimeMillis();
            FMCAPlugin.getDefault().getPluginPreferences().setValue(PROPERTY_ID_INSTALLDATE, installTimestamp);
        }
        Date installDate = new Date(installTimestamp);
        LicenseFileReader.LicenseFileReaderStatus status = LicenseFileReader.readLicenseFiles(ClientLicenseFilesManager.getLicenseFileDirs(), (Date)installDate, this.allowedNumberOfUsersMap, this.allowedModuleMap);
        this.currentLicenseFilesStatusAsHTMLSnippet = status.getStatusHTML();
        return status;
    }

    public static Collection<File> getLicenseFileDirs() {
        ArrayList<File> licenseFileDirs = new ArrayList<File>();
        if (licenseInstallDir != null) {
            licenseFileDirs.add(licenseInstallDir);
        }
        licenseFileDirs.add(wsDir);
        return licenseFileDirs;
    }

    public static String getHostID() throws HostNameRetriever.UnableToRetrieveHostnameException {
        return LicenseFileReader.getHostID2();
    }

    public String getLicenseFilesDetails() {
        return "<HTML><BODY>" + this.currentLicenseFilesStatusAsHTMLSnippet + "</BODY></HTML>";
    }
}

