/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.global.license;

import com.arcway.cockpit.frame.client.global.license.AbstractClientProductLicenseManager;
import com.arcway.cockpit.frame.client.global.license.ClientLicenseFilesManager;
import com.arcway.cockpit.frame.client.global.license.IClientProductLicenseType;
import com.arcway.cockpit.frame.client.global.license.ILocalClientProductLicenseManager;
import com.arcway.cockpit.frame.client.global.license.Messages;
import com.arcway.lib.java.tuples.ThreeTuple;
import com.arcway.lib.java.tuples.Tuple;
import de.plans.lib.lic.LicenseFileReader;
import de.plans.lib.lic.UserLicense;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

public abstract class AbstractLocalClientProductLicenseManager
extends AbstractClientProductLicenseManager
implements ILocalClientProductLicenseManager {
    private static final String PROVIDER_DESCRIPTION = Messages.getString("ProductLicenseManager.ProviderDescription.LocalLicenseFile");

    public AbstractLocalClientProductLicenseManager() {
        this.init();
    }

    protected void init() {
        this.activateProductAndModuleLicenses();
    }

    @Override
    public ThreeTuple<Integer, Boolean, List<String>> importAdditionalLicenseFile(File newLicenseFile) {
        Tuple<Integer, LicenseFileReader.LicenseFileReaderLicenseFileStatus> result = ClientLicenseFilesManager.getDefault().importLicenseFile(newLicenseFile);
        this.activateProductAndModuleLicenses();
        this.notifyLicenseChangeListeners();
        return new ThreeTuple((Object)((Integer)result.getT1()), (Object)this.hasLicenseForThisApplication((LicenseFileReader.LicenseFileReaderLicenseFileStatus)result.getT2()), result.getT2() != null ? ((LicenseFileReader.LicenseFileReaderLicenseFileStatus)result.getT2()).problems : Collections.emptyList());
    }

    private void activateProductAndModuleLicenses() {
        this.clearProductAndModuleLicenses();
        Collection<IClientProductLicenseType> relevantProductLicenseTypes = this.getRelevantProductLicenseTypes();
        for (IClientProductLicenseType productLicenseType : relevantProductLicenseTypes) {
            if (!ClientLicenseFilesManager.getDefault().hasUserLicense(productLicenseType.getProductID())) continue;
            UserLicense userLicense = ClientLicenseFilesManager.getDefault().getUserLicense(productLicenseType.getProductID());
            this.activateProductLicense(productLicenseType, userLicense, PROVIDER_DESCRIPTION);
            this.activateModuleLicenses(userLicense, ClientLicenseFilesManager.getDefault().getModuleLicenses(userLicense.getApplicationName()), PROVIDER_DESCRIPTION);
        }
        this.activateModuleLicenses(null, ClientLicenseFilesManager.getDefault().getModuleLicenses("independant-additional-module"), PROVIDER_DESCRIPTION);
    }

    private boolean hasLicenseForThisApplication(LicenseFileReader.LicenseFileReaderLicenseFileStatus licenseFileStatus) {
        if (licenseFileStatus == null) {
            return false;
        }
        HashSet<String> applicationForWhichLicenseArePresent = new HashSet<String>();
        for (LicenseFileReader.LicenseFileReaderUserLicenseStatus userLicenseStatus : licenseFileStatus.userLicenses) {
            applicationForWhichLicenseArePresent.add(userLicenseStatus.applicationName);
        }
        for (LicenseFileReader.LicenseFileReaderModuleLicenseStatus moduleLicenseStatus : licenseFileStatus.allowedModules) {
            applicationForWhichLicenseArePresent.add(moduleLicenseStatus.applicationName);
        }
        for (IClientProductLicenseType relevantProductLicenseType : this.getRelevantProductLicenseTypes()) {
            if (!applicationForWhichLicenseArePresent.contains(relevantProductLicenseType.getProductID())) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getLicenseFilesDetails() {
        return ClientLicenseFilesManager.getDefault().getLicenseFilesDetails();
    }

    protected abstract Collection<IClientProductLicenseType> getRelevantProductLicenseTypes();
}

