/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.global.license;

import com.arcway.cockpit.frame.client.global.ExtensionMgr;
import com.arcway.cockpit.frame.client.global.license.ClientProductLicenseTypes;
import com.arcway.cockpit.frame.client.global.license.IClientFunctionLicense;
import com.arcway.cockpit.frame.client.global.license.IClientFunctionLicenseManager;
import com.arcway.cockpit.frame.client.global.license.IClientFunctionLicenseType;
import com.arcway.cockpit.frame.client.global.license.IClientFunctionLicenseType2;
import com.arcway.cockpit.frame.client.global.license.IClientProductLicenseManager;
import com.arcway.cockpit.frame.client.global.license.IClientProductLicenseType;
import com.arcway.cockpit.frame.client.global.license.IClientProductOrModuleLicense;
import com.arcway.lib.java.collections.CollectionUtils;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;

public abstract class AbstractClientFunctionLicenseManager
implements IClientFunctionLicenseManager {
    private static Collection<? extends IClientFunctionLicenseType> clientFunctionLicenseTypes;
    private IClientProductLicenseManager productLicenseManager;
    private final HashMap<IClientFunctionLicenseType, ArrayList<IClientFunctionLicense>> effectiveFunctionLicenseMap = new HashMap(2 * AbstractClientFunctionLicenseManager.getClientFunctionLicenseTypes().size(), 0.5f);

    private static synchronized Collection<? extends IClientFunctionLicenseType> getClientFunctionLicenseTypes() {
        if (clientFunctionLicenseTypes == null) {
            clientFunctionLicenseTypes = CollectionUtils.getTypedList(ExtensionMgr.getDefault().getExtension("clientFunctionLicenses", "clientFunctionLicenseType", "clientFunctionLicenseType"), IClientFunctionLicenseType.class);
        }
        return clientFunctionLicenseTypes;
    }

    protected void init() {
        this.productLicenseManager = this.createProductLicenseManager();
        this.determineFunctionLicenses();
        this.productLicenseManager.addLicenseChangeListener(this);
    }

    @Override
    public IClientFunctionLicense findClientFunctionLicense(IClientFunctionLicenseType licenseType) {
        IClientFunctionLicense clientLicense = null;
        ArrayList<IClientFunctionLicense> licenses = this.effectiveFunctionLicenseMap.get(licenseType);
        if (licenses != null) {
            while (!licenses.isEmpty()) {
                IClientFunctionLicense availableLicense = licenses.get(0);
                if (this.isValid(availableLicense)) {
                    clientLicense = availableLicense;
                    break;
                }
                licenses.remove(0);
            }
        }
        return clientLicense;
    }

    @Override
    public boolean isLicenseOperationAllowed(IClientFunctionLicenseType licenseType) {
        IClientFunctionLicense clientLicense = this.findClientFunctionLicense(licenseType);
        if (licenseType instanceof IClientFunctionLicenseType2) {
            return !((IClientFunctionLicenseType2)licenseType).isDenial(clientLicense);
        }
        return clientLicense != null;
    }

    public static Collection<? extends IClientProductLicenseType> getClientProductLicenseTypes(IClientFunctionLicenseType functionLicenseType) {
        ArrayList<IClientProductLicenseType> userLicenseTypes = new ArrayList<IClientProductLicenseType>();
        for (IClientProductLicenseType element : ClientProductLicenseTypes.getAllProductTypes()) {
            IClientProductLicenseType userLicenseType = element;
            if (!functionLicenseType.isGrantedByProductLicenseOfType(userLicenseType)) continue;
            userLicenseTypes.add(userLicenseType);
        }
        return userLicenseTypes;
    }

    @Override
    public final void productOrModuleLicensesChanged() {
        this.determineFunctionLicenses();
    }

    protected abstract IClientProductLicenseManager createProductLicenseManager();

    private void determineFunctionLicenses() {
        this.clearFunctionLicenses();
        this.setProductOrModuleLicenses(this.productLicenseManager.getProductLicenses());
        this.setProductOrModuleLicenses(this.productLicenseManager.getModuleLicenses());
    }

    private void clearFunctionLicenses() {
        this.effectiveFunctionLicenseMap.clear();
        for (IClientFunctionLicenseType iClientFunctionLicenseType : AbstractClientFunctionLicenseManager.getClientFunctionLicenseTypes()) {
            IClientFunctionLicense license = iClientFunctionLicenseType.getClientFunctionLicense(null);
            if (license == null) continue;
            this.putClientFunctionLicense(license);
        }
    }

    private void setProductOrModuleLicenses(Collection<? extends IClientProductOrModuleLicense> productOrModuleLicences) {
        for (IClientProductOrModuleLicense iClientProductOrModuleLicense : productOrModuleLicences) {
            Timestamp endDate = iClientProductOrModuleLicense.getEndDate();
            Timestamp currentDate = new Timestamp(System.currentTimeMillis());
            if (endDate != null && endDate.compareTo(currentDate) <= 0) continue;
            this.addClientFunctionLicenses(iClientProductOrModuleLicense);
        }
    }

    private void addClientFunctionLicenses(IClientProductOrModuleLicense productOrModuleLicense) {
        for (IClientFunctionLicenseType iClientFunctionLicenseType : AbstractClientFunctionLicenseManager.getClientFunctionLicenseTypes()) {
            IClientFunctionLicense license = iClientFunctionLicenseType.getClientFunctionLicense(productOrModuleLicense);
            if (license == null) continue;
            this.putClientFunctionLicense(license);
        }
    }

    private void putClientFunctionLicense(IClientFunctionLicense functionLicense) {
        ArrayList<IClientFunctionLicense> licenses = this.effectiveFunctionLicenseMap.get(functionLicense.getType());
        if (licenses == null) {
            licenses = new ArrayList(4);
            this.effectiveFunctionLicenseMap.put(functionLicense.getType(), licenses);
        }
        int insertPosition = licenses.size();
        int i = 0;
        while (i < licenses.size()) {
            if (licenses.get(i).compareTo(functionLicense) < 0) {
                insertPosition = i;
                break;
            }
            ++i;
        }
        licenses.add(insertPosition, functionLicense);
    }

    private boolean isValid(IClientFunctionLicense fucntionLicense) {
        Timestamp endDate = fucntionLicense.getEndDate();
        return endDate == null || endDate.getTime() >= System.currentTimeMillis();
    }
}

