/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.global.gui.wizards.newproject;

import com.arcway.cockpit.frame.client.global.gui.wizards.newproject.AbstractProjectSelectionDialog;
import com.arcway.cockpit.frame.shared.message.EOProject;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.FilteredList;

public class ProjectSelectionDialog
extends AbstractProjectSelectionDialog {
    private final String shellText;
    private final String title;
    private final String message;
    private final EOProject[] projects;
    private EOProject selectedProject;

    public ProjectSelectionDialog(Shell shell, EOProject[] projects, String shellText, String title, String message) {
        super(shell, false);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.shellText = shellText;
        this.title = title;
        this.message = message;
        this.projects = projects;
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(this.shellText);
        this.setTitle(this.title);
        this.setMessage(this.message);
        Composite base = new Composite(parent, 0);
        base.setLayoutData((Object)new GridData(1808));
        base.setLayout((Layout)new GridLayout(1, true));
        Composite childComposite = new Composite(base, 16);
        childComposite.setLayout((Layout)new GridLayout(2, false));
        GridData layoutData = new GridData(4, 4, true, false);
        childComposite.setLayoutData((Object)layoutData);
        Label lblSearch = new Label(childComposite, 0);
        lblSearch.setLayoutData((Object)new GridData());
        lblSearch.setText(FILTER_LABEL_TEXT);
        final Text filter = new Text(childComposite, 2048);
        filter.setLayoutData((Object)new GridData(768));
        final FilteredList fList = new FilteredList(base, 2052, (ILabelProvider)this.labelProvider, true, true, true);
        layoutData = new GridData(4, 4, true, true);
        layoutData.heightHint = 200;
        fList.setLayoutData((Object)layoutData);
        fList.setElements((Object[])this.projects);
        fList.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                Object[] selection = fList.getSelection();
                if (selection.length == 1 && selection[0] instanceof EOProject) {
                    ProjectSelectionDialog.this.selectedProject = (EOProject)selection[0];
                } else {
                    ProjectSelectionDialog.this.selectedProject = null;
                }
                ProjectSelectionDialog.this.refresh();
                Button button = ProjectSelectionDialog.this.getButton(0);
                if (button != null && !button.isDisposed() && button.isVisible() && button.isEnabled()) {
                    ProjectSelectionDialog.this.buttonPressed(0);
                }
            }

            public void widgetSelected(SelectionEvent e) {
                Object[] selection = fList.getSelection();
                if (selection.length == 1 && selection[0] instanceof EOProject) {
                    ProjectSelectionDialog.this.selectedProject = (EOProject)selection[0];
                } else {
                    ProjectSelectionDialog.this.selectedProject = null;
                }
                ProjectSelectionDialog.this.refresh();
            }
        });
        filter.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String filterText = "*" + filter.getText().toLowerCase();
                fList.setFilter(filterText);
            }
        });
        if (this.projects.length == 1) {
            fList.setSelection(new int[1]);
        }
        return base;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.getButton(0).setEnabled(false);
    }

    private void refresh() {
        boolean okEnabled = this.selectedProject != null;
        this.getButton(0).setEnabled(okEnabled);
    }

    public static EOProject open(Shell shell, EOProject[] projects, String shellText, String title, String message) {
        ProjectSelectionDialog dialog = new ProjectSelectionDialog(shell, projects, shellText, title, message);
        if (dialog.open() == 0) {
            return dialog.selectedProject;
        }
        return null;
    }
}

