/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.global.gui.wizards.newproject;

import com.arcway.cockpit.frame.client.global.Messages;
import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.global.gui.wizards.newproject.AbstractProjectSelectionDialog;
import com.arcway.cockpit.frame.client.global.gui.wizards.newproject.RenameProjectDialog;
import com.arcway.cockpit.frame.client.project.ExProjectOpenAbortWithMessage;
import com.arcway.cockpit.frame.client.project.Project;
import com.arcway.cockpit.frame.client.project.ProjectAgent;
import com.arcway.cockpit.frame.client.project.ProjectAttributeTypeProvider;
import com.arcway.cockpit.frame.client.project.core.framedata.ModificationProblem;
import com.arcway.cockpit.frame.client.project.core.serverproxy.IProjectManagerServerProxy;
import com.arcway.cockpit.frame.client.project.datainterchange.ImportFailedException;
import com.arcway.cockpit.frame.shared.message.EOProject;
import com.arcway.cockpit.frame.shared.message.genericframedata.EOAttribute;
import com.arcway.cockpit.frame.shared.message.genericframedata.EOAttributeTypeID;
import com.arcway.lib.eclipse.gui.ModificationProblemsDialog;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import de.plans.fmca.client.PSCServices;
import de.plans.lib.xml.encoding.EOEncodableObject;
import de.plans.lib.xml.primitiveTypes.EOString;
import de.plans.psc.client.communication.ExPrematureEndOfTransfer;
import de.plans.psc.client.communication.LoginCanceledException;
import de.plans.psc.client.communication.ServerConnection;
import de.plans.psc.client.communication.ServerNotAvailableException;
import de.plans.psc.client.communication.UnknownServerException;
import de.plans.psc.shared.serverexceptions.EXServerException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.dialogs.FilteredList;

public class GetProjectFromServerDialog
extends AbstractProjectSelectionDialog {
    private static final ILogger logger = Logger.getLogger(GetProjectFromServerDialog.class);
    private final ServerConnection server;
    private EOProject selectedProject;
    private final List<EOProject> projectsOnServer;
    private final String shellText;
    private final String title;
    private final String message;
    private final IInputValidator nameValidator;
    private final IWorkbenchPage currentPage;
    private String conflictMsg;
    private final String startError = "";

    public GetProjectFromServerDialog(IWorkbenchPage currentPage, ServerConnection server, EOProject[] projects, String shellText, String title, String message) {
        super(currentPage == null ? null : currentPage.getWorkbenchWindow().getShell(), false);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.currentPage = currentPage;
        this.shellText = shellText;
        this.title = title;
        this.message = message;
        this.projectsOnServer = new ArrayList<EOProject>(Arrays.asList(projects));
        this.server = server;
        this.nameValidator = ProjectMgr.getProjectMgr().getProjectManagerServerProxy(server.getServerID()).getProjectNameValidatorForGettingProjectFromServer();
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(this.shellText);
        this.setTitle(this.title);
        this.setMessage(String.valueOf(this.message) + " " + Messages.getString("GetProjectFromServerDialog.Please_select_a_project..._2"));
        Composite base = new Composite(parent, 0);
        base.setLayoutData((Object)new GridData(1808));
        base.setLayout((Layout)new GridLayout(1, true));
        Composite childComposite = new Composite(base, 16);
        childComposite.setLayout((Layout)new GridLayout(2, false));
        GridData layoutData = new GridData(4, 4, true, false);
        childComposite.setLayoutData((Object)layoutData);
        Label lblSearch = new Label(childComposite, 0);
        lblSearch.setLayoutData((Object)new GridData());
        lblSearch.setText(FILTER_LABEL_TEXT);
        final Text filter = new Text(childComposite, 2048);
        filter.setLayoutData((Object)new GridData(768));
        final FilteredList fList = new FilteredList(base, 2052, (ILabelProvider)this.labelProvider, true, true, true);
        layoutData = new GridData(4, 4, true, true);
        layoutData.heightHint = 200;
        fList.setLayoutData((Object)layoutData);
        fList.setElements(this.projectsOnServer.toArray());
        fList.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                Object[] selection = fList.getSelection();
                if (selection.length == 1 && selection[0] instanceof EOProject) {
                    GetProjectFromServerDialog.this.selectedProject = (EOProject)selection[0];
                } else {
                    GetProjectFromServerDialog.this.selectedProject = null;
                }
                GetProjectFromServerDialog.this.refresh();
                Button button = GetProjectFromServerDialog.this.getButton(0);
                if (button != null && !button.isDisposed() && button.isVisible() && button.isEnabled()) {
                    GetProjectFromServerDialog.this.buttonPressed(0);
                }
            }

            public void widgetSelected(SelectionEvent e) {
                Object[] selection = fList.getSelection();
                if (selection.length == 1 && selection[0] instanceof EOProject) {
                    GetProjectFromServerDialog.this.selectedProject = (EOProject)selection[0];
                } else {
                    GetProjectFromServerDialog.this.selectedProject = null;
                }
                GetProjectFromServerDialog.this.refresh();
            }
        });
        filter.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String filterText = "*" + filter.getText().toLowerCase();
                fList.setFilter(filterText);
            }
        });
        if (this.conflictMsg != null) {
            Text conflictText = new Text(base, 2);
            conflictText.setEditable(false);
            conflictText.setText(this.conflictMsg);
        }
        if (this.projectsOnServer.isEmpty()) {
            this.setErrorMessage(Messages.getString("GetProjectFromServerDialog.No_new_projects_found_on_the_selected_server_3"));
        }
        if (!"".equals("")) {
            this.setErrorMessage("");
        } else if (this.projectsOnServer.isEmpty()) {
            this.setErrorMessage(Messages.getString("GetProjectFromServerDialog.No_new_projects_found_on_the_selected_server_3"));
        }
        return base;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.getButton(0).setEnabled(false);
    }

    private void refresh() {
        if (this.selectedProject == null) {
            this.getButton(0).setEnabled(false);
        } else {
            String msg = this.nameValidator.isValid(Project.getProjectName(this.selectedProject));
            if (msg != null) {
                this.setErrorMessage(msg);
            }
            this.getButton(0).setEnabled(msg == null);
        }
    }

    public int open() {
        IProjectManagerServerProxy serverProxy = ProjectMgr.getProjectMgr().getProjectManagerServerProxy(this.server.getServerID());
        ArrayList<ProjectAgent> conflictingProjectAgents = new ArrayList<ProjectAgent>();
        Iterator<EOProject> i = this.projectsOnServer.iterator();
        while (i.hasNext()) {
            EOProject serverP = i.next();
            ProjectAgent clientProjectAgent = ProjectMgr.getProjectMgr().getProjectAgent(serverP.getProjectUID());
            if (clientProjectAgent == null) continue;
            i.remove();
            if (clientProjectAgent.getServerID().equals(this.server.getServerID())) continue;
            conflictingProjectAgents.add(clientProjectAgent);
        }
        if (conflictingProjectAgents.size() > 0) {
            this.conflictMsg = String.valueOf(Messages.getString("GetProjectFromServerDialog._nWarning_!_n_nServer__4")) + this.server.getServerName() + Messages.getString("GetProjectFromServerDialog._contains_the_following_projects,_which_are_also_available_on_other_servers__5");
            int i2 = 0;
            while (i2 < conflictingProjectAgents.size()) {
                ProjectAgent project = (ProjectAgent)conflictingProjectAgents.get(i2);
                String serverName = PSCServices.getServiceFacade().getServerName(project.getServerID());
                this.conflictMsg = String.valueOf(this.conflictMsg) + "\n - " + project.getProjectName() + Messages.getString("GetProjectFromServerDialog._[Server___7") + serverName + "]";
                ++i2;
            }
            this.conflictMsg = String.valueOf(this.conflictMsg) + Messages.getString("GetProjectFromServerDialog._n_nIt_is_not_possible_to_connect_to_two_instance_of_the_same_project._9");
        }
        if (serverProxy.getNumberOfMaxProjectsOnServer() != 1) {
            return super.open();
        }
        if (this.projectsOnServer.size() == 0) {
            MessageBox dlg = new MessageBox(this.getShell(), 257);
            dlg.setText(serverProxy.getGetProjectFromServerLabel());
            dlg.setMessage(Messages.getString("GetProjectFromServerDialog.project_exists"));
            dlg.open();
        } else if (this.projectsOnServer.size() == 1) {
            this.selectedProject = this.projectsOnServer.get(0);
            String newName = Project.getProjectName(this.selectedProject);
            String problem = this.nameValidator.isValid(newName);
            while (problem != null) {
                RenameProjectDialog dialog = new RenameProjectDialog(this.getShell(), problem);
                int answer = dialog.open();
                if (answer == 1) {
                    this.selectedProject = null;
                    return 1;
                }
                newName = dialog.getNewName();
                problem = this.nameValidator.isValid(newName);
            }
            EOString eoName = new EOString(newName);
            EOAttributeTypeID attributeTypeID = new EOAttributeTypeID(ProjectAttributeTypeProvider.ATTRID_NAME.getUID(), "name");
            EOAttribute nameAttribute = new EOAttribute();
            nameAttribute.setAttributeTypeID(attributeTypeID);
            nameAttribute.setValueAsEO((EOEncodableObject)eoName);
            this.selectedProject.addAttribute(nameAttribute);
            this.okPressed();
            return 0;
        }
        this.selectedProject = null;
        return 1;
    }

    protected void okPressed() {
        if (this.selectedProject != null) {
            Throwable th = null;
            try {
                IProjectManagerServerProxy sp = ProjectMgr.getProjectMgr().getProjectManagerServerProxy(this.server.getServerID());
                boolean triggerUserOnOpenActions = true;
                sp.getProjectFromServer(this.selectedProject, this.currentPage, triggerUserOnOpenActions);
                super.okPressed();
                return;
            }
            catch (ServerNotAvailableException e) {
                th = e;
            }
            catch (EXServerException e) {
                th = e;
            }
            catch (LoginCanceledException e) {
                th = e;
            }
            catch (UnknownServerException e) {
                th = e;
            }
            catch (IOException e) {
                th = e;
            }
            catch (ExPrematureEndOfTransfer e) {
                th = e;
            }
            catch (ImportFailedException e) {
                th = e;
            }
            catch (ExProjectOpenAbortWithMessage e) {
                th = e;
            }
            String descriptionOfConsequence = Messages.getString("GetProjectFromServerDialog.Failed.DescriptionOfConsequence");
            String genericMessage = Messages.getString("GetProjectFromServerDialog.Failed.genericMessage");
            String dialogTitle = Messages.getString("GetProjectFromServerDialog.Failed.dialogTitle");
            String dialogMessage = Messages.getString("GetProjectFromServerDialog.Failed.dialogMessage");
            GetProjectFromServerDialog.handleGetProjectFromServerThrowable(th, this.getShell(), Project.getProjectName(this.selectedProject), descriptionOfConsequence, genericMessage, dialogTitle, dialogMessage);
        }
    }

    private static void handleGetProjectFromServerThrowable(Throwable th, Shell parentShell, String projectOrServerName, String humanReadableDescriptionOfConsequence, String exGenericMessage, String dialogTitle, String dialogMessage) {
        Exception userShownEx;
        Throwable thToHandle = (th instanceof ExPrematureEndOfTransfer || th instanceof ImportFailedException) && th.getCause() != null ? th.getCause() : th;
        if (thToHandle instanceof Exception) {
            userShownEx = (Exception)thToHandle;
        } else {
            userShownEx = new Exception(exGenericMessage);
            userShownEx.initCause(thToHandle);
        }
        logger.warn("Error when fetching project from server.", th);
        ModificationProblem mProblem = new ModificationProblem(userShownEx, 2, humanReadableDescriptionOfConsequence);
        ArrayList<ModificationProblem> mProblems = new ArrayList<ModificationProblem>();
        mProblems.add(mProblem);
        String mProblemDialogMessage = NLS.bind((String)dialogMessage, (Object)projectOrServerName);
        ModificationProblemsDialog mpDialog = new ModificationProblemsDialog(mProblems, dialogTitle, mProblemDialogMessage, parentShell);
        mpDialog.open();
    }
}

