/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.global.gui.wizards.newproject;

import com.arcway.cockpit.frame.client.global.Messages;
import com.arcway.cockpit.frame.client.global.ProjectMgr;
import de.plans.psc.client.communication.ServerConnection;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class CreateNewProjectWizardPage
extends WizardPage {
    private final IInputValidator nameValidator;
    private Text projectName;
    private Text projectDescription;
    private Composite base;
    private final String predefinedDescription;

    protected CreateNewProjectWizardPage(ServerConnection server, String predefinedDescription) {
        super(Messages.getString("CreateNewProjectWizardPage.Create_new_project_on_server_1"));
        this.predefinedDescription = predefinedDescription;
        this.nameValidator = ProjectMgr.getProjectMgr().getProjectManagerServerProxy(server.getServerID()).getProjectNameValidatorForCreatingNewProjectOnServer();
        this.setTitle(Messages.getString("CreateNewProjectWizardPage.Create_a_new_project_on_the_selected_server_2"));
        this.setMessage(Messages.getString("CreateNewProjectWizardPage.Please_enter_the_project__s_name_and_it__s_description_3"));
    }

    public void createControl(Composite arg0) {
        this.base = new Composite(arg0, 0);
        this.base.setLayoutData((Object)new GridData(4, 0, true, false));
        this.base.setLayout((Layout)new GridLayout());
        Composite nameAndDescription = new Composite(this.base, 0);
        nameAndDescription.setLayoutData((Object)new GridData(4, 4, true, true));
        nameAndDescription.setLayout((Layout)new GridLayout(2, false));
        Label label = new Label(nameAndDescription, 0);
        label.setText(Messages.getString("CreateNewProjectWizardPage.Name_4"));
        this.projectName = new Text(nameAndDescription, 2052);
        GridData data = new GridData(4, 0, true, false);
        this.projectName.setLayoutData((Object)data);
        this.projectName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CreateNewProjectWizardPage.this.setErrorMessage(CreateNewProjectWizardPage.this.nameValidator.isValid(CreateNewProjectWizardPage.this.projectName.getText()));
            }
        });
        label = new Label(nameAndDescription, 0);
        label.setText(Messages.getString("CreateNewProjectWizardPage.Description_5"));
        data = new GridData();
        data.verticalAlignment = 1;
        label.setLayoutData((Object)data);
        this.projectDescription = new Text(nameAndDescription, 2626);
        data = new GridData(4, 4, true, true);
        data.widthHint = 280;
        this.projectDescription.setLayoutData((Object)data);
        this.setControl((Control)this.base);
        this.setPageComplete(false);
        if (this.predefinedDescription != null) {
            this.projectDescription.setText(this.predefinedDescription);
        }
        this.projectName.setFocus();
    }

    protected String getProjectName() {
        return this.projectName.getText().trim();
    }

    protected String getProjectDescription() {
        String ds = this.projectDescription.getText();
        if (ds == null) {
            ds = "";
        }
        return ds.trim();
    }

    public void setErrorMessage(String newMessage) {
        this.setPageComplete(newMessage == null);
        super.setErrorMessage(newMessage);
    }

    public boolean isPageComplete() {
        return this.projectName.getText().trim().length() > 0 && super.isPageComplete();
    }
}

