/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.global.gui.wizards;

import com.arcway.cockpit.frame.client.global.Messages;
import com.arcway.cockpit.frame.client.global.gui.wizards.WizardInformation;
import java.util.List;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardSelectionPage;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class MainSynchronizeWizardSelectionPage
extends WizardSelectionPage
implements ISelectionChangedListener,
IDoubleClickListener {
    private final List synchronizeWizards;

    public MainSynchronizeWizardSelectionPage(String pageName, List wizards) {
        super(pageName);
        assert (wizards != null) : "wizards list is null";
        this.synchronizeWizards = wizards;
        this.setTitle(Messages.getString("MainSynchronizeWizardSelectionPage.0"));
    }

    public void createControl(Composite parent) {
        Composite filler = new Composite(parent, 0);
        filler.setLayout((Layout)new FillLayout());
        Composite composite = new Composite(filler, 0);
        composite.setLayout((Layout)new GridLayout());
        Label synchronizeTarget = new Label(composite, 0);
        synchronizeTarget.setText(Messages.getString("MainSynchronizeWizardSelectionPage.1"));
        synchronizeTarget.setLayoutData((Object)new GridData(512));
        Composite fillC = new Composite(composite, 0);
        fillC.setLayout((Layout)new FillLayout());
        fillC.setLayoutData((Object)new GridData(1808));
        TableViewer listViewer = new TableViewer(fillC, 2816);
        listViewer.setContentProvider((IContentProvider)new ExportWizardListContentProvider());
        listViewer.setLabelProvider((IBaseLabelProvider)new ExportWizardListLabelProvider());
        listViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        listViewer.addDoubleClickListener((IDoubleClickListener)this);
        listViewer.setInput((Object)this.synchronizeWizards);
        this.setControl((Control)filler);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
        WizardInformation wi = (WizardInformation)selection.getFirstElement();
        this.setDescription(wi.getDescription());
        if (!wi.hasPermission()) {
            this.setMessage(wi.getPermissionErrorText(), 3);
            this.setSelectedNode(null);
        } else {
            this.setMessage(null, 3);
            this.setSelectedNode(wi);
        }
    }

    public void doubleClick(DoubleClickEvent event) {
        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
        WizardInformation wi = (WizardInformation)selection.getFirstElement();
        this.setSelectedNode(wi);
        if (wi.hasPermission()) {
            this.getContainer().showPage(this.getNextPage());
        }
    }

    private static class ExportWizardListContentProvider
    implements IStructuredContentProvider {
        private ExportWizardListContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return ((List)inputElement).toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private static class ExportWizardListLabelProvider
    implements ILabelProvider {
        private ExportWizardListLabelProvider() {
        }

        public Image getImage(Object element) {
            return ((WizardInformation)element).getImage();
        }

        public String getText(Object element) {
            return ((WizardInformation)element).getWizardName();
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

