/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.global.gui.wizards;

import com.arcway.cockpit.frame.client.global.ExtensionMgr;
import com.arcway.cockpit.frame.client.global.FramePlugin;
import com.arcway.cockpit.frame.client.global.Messages;
import com.arcway.cockpit.frame.client.global.gui.wizards.IWizardDescription;
import com.arcway.cockpit.frame.client.global.gui.wizards.IWizardProvider;
import com.arcway.cockpit.frame.client.global.gui.wizards.MainSynchronizeWizardSelectionPage;
import com.arcway.cockpit.frame.client.global.gui.wizards.WizardInformation;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.graphics.Image;

public class MainSynchronizeWizard
extends Wizard {
    private final Object selectedElement;
    private static final String SYNCHRONIZE_WIZARD_ELEMENT_NAME = "WizardProvider";
    private static final String SYNCHRONIZE_WIZARD_CLASS_ATTRIBUTE = "wizardProvider";
    private static List synchronizeWizardProviders = null;

    public MainSynchronizeWizard(Object selectedElement) {
        this.selectedElement = selectedElement;
        this.setWindowTitle(Messages.getString("MainSynchronizeWizard.1"));
        this.setDefaultPageImageDescriptor(FramePlugin.getImageDescriptor("synchronize_wiz_big.gif"));
        this.setForcePreviousAndNextButtons(true);
    }

    public void addPages() {
        List synchronizeWizardProviders = MainSynchronizeWizard.getSynchronizeWizardProviders();
        ArrayList<WizardInformation> synchronizeWizards = new ArrayList<WizardInformation>();
        for (IWizardProvider provider : synchronizeWizardProviders) {
            for (IWizardDescription iWizardDescription : provider.getWizardDescriptions(this.selectedElement)) {
                IWizardDescription wizardDescription = iWizardDescription;
                if (!wizardDescription.validForSelectedElement(this.selectedElement)) continue;
                Image image = wizardDescription.getImageDescriptor().createImage();
                WizardInformation wi = new WizardInformation(wizardDescription.getID(), wizardDescription.getName(), wizardDescription.getWizard(this.selectedElement), image, wizardDescription.getDescription(), wizardDescription.hasPermissionForSelectedElement(this.selectedElement), wizardDescription.getPermissionError());
                if (wi == null) continue;
                synchronizeWizards.add(wi);
            }
        }
        MainSynchronizeWizardSelectionPage mainSynchronizeWizardSelectionPage = new MainSynchronizeWizardSelectionPage(Messages.getString("MainSynchronizeWizard.0"), synchronizeWizards);
        this.addPage((IWizardPage)mainSynchronizeWizardSelectionPage);
    }

    public static List getSynchronizeWizardProviders() {
        if (synchronizeWizardProviders == null) {
            ExtensionMgr emgr = ExtensionMgr.getDefault();
            synchronizeWizardProviders = emgr.getExtension("synchronizewizards", SYNCHRONIZE_WIZARD_ELEMENT_NAME, SYNCHRONIZE_WIZARD_CLASS_ATTRIBUTE);
        }
        return synchronizeWizardProviders;
    }

    public static boolean hasSynchronizeWizardProviders() {
        return !MainSynchronizeWizard.getSynchronizeWizardProviders().isEmpty();
    }

    public boolean performFinish() {
        return true;
    }
}

