/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.global.gui.wizards;

import com.arcway.cockpit.frame.client.global.ExtensionMgr;
import com.arcway.cockpit.frame.client.global.FramePlugin;
import com.arcway.cockpit.frame.client.global.Messages;
import com.arcway.cockpit.frame.client.global.gui.wizards.IWizardDescription;
import com.arcway.cockpit.frame.client.global.gui.wizards.IWizardProvider;
import com.arcway.cockpit.frame.client.global.gui.wizards.MainImportWizardSelectionPage;
import com.arcway.cockpit.frame.client.global.gui.wizards.WizardInformation;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.core.sectionsandplans.sections.ISection;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.graphics.Image;

public class MainImportWizard
extends Wizard {
    private static final String IMPORT_WIZARD_ELEMENT_NAME = "wizard";
    private static final String IMPORT_WIZARD_CLASS_ATTRIBUTE = "wizard";
    private static List importWizardProviders = null;
    private IFrameProjectAgent projectAgent;
    private String sectionUID;
    private final ICockpitProjectData selectedElement;
    private final Collection<Image> currentImages = new ArrayList<Image>();

    public MainImportWizard(ICockpitProjectData selectedElement) {
        assert (selectedElement != null);
        this.selectedElement = selectedElement;
    }

    public void init(IFrameProjectAgent newProjectAgent, String newSectionUID) {
        this.setWindowTitle(Messages.getString("MainImportWizard.Import_1"));
        this.setDefaultPageImageDescriptor(FramePlugin.getImageDescriptor("import_wiz_big.gif"));
        this.setForcePreviousAndNextButtons(true);
        this.projectAgent = newProjectAgent;
        this.sectionUID = newSectionUID;
    }

    public void addPages() {
        List importWizardProviders = MainImportWizard.getImportWizardProviders();
        ArrayList<WizardInformation> importWizards = new ArrayList<WizardInformation>();
        for (IWizardProvider provider : importWizardProviders) {
            for (IWizardDescription iWizardDescription : provider.getWizardDescriptions(this.selectedElement)) {
                IWizardDescription wizardDescription = iWizardDescription;
                if (!wizardDescription.validForSelectedElement(this.selectedElement)) continue;
                Image image = wizardDescription.getImageDescriptor().createImage();
                WizardInformation wi = new WizardInformation(wizardDescription.getID(), wizardDescription.getName(), wizardDescription.getWizard(this.selectedElement), image, wizardDescription.getDescription(), wizardDescription.hasPermissionForSelectedElement(this.selectedElement), wizardDescription.getPermissionError());
                if (wi != null) {
                    importWizards.add(wi);
                }
                this.currentImages.add(image);
            }
        }
        MainImportWizardSelectionPage mainImportWizardSelectionPage = new MainImportWizardSelectionPage(Messages.getString("MainImportWizard.Import_3"), importWizards);
        this.addPage((IWizardPage)mainImportWizardSelectionPage);
    }

    public boolean performFinish() {
        return true;
    }

    public void dispose() {
        super.dispose();
        for (Image image : this.currentImages) {
            if (image == null || image.isDisposed()) continue;
            image.dispose();
        }
        this.currentImages.clear();
    }

    public IFrameProjectAgent getProjectAgent() {
        return this.projectAgent;
    }

    public String getSectionUID() {
        return this.sectionUID;
    }

    public ISection getSection() {
        return this.projectAgent.getFrameSectionManager().getSection(this.sectionUID);
    }

    public static List getImportWizardProviders() {
        if (importWizardProviders == null) {
            ExtensionMgr emgr = ExtensionMgr.getDefault();
            importWizardProviders = emgr.getExtension("importwizards", "wizard", "wizard");
        }
        return importWizardProviders;
    }

    public static boolean hasImportWizardProviders() {
        return !MainImportWizard.getImportWizardProviders().isEmpty();
    }
}

