/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.global.gui.wizards;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeType;
import com.arcway.cockpit.frame.client.global.Messages;
import com.arcway.cockpit.frame.client.global.gui.validators.RenameSectionValidator;
import com.arcway.cockpit.frame.client.global.gui.wizards.AbstractWizardPageWithCategorySelection;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.core.framedata.IAttributeTypesProvider;
import com.arcway.cockpit.frame.client.project.core.framedata.ModificationProblem;
import com.arcway.cockpit.frame.client.project.core.sectionsandplans.sections.ISection;
import com.arcway.cockpit.frame.client.project.core.sectionsandplans.sections.SectionAttributeTypesProvider;
import com.arcway.cockpit.frame.client.project.core.userdefinedattributetypes.IParentOperandTree;
import com.arcway.cockpit.frame.shared.IPermissionOperand;
import com.arcway.lib.eclipse.gui.LineSeparator;
import com.arcway.lib.eclipse.gui.ModificationProblemsDialog;
import com.arcway.lib.eclipse.gui.dialogs.ArcwayWizardDialog;
import com.arcway.lib.ui.IModificationProblem;
import com.arcway.lib.ui.editor.ObjectTypeCategoryLabels;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class CreateSectionWizardPage
extends AbstractWizardPageWithCategorySelection {
    private final ISection parentSection;
    private String typedSection;
    private String typedDescription;
    private final Collection<IModificationProblem> modificationProblems = new ArrayList<IModificationProblem>();
    private RenameSectionValidator validator;
    private final IParentOperandTree operandTree = new IParentOperandTree(){

        @Override
        public IPermissionOperand getBaseOperand() {
            return CreateSectionWizardPage.this.parentSection;
        }

        @Override
        public IPermissionOperand getParent(IPermissionOperand childOperand) {
            return CreateSectionWizardPage.this.projectAgent.getFrameSectionManager().getParentSection((ISection)childOperand);
        }
    };
    private Combo categoryCombo;

    public CreateSectionWizardPage(ISection parentSection, IFrameProjectAgent projectAgent, String pageName, String title, ImageDescriptor titleImage) {
        super(projectAgent, pageName, title, titleImage);
        this.parentSection = parentSection;
        this.setPageComplete(false);
    }

    @Override
    public void createControl_internal(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite.setLayout((Layout)gridLayout);
        Label label = new Label(composite, 256);
        GridDataFactory.fillDefaults().align(4, 2).grab(false, false).applyTo((Control)label);
        label.setText(String.valueOf(ObjectTypeCategoryLabels.LABEL_CATEGORY) + ":");
        this.categoryCombo = new Combo(composite, 12);
        GridDataFactory.fillDefaults().align(4, 2).grab(true, false).applyTo((Control)this.categoryCombo);
        LineSeparator line = new LineSeparator(composite, 0);
        GridDataFactory.fillDefaults().align(4, 2).grab(true, false).span(2, 1).applyTo((Control)line);
        Label space = new Label(composite, 0);
        GridDataFactory.fillDefaults().align(4, 2).grab(true, false).span(2, 1).applyTo((Control)space);
        Label sectionLabel = new Label(composite, 0);
        sectionLabel.setText(Messages.getString("CreateSectionWizardPage.Folder_Name__1"));
        final Text sectionText = new Text(composite, 2048);
        sectionText.setData((Object)"Section");
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        sectionText.setLayoutData((Object)gridData);
        sectionText.setFocus();
        sectionText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String v;
                CreateSectionWizardPage.this.typedSection = sectionText.getText();
                if (CreateSectionWizardPage.this.validator == null) {
                    CreateSectionWizardPage.this.validator = new RenameSectionValidator(CreateSectionWizardPage.this.projectAgent, CreateSectionWizardPage.this.parentSection);
                }
                CreateSectionWizardPage.this.setPageComplete((v = CreateSectionWizardPage.this.validator.isValid(CreateSectionWizardPage.this.typedSection)) == null);
                CreateSectionWizardPage.this.setErrorMessage(v);
            }
        });
        Label descriptionLabel = new Label(composite, 0);
        GridData data = new GridData();
        data.verticalAlignment = 2;
        descriptionLabel.setLayoutData((Object)data);
        descriptionLabel.setText(Messages.getString("CreateSectionWizardPage.Description__3"));
        final Text descriptionText = new Text(composite, 2626);
        descriptionText.setLayoutData((Object)new GridData(1808));
        IAttributeTypesProvider provider = this.projectAgent.getFrameDataAttributeTypesProviderManager().getAttributeTypesProvider("com.arcway.cockpit.section");
        IAttributeType descriptionType = provider.getAttributeType(SectionAttributeTypesProvider.ATTRID_DESCRIPTION);
        if (this.projectAgent.getFramePermissionChecker().hasAttributeModificationPermission(descriptionType, this.operandTree, true)) {
            descriptionText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    CreateSectionWizardPage.this.typedDescription = descriptionText.getText();
                }
            });
            descriptionText.setEditable(true);
        } else {
            this.addModificationProblem(new ModificationProblem(descriptionType, this.operandTree, this.projectAgent));
            descriptionText.setEditable(false);
        }
        this.setControl((Control)composite);
    }

    private void addModificationProblem(IModificationProblem problem) {
        this.modificationProblems.add(problem);
        IWizardContainer container = this.getWizard().getContainer();
        if (container instanceof ArcwayWizardDialog) {
            ArcwayWizardDialog dialog = (ArcwayWizardDialog)container;
            dialog.setHelpEnabled(true);
        }
    }

    public String getSectionName() {
        return this.typedSection;
    }

    public String getSectionDescription() {
        return this.typedDescription;
    }

    public void performHelp() {
        ModificationProblemsDialog dialog = new ModificationProblemsDialog(this.modificationProblems, this.getShell());
        dialog.open();
    }

    public void setWizard(IWizard newWizard) {
        super.setWizard(newWizard);
        IWizardContainer container = this.getWizard().getContainer();
        if (container instanceof ArcwayWizardDialog) {
            ArcwayWizardDialog dialog = (ArcwayWizardDialog)container;
            dialog.setHelpEnabled(!this.modificationProblems.isEmpty());
        }
    }

    @Override
    protected Combo getCategoryCombo() {
        return this.categoryCombo;
    }

    @Override
    protected String getFrameDataTypeID() {
        return "com.arcway.cockpit.section";
    }
}

