/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.global.gui.wizards;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttribute;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeType;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.ObjectTypeCategoryID;
import com.arcway.cockpit.client.base.interfaces.frame.permissions.EXNoPermission;
import com.arcway.cockpit.frame.client.global.FramePlugin;
import com.arcway.cockpit.frame.client.global.Messages;
import com.arcway.cockpit.frame.client.global.gui.wizards.CreateSectionWizardPage;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.ISectionAddID;
import com.arcway.cockpit.frame.client.project.core.framedata.Attribute;
import com.arcway.cockpit.frame.client.project.core.framedata.FrameDataTypes;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.DataTypeText;
import com.arcway.cockpit.frame.client.project.core.sectionsandplans.sections.ISection;
import com.arcway.cockpit.frame.client.project.core.sectionsandplans.sections.SectionAttributeTypesProvider;
import com.arcway.cockpit.frame.client.project.core.userdefinedattributetypes.CreateDataWithUserDefinedAttributeTypesWizardPage;
import com.arcway.cockpit.frame.client.project.core.userdefinedattributetypes.IParentOperandTree;
import com.arcway.cockpit.frame.shared.IPermissionOperand;
import com.arcway.lib.eclipse.gui.ModificationProblemsDialog;
import com.arcway.lib.eclipse.gui.dialogs.IArcwayWizard;
import com.arcway.lib.eclipse.gui.dialogs.wizardpages.IWizardPageModificationInProgress;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.ui.IModificationProblem;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.osgi.util.NLS;

public class CreateSectionWizard
extends Wizard
implements IArcwayWizard {
    private static final ILogger logger = Logger.getLogger(CreateSectionWizard.class);
    private final ISection parentSection;
    private final IFrameProjectAgent projectAgent;
    private CreateSectionWizardPage createSectionWizardPage;
    private CreateDataWithUserDefinedAttributeTypesWizardPage userDefinedAttributeTypesPage;

    public CreateSectionWizard(IFrameProjectAgent projectAgent, ISection parentSection) {
        this.projectAgent = projectAgent;
        this.parentSection = parentSection;
        this.setDefaultPageImageDescriptor(FramePlugin.getImageDescriptor("newfolder_wiz_big.gif"));
    }

    public boolean performFinish() {
        ISectionAddID addID;
        ArrayList<IAttribute> attributes = new ArrayList<IAttribute>();
        String typedName = this.createSectionWizardPage.getSectionName();
        String typedDescription = this.createSectionWizardPage.getSectionDescription();
        ObjectTypeCategoryID objectTypeCategoryID = this.createSectionWizardPage.getObjectTypeCategoryID();
        if (typedDescription != null) {
            Attribute description = new Attribute(SectionAttributeTypesProvider.ATTRID_DESCRIPTION, DataTypeText.getInstanceText().getAttributeValueFromString(typedDescription, null, null));
            attributes.add(description);
        }
        if (this.userDefinedAttributeTypesPage != null) {
            attributes.addAll(this.userDefinedAttributeTypesPage.getAttributes());
        }
        if ((addID = this.projectAgent.getFrameSectionManager().requestSectionAdditionPermission(typedName, this.parentSection, objectTypeCategoryID, attributes)).permissionGranted()) {
            try {
                this.projectAgent.getFrameSectionManager().addSection(addID);
            }
            catch (EXNoPermission e) {
                logger.error("could not execute", (Throwable)e);
            }
        } else {
            IModificationProblem modProblem = addID.getModificationProblem();
            ArrayList<IModificationProblem> mpProblems = new ArrayList<IModificationProblem>();
            mpProblems.add(modProblem);
            String title = Messages.getString("CreateSectionWizard.CannotCreateSection.Title");
            String message = NLS.bind((String)Messages.getString("CreateSectionWizard.CannotCreateSection.Message"), (Object)typedName);
            ModificationProblemsDialog mpDialog = new ModificationProblemsDialog(mpProblems, title, message, this.getShell());
            mpDialog.open();
        }
        if (this.userDefinedAttributeTypesPage != null) {
            this.userDefinedAttributeTypesPage.disposeResources();
        }
        return addID.permissionGranted();
    }

    public boolean performCancel() {
        if (this.userDefinedAttributeTypesPage != null) {
            this.userDefinedAttributeTypesPage.disposeResources();
        }
        return super.performCancel();
    }

    public void addPages() {
        this.setWindowTitle(Messages.getString("CreateSectionWizard.New_Folder_2"));
        this.createSectionWizardPage = new CreateSectionWizardPage(this.parentSection, this.projectAgent, "CreateSectionPage", Messages.getString("CreateSectionWizard.Folder_4"), null);
        this.createSectionWizardPage.setDescription(Messages.getString("CreateSectionWizard.Create_a_new_Folder._5"));
        this.addPage((IWizardPage)this.createSectionWizardPage);
        List<IAttributeType> types = this.projectAgent.getFrameUserDefinedAttributeTypesManager().getAllUserDefinedAttributeTypes("com.arcway.cockpit.section");
        if (!types.isEmpty()) {
            IParentOperandTree operandTree = new IParentOperandTree(){

                @Override
                public IPermissionOperand getBaseOperand() {
                    return CreateSectionWizard.this.parentSection;
                }

                @Override
                public IPermissionOperand getParent(IPermissionOperand childOperand) {
                    return CreateSectionWizard.this.projectAgent.getFrameSectionManager().getParentSection((ISection)childOperand);
                }
            };
            this.userDefinedAttributeTypesPage = new CreateDataWithUserDefinedAttributeTypesWizardPage(FrameDataTypes.getDataType("com.arcway.cockpit.section"), this.projectAgent.getProjectUID(), operandTree);
            this.createSectionWizardPage.addCategoryChangeListener(this.userDefinedAttributeTypesPage, false);
            this.addPage((IWizardPage)this.userDefinedAttributeTypesPage);
        }
    }

    public boolean isHelpAvailable() {
        return true;
    }

    public void nextPageRequested() {
    }

    public boolean canCancel() {
        boolean canCancel = true;
        IWizardPage[] iWizardPageArray = this.getPages();
        int n = iWizardPageArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWizardPage singlePage = iWizardPageArray[n2];
            if (singlePage instanceof IWizardPageModificationInProgress && !(canCancel &= !((IWizardPageModificationInProgress)singlePage).getModificationInProgress())) break;
            ++n2;
        }
        return canCancel;
    }

    public boolean canClose() {
        return this.canCancel();
    }

    public boolean showHelpOnPreventedClose() {
        return true;
    }
}

