/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.global.gui.wizards;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttribute;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.ObjectTypeCategoryID;
import com.arcway.cockpit.frame.client.global.FramePlugin;
import com.arcway.cockpit.frame.client.global.Messages;
import com.arcway.cockpit.frame.client.global.gui.wizards.CreatePlanTypeSelectionWizardPage;
import com.arcway.cockpit.frame.client.global.gui.wizards.CreatePlanWizardPage;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.core.framedata.Attribute;
import com.arcway.cockpit.frame.client.project.core.framedata.FrameDataTypes;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.DataTypeText;
import com.arcway.cockpit.frame.client.project.core.sectionsandplans.plan.PlanAttributeTypeProvider;
import com.arcway.cockpit.frame.client.project.core.sectionsandplans.sections.ISection;
import com.arcway.cockpit.frame.client.project.core.userdefinedattributetypes.CreateDataWithUserDefinedAttributeTypesWizardPage;
import com.arcway.cockpit.frame.client.project.core.userdefinedattributetypes.IParentOperandTree;
import com.arcway.cockpit.frame.shared.IPermissionOperand;
import com.arcway.lib.eclipse.gui.dialogs.IArcwayWizard;
import com.arcway.lib.eclipse.gui.dialogs.wizardpages.IWizardPageModificationInProgress;
import com.arcway.planagent.controllinginterface.planfilefactory.IPlanFileFactory;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;

public class CreatePlanWizard
extends Wizard
implements IArcwayWizard {
    private final IFrameProjectAgent projectAgent;
    private final CreatePlanWizardPage createPlanWizardPage;
    private final CreatePlanTypeSelectionWizardPage createPlanTypeSelectionWizardPage;
    private CreateDataWithUserDefinedAttributeTypesWizardPage userDefinedAttributeTypes;
    private String name;
    private String planType;
    private Collection<IAttribute> attributes;
    private final ISection parentSection;
    private ObjectTypeCategoryID categoryID;

    public CreatePlanWizard(IFrameProjectAgent projectAgent, ISection section) {
        this.projectAgent = projectAgent;
        this.parentSection = section;
        this.setDefaultPageImageDescriptor(FramePlugin.getImageDescriptor("newfolder_wiz_big.gif"));
        this.createPlanWizardPage = new CreatePlanWizardPage(section, projectAgent);
        this.createPlanTypeSelectionWizardPage = new CreatePlanTypeSelectionWizardPage(this);
    }

    public boolean performFinish() {
        this.name = this.createPlanWizardPage.getNewName();
        this.planType = this.createPlanTypeSelectionWizardPage.getSelectedFactoryDescription().getPlanTypeID();
        String description = this.createPlanWizardPage.getNewDescription();
        this.categoryID = this.createPlanWizardPage.getObjectTypeCategoryID();
        this.attributes = new ArrayList<IAttribute>();
        if (description != null) {
            this.attributes.add(new Attribute(PlanAttributeTypeProvider.ATTRID_DESCRIPTION, DataTypeText.getInstanceText().getAttributeValueFromString(description, null, null)));
        }
        if (this.userDefinedAttributeTypes != null) {
            this.attributes.addAll(this.userDefinedAttributeTypes.getAttributes());
        }
        return true;
    }

    public String getPlanName() {
        return this.name;
    }

    public String getPlanType() {
        return this.planType;
    }

    public Collection<IAttribute> getAttributes() {
        return this.attributes;
    }

    public ObjectTypeCategoryID getCategoryID() {
        return this.categoryID;
    }

    public IFrameProjectAgent getProjectAgent() {
        return this.projectAgent;
    }

    public void addPages() {
        this.setWindowTitle(Messages.getString("CreatePlanWizard.New_Plan_4"));
        this.createPlanTypeSelectionWizardPage.setDescription(Messages.getString("CreatePlanWizard.Create_a_new_Plan._5"));
        this.addPage((IWizardPage)this.createPlanTypeSelectionWizardPage);
        this.createPlanWizardPage.setDescription(Messages.getString("CreatePlanWizard.Create_a_new_Plan._5"));
        this.addPage((IWizardPage)this.createPlanWizardPage);
        if (this.projectAgent.getFrameUserDefinedAttributeTypesManager().hasUserDefinedAttributeTypes("com.arcway.cockpit.plan")) {
            IParentOperandTree parentOperandTree = new IParentOperandTree(){

                @Override
                public IPermissionOperand getBaseOperand() {
                    return CreatePlanWizard.this.parentSection;
                }

                @Override
                public IPermissionOperand getParent(IPermissionOperand childOperand) {
                    return CreatePlanWizard.this.projectAgent.getFrameSectionManager().getParentSection((ISection)childOperand);
                }
            };
            this.userDefinedAttributeTypes = new CreateDataWithUserDefinedAttributeTypesWizardPage(FrameDataTypes.getDataType("com.arcway.cockpit.plan"), this.projectAgent.getProjectUID(), parentOperandTree);
            this.createPlanWizardPage.addCategoryChangeListener(this.userDefinedAttributeTypes, false);
            this.addPage((IWizardPage)this.userDefinedAttributeTypes);
        }
    }

    public void disposeResources() {
        if (this.userDefinedAttributeTypes != null) {
            this.userDefinedAttributeTypes.disposeResources();
        }
    }

    public IPlanFileFactory getFactory() {
        return this.createPlanTypeSelectionWizardPage.getSelectedFactoryDescription().getPlanFileFactory();
    }

    public boolean isHelpAvailable() {
        return true;
    }

    public void setSelectedPlanType(ImageDescriptor imageDescriptor) {
        IWizardPage[] pages;
        IWizardPage[] iWizardPageArray = pages = this.getPages();
        int n = pages.length;
        int n2 = 0;
        while (n2 < n) {
            IWizardPage page = iWizardPageArray[n2];
            page.setImageDescriptor(imageDescriptor);
            ++n2;
        }
    }

    public void nextPageRequested() {
    }

    public boolean canCancel() {
        boolean canCancel = true;
        IWizardPage[] iWizardPageArray = this.getPages();
        int n = iWizardPageArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWizardPage singlePage = iWizardPageArray[n2];
            if (singlePage instanceof IWizardPageModificationInProgress && !(canCancel &= !((IWizardPageModificationInProgress)singlePage).getModificationInProgress())) break;
            ++n2;
        }
        return canCancel;
    }

    public boolean canClose() {
        return this.canCancel();
    }

    public boolean showHelpOnPreventedClose() {
        return true;
    }
}

