/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.global.gui.wizards;

import com.arcway.cockpit.frame.client.global.Icons;
import com.arcway.cockpit.frame.client.global.Messages;
import com.arcway.cockpit.frame.client.global.gui.wizards.CreatePlanWizard;
import com.arcway.lib.eclipse.gui.ModificationProblemsDialog;
import com.arcway.lib.eclipse.gui.dialogs.ArcwayWizardDialog;
import com.arcway.lib.eclipse.gui.widgets.ImageButton;
import com.arcway.lib.eclipse.resources.ColorConstant;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.ui.IModificationProblem;
import com.arcway.planagent.controllinginterface.planagent.plugin.EXPlanTypeUnknown;
import com.arcway.planagent.controllinginterface.planagent.plugin.PlanAgentExtensionMgr;
import com.arcway.planagent.controllinginterface.planagent.plugin.PlanFileFactoryDescription;
import com.arcway.planagent.controllinginterface.planagent.plugin.PlanTypeDescription;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class CreatePlanTypeSelectionWizardPage
extends WizardPage {
    private static final ILogger logger = Logger.getLogger(CreatePlanTypeSelectionWizardPage.class);
    private final CreatePlanWizard wizard;
    private PlanFileFactoryDescription selectedFactory;
    private final List<Image> images = new ArrayList<Image>();
    private final List<PlanTypeRow> planTypeRows = new ArrayList<PlanTypeRow>();
    private final Collection<IModificationProblem> problems = new ArrayList<IModificationProblem>();

    public CreatePlanTypeSelectionWizardPage(CreatePlanWizard my_wizard) {
        super("main page");
        this.wizard = my_wizard;
    }

    public void createControl(Composite parent) {
        final ScrolledComposite scrolledComposite = new ScrolledComposite(parent, 512);
        scrolledComposite.setLayoutData((Object)new GridData(1808));
        GridLayout gl = new GridLayout(1, false);
        gl.marginWidth = 0;
        scrolledComposite.setLayout((Layout)gl);
        final Composite base = new Composite((Composite)scrolledComposite, 0);
        base.setLayoutData((Object)new GridData(1808));
        gl = new GridLayout(1, false);
        gl.verticalSpacing = 0;
        base.setLayout((Layout)gl);
        scrolledComposite.setContent((Control)base);
        scrolledComposite.setAlwaysShowScrollBars(false);
        scrolledComposite.setContent((Control)base);
        scrolledComposite.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Rectangle r = scrolledComposite.getClientArea();
                base.setSize(base.computeSize(r.width, -1));
                Rectangle r2 = scrolledComposite.getClientArea();
                base.setSize(base.computeSize(r2.width, -1));
            }
        });
        scrolledComposite.addListener(26, new Listener(){

            public void handleEvent(Event e) {
                scrolledComposite.setFocus();
            }
        });
        scrolledComposite.getVerticalBar().setIncrement(25);
        this.setPageComplete(false);
        this.setTitle(Messages.getString("CreatePlanWizard.New_Plan_4"));
        this.setMessage(Messages.getString("CreatePlanWizard.Select_plan_typ"));
        List planDescriptions = PlanAgentExtensionMgr.getDefault().getPlanFileFactoryDescriptions();
        String defaultPlanTypeID = PlanAgentExtensionMgr.getDefault().getDefaultPlanTypeID();
        PlanTypeRow defaultPlanTypeRow = null;
        int i = 0;
        while (i < planDescriptions.size()) {
            try {
                PlanFileFactoryDescription factoryDescription = (PlanFileFactoryDescription)planDescriptions.get(i);
                PlanTypeDescription planTypeDescription = PlanAgentExtensionMgr.getDefault().getPlanTypeDescriptionForType(factoryDescription.getPlanTypeID());
                ImageDescriptor largeIcon = Icons.getLargeImageDescriptorForPlanType(factoryDescription.getPlanTypeID());
                Image image = largeIcon.createImage();
                this.images.add(image);
                PlanTypeRow planTypeRow = new PlanTypeRow(factoryDescription, planTypeDescription, image, largeIcon);
                this.planTypeRows.add(planTypeRow);
                planTypeRow.createWidgets(base);
                if (planTypeDescription.getPlanTypeID().equals(defaultPlanTypeID)) {
                    defaultPlanTypeRow = planTypeRow;
                }
            }
            catch (EXPlanTypeUnknown e) {
                logger.error((Throwable)e);
            }
            ++i;
        }
        this.deselectAllPlantypeRows();
        if (defaultPlanTypeRow != null) {
            defaultPlanTypeRow.selectPlanType();
        }
        this.setControl((Control)scrolledComposite);
    }

    private void deselectAllPlantypeRows() {
        for (PlanTypeRow planTypeRow : this.planTypeRows) {
            planTypeRow.setSelection(false);
        }
    }

    public void setWizard(IWizard newWizard) {
        super.setWizard(newWizard);
        IWizardContainer container = newWizard.getContainer();
        if (container instanceof ArcwayWizardDialog) {
            ArcwayWizardDialog wizardDialog = (ArcwayWizardDialog)container;
            wizardDialog.setHelpEnabled(!this.problems.isEmpty());
        }
    }

    public void performHelp() {
        ModificationProblemsDialog dialog = new ModificationProblemsDialog(this.problems, this.getShell());
        dialog.open();
    }

    protected PlanFileFactoryDescription getSelectedFactoryDescription() {
        return this.selectedFactory;
    }

    public void dispose() {
        super.dispose();
        for (Image image : this.images) {
            if (image.isDisposed()) continue;
            image.dispose();
        }
    }

    private class PlanTypeRow {
        private final PlanFileFactoryDescription m_fctryDescription;
        private final PlanTypeDescription m_planTypeDescription;
        private final Image m_image;
        private final ImageDescriptor m_largeIcon;
        private Composite row;
        Label text;
        ImageButton planTypeBtn;

        private PlanTypeRow(PlanFileFactoryDescription fctryDescription, PlanTypeDescription planTypeDescription, Image image, ImageDescriptor largeIcon) {
            this.m_fctryDescription = fctryDescription;
            this.m_planTypeDescription = planTypeDescription;
            this.m_image = image;
            this.m_largeIcon = largeIcon;
        }

        private void createWidgets(Composite parent) {
            String planTypeName;
            this.row = new Composite(parent, 0);
            this.row.setLayoutData((Object)new GridData(1808));
            GridLayout gl = new GridLayout(2, false);
            this.row.setLayout((Layout)gl);
            String planTemplateName = this.m_fctryDescription.getTemplateName();
            String entry = planTypeName = this.m_planTypeDescription.getPlanTypeName(Locale.getDefault());
            if (planTemplateName != null && planTemplateName.length() > 0) {
                entry = String.valueOf(entry) + " (" + planTemplateName + ")";
            }
            this.planTypeBtn = new ImageButton(this.row, null, this.m_image, 2);
            this.text = new Label(this.row, 16384);
            this.text.setText(entry);
            MouseAdapter listener = new MouseAdapter(){

                public void mouseDown(MouseEvent e) {
                    PlanTypeRow.this.selectPlanType();
                }
            };
            this.planTypeBtn.addMouseListener((MouseListener)listener);
            this.text.addMouseListener((MouseListener)listener);
            this.row.addMouseListener((MouseListener)listener);
        }

        private void selectPlanType() {
            CreatePlanTypeSelectionWizardPage.this.selectedFactory = this.m_fctryDescription;
            CreatePlanTypeSelectionWizardPage.this.setPageComplete(true);
            CreatePlanTypeSelectionWizardPage.this.deselectAllPlantypeRows();
            this.setSelection(true);
        }

        private void setSelection(boolean selected) {
            if (selected) {
                Color selectionBgColor = ColorConstant.getColor((Device)this.row.getDisplay(), (ColorConstant)ColorConstant.PLANTYPESELECTIONCOLOR_SELECTED_BACKGROUND);
                Color selectionFgColorText = this.row.getDisplay().getSystemColor(2);
                this.row.setBackground(selectionBgColor);
                this.planTypeBtn.setBackground(selectionBgColor);
                this.text.setBackground(selectionBgColor);
                this.text.setForeground(selectionFgColorText);
                CreatePlanTypeSelectionWizardPage.this.wizard.setSelectedPlanType(this.m_largeIcon);
            } else {
                Color bgColor = this.row.getDisplay().getSystemColor(1);
                Color fgColorText = this.row.getDisplay().getSystemColor(2);
                this.row.setBackground(bgColor);
                this.planTypeBtn.setBackground(bgColor);
                this.text.setBackground(bgColor);
                this.text.setForeground(fgColorText);
            }
        }
    }
}

