/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.global.gui.wizards;

import com.arcway.cockpit.frame.client.global.gui.properties.IPropertiesDialog;
import com.arcway.cockpit.frame.client.global.gui.properties.IPropertiesListEntry;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.lib.eclipse.gui.ModificationProblemsDialog;
import com.arcway.lib.eclipse.gui.dialogs.ArcwayWizardDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbenchPage;

public class CreateFrameDataWizardPage
extends WizardPage
implements IPropertiesDialog {
    private final IPropertiesListEntry propertiesListEntry;
    private final IFrameProjectAgent projectAgent;
    private final IWorkbenchPage workbenchPage;
    private boolean inited = false;
    private final String currentTitle;
    private String oldMessage;
    private int oldMessageType;
    private String currentMessage;
    private int currentMessageType;

    public CreateFrameDataWizardPage(IPropertiesListEntry propertiesListEntry, ICockpitProjectData[] data, IFrameProjectAgent projectAgent, IWorkbenchPage workbenchPage) {
        super(propertiesListEntry.getPropertyName());
        this.propertiesListEntry = propertiesListEntry;
        this.workbenchPage = workbenchPage;
        this.projectAgent = projectAgent;
        this.currentTitle = propertiesListEntry.getPropertyName();
        propertiesListEntry.init(data, this, true);
    }

    public void createControl(Composite parent) {
        this.setTitle(this.propertiesListEntry.getPropertyName());
        this.setPageComplete(false);
        Composite control = this.propertiesListEntry.getPropertyPage(parent);
        this.setControl((Control)control);
        this.inited = true;
    }

    public IPropertiesListEntry getPropertiesListEntry() {
        return this.propertiesListEntry;
    }

    public String getMessage() {
        return this.currentMessage;
    }

    public int getMessageType() {
        return this.currentMessageType;
    }

    public String getTitle() {
        return this.currentTitle;
    }

    @Override
    public void setTitle(String title, IPropertiesListEntry entry) {
    }

    @Override
    public void setMessage(String message, int severity, IPropertiesListEntry caller) {
        if (message != null && this.currentMessageType != 3 && this.currentMessageType != 2) {
            this.oldMessage = this.currentMessage;
            this.oldMessageType = this.currentMessageType;
            this.currentMessage = message;
            this.currentMessageType = severity;
        } else if (message == null && (this.currentMessageType == 3 || this.currentMessageType == 2) && this.oldMessage != null) {
            this.currentMessage = this.oldMessage;
            this.currentMessageType = this.oldMessageType;
            this.oldMessage = null;
        } else if (message != null) {
            this.currentMessage = message;
            this.currentMessageType = severity;
        }
        this.getContainer().updateMessage();
    }

    @Override
    public IWorkbenchPage getWorkbenchPage() {
        return this.workbenchPage;
    }

    @Override
    public void setIsCommitable(boolean isCommitable, IPropertiesListEntry caller) {
        this.setPageComplete(isCommitable);
    }

    @Override
    public void setIsCancelable(boolean isCancelable, IPropertiesListEntry caller) {
    }

    @Override
    public String getProjectUID() {
        return this.projectAgent.getProjectUID();
    }

    @Override
    public boolean mayModify() {
        return true;
    }

    public void performHelp() {
        ModificationProblemsDialog dialog = new ModificationProblemsDialog(this.propertiesListEntry.getModificationProblems(), this.getShell());
        dialog.open();
    }

    public void setWizard(IWizard newWizard) {
        IWizardContainer container;
        super.setWizard(newWizard);
        if (this.inited && (container = this.getWizard().getContainer()) instanceof ArcwayWizardDialog) {
            ArcwayWizardDialog dialog = (ArcwayWizardDialog)container;
            dialog.setHelpEnabled(!this.propertiesListEntry.getModificationProblems().isEmpty());
        }
    }
}

