/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.global.gui.wizards;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttribute;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeOwner;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeType;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeTypeID;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.ICockpitDataType;
import com.arcway.cockpit.client.base.interfaces.frame.permissions.EXNoPermission;
import com.arcway.cockpit.frame.client.global.ExtensionMgr;
import com.arcway.cockpit.frame.client.global.Messages;
import com.arcway.cockpit.frame.client.global.gui.properties.IPropertiesListEntry;
import com.arcway.cockpit.frame.client.global.gui.wizards.CreateFrameDataWizardPage;
import com.arcway.cockpit.frame.client.project.IFrameDataManager;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.core.framedata.IAttributeModificationManager;
import com.arcway.cockpit.frame.client.project.core.framedata.IFrameDataRW;
import com.arcway.cockpit.frame.client.project.core.framedata.ModificationProblem;
import com.arcway.cockpit.frame.client.project.core.framedata.datamanager.DataManager;
import com.arcway.cockpit.frame.client.project.core.framedata.transactionmanagement.ILocksAndPermissionsTransactionController;
import com.arcway.cockpit.frame.client.project.core.framedata.transactionmanagement.LocksAndPermissionsTransactionController;
import com.arcway.cockpit.frame.client.project.core.locking.EXNoLock;
import com.arcway.cockpit.frame.client.project.core.userdefinedattributetypes.IParentOperandTree;
import com.arcway.cockpit.frame.shared.userdefinedattributes.ExInvalidAttributeType;
import com.arcway.cockpit.frame.shared.userdefinedattributes.ExInvalidDataType;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.lib.eclipse.gui.ModificationProblemsDialog;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.ui.IModificationProblem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IWorkbenchPage;

public class CreateFrameDataWizardNew
extends Wizard {
    private static final ILogger logger = Logger.getLogger(CreateFrameDataWizardNew.class);
    private final IFrameProjectAgent projectAgent;
    private final ICockpitDataType dataType;
    private final IFrameDataManager dataManager;
    private final IAttributeTypeID nameAttributeTypeID;
    private final IAttributeOwner parent;
    private final IWorkbenchPage workbenchPage;
    private final IFrameDataRW dummyData;
    private final IParentOperandTree parentOperandTree;
    private final Map inputValidators;

    public CreateFrameDataWizardNew(ICockpitDataType dataType, IAttributeTypeID nameAttributeTypeID, IAttributeOwner parent, Map inputValidators, IFrameProjectAgent projectAgent, IWorkbenchPage workbenchPage) {
        this.projectAgent = projectAgent;
        this.dataType = dataType;
        this.nameAttributeTypeID = nameAttributeTypeID;
        this.parent = parent;
        this.workbenchPage = workbenchPage;
        this.dataManager = projectAgent.getDataManager(dataType.getCockpitDataTypeID());
        this.dummyData = this.dataManager.getDataFactory().createFrameData(Collections.emptyList());
        this.parentOperandTree = DataManager.getParentOperandTree(parent, projectAgent);
        this.inputValidators = inputValidators;
        this.dataManager.getDataFactory().setAttributeModificationManager(this.dummyData, new DummyModificationManager());
        this.setWindowTitle(String.valueOf(Messages.getString("CreateFrameDataWizardNew.create1")) + dataType.getDisplayName() + Messages.getString("CreateFrameDataWizardNew.create2") + " ...");
    }

    public boolean isHelpAvailable() {
        return true;
    }

    public void addPages() {
        ArrayList<IPropertiesListEntry> providers = new ArrayList<IPropertiesListEntry>(ExtensionMgr.getDefault().getAllPropertiesProvider());
        Collections.sort(providers, new Comparator(){

            public int compare(Object arg0, Object arg1) {
                IPropertiesListEntry e0 = (IPropertiesListEntry)arg0;
                IPropertiesListEntry e1 = (IPropertiesListEntry)arg1;
                return e0.getTypeOfPage() - e1.getTypeOfPage();
            }
        });
        ICockpitProjectData[] dummyArray = new ICockpitProjectData[]{this.dummyData};
        ListIterator i = providers.listIterator();
        while (i.hasNext()) {
            IPropertiesListEntry entry = (IPropertiesListEntry)i.next();
            if (!entry.providesPropertiesFor(dummyArray)) continue;
            this.addPage((IWizardPage)new CreateFrameDataWizardPage(entry, dummyArray, this.projectAgent, this.workbenchPage));
        }
    }

    public boolean performFinish() {
        IWizardPage[] entry;
        CreateFrameDataWizardPage page;
        IWizardPage element;
        IWizardPage[] pages = this.getPages();
        ArrayList<Object> modProblems = new ArrayList<Object>();
        IWizardPage[] iWizardPageArray = pages;
        int n = pages.length;
        int n2 = 0;
        while (n2 < n) {
            element = iWizardPageArray[n2];
            page = (CreateFrameDataWizardPage)element;
            entry = page.getPropertiesListEntry();
            modProblems.addAll(entry.requestCommit());
            ++n2;
        }
        if (modProblems.isEmpty()) {
            iWizardPageArray = pages;
            n = pages.length;
            n2 = 0;
            while (n2 < n) {
                element = iWizardPageArray[n2];
                page = (CreateFrameDataWizardPage)element;
                entry = page.getPropertiesListEntry();
                entry.commitPropertyChanges1();
                ++n2;
            }
            LocksAndPermissionsTransactionController transactionController = new LocksAndPermissionsTransactionController(this.projectAgent);
            try {
                IAttribute nameAttribute = this.dummyData.getAttribute(this.nameAttributeTypeID);
                this.dataManager.requestAddPermission(nameAttribute.getAttributeValue().toString(), null, this.dummyData.getAllAttributes(), this.parent, false, transactionController);
                modProblems.addAll(transactionController.execute());
                if (modProblems.isEmpty()) {
                    this.dataManager.addData(transactionController);
                    entry = pages;
                    int page2 = pages.length;
                    int n3 = 0;
                    while (n3 < page2) {
                        IWizardPage element2 = entry[n3];
                        CreateFrameDataWizardPage page3 = (CreateFrameDataWizardPage)element2;
                        IPropertiesListEntry entry2 = page3.getPropertiesListEntry();
                        entry2.disposeResources();
                        ++n3;
                    }
                    return true;
                }
            }
            catch (EXNoPermission e) {
                logger.error("could not create data", (Throwable)e);
            }
        }
        iWizardPageArray = pages;
        n = pages.length;
        int n4 = 0;
        while (n4 < n) {
            element = iWizardPageArray[n4];
            page = (CreateFrameDataWizardPage)element;
            entry = page.getPropertiesListEntry();
            entry.rollbackCommitRequest();
            ++n4;
        }
        ModificationProblemsDialog modProblemsDialog = new ModificationProblemsDialog(modProblems, String.valueOf(this.dataType.getDisplayName()) + Messages.getString("CreateFrameDataWizardNew.cannot_be_created"), this.workbenchPage.getWorkbenchWindow().getShell());
        modProblemsDialog.open();
        return false;
    }

    private class DummyModificationManager
    implements IAttributeModificationManager {
        private DummyModificationManager() {
        }

        @Override
        public void requestAttributeModificationPermission(IAttribute newAttribute, ILocksAndPermissionsTransactionController transactionController) {
            String msg;
            IAttributeType attributeType = CreateFrameDataWizardNew.this.dummyData.getAttributeType(newAttribute.getAttributeTypeID());
            transactionController.addAttributeModificationPermission(attributeType, CreateFrameDataWizardNew.this.parentOperandTree, true);
            IInputValidator inputValidator = (IInputValidator)CreateFrameDataWizardNew.this.inputValidators.get(attributeType);
            if (inputValidator != null && (msg = inputValidator.isValid(newAttribute.getAttributeValue().toString())) != null) {
                ModificationProblem modProblem = new ModificationProblem(msg, Messages.getString("CreateFrameDataWizardNew.cannot_set_attribute_value"));
                transactionController.addLockModificationProblem(modProblem);
            }
        }

        @Override
        public IModificationProblem checkLocks() {
            return null;
        }

        @Override
        public Collection<IModificationProblem> checkGeneralModificationPermissions(IAttributeType attributeType) {
            ArrayList<IModificationProblem> modProblems = new ArrayList<IModificationProblem>();
            if (!CreateFrameDataWizardNew.this.projectAgent.getFramePermissionChecker().hasAttributeModificationPermission(attributeType, CreateFrameDataWizardNew.this.parentOperandTree, true)) {
                modProblems.add(new ModificationProblem(attributeType, CreateFrameDataWizardNew.this.parentOperandTree, CreateFrameDataWizardNew.this.projectAgent));
            }
            return modProblems;
        }

        @Override
        public void requestObjectTypeCategoryModificationPermission(ILocksAndPermissionsTransactionController transactionController) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Collection<IModificationProblem> checkObjectTypeCategoryModificationPermission() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void modifyAttribute(IAttribute newAttribute, Object oldAttributeValue) throws ExInvalidAttributeType, ExInvalidDataType, EXNoPermission, EXNoLock {
        }

        @Override
        public void modifyCategoryID() throws ExInvalidAttributeType, ExInvalidDataType, EXNoPermission, EXNoLock {
        }
    }
}

