/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.global.gui.wizards;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.ObjectTypeCategoryID;
import com.arcway.cockpit.frame.client.global.gui.properties.IObjectTypeCategoryChangeListener;
import com.arcway.cockpit.frame.client.global.gui.properties.IObjectTypeCategoryChangeProvider;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.core.categories.ObjectTypeCategory;
import com.arcway.lib.ui.editor.ObjectTypeCategoryLabels;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;

public abstract class AbstractWizardPageWithCategorySelection
extends WizardPage
implements IObjectTypeCategoryChangeProvider {
    protected IFrameProjectAgent projectAgent;
    private final Set<IObjectTypeCategoryChangeListener> objectTypeCategoryChangeListeners = new HashSet<IObjectTypeCategoryChangeListener>();
    private List<ObjectTypeCategory> allCategories;

    public AbstractWizardPageWithCategorySelection(IFrameProjectAgent projectAgent, String pageName) {
        super(pageName);
        this.projectAgent = projectAgent;
    }

    public AbstractWizardPageWithCategorySelection(IFrameProjectAgent projectAgent, String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
        this.projectAgent = projectAgent;
    }

    public void createControl(Composite parent) {
        this.createControl_internal(parent);
        Combo categoryCombo = this.getCategoryCombo();
        assert (categoryCombo != null) : "Combo for category selection has to be defined.";
        this.allCategories = this.projectAgent.getObjectTypeCategoriesManager().getAllCategoriesForObjectTypeSorted(this.getFrameDataTypeID());
        categoryCombo.add(ObjectTypeCategoryLabels.LABEL_DEFAULTCATEGORY);
        for (ObjectTypeCategory category : this.allCategories) {
            categoryCombo.add(category.getDisplayName());
        }
        categoryCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractWizardPageWithCategorySelection.this.notifyObjectTypeCategoryChangeListener();
            }
        });
        categoryCombo.select(0);
    }

    protected abstract void createControl_internal(Composite var1);

    protected abstract Combo getCategoryCombo();

    protected abstract String getFrameDataTypeID();

    public ObjectTypeCategoryID getObjectTypeCategoryID() {
        int selectionIndex = this.getCategoryCombo().getSelectionIndex();
        if (selectionIndex == 0) {
            return null;
        }
        return this.allCategories.get(selectionIndex - 1).getObjectTypeCategoryID();
    }

    private ObjectTypeCategory getSelectedCategory() {
        ObjectTypeCategoryID categoryID = this.getObjectTypeCategoryID();
        ObjectTypeCategory category = null;
        if (categoryID != null) {
            category = this.projectAgent.getObjectTypeCategoriesManager().getCategory(categoryID);
        }
        return category;
    }

    @Override
    public void addCategoryChangeListener(IObjectTypeCategoryChangeListener listener, boolean fireNotifyEventOnAdd) {
        this.objectTypeCategoryChangeListeners.add(listener);
        if (fireNotifyEventOnAdd) {
            listener.categoryChanged(this.getSelectedCategory());
        }
    }

    @Override
    public void removeCategoryChangeListener(IObjectTypeCategoryChangeListener listener) {
        this.objectTypeCategoryChangeListeners.remove(listener);
    }

    private void notifyObjectTypeCategoryChangeListener() {
        ObjectTypeCategory category = this.getSelectedCategory();
        for (IObjectTypeCategoryChangeListener listener : this.objectTypeCategoryChangeListeners) {
            listener.categoryChanged(category);
        }
    }
}

