/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.global.gui.views.uniqueelement2;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeOwner;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeType;
import com.arcway.cockpit.client.base.interfaces.general.ICategoryOwner;
import com.arcway.cockpit.cockpitlib.client.filter.gui.IFilterItem;
import com.arcway.cockpit.frame.client.global.FramePlugin;
import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.global.gui.Messages;
import com.arcway.cockpit.frame.client.global.gui.views.lib.dataview.CockpitTreeDataViewProvider;
import com.arcway.cockpit.frame.client.global.gui.views.lib.dataview.filters.FilterHelper;
import com.arcway.cockpit.frame.client.global.gui.views.lib.dataview.filters.ICustomPropertyFiltersModelAccess;
import com.arcway.cockpit.frame.client.global.gui.views.uniqueelement2.CycleWrapper;
import com.arcway.cockpit.frame.client.global.gui.views.uniqueelement2.ObjectTypeCategoryChangeMenu;
import com.arcway.cockpit.frame.client.global.gui.views.uniqueelement2.PlanEditorDragSupport;
import com.arcway.cockpit.frame.client.global.gui.views.uniqueelement2.UEView2FilterFactory;
import com.arcway.cockpit.frame.client.global.gui.views.uniqueelement2.UEView2LabelProvider;
import com.arcway.cockpit.frame.client.global.gui.views.uniqueelement2.UEView2TreeDataViewStateModelAccess;
import com.arcway.cockpit.frame.client.global.gui.views.uniqueelement2.UniqueElementView2;
import com.arcway.cockpit.frame.client.global.license.IClientFunctionLicenseType2;
import com.arcway.cockpit.frame.client.lib.dataviews.actions.ActionDelegateSelectAll;
import com.arcway.cockpit.frame.client.lib.dataviews.actions.DelegateBasedModuleAction;
import com.arcway.cockpit.frame.client.lib.dataviews.dnd.DragSource;
import com.arcway.cockpit.frame.client.lib.dataviews.dnd.DropTarget;
import com.arcway.cockpit.frame.client.lib.dataviews.projectmanager.ProjectAssociationManager;
import com.arcway.cockpit.frame.client.lib.dataviews.search.CockpitSearchStringGenerator;
import com.arcway.cockpit.frame.client.lib.dataviews.search.ICockpitSearchStringGenerator;
import com.arcway.cockpit.frame.client.lib.dataviews.search.IItemTypeForSearchProvider;
import com.arcway.cockpit.frame.client.lib.dataviews.view.jfaceviewer.tree.IDataViewSortingState;
import com.arcway.cockpit.frame.client.lib.dataviews.view.jfaceviewer.tree.ITreeDataViewStateSerialisationHelper;
import com.arcway.cockpit.frame.client.lib.dataviews.view.jfaceviewer.tree.ITreeDataViewStateSerialisationHelperProvider;
import com.arcway.cockpit.frame.client.lib.dataviews.view.jfaceviewer.tree.ITreeDataViewStateSerialisationHelperWO;
import com.arcway.cockpit.frame.client.lib.dataviews.view.jfaceviewer.tree.TreeDataViewSorter;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.IFrameUniqueElementManager;
import com.arcway.cockpit.frame.client.project.ProjectAgent;
import com.arcway.cockpit.frame.client.project.core.categories.ObjectTypeCategory;
import com.arcway.cockpit.frame.client.project.core.framedata.FrameDataTypes;
import com.arcway.cockpit.frame.client.project.core.framedata.IFrameDataTypeDescription;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.IUniqueElement;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.relationships.IUniqueElementRelationshipProvider;
import com.arcway.cockpit.frame.client.project.core.userdefinedattributetypes.IFrameUserDefinedAttributeTypesManager;
import com.arcway.cockpit.frame.shared.message.EOUniqueElementRelationship;
import com.arcway.cockpit.frame.shared.message.IUniqueElementOccurrence;
import com.arcway.lib.java.EitherOr;
import de.plans.lib.util.incrementalsearch.ISearchAlgorithm;
import de.plans.lib.util.incrementalsearch.JavaStdRegexSearch;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.swt.events.KeyListener;

public class UEView2Provider
extends CockpitTreeDataViewProvider<Object> {
    private final UniqueElementView2 ueView;
    private final UEView2LabelProvider columnAndLabelProvider;
    private final IAction hierarchyModeAction;
    private final EitherOr<IAction, IContributionItem> categoryContextMenu;

    public UEView2Provider(UniqueElementView2 ueView, ISelectionProvider selectionProvider) {
        super(ueView);
        this.ueView = ueView;
        this.columnAndLabelProvider = new UEView2LabelProvider();
        this.hierarchyModeAction = this.createHierarchyModeAction();
        this.categoryContextMenu = new EitherOr.Or((Object)new ObjectTypeCategoryChangeMenu("com.arcway.cockpit.uniqueelement", selectionProvider));
    }

    public void projectModified() {
        this.columnAndLabelProvider.projectModified();
    }

    public void projectChanged(IFrameProjectAgent projectAgent) {
        this.columnAndLabelProvider.projectChanged(projectAgent);
    }

    @Override
    protected CockpitTreeDataViewProvider.IFixColumnProvider<Object> getFixColumnProvider() {
        return this.columnAndLabelProvider;
    }

    @Override
    protected CockpitTreeDataViewProvider.IGeneralColumnProvider<Object> getGeneralColumnProvider() {
        return this.columnAndLabelProvider;
    }

    @Override
    protected CockpitTreeDataViewProvider.ICustomPropertyColumnProvider<Object> getCustomPropertyColumnProvider() {
        return this.columnAndLabelProvider;
    }

    @Override
    public ITreeDataViewStateSerialisationHelperProvider<Object> getTreeDataViewStateSerialisationHelperProvider() {
        return new ITreeDataViewStateSerialisationHelperProvider<Object>(){

            @Override
            public ITreeDataViewStateSerialisationHelper<Object> getTreeDataViewStateSerialisationHelper(String projectUID) {
                ProjectAgent projectAgent = ProjectMgr.getProjectMgr().getProjectAgent(projectUID);
                if (projectAgent != null && projectAgent.isOpened()) {
                    IFrameUniqueElementManager uniqueElementManager = projectAgent.getFrameUniqueElementMgr();
                    IUniqueElementRelationshipProvider containmentRelationshipProvider = projectAgent.getUniqueElementRelationshipManager().getUERelationshipProviderManager().getContainmentRelationshipProvider();
                    return UEView2TreeDataViewStateModelAccess.getInstance(uniqueElementManager, containmentRelationshipProvider);
                }
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                return null;
            }

            @Override
            public ITreeDataViewStateSerialisationHelperWO<Object> getTreeDataViewStateSerialisationHelperWO(String projectUID) {
                return UEView2TreeDataViewStateModelAccess.getInstanceWO();
            }
        };
    }

    @Override
    protected Collection<Class<?>> getDataTypesThatTriggerRefresh() {
        HashSet dataTypesThatTriggerRefresh = new HashSet();
        dataTypesThatTriggerRefresh.add(IUniqueElement.class);
        dataTypesThatTriggerRefresh.add(IUniqueElementOccurrence.class);
        dataTypesThatTriggerRefresh.add(EOUniqueElementRelationship.class);
        dataTypesThatTriggerRefresh.add(IAttributeType.class);
        dataTypesThatTriggerRefresh.add(ObjectTypeCategory.class);
        return dataTypesThatTriggerRefresh;
    }

    @Override
    protected ProjectAssociationManager getProjectAssociationManager() {
        return FramePlugin.getDefault().getFrameProjectAssociationManager();
    }

    @Override
    public boolean hasNaturalOrder() {
        return false;
    }

    @Override
    public TreeDataViewSorter<Object> getSorter(String projectUID) {
        return new TreeDataViewSorter<Object>((IDataViewSortingState)this.ueView){

            @Override
            protected Integer compareAccordingToType(Object dataItem1, Object dataItem2) {
                if (dataItem1 instanceof IUniqueElement && dataItem2 instanceof CycleWrapper) {
                    return -1;
                }
                if (dataItem1 instanceof CycleWrapper && dataItem2 instanceof IUniqueElement) {
                    return 1;
                }
                return null;
            }

            @Override
            protected Integer compareAccordingToTypeSpecificRule(Object dataItem1, Object dataItem2) {
                if (dataItem1 instanceof CycleWrapper && dataItem2 instanceof CycleWrapper) {
                    IUniqueElement entryPoint1 = ((CycleWrapper)dataItem1).getCycleEntryPoint();
                    IUniqueElement entryPoint2 = ((CycleWrapper)dataItem2).getCycleEntryPoint();
                    if (entryPoint1 == null && entryPoint2 == null) {
                        return ((CycleWrapper)dataItem1).hashCode() - ((CycleWrapper)dataItem2).hashCode();
                    }
                    if (entryPoint1 != null && entryPoint2 != null) {
                        return entryPoint1.getElementName().compareToIgnoreCase(entryPoint2.getElementName());
                    }
                    if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                    return 0;
                }
                return null;
            }

            @Override
            protected Integer compareAccordingToNaturalOrder(Object dataItem1, Object dataItem2) {
                return null;
            }
        };
    }

    @Override
    public boolean hasIncrementalSearch() {
        return true;
    }

    @Override
    public String getFullModuleID() {
        return "ModelElements";
    }

    @Override
    public ISearchAlgorithm getSearchAlgorithm() {
        return new JavaStdRegexSearch();
    }

    @Override
    public Map<String, ICockpitSearchStringGenerator<Object>> getSearchStringGenerators() {
        HashMap<String, ICockpitSearchStringGenerator<Object>> searchStringGenerators = new HashMap<String, ICockpitSearchStringGenerator<Object>>();
        searchStringGenerators.put("uniqueelement", new ICockpitSearchStringGenerator<Object>(){

            @Override
            public String getSearchString(Object item) {
                IUniqueElement modelElement = (IUniqueElement)item;
                StringBuilder searchString = new StringBuilder();
                CockpitSearchStringGenerator.appendSearchStringForObjectTypeCategory(searchString, (ICategoryOwner)modelElement);
                searchString.append(modelElement.getElementName());
                searchString.append(" ");
                searchString.append(modelElement.getDescription());
                Locale language = new Locale(ProjectMgr.getProjectMgr().getProjectAgent(modelElement.getProjectUID()).getLanguage());
                CockpitSearchStringGenerator.appendSearchStringForCustomProperties(searchString, (IAttributeOwner)modelElement, language);
                CockpitSearchStringGenerator.appendSearchStringForMetaAttributes(searchString, (IAttributeOwner)modelElement, language);
                return searchString.toString();
            }
        });
        searchStringGenerators.put("cycle", new ICockpitSearchStringGenerator<Object>(){

            @Override
            public String getSearchString(Object item) {
                return "";
            }
        });
        return searchStringGenerators;
    }

    @Override
    public IItemTypeForSearchProvider<Object> getItemTypeProviderForSearch() {
        return new IItemTypeForSearchProvider<Object>(){

            @Override
            public String getTypeID(Object dataItem) {
                if (dataItem instanceof IUniqueElement) {
                    return "uniqueelement";
                }
                if (dataItem instanceof CycleWrapper) {
                    return "cycle";
                }
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                return null;
            }
        };
    }

    @Override
    public IClientFunctionLicenseType2 getRequiredLicenseTypeForSearch() {
        return null;
    }

    @Override
    public IOpenListener createOpenListener() {
        return new IOpenListener(){

            public void open(OpenEvent event) {
                Object selectedItem;
                IStructuredSelection structuredSelection;
                ISelection selection = event.getSelection();
                if (selection instanceof IStructuredSelection && (structuredSelection = (IStructuredSelection)selection).size() == 1 && (selectedItem = structuredSelection.getFirstElement()) instanceof IUniqueElement) {
                    IUniqueElement modelElement = (IUniqueElement)selectedItem;
                    ProjectAgent projectAgent = ProjectMgr.getProjectMgr().getProjectAgent(modelElement.getProjectUID());
                    projectAgent.getFrameUniqueElementMgr().openPlanForUniqueElement(modelElement, null, UEView2Provider.this.ueView.getSite().getPage());
                }
            }
        };
    }

    @Override
    public List<IFilterItem> createFilterItems() {
        return UEView2FilterFactory.getFilterItems(this.ueView);
    }

    @Override
    public List<IFilterItem> createProjectSpecificFilterItems(String projectUID) {
        ArrayList<IFilterItem> filterItems = new ArrayList<IFilterItem>();
        if (projectUID != null) {
            ProjectAgent projectAgent = ProjectMgr.getProjectMgr().getProjectAgent(projectUID);
            IFrameUserDefinedAttributeTypesManager userDefinedAttributeTypesManager = projectAgent.getFrameUserDefinedAttributeTypesManager();
            String typeName = ((IFrameDataTypeDescription)FrameDataTypes.getDataType("com.arcway.cockpit.uniqueelement")).getDisplayName(Locale.getDefault());
            FilterHelper.getCustomPropertyFilters("com.arcway.cockpit.uniqueelement", filterItems, typeName, userDefinedAttributeTypesManager, new ICustomPropertyFiltersModelAccess<IUniqueElement>(){

                @Override
                public boolean isAttributeOwner(IUniqueElement dataItem) {
                    return true;
                }

                @Override
                public IAttributeOwner getAttributeOwner(IUniqueElement dataItem) {
                    return dataItem;
                }
            }, IUniqueElement.class);
        }
        return filterItems;
    }

    @Override
    public String getFilterDialogueTitle() {
        return Messages.getString("UniqueElementView2.FilterDialogue.Title");
    }

    @Override
    public String getFilterDialogueDescription() {
        return Messages.getString("UniqueElementView2.FilterDialogue.Description");
    }

    @Override
    public boolean isRetainingTreeStructuresWhenFiltering() {
        return true;
    }

    @Override
    public KeyListener createKeyListener() {
        return null;
    }

    @Override
    public boolean hasNewMenu() {
        return true;
    }

    @Override
    public String getAlternativeNewMenuID() {
        return "com.arcway.cockpit.contextmenu.new";
    }

    @Override
    public List<String> getNewMenuSeparatorIDs() {
        return Arrays.asList("com.arcway.cockpit.contextmenu.new.root.separator", "com.arcway.cockpit.contextmenu.new.linkeditem.separator");
    }

    @Override
    public IAction getDeleteAction() {
        return null;
    }

    @Override
    public IAction getCopyAction() {
        return null;
    }

    @Override
    public IAction getCutAction() {
        return null;
    }

    @Override
    public IAction getPasteAction() {
        return null;
    }

    @Override
    public IAction getSelectAllAction() {
        DelegateBasedModuleAction selectAllAction = new DelegateBasedModuleAction(new ActionDelegateSelectAll(this.ueView));
        return selectAllAction;
    }

    @Override
    public List<? extends IAction> getAdditionalToolbarActions() {
        ArrayList<IAction> actions = new ArrayList<IAction>();
        actions.addAll(super.getAdditionalToolbarActions());
        actions.add(this.hierarchyModeAction);
        return actions;
    }

    @Override
    public List<EitherOr<IAction, IContributionItem>> getAdditionalContextMenuActions() {
        return Collections.singletonList(this.categoryContextMenu);
    }

    @Override
    public DragSource[] createDragSources() {
        return new DragSource[]{new PlanEditorDragSupport().getDragSource()};
    }

    @Override
    public DropTarget[] createDropTargets() {
        return new DropTarget[0];
    }

    @Override
    public String getHelpContextId() {
        return null;
    }

    @Override
    public void dispose() {
        this.columnAndLabelProvider.dispose();
    }

    public final IAction getHierarchyModeAction() {
        return this.hierarchyModeAction;
    }

    private IAction createHierarchyModeAction() {
        Action hierarchyModeAction_ = new Action("", 2){

            public void run() {
                UEView2Provider.this.ueView.handleHierarchyModeActionSelected();
            }
        };
        hierarchyModeAction_.setImageDescriptor(FramePlugin.getImageDescriptor("tree_mode.gif"));
        hierarchyModeAction_.setToolTipText(com.arcway.cockpit.frame.client.global.Messages.getString("SwitchUEViewModeAction.Show_Containment_Hierarchie_3"));
        return hierarchyModeAction_;
    }
}

