/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.global.gui.views.uniqueelement2;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttribute;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeOwner;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeType;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeTypeID;
import com.arcway.cockpit.client.base.interfaces.general.ICategoryOwner;
import com.arcway.cockpit.frame.client.global.FramePlugin;
import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.global.gui.Messages;
import com.arcway.cockpit.frame.client.global.gui.views.lib.dataview.CockpitTreeDataViewProvider;
import com.arcway.cockpit.frame.client.global.gui.views.uniqueelement2.CycleWrapper;
import com.arcway.cockpit.frame.client.global.gui.views.uniqueelement2.UEListLabelProvider;
import com.arcway.cockpit.frame.client.global.gui.views.uniqueelement2.UniqueElementLabelDecorator;
import com.arcway.cockpit.frame.client.lib.dataviews.view.jfaceviewer.tree.ColumnDescription;
import com.arcway.cockpit.frame.client.lib.dataviews.view.jfaceviewer.tree.IColumnDescription;
import com.arcway.cockpit.frame.client.lib.dataviews.view.jfaceviewer.tree.IDataViewColumnComparator;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.core.categories.ObjectTypeCategories;
import com.arcway.cockpit.frame.client.project.core.categories.ObjectTypeCategory;
import com.arcway.cockpit.frame.client.project.core.framedata.AbstractAttributeTypesProvider;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.DataTypeDate;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.IUniqueElement;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.UniqueElementAttributeTypesProvider;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.UniqueElementHelper;
import com.arcway.lib.eclipse.gui.viewers.CachingLabelProvider;
import de.plans.lib.util.gui.DecoratingLabelProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Locale;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;

public class UEView2LabelProvider
implements CockpitTreeDataViewProvider.IFixColumnProvider<Object>,
CockpitTreeDataViewProvider.IGeneralColumnProvider<Object>,
CockpitTreeDataViewProvider.ICustomPropertyColumnProvider<Object> {
    public static final String COLUMNID_NAME = "name";
    public static final String COLUMNID_DESCRIPTION = "description";
    public static final String COLUMNID_TYPE = "type";
    public static final String COLUMNID_ASSIGNED = "assigned";
    private final UEListLabelProvider ueListLabelProvider = new UEListLabelProvider();
    private final CachingLabelProvider cachingUELabelProvider;
    private final Image image_uecycle;

    public UEView2LabelProvider() {
        DecoratingLabelProvider decoratingUELabelProvider = new DecoratingLabelProvider((ILabelProvider)this.ueListLabelProvider);
        decoratingUELabelProvider.addLabelDecorator((ILabelDecorator)new UniqueElementLabelDecorator());
        this.cachingUELabelProvider = new CachingLabelProvider((ILabelProvider)decoratingUELabelProvider);
        ImageDescriptor imageDescriptor = FramePlugin.getImageDescriptor("ue-cycle.png");
        this.image_uecycle = imageDescriptor.createImage();
    }

    public void projectModified() {
        this.cachingUELabelProvider.clearLabelCaches();
    }

    public void projectChanged(IFrameProjectAgent projectAgent) {
        this.ueListLabelProvider.setProjectAgent(projectAgent);
        this.cachingUELabelProvider.clearLabelCaches();
    }

    @Override
    public Collection<IColumnDescription> getColumnDescriptions() {
        ArrayList<IColumnDescription> fixColumnDescriptions = new ArrayList<IColumnDescription>(2);
        fixColumnDescriptions.add(new ColumnDescription(COLUMNID_NAME, UniqueElementAttributeTypesProvider.ATTRNAME_DISPLAY_NAME, 200, 0, true, 1, 0, new IDataViewColumnComparator(){

            @Override
            public int compare(Object o1, Object o2) {
                if (o1 instanceof IUniqueElement && o2 instanceof IUniqueElement) {
                    return ((IUniqueElement)o1).getElementName().compareToIgnoreCase(((IUniqueElement)o2).getElementName());
                }
                if (o1 instanceof IUniqueElement && !(o2 instanceof IUniqueElement)) {
                    return -1;
                }
                if (!(o1 instanceof IUniqueElement) && o2 instanceof IUniqueElement) {
                    return 1;
                }
                return 0;
            }
        }));
        fixColumnDescriptions.add(new ColumnDescription(COLUMNID_DESCRIPTION, UniqueElementAttributeTypesProvider.ATTRNAME_DESCRIPTION, 300, 1, false, 1, 1, new IDataViewColumnComparator(){

            @Override
            public int compare(Object o1, Object o2) {
                return 0;
            }
        }));
        fixColumnDescriptions.add(new ColumnDescription(COLUMNID_TYPE, UniqueElementAttributeTypesProvider.ATTRNAME_ELEMENT_TYPE, 120, 2000, false, 1, 2, new IDataViewColumnComparator(){

            @Override
            public int compare(Object o1, Object o2) {
                if (o1 instanceof IUniqueElement && o2 instanceof IUniqueElement) {
                    String label1 = UniqueElementHelper.getElementTypeName((IUniqueElement)o1, Locale.getDefault());
                    String label2 = UniqueElementHelper.getElementTypeName((IUniqueElement)o2, Locale.getDefault());
                    return label1.compareToIgnoreCase(label2);
                }
                if (o1 instanceof IUniqueElement && !(o2 instanceof IUniqueElement)) {
                    return -1;
                }
                if (!(o1 instanceof IUniqueElement) && o2 instanceof IUniqueElement) {
                    return 1;
                }
                return 0;
            }
        }));
        fixColumnDescriptions.add(new ColumnDescription(COLUMNID_ASSIGNED, Messages.getString("UEView2.OccurrenceExistsProperty.Name"), 40, 2001, false, 1, 3, new IDataViewColumnComparator(){

            @Override
            public int compare(Object o1, Object o2) {
                if (o1 instanceof IUniqueElement && o2 instanceof IUniqueElement) {
                    int o1IsAssigned = UniqueElementHelper.isElementAssigned((IUniqueElement)o1) ? 1 : 0;
                    int o2IsAssigned = UniqueElementHelper.isElementAssigned((IUniqueElement)o2) ? 1 : 0;
                    return o1IsAssigned - o2IsAssigned;
                }
                if (o1 instanceof IUniqueElement && !(o2 instanceof IUniqueElement)) {
                    return -1;
                }
                if (!(o1 instanceof IUniqueElement) && o2 instanceof IUniqueElement) {
                    return 1;
                }
                return 0;
            }
        }));
        return fixColumnDescriptions;
    }

    @Override
    public Image getColumnImage(Object element, String columnID) {
        if (columnID.equals(COLUMNID_NAME)) {
            if (element instanceof IUniqueElement) {
                return this.cachingUELabelProvider.getImage(element);
            }
            if (element instanceof CycleWrapper) {
                return this.image_uecycle;
            }
            assert (false);
            return null;
        }
        return null;
    }

    @Override
    public String getColumnText(Object element, String columnID) {
        if (element instanceof IUniqueElement) {
            IUniqueElement modelElement = (IUniqueElement)element;
            if (columnID.equals(COLUMNID_NAME)) {
                return this.cachingUELabelProvider.getText((Object)modelElement);
            }
            if (columnID.equals(COLUMNID_DESCRIPTION)) {
                return modelElement.getDescription();
            }
            if (columnID.equals(COLUMNID_TYPE)) {
                return UniqueElementHelper.getElementTypeName(modelElement, Locale.getDefault());
            }
            if (columnID.equals(COLUMNID_ASSIGNED)) {
                if (UniqueElementHelper.isElementAssigned(modelElement)) {
                    return Messages.getString("UEView2.Column.Assigned.Yes.Label");
                }
                return Messages.getString("UEView2.Column.Assigned.No.Label");
            }
            return "Unknown Column";
        }
        if (element instanceof CycleWrapper) {
            if (columnID.equals(COLUMNID_NAME)) {
                CycleWrapper cycle = (CycleWrapper)element;
                IUniqueElement entryPointElement = cycle.getCycleEntryPoint();
                if (entryPointElement != null) {
                    return NLS.bind((String)Messages.getString("UEDataViewLabelProvider.Cycle.Label_NonRoot"), (Object)entryPointElement.getElementName());
                }
                return Messages.getString("UEDataViewLabelProvider.Cycle.Label_Root");
            }
            return "";
        }
        assert (false);
        return null;
    }

    @Override
    public boolean isCategoryColumnNeeded() {
        return true;
    }

    @Override
    public ObjectTypeCategory getCategory(Object dataItem) {
        if (dataItem instanceof IUniqueElement) {
            return ObjectTypeCategories.getCategoryForItem((ICategoryOwner)((IUniqueElement)dataItem));
        }
        return null;
    }

    @Override
    public String getAuthor(Object dataItem) {
        if (dataItem instanceof IUniqueElement) {
            return UEView2LabelProvider.getAttributeValueAsString((IUniqueElement)dataItem, AbstractAttributeTypesProvider.ATTRID_CREATOR);
        }
        return null;
    }

    @Override
    public Long getCreationDate(Object dataItem) {
        if (dataItem instanceof IUniqueElement) {
            return UEView2LabelProvider.getAttributeValueAsDate((IUniqueElement)dataItem, AbstractAttributeTypesProvider.ATTRID_CREATION_DATE);
        }
        return null;
    }

    @Override
    public String getCreationDateStringRepresentation(Object dataItem) {
        if (dataItem instanceof IUniqueElement) {
            return UEView2LabelProvider.getAttributeValueAsString((IUniqueElement)dataItem, AbstractAttributeTypesProvider.ATTRID_CREATION_DATE);
        }
        return null;
    }

    @Override
    public String getLastModifier(Object dataItem) {
        if (dataItem instanceof IUniqueElement) {
            return UEView2LabelProvider.getAttributeValueAsString((IUniqueElement)dataItem, AbstractAttributeTypesProvider.ATTRID_LAST_EDITOR);
        }
        return null;
    }

    @Override
    public Long getDateOfLastModification(Object dataItem) {
        if (dataItem instanceof IUniqueElement) {
            return UEView2LabelProvider.getAttributeValueAsDate((IUniqueElement)dataItem, AbstractAttributeTypesProvider.ATTRID_LAST_EDIT_DATE);
        }
        return null;
    }

    @Override
    public String getDateOfLastModificationStringRepresentation(Object dataItem) {
        if (dataItem instanceof IUniqueElement) {
            return UEView2LabelProvider.getAttributeValueAsString((IUniqueElement)dataItem, AbstractAttributeTypesProvider.ATTRID_LAST_EDIT_DATE);
        }
        return null;
    }

    private static String getAttributeValueAsString(IUniqueElement dataItem, IAttributeTypeID attributeTypeID) {
        IAttribute attribute = dataItem.getAttribute(attributeTypeID);
        IAttributeType attributeType = dataItem.getAttributeType(attributeTypeID);
        Locale projectLanguage = new Locale(ProjectMgr.getProjectMgr().getProjectAgent(dataItem.getProjectUID()).getLanguage());
        return attributeType.getDataType().getValueAsSingleLineString(attribute.getAttributeValue(), attributeType.getValueRange(), ",", projectLanguage);
    }

    private static long getAttributeValueAsDate(IUniqueElement dataItem, IAttributeTypeID attributeTypeID) {
        IAttribute attribute = dataItem.getAttribute(attributeTypeID);
        Date date = DataTypeDate.getValueAsDate(attribute.getAttributeValue());
        return date != null ? date.getTime() : 0L;
    }

    @Override
    public Collection<String> getDatatypesForWhichCustomPropertyColumnsAreToBeCreated() {
        return Collections.singleton("com.arcway.cockpit.uniqueelement");
    }

    @Override
    public String getProjectUID(Object dataItem) {
        if (dataItem instanceof IUniqueElement) {
            return ((IUniqueElement)dataItem).getProjectUID();
        }
        if (dataItem instanceof CycleWrapper) {
            return ((CycleWrapper)dataItem).getProjectUID();
        }
        assert (false);
        return null;
    }

    @Override
    public IAttributeOwner getAttributeOwner(Object dataItem) {
        if (dataItem instanceof IUniqueElement) {
            return (IUniqueElement)dataItem;
        }
        return null;
    }

    public void dispose() {
        this.cachingUELabelProvider.clearLabelCaches();
        this.image_uecycle.dispose();
    }
}

