/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.global.gui.views.uniqueelement2;

import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.global.gui.views.uniqueelement2.CycleWrapper;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.IFrameUniqueElementManager;
import com.arcway.cockpit.frame.client.project.ProjectAgent;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.IUniqueElement;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.relationships.CyclicUERelationshipIdentifier;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.relationships.IUniqueElementRelationshipProvider;
import com.arcway.cockpit.frame.client.project.modules.IModuleUniqueElementManager;
import com.arcway.lib.java.collectionmaps.SetMap;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class UEView2ContentProvider {
    private static final ILogger logger = Logger.getLogger(UEView2ContentProvider.class);
    private boolean showListOnly;

    public UEView2ContentProvider(boolean showListOnly) {
        this.showListOnly = showListOnly;
    }

    public void setViewMode(boolean showListOnly) {
        this.showListOnly = showListOnly;
    }

    public List<Object> getElements(IFrameProjectAgent project) {
        ArrayList<Object> elementsToShowOnRootLevel = new ArrayList<Object>();
        if (project != null && project.isOpened()) {
            if (this.showListOnly) {
                ArrayList<? extends IUniqueElement> allUniqueElements = new ArrayList<IUniqueElement>(project.getFrameUniqueElementMgr().getUniqueElements());
                elementsToShowOnRootLevel.addAll(allUniqueElements);
            } else {
                elementsToShowOnRootLevel.addAll(this.retrieveChildren(null, project.getProjectUID()));
            }
        }
        return elementsToShowOnRootLevel;
    }

    public List<Object> getChildren(Object parentObject, String projectUID) {
        List<Object> result;
        if (this.showListOnly) {
            result = Collections.emptyList();
        } else if (parentObject instanceof IUniqueElement) {
            IUniqueElement parentElement = (IUniqueElement)parentObject;
            result = this.retrieveChildren(parentElement, projectUID);
        } else if (parentObject instanceof CycleWrapper) {
            IModuleUniqueElementManager moduleUniqueElementManager_ = ProjectMgr.getProjectMgr().getProjectAgent(projectUID).getModuleUniqueElementManager();
            Set<String> cycleElements = ((CycleWrapper)parentObject).getCycle().getAllElements();
            result = new ArrayList<Object>(cycleElements.size());
            for (String cycleElement : cycleElements) {
                result.add(moduleUniqueElementManager_.getUniqueElement(cycleElement));
            }
        } else {
            logger.debug("Unique Element View requested children of tree element that is neither a unique element nor a cycle.");
            assert (false);
            result = null;
        }
        return result;
    }

    private List<Object> retrieveChildren(IUniqueElement parentModelElement, String projectUID) {
        ArrayList<Object> children;
        ProjectAgent projectAgent_ = ProjectMgr.getProjectMgr().getProjectAgent(projectUID);
        IUniqueElementRelationshipProvider containmentRelationshipProv = projectAgent_.getUniqueElementRelationshipManager().getUERelationshipProviderManager().getContainmentRelationshipProvider();
        if (parentModelElement == null) {
            Collection<IUniqueElement> firstUniqueElements = containmentRelationshipProv.getFirstUniqueElements();
            Set<CyclicUERelationshipIdentifier.Cycle> rootCycles = containmentRelationshipProv.getRootCycles();
            children = new ArrayList(firstUniqueElements.size() + rootCycles.size());
            children.addAll(firstUniqueElements);
            for (CyclicUERelationshipIdentifier.Cycle rootCycle : rootCycles) {
                children.add(new CycleWrapper(null, null, rootCycle, projectUID));
            }
        } else {
            Collection<IUniqueElement> foundModelElements = containmentRelationshipProv.getNextUniqueElements(parentModelElement.getUID());
            children = new ArrayList<Object>(foundModelElements.size());
            for (IUniqueElement foundModelElement : foundModelElements) {
                if (!containmentRelationshipProv.isPartOfCycle(foundModelElement.getUID())) {
                    children.add(foundModelElement);
                    continue;
                }
                CyclicUERelationshipIdentifier.Cycle cycle = containmentRelationshipProv.getCycle(foundModelElement.getUID());
                if (cycle.getAllElements().contains(parentModelElement.getUID())) continue;
                children.add(new CycleWrapper(parentModelElement, foundModelElement, cycle, projectUID));
            }
        }
        return children;
    }

    public List<Object> getParents(Object element, String projectUID) {
        if (this.showListOnly) {
            return null;
        }
        if (element instanceof IUniqueElement) {
            ProjectAgent projectAgent_ = ProjectMgr.getProjectMgr().getProjectAgent(projectUID);
            IUniqueElementRelationshipProvider containmentRelationshipProv = projectAgent_.getUniqueElementRelationshipManager().getUERelationshipProviderManager().getContainmentRelationshipProvider();
            IFrameUniqueElementManager modelElementManager = projectAgent_.getFrameUniqueElementMgr();
            IUniqueElement modelElement = (IUniqueElement)element;
            if (containmentRelationshipProv.isPartOfCycle(modelElement.getUID())) {
                CyclicUERelationshipIdentifier.Cycle cycle = containmentRelationshipProv.getCycle(modelElement.getUID());
                if (cycle.isRootCycle()) {
                    return Collections.singletonList(new CycleWrapper(null, null, cycle, projectUID));
                }
                ArrayList<Object> parents = new ArrayList<Object>();
                SetMap<String, String> possibleParents = cycle.getPossibleParents();
                for (String entryPoint : possibleParents.keySet()) {
                    IUniqueElement entryPointUniqueElement = modelElementManager.getUniqueElement(entryPoint);
                    for (String parent : possibleParents.get((Object)entryPoint)) {
                        parents.add(new CycleWrapper(modelElementManager.getUniqueElement(parent), entryPointUniqueElement, cycle, projectUID));
                    }
                }
                return parents;
            }
            return new ArrayList<Object>(containmentRelationshipProv.getPreviousUniqueElements(modelElement.getUID()));
        }
        if (element instanceof CycleWrapper) {
            IUniqueElement parent = ((CycleWrapper)element).getParent();
            if (parent != null) {
                return Collections.singletonList(parent);
            }
            return null;
        }
        assert (false);
        return null;
    }

    public boolean itemExists(Object element, String projectUID) {
        ProjectAgent projectAgent_ = ProjectMgr.getProjectMgr().getProjectAgent(projectUID);
        if (element instanceof IUniqueElement) {
            return projectAgent_.getFrameUniqueElementMgr().getUniqueElement(((IUniqueElement)element).getUID()) != null;
        }
        if (element instanceof CycleWrapper) {
            CycleWrapper cycleToBeFound = (CycleWrapper)element;
            IUniqueElementRelationshipProvider containmentRelationshipProv = projectAgent_.getUniqueElementRelationshipManager().getUERelationshipProviderManager().getContainmentRelationshipProvider();
            if (cycleToBeFound.getCycleEntryPoint() != null) {
                return containmentRelationshipProv.isPartOfCycle(cycleToBeFound.getCycleEntryPoint().getUID()) && containmentRelationshipProv.doesRelationshipExist(cycleToBeFound.getParent().getUID(), cycleToBeFound.getCycleEntryPoint().getUID());
            }
            for (CyclicUERelationshipIdentifier.Cycle rootCycle : projectAgent_.getUniqueElementRelationshipManager().getUERelationshipProviderManager().getContainmentRelationshipProvider().getRootCycles()) {
                if (!cycleToBeFound.getCycle().getAllElements().equals(rootCycle.getAllElements())) continue;
                return true;
            }
            return false;
        }
        logger.debug("Unique Element View asks whether an item exists, which is neither a unique element nor a cycle.");
        assert (false);
        return false;
    }
}

