/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.global.gui.views.uniqueelement2;

import com.arcway.cockpit.frame.client.global.EXConstructionElementTypeUnknown;
import com.arcway.cockpit.frame.client.global.ExtensionMgr;
import com.arcway.cockpit.frame.client.global.Icons;
import com.arcway.cockpit.frame.client.global.Messages;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.IFrameUniqueElementManager;
import com.arcway.cockpit.frame.client.project.core.categories.ObjectTypeCategoryIconProvider;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.IUniqueElement;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.OccurrenceList;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.swt.graphics.Image;

public class UEListLabelProvider
implements ILabelProvider {
    private final Map<String, Image> ueTypeImages = new HashMap<String, Image>(20, 0.5f);
    private IFrameProjectAgent projectAgent;

    public UEListLabelProvider() {
    }

    public UEListLabelProvider(IFrameProjectAgent projectAgent) {
        assert (projectAgent != null);
        assert (projectAgent.isOpened());
        this.projectAgent = projectAgent;
    }

    public Image getImage(Object element) {
        assert (element instanceof IUniqueElement) : "invalid entry";
        IUniqueElement modelElement = (IUniqueElement)element;
        Image objectTypeCategoryIcon = ObjectTypeCategoryIconProvider.getDefault().getObjectTypeCategoryIcon(modelElement.getProjectUID(), modelElement.getCategoryID());
        if (objectTypeCategoryIcon != null) {
            return objectTypeCategoryIcon;
        }
        String elementTypeID = modelElement.getElementTypeID();
        Image image = this.ueTypeImages.get(elementTypeID);
        if (image == null) {
            try {
                URL url = ExtensionMgr.getDefault().getConstructionElementIconForType(elementTypeID);
                ImageDescriptor descriptor = ImageDescriptor.createFromURL((URL)url);
                image = descriptor.createImage();
            }
            catch (EXConstructionElementTypeUnknown e) {
                image = Icons.getUnknownImageDescriptor().createImage();
            }
            this.ueTypeImages.put(elementTypeID, image);
        }
        return image;
    }

    public String getText(Object element) {
        assert (element instanceof IUniqueElement) : "invalid entry";
        IUniqueElement uniqueElement = (IUniqueElement)element;
        IFrameUniqueElementManager uniqueElementMgr = this.projectAgent.getFrameUniqueElementMgr();
        OccurrenceList occurenceList = uniqueElementMgr.getUniqueElementOccurrences(uniqueElement.getUID());
        String text = uniqueElement.getElementName();
        if (occurenceList.isEmpty()) {
            text = String.valueOf(text) + Messages.getString("UEListLabelProvider.unassigned");
        }
        return text;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void setProjectAgent(IFrameProjectAgent projectAgent) {
        this.projectAgent = projectAgent;
    }

    public void dispose() {
        Iterator<String> i = this.ueTypeImages.keySet().iterator();
        while (i.hasNext()) {
            Image image = this.ueTypeImages.get(i.next());
            image.dispose();
            i.remove();
        }
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }
}

