/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.global.gui.views.project;

import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.global.gui.views.project.ProjectView;
import com.arcway.cockpit.frame.client.global.gui.views.project.ProjectViewTransfer;
import com.arcway.cockpit.frame.client.global.license.IClientFunctionLicense;
import com.arcway.cockpit.frame.client.global.license.licensetypes.ClientFunctionLicenseTypeModifyProjectsAndSectionsAndPlans;
import com.arcway.cockpit.frame.client.project.ProjectAgent;
import com.arcway.cockpit.frame.client.project.core.framedata.IFrameDataRW;
import com.arcway.cockpit.frame.client.project.core.sectionsandplans.plan.IPlan;
import com.arcway.cockpit.frame.client.project.core.sectionsandplans.plan.IPlanRW;
import com.arcway.cockpit.frame.client.project.core.sectionsandplans.sections.ISection;
import com.arcway.cockpit.frame.client.project.core.sectionsandplans.sections.ISectionRW;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.Transfer;

class ProjectViewDragAgent
implements DragSourceListener {
    private final ISelectionProvider sourceSelectionProvider;

    protected ProjectViewDragAgent(ProjectView projectView) {
        assert (projectView != null);
        this.sourceSelectionProvider = projectView.getTreeViewer();
        DragSource dragSource = new DragSource(projectView.getTreeViewer().getControl(), 2);
        dragSource.setTransfer(new Transfer[]{ProjectViewTransfer.getInstance()});
        dragSource.addDragListener((DragSourceListener)this);
    }

    public void dragStart(DragSourceEvent event) {
        Collection selection = this.calculateSelectedElements();
        if (!(selection = this.considerLicensesForDragOperation(selection)).isEmpty() && selection.size() == 1) {
            ProjectViewTransfer.getInstance().setSelection(selection);
            event.doit = true;
        } else {
            event.doit = false;
        }
    }

    private Collection considerLicensesForDragOperation(Collection selection) {
        ArrayList result = new ArrayList();
        ProjectAgent projectAgent = null;
        boolean hasModifySectionsAndPlansLicense = false;
        for (Object o : selection) {
            if (!(o instanceof IFrameDataRW)) continue;
            IFrameDataRW section = (IFrameDataRW)o;
            if (projectAgent == null) {
                projectAgent = ProjectMgr.getProjectMgr().getProjectAgent(section.getProjectUID());
                IClientFunctionLicense license = projectAgent.getServerLicenseManager().findClientFunctionLicense(ClientFunctionLicenseTypeModifyProjectsAndSectionsAndPlans.getInstance());
                boolean bl = hasModifySectionsAndPlansLicense = !ClientFunctionLicenseTypeModifyProjectsAndSectionsAndPlans.getInstance().isDenial(license);
            }
            if (o instanceof ISection || o instanceof IPlan) {
                if (!hasModifySectionsAndPlansLicense) continue;
                result.add(o);
                continue;
            }
            result.add(o);
        }
        return result;
    }

    public void dragSetData(DragSourceEvent event) {
    }

    public void dragFinished(DragSourceEvent event) {
    }

    private Collection calculateSelectedElements() {
        ArrayList<ICockpitProjectData> selection = new ArrayList<ICockpitProjectData>();
        if (!this.sourceSelectionProvider.getSelection().isEmpty() && this.sourceSelectionProvider.getSelection() instanceof IStructuredSelection) {
            IStructuredSelection sel = (IStructuredSelection)this.sourceSelectionProvider.getSelection();
            String projectUID = null;
            for (Object o : sel) {
                if (!(o instanceof ISectionRW) && !(o instanceof IPlanRW)) continue;
                ICockpitProjectData data = (ICockpitProjectData)o;
                if (projectUID == null) {
                    projectUID = data.getProjectUID();
                }
                if (projectUID.equals(data.getProjectUID())) {
                    selection.add(data);
                    continue;
                }
                selection.clear();
                break;
            }
        }
        return selection;
    }
}

