/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.global.gui.views.project;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeOwner;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeType;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.stakeholders.IStakeholder;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.stakeholders.IStakeholderManager;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.stakeholders.IStakeholderRole;
import com.arcway.cockpit.client.base.interfaces.frame.propertychanges.IPropertyChanges;
import com.arcway.cockpit.client.base.interfaces.frame.propertychanges.IPropertyChangesListener;
import com.arcway.cockpit.cockpitlib.client.gui.DeferredRefresher;
import com.arcway.cockpit.cockpitlib.client.gui.IRefreshableDisplay;
import com.arcway.cockpit.frame.client.global.Messages;
import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.global.gui.actions.ChangeServerPropertiesAction;
import com.arcway.cockpit.frame.client.global.gui.properties.CEProperties;
import com.arcway.cockpit.frame.client.global.gui.views.linkview.ModuleLinkViewContribution;
import com.arcway.cockpit.frame.client.global.gui.views.project.ProjectTemplateFileDropListener;
import com.arcway.cockpit.frame.client.global.gui.views.project.ProjectTreeContentProvider;
import com.arcway.cockpit.frame.client.global.gui.views.project.ProjectViewDragAgent;
import com.arcway.cockpit.frame.client.global.gui.views.project.ProjectViewDropAgent;
import com.arcway.cockpit.frame.client.global.gui.views.project.ProjectViewLabelDecorator;
import com.arcway.cockpit.frame.client.global.gui.views.project.ProjectViewSorter;
import com.arcway.cockpit.frame.client.global.gui.views.uniqueelement2.UniqueElementLabelDecorator;
import com.arcway.cockpit.frame.client.global.gui.wizards.MainExportWizard;
import com.arcway.cockpit.frame.client.global.gui.wizards.MainSynchronizeWizard;
import com.arcway.cockpit.frame.client.global.selection.CockpitSelectionManager;
import com.arcway.cockpit.frame.client.project.ExProjectOpenAbortWithMessage;
import com.arcway.cockpit.frame.client.project.ICockpitProject;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.IProjectAgent;
import com.arcway.cockpit.frame.client.project.IProjectOpenListener;
import com.arcway.cockpit.frame.client.project.Project;
import com.arcway.cockpit.frame.client.project.ProjectAgent;
import com.arcway.cockpit.frame.client.project.core.reporttemplates.IReportTemplateFolderRW;
import com.arcway.cockpit.frame.client.project.core.sectionsandplans.plan.IPlan;
import com.arcway.cockpit.frame.client.project.core.sectionsandplans.sections.ISection;
import com.arcway.cockpit.frame.client.project.core.stakeholders.RoleList;
import com.arcway.cockpit.frame.client.project.core.stakeholders.StakeholderList;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.IUniqueElement;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.UniqueElementMgr;
import com.arcway.cockpit.frame.client.project.modules.IProjectCloseListener;
import com.arcway.cockpit.frame.client.project.modules.ModuleController;
import com.arcway.cockpit.frame.client.project.planeditors.PlanEditorLauncher;
import com.arcway.cockpit.frame.shared.message.IRoleAndStakeholder;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.lib.eclipse.gui.LayoutHelper;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import de.plans.fmca.client.PSCServices;
import de.plans.lib.util.gui.DecoratingLabelProvider;
import de.plans.psc.client.communication.IServerStatusChangedListener;
import de.plans.psc.client.communication.LoginCanceledException;
import de.plans.psc.client.communication.ServerConnection;
import de.plans.psc.client.communication.ServerNotAvailableException;
import de.plans.psc.client.communication.UnknownServerException;
import de.plans.psc.client.dialogs.swt.ServerConnectionFailureUI;
import de.plans.psc.shared.serverexceptions.EXServerException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class ProjectView
extends ViewPart
implements IServerStatusChangedListener,
ISelectionChangedListener,
IOpenListener,
IProjectOpenListener,
IProjectCloseListener,
IPropertyChangesListener,
ISelectionListener,
IRefreshableDisplay {
    public static final String VIEW_ID = "de.plans.fmca.frame.ProjectView";
    private static final String PROJECTVIEW_CONTEXTMENU_ID = "de.plans.fmca.frame.ProjectView.contextmenu";
    private static final ILogger logger = Logger.getLogger(ProjectView.class);
    private TreeViewer treeViewer;
    private ProjectTreeContentProvider projectTreeContentProvider = new ProjectTreeContentProvider(null);
    private DecoratingLabelProvider projectTreeLabelProvider;
    private final MenuManager contextMenuMgr = new MenuManager("ProjectViewContextMenu");
    private Set<Object> additionalElementsToExpand;
    private ChangeServerPropertiesAction addServerAction;
    private ISelection selection;
    private IFrameProjectAgent currentProjectAgent;
    private DeferredRefresher refresher;
    private final Set<IFrameProjectAgent> whereAmIRegistered = new HashSet<IFrameProjectAgent>();
    private Composite pagebook;
    private StackLayout pageBookLayout;
    private Composite pageWithCreateServerButton;
    private Composite pageWithTreeViewer;
    private Composite projectCreationHint = null;
    private static Set<ProjectView> openProjectViews = new HashSet<ProjectView>();

    public void init(IViewSite site) throws PartInitException {
        ModuleLinkViewContribution moduleLinkViewContribution = new ModuleLinkViewContribution((IWorkbenchPartSite)site);
        this.projectTreeContentProvider = new ProjectTreeContentProvider(moduleLinkViewContribution);
        super.init(site);
    }

    private void refreshPageBook() {
        this.pageBookLayout.topControl = ProjectMgr.getProjectMgr().getConfiguredServerConnections().size() == 0 && ProjectMgr.getProjectMgr().getGeneralServerProxy().mayAdministrateServers() ? this.pageWithCreateServerButton : this.pageWithTreeViewer;
        this.pagebook.layout();
    }

    private void refreshCreateProjectHint() {
        if (ProjectMgr.getProjectMgr().getConfiguredProjects().length > 0) {
            this.disposeProjectCreationHint();
        } else {
            this.disposeProjectCreationHint();
            this.createProjectCreationHint();
        }
    }

    public void createPartControl(Composite parent) {
        Color white = parent.getDisplay().getSystemColor(1);
        this.pagebook = new Composite(parent, 0);
        this.pageBookLayout = new StackLayout();
        this.pagebook.setLayout((Layout)this.pageBookLayout);
        this.pageWithCreateServerButton = new Composite(this.pagebook, 0);
        this.pageWithCreateServerButton.setLayout((Layout)new GridLayout());
        this.pageWithCreateServerButton.setBackground(white);
        this.pageWithTreeViewer = new Composite(this.pagebook, 0);
        this.pageWithTreeViewer.setLayout((Layout)LayoutHelper.createGridLayout((int)1, (boolean)true, (int)0, (int)0));
        this.refreshPageBook();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.pagebook, "com.arcway.cockpit.frame.help.project_navigator_index");
        Text textToCreateAServer = new Text(this.pageWithCreateServerButton, 64);
        textToCreateAServer.setLayoutData((Object)new GridData(768));
        textToCreateAServer.setBackground(white);
        textToCreateAServer.setText(Messages.getString("ProjectView.YouMustAddAServer"));
        Button buttonToCreateAServer = new Button(this.pageWithCreateServerButton, 0);
        buttonToCreateAServer.setLayoutData((Object)new GridData(1));
        buttonToCreateAServer.setText(Messages.getString("ProjectView.AddAServer"));
        if (this.addServerAction == null) {
            this.addServerAction = new ChangeServerPropertiesAction((ISelectionProvider)this.treeViewer, 1);
        }
        buttonToCreateAServer.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                ProjectView.this.addServerAction.update();
                if (ProjectView.this.addServerAction.isEnabled()) {
                    ProjectView.this.addServerAction.run();
                }
            }

            public void widgetSelected(SelectionEvent e) {
                ProjectView.this.addServerAction.update();
                if (ProjectView.this.addServerAction.isEnabled()) {
                    ProjectView.this.addServerAction.run();
                }
            }
        });
        this.treeViewer = new TreeViewer(this.pageWithTreeViewer, 2);
        this.treeViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.treeViewer.setContentProvider((IContentProvider)this.projectTreeContentProvider);
        this.projectTreeLabelProvider = new DecoratingLabelProvider((ILabelProvider)this.projectTreeContentProvider);
        this.projectTreeLabelProvider.addLabelDecorator((ILabelDecorator)new UniqueElementLabelDecorator());
        this.projectTreeLabelProvider.addLabelDecorator((ILabelDecorator)new ProjectViewLabelDecorator(this.projectTreeContentProvider));
        this.treeViewer.setLabelProvider((IBaseLabelProvider)this.projectTreeLabelProvider);
        this.treeViewer.setSorter((ViewerSorter)ProjectViewSorter.getSingleton());
        this.treeViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.treeViewer.addOpenListener((IOpenListener)this);
        this.contextMenuMgr.setRemoveAllWhenShown(true);
        this.getSite().registerContextMenu(PROJECTVIEW_CONTEXTMENU_ID, this.contextMenuMgr, (ISelectionProvider)this.treeViewer);
        Menu menu = this.contextMenuMgr.createContextMenu(this.treeViewer.getControl());
        this.treeViewer.getControl().setMenu(menu);
        this.getSite().setSelectionProvider((ISelectionProvider)this.treeViewer);
        CockpitSelectionManager.getSelectionService(this.getSite().getWorkbenchWindow().getSelectionService()).addSelectionListener(this);
        ProjectAgent.addProjectOpenListener(this);
        this.updatePropertyChangeListeners(false);
        this.treeViewer.setAutoExpandLevel(2);
        this.treeViewer.setInput((Object)ProjectMgr.getProjectMgr());
        this.refreshCreateProjectHint();
        new ProjectViewDragAgent(this);
        ProjectViewDropAgent dropAgent = new ProjectViewDropAgent(this);
        dropAgent.addFileDropListener(new ProjectTemplateFileDropListener(this.getSite().getPage().getWorkbenchWindow()));
        PSCServices.getServiceFacade().getRequestForwarder().addServerStatusChangedListener((IServerStatusChangedListener)this);
        Collection<ServerConnection> serverConnections = ProjectMgr.getProjectMgr().getConfiguredServerConnections();
        if (serverConnections.size() == 1) {
            this.getSite().getSelectionProvider().setSelection((ISelection)new StructuredSelection((Object)serverConnections.iterator().next()));
        }
        openProjectViews.add(this);
    }

    private void createProjectCreationHint() {
        if (this.projectCreationHint == null && this.pageWithTreeViewer != null && !this.pageWithTreeViewer.isDisposed()) {
            String serverName;
            Collection<ServerConnection> serverConnections = ProjectMgr.getProjectMgr().getConfiguredServerConnections();
            if (serverConnections.isEmpty()) {
                serverName = "[???]";
            } else {
                ServerConnection serverConnection = serverConnections.iterator().next();
                serverName = serverConnection.getServerName();
            }
            Color white = this.pageWithTreeViewer.getDisplay().getSystemColor(1);
            this.projectCreationHint = new Composite(this.pageWithTreeViewer, 0);
            this.projectCreationHint.setLayoutData((Object)new GridData(4, 1024, true, false));
            this.projectCreationHint.setLayout((Layout)LayoutHelper.createGridLayout((int)1, (boolean)true, (int)10, (int)0));
            this.projectCreationHint.setBackground(white);
            Label helpHowToOpenProjects = new Label(this.projectCreationHint, 64);
            helpHowToOpenProjects.setLayoutData((Object)new GridData(4, 1024, true, false));
            helpHowToOpenProjects.setBackground(white);
            String message = Messages.getString("ProjectView.ProjectCreationHint");
            helpHowToOpenProjects.setText(NLS.bind((String)message, (Object)serverName));
            this.pageWithTreeViewer.layout();
        }
    }

    private void disposeProjectCreationHint() {
        if (this.projectCreationHint != null) {
            if (!this.projectCreationHint.isDisposed()) {
                this.projectCreationHint.dispose();
            }
            this.projectCreationHint = null;
            if (!this.pageWithTreeViewer.isDisposed()) {
                this.pageWithTreeViewer.layout();
            }
        }
    }

    public void dispose() {
        ProjectAgent.removeProjectOpenListener(this);
        this.updatePropertyChangeListeners(true);
        if (this.refresher != null) {
            this.refresher.halt();
        }
        CockpitSelectionManager.getSelectionService(this.getSite().getWorkbenchWindow().getSelectionService()).removeSelectionListener(this);
        openProjectViews.remove(this);
        super.dispose();
    }

    public TreeViewer getTreeViewer() {
        return this.treeViewer;
    }

    public void activateExportWizard(MainExportWizard wizard) {
        assert (wizard != null) : "wizard is null";
        WizardDialog dialog = new WizardDialog(this.getSite().getShell(), (IWizard)wizard);
        dialog.open();
    }

    public void activateSynchronizeWizard(MainSynchronizeWizard wizard) {
        assert (wizard != null) : "wizard is null";
        WizardDialog dialog = new WizardDialog(this.getSite().getShell(), (IWizard)wizard);
        dialog.open();
    }

    public void refresh() {
        if (!this.pagebook.isDisposed()) {
            this.refreshPageBook();
        }
        this.refreshCreateProjectHint();
        if (!this.treeViewer.getTree().isDisposed()) {
            Object[] expandedElements = this.treeViewer.getExpandedElements();
            ArrayList<Object> elementsToExpand = new ArrayList<Object>(Arrays.asList(expandedElements));
            if (this.additionalElementsToExpand != null) {
                elementsToExpand.addAll(this.additionalElementsToExpand);
                this.additionalElementsToExpand = null;
            }
            this.treeViewer.refresh();
            this.treeViewer.setExpandedElements(elementsToExpand.toArray());
            ISelection oldSelection = this.getSite().getSelectionProvider().getSelection();
            this.getSite().getSelectionProvider().setSelection(null);
            this.getSite().getSelectionProvider().setSelection(oldSelection);
        }
    }

    private void updatePropertyChangeListeners(boolean deregisterAll) {
        IFrameProjectAgent[] currentlyConfiguredProjects = deregisterAll ? new IFrameProjectAgent[]{} : ProjectMgr.getProjectMgr().getConfiguredProjects();
        HashSet<IFrameProjectAgent> noLongerOpenProjects = new HashSet<IFrameProjectAgent>(this.whereAmIRegistered);
        IFrameProjectAgent[] iFrameProjectAgentArray = currentlyConfiguredProjects;
        int n = currentlyConfiguredProjects.length;
        int n2 = 0;
        while (n2 < n) {
            IFrameProjectAgent currentlyConfiguredProject = iFrameProjectAgentArray[n2];
            if (currentlyConfiguredProject.isOpenAndNotClosing()) {
                if (this.whereAmIRegistered.contains(currentlyConfiguredProject)) {
                    noLongerOpenProjects.remove(currentlyConfiguredProject);
                } else {
                    currentlyConfiguredProject.getPropertyChangesListenerManager().register((IPropertyChangesListener)this, IFrameProjectAgent.class);
                    currentlyConfiguredProject.getPropertyChangesListenerManager().register((IPropertyChangesListener)this, ICockpitProjectData.class);
                    currentlyConfiguredProject.getPropertyChangesListenerManager().register((IPropertyChangesListener)this, IRoleAndStakeholder.class);
                    currentlyConfiguredProject.getPropertyChangesListenerManager().register((IPropertyChangesListener)this, IAttributeType.class);
                    currentlyConfiguredProject.getPropertyChangesListenerManager().register((IPropertyChangesListener)this, ICockpitProject.class);
                    currentlyConfiguredProject.getPropertyChangesListenerManager().register((IPropertyChangesListener)this, IReportTemplateFolderRW.class);
                    if (currentlyConfiguredProject.isOpened()) {
                        currentlyConfiguredProject.getPropertyChangesListenerManager().register((IPropertyChangesListener)this, ISection.class);
                        currentlyConfiguredProject.getPropertyChangesListenerManager().register((IPropertyChangesListener)this, IPlan.class);
                        currentlyConfiguredProject.getPropertyChangesListenerManager().register((IPropertyChangesListener)this, IStakeholder.class);
                        currentlyConfiguredProject.getPropertyChangesListenerManager().register((IPropertyChangesListener)this, IStakeholderRole.class);
                    }
                    this.whereAmIRegistered.add(currentlyConfiguredProject);
                }
            }
            ++n2;
        }
        for (IFrameProjectAgent noLongerOpenProject : noLongerOpenProjects) {
            noLongerOpenProject.getPropertyChangesListenerManager().deregister((IPropertyChangesListener)this);
            this.whereAmIRegistered.remove(noLongerOpenProject);
        }
    }

    private void refreshViewer() {
        if (this.refresher == null) {
            this.refresher = new DeferredRefresher((IRefreshableDisplay)this);
            this.refresher.start();
        }
        this.refresher.scheduleDeferredRefresh();
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.selection = event.getSelection();
        if (!this.selection.isEmpty() && this.selection instanceof IStructuredSelection) {
            IStructuredSelection sel = (IStructuredSelection)this.selection;
            Object obj = sel.getFirstElement();
            if (obj instanceof ICockpitProjectData) {
                ICockpitProjectData cpd = (ICockpitProjectData)obj;
                this.setCurrentProjectAgent(cpd.getProjectUID());
            } else if (obj instanceof ModuleController) {
                ModuleController moduleController = (ModuleController)obj;
                String id = moduleController.getProjectAgent().getProjectUID();
                this.setCurrentProjectAgent(id);
            } else if (obj instanceof UniqueElementMgr) {
                UniqueElementMgr uniqueElementMgr = (UniqueElementMgr)obj;
                String projectUID = uniqueElementMgr.getProjectAgent().getProjectUID();
                this.setCurrentProjectAgent(projectUID);
            } else if (obj instanceof IUniqueElement) {
                IUniqueElement uniqueElement = (IUniqueElement)obj;
                this.setCurrentProjectAgent(uniqueElement.getProjectUID());
            } else if (obj instanceof IStakeholder[]) {
                IStakeholder[] stakeholders = (IStakeholder[])obj;
                if (stakeholders.length > 0) {
                    this.setCurrentProjectAgent(stakeholders[0].getProjectUID());
                }
            } else if (obj instanceof IStakeholderRole[]) {
                IStakeholderRole[] roles = (IStakeholderRole[])obj;
                if (roles.length > 0) {
                    this.setCurrentProjectAgent(roles[0].getProjectUID());
                }
            } else if (obj instanceof IStakeholderManager) {
                IStakeholderManager manager = (IStakeholderManager)obj;
                this.setCurrentProjectAgent(manager.getProjectUID());
            } else if (obj instanceof StakeholderList) {
                StakeholderList stakeholderList = (StakeholderList)obj;
                this.setCurrentProjectAgent(stakeholderList.getProjectUID());
            } else if (obj instanceof RoleList) {
                RoleList roleList = (RoleList)obj;
                this.setCurrentProjectAgent(roleList.getProjectUID());
            }
        }
    }

    @Override
    public void projectOpened(IProjectAgent projectAgent) {
        ((IFrameProjectAgent)projectAgent).addProjectCloseListener(this);
        this.updatePropertyChangeListeners(false);
        if (this.additionalElementsToExpand == null) {
            this.additionalElementsToExpand = new HashSet<Object>();
        }
        this.additionalElementsToExpand.add(projectAgent);
        this.refreshViewer();
    }

    @Override
    public void closeProject(IFrameProjectAgent projectAgent) {
        projectAgent.removeProjectCloseListener(this);
        this.updatePropertyChangeListeners(false);
        this.refreshViewer();
    }

    public void open(OpenEvent event) {
        CEProperties.Input input;
        IStructuredSelection sel = (IStructuredSelection)this.selection;
        Object obj = sel.getFirstElement();
        if (obj instanceof IPlan) {
            assert (this.currentProjectAgent != null);
            assert (this.currentProjectAgent.isOpened());
            IWorkbenchPage page = this.getSite().getPage();
            PlanEditorLauncher planEditorLauncher = new PlanEditorLauncher(3, false);
            planEditorLauncher.openOrShowPlanEditors(page, this.selection);
        } else if (obj instanceof ISection) {
            if (this.treeViewer.getExpandedState(obj)) {
                this.collapse(obj);
            } else {
                this.expand(obj);
            }
        } else if (obj instanceof IFrameProjectAgent) {
            IFrameProjectAgent projectAgent = (IFrameProjectAgent)obj;
            if (projectAgent.isOpened()) {
                if (this.treeViewer.getExpandedState(obj)) {
                    this.collapse(obj);
                } else {
                    this.expand(obj);
                }
            } else {
                Throwable th = null;
                try {
                    boolean triggerUserOnOpenActions = true;
                    projectAgent.openWithProgressbar(false, triggerUserOnOpenActions, this.getSite().getPage());
                }
                catch (LoginCanceledException triggerUserOnOpenActions) {
                }
                catch (ServerNotAvailableException e) {
                    th = e;
                }
                catch (UnknownServerException e) {
                    th = e;
                }
                catch (EXServerException e) {
                    th = e;
                }
                catch (InterruptedException e) {
                    th = e;
                }
                catch (ExProjectOpenAbortWithMessage e) {
                    th = e;
                }
                if (th != null) {
                    logger.error("could not open project", th);
                    if (th instanceof ExProjectOpenAbortWithMessage) {
                        projectAgent.showProjectOpenAbortWithMessageDialog(this.getSite().getShell(), (ExProjectOpenAbortWithMessage)th);
                    } else {
                        ServerConnectionFailureUI.troubleshootServerConnectionFailure((Shell)this.getSite().getShell(), (String)NLS.bind((String)Messages.getString("ProjectView.open_OpenEvent_CouldNotOpenProject"), (Object)projectAgent.getProjectName()), (Throwable)th);
                    }
                }
            }
        } else if (obj instanceof ModuleController) {
            if (this.treeViewer.getExpandedState(obj)) {
                this.collapse(obj);
            } else {
                this.expand(obj);
            }
        } else if (obj instanceof IUniqueElement) {
            IUniqueElement ue = (IUniqueElement)obj;
            this.currentProjectAgent.getFrameUniqueElementMgr().openPlanForUniqueElement(ue, null, this.getViewSite().getPage());
        } else if (obj instanceof ICockpitProjectData && (input = CEProperties.checkSuitabilityForPropertiesCommand((ISelection)sel)) != null) {
            CEProperties.openProperties(input, this.getSite().getPage());
        }
    }

    public static void refresh1() {
        for (ProjectView projectView : openProjectViews) {
            projectView.refreshViewer();
        }
    }

    public static void select(Object o) {
        if (o instanceof IFrameProjectAgent) {
            ProjectView.selectProject((IFrameProjectAgent)o);
        } else if (o instanceof ServerConnection) {
            ProjectView.selectServerConnection((ServerConnection)o);
        }
    }

    private static void selectServerConnection(ServerConnection serverConnection) {
        for (ProjectView view : openProjectViews) {
            view.refresh();
            ArrayList<Object> elementsToExpand = new ArrayList<Object>();
            elementsToExpand.add(serverConnection);
            elementsToExpand.addAll(Arrays.asList(view.getTreeViewer().getExpandedElements()));
            view.getTreeViewer().setExpandedElements(elementsToExpand.toArray());
            StructuredSelection sel = new StructuredSelection((Object)serverConnection);
            view.treeViewer.setSelection((ISelection)sel, true);
            CockpitSelectionManager.getSelectionService(view.getSite().getPage().getWorkbenchWindow().getSelectionService()).fireSelection((ISelection)sel, (IWorkbenchPart)view);
        }
    }

    private static void selectProject(IFrameProjectAgent projectAgent) {
        for (ProjectView view : openProjectViews) {
            view.refresh();
            ArrayList<Object> elementsToExpand = new ArrayList<Object>();
            ServerConnection serverConnection = ProjectMgr.getProjectMgr().getServerConnectionByServerID(projectAgent.getServerID());
            elementsToExpand.add(serverConnection);
            elementsToExpand.add(projectAgent);
            elementsToExpand.addAll(Arrays.asList(view.getTreeViewer().getExpandedElements()));
            view.getTreeViewer().setExpandedElements(elementsToExpand.toArray());
            StructuredSelection sel = new StructuredSelection((Object)projectAgent);
            view.treeViewer.setSelection((ISelection)sel, true);
            CockpitSelectionManager.getSelectionService(view.getSite().getPage().getWorkbenchWindow().getSelectionService()).fireSelection((ICockpitProjectData)projectAgent, (IWorkbenchPart)view);
        }
    }

    private void expand(Object obj) {
        if (obj instanceof ISection) {
            ISection section = (ISection)obj;
            ProjectAgent projectAgent = ProjectMgr.getProjectMgr().getProjectAgent(section.getProjectUID());
            ISection containedSection = projectAgent.getFrameSectionManager().getSection(section.getUID());
            if (containedSection != null) {
                this.treeViewer.expandToLevel((Object)containedSection, 1);
            }
        } else if (obj instanceof IPlan) {
            IPlan plan = (IPlan)obj;
            IPlan containedPlan = this.currentProjectAgent.getFrameSectionManager().getPlan(plan.getUID());
            if (containedPlan != null) {
                this.treeViewer.expandToLevel((Object)containedPlan, 1);
            }
        } else if (obj instanceof IFrameProjectAgent) {
            this.treeViewer.expandToLevel(obj, 1);
        } else if (obj instanceof ModuleController) {
            this.treeViewer.expandToLevel(obj, 1);
        }
        this.refreshViewer();
    }

    private void collapse(Object obj) {
        if (obj instanceof ISection) {
            ISection section = (ISection)obj;
            ISection containedSection = this.currentProjectAgent.getFrameSectionManager().getSection(section.getUID());
            if (containedSection != null) {
                this.treeViewer.collapseToLevel((Object)containedSection, -1);
            }
        } else if (obj instanceof IFrameProjectAgent) {
            this.treeViewer.collapseToLevel(obj, -1);
        } else if (obj instanceof ModuleController) {
            this.treeViewer.collapseToLevel(obj, -1);
        }
        this.refreshViewer();
    }

    public void modelRefreshed(IPropertyChanges<?> changes, Class<?> clazz, String projectUID) {
        if (this.currentProjectAgent != null && this.currentProjectAgent.isOpened()) {
            Collection added = changes.getCreatedElements();
            Collection modified = changes.getModifiedElements();
            ArrayList allChildren = new ArrayList();
            if (added != null) {
                allChildren.addAll(added);
            }
            if (modified != null) {
                allChildren.addAll(modified);
            }
            if (this.additionalElementsToExpand == null) {
                this.additionalElementsToExpand = new HashSet<Object>();
            }
            for (Object o : allChildren) {
                if (!(o instanceof IAttributeOwner) && !(o instanceof IFrameProjectAgent)) continue;
                this.addParentsToBeExpanded(o, this.additionalElementsToExpand);
            }
        }
        this.refreshViewer();
    }

    private void addParentsToBeExpanded(Object elementToBeExpanded, Collection<Object> parentsToBeExpanded) {
        Object parent = this.projectTreeContentProvider.getParent(elementToBeExpanded);
        if (parent != null) {
            if (parent instanceof Project) {
                parent = ProjectMgr.getProjectMgr().getProjectAgent(((Project)parent).getProjectUID());
            }
            if (parentsToBeExpanded.add(parent)) {
                this.addParentsToBeExpanded(parent, parentsToBeExpanded);
            }
        }
    }

    public void selectionChanged(IWorkbenchPart part, ISelection newSelection) {
        if (part != null && part instanceof IEditorPart && newSelection != null && part != this && !newSelection.isEmpty() && newSelection instanceof IStructuredSelection) {
            IStructuredSelection sel = (IStructuredSelection)newSelection;
            ArrayList<Object> elementsToSelect = new ArrayList<Object>();
            for (Object o : sel) {
                ProjectAgent selectedProjectAgent;
                if (!(o instanceof ICockpitProjectData)) continue;
                ICockpitProjectData cpd = (ICockpitProjectData)o;
                if (cpd instanceof ISection || cpd instanceof IPlan) {
                    elementsToSelect.add(cpd);
                }
                if (this.currentProjectAgent == (selectedProjectAgent = ProjectMgr.getProjectMgr().getProjectAgent(cpd.getProjectUID()))) continue;
                this.setCurrentProjectAgent(selectedProjectAgent);
                if (this.shownInTree(this.treeViewer.getTree().getItems(), cpd)) continue;
                elementsToSelect.add(selectedProjectAgent);
            }
            if (!elementsToSelect.isEmpty()) {
                StructuredSelection selToSet = new StructuredSelection(elementsToSelect.iterator().next());
                this.treeViewer.setSelection((ISelection)selToSet);
            }
        }
    }

    private boolean shownInTree(TreeItem[] items, Object data) {
        TreeItem[] treeItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            if (item.getData() == data) {
                return true;
            }
            if (this.shownInTree(item.getItems(), data)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private void setCurrentProjectAgent(String projectUID) {
        ProjectAgent newProjectAgent = ProjectMgr.getProjectMgr().getProjectAgent(projectUID);
        if (newProjectAgent != null) {
            this.setCurrentProjectAgent(newProjectAgent);
        }
    }

    private void setCurrentProjectAgent(IFrameProjectAgent projectAgent) {
        assert (projectAgent != null);
        if (projectAgent != this.currentProjectAgent) {
            this.currentProjectAgent = projectAgent;
            this.updatePropertyChangeListeners(false);
        }
    }

    public Display getDisplay() {
        return this.getSite().getShell().getDisplay();
    }

    public void setFocus() {
        this.treeViewer.getTree().setFocus();
    }

    public void addedServer(ServerConnection serverConnection) {
        this.refreshViewer();
    }

    public void modifiedServer(ServerConnection serverConnection) {
        this.refreshViewer();
    }

    public void deletedServer(ServerConnection serverConnection) {
        this.refreshViewer();
    }

    public boolean serverAboutToBeDeleted(ServerConnection serverConnection) {
        return true;
    }

    public void login(ServerConnection serverConnection) {
        this.refreshViewer();
    }

    public void logoff(ServerConnection serverConnection) {
        this.refreshViewer();
    }

    public boolean isDisposed() {
        return this.treeViewer.getTree().isDisposed();
    }
}

