/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.global.gui.views.project;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAddedItem;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttribute;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeOwner;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeType;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeTypeID;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.ICockpitDataType;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IDeletedItem;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.ILocalModificationContainer;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IModifiedItem;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.ObjectTypeCategoryID;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.stakeholders.IStakeholder;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.stakeholders.IStakeholderRole;
import com.arcway.cockpit.frame.client.global.ExtensionMgr;
import com.arcway.cockpit.frame.client.global.FramePlugin;
import com.arcway.cockpit.frame.client.global.Icons;
import com.arcway.cockpit.frame.client.global.Messages;
import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.global.gui.views.linkview.ModuleLinkViewContribution;
import com.arcway.cockpit.frame.client.global.gui.views.project.RootEntry;
import com.arcway.cockpit.frame.client.global.license.licensetypes.ClientFunctionLicenseTypeShowReportTree;
import com.arcway.cockpit.frame.client.global.license.licensetypes.ClientFunctionLicenseTypeShowStakeholderTree;
import com.arcway.cockpit.frame.client.project.ICockpitProject;
import com.arcway.cockpit.frame.client.project.IFrameDataManager;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.IFrameSectionManager;
import com.arcway.cockpit.frame.client.project.IFrameStakeholderManager;
import com.arcway.cockpit.frame.client.project.IFrameUniqueElementManager;
import com.arcway.cockpit.frame.client.project.ModificationRootItem;
import com.arcway.cockpit.frame.client.project.ProjectAgent;
import com.arcway.cockpit.frame.client.project.core.categories.ObjectTypeCategoryIconProvider;
import com.arcway.cockpit.frame.client.project.core.constructionelements.IConstructionElementTypeDescription;
import com.arcway.cockpit.frame.client.project.core.framedata.AbstractFrameData;
import com.arcway.cockpit.frame.client.project.core.framedata.FrameDataTypes;
import com.arcway.cockpit.frame.client.project.core.reporttemplates.IReportTemplateFolderRW;
import com.arcway.cockpit.frame.client.project.core.sectionsandplans.plan.IPlan;
import com.arcway.cockpit.frame.client.project.core.sectionsandplans.sections.ISection;
import com.arcway.cockpit.frame.client.project.core.stakeholders.RoleList;
import com.arcway.cockpit.frame.client.project.core.stakeholders.StakeholderList;
import com.arcway.cockpit.frame.client.project.core.stakeholders.StakeholderManager;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.IUniqueElement;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.UniqueElementMgr;
import com.arcway.cockpit.frame.client.project.modifications.IChangedItemWithImageAndLabel;
import com.arcway.cockpit.frame.client.project.modules.ModuleController;
import com.arcway.cockpit.frame.client.project.offlinemode.OfflineProjectProperties;
import com.arcway.cockpit.frame.client.project.offlinemode.exceptions.EXOfflineDataNotAvailable;
import com.arcway.cockpit.frame.shared.message.FrameDataTypeIDs;
import com.arcway.cockpit.frame.shared.userdefinedattributes.ExInvalidAttributeType;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.lib.eclipse.gui.viewers.ICachedItem;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.planagent.controllinginterface.planagent.plugin.PlanAgentExtensionMgr;
import com.arcway.planagent.controllinginterface.planagent.plugin.PlanTypeDescription;
import de.plans.psc.client.communication.ServerConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;

public class ProjectTreeContentProvider
implements ITreeContentProvider,
ILabelProvider {
    private static final ILogger logger = Logger.getLogger(ProjectTreeContentProvider.class);
    private static final String KEY_UNKNOWN_ICON = "unknownIcon";
    public static final String KEY_SERVER_CONNECTED = "frame.serverconnected";
    public static final String KEY_SERVER_DISCONNECTED = "frame.serverdisconnected";
    private static final String KEY_SECTION = "frame.section";
    private static final String KEY_OPENED_PROJECT = "frame.openedproject";
    private static final String KEY_CLOSED_PROJECT = "frame.closedproject";
    private static final String KEY_OPENED_OFFLINE_PROJECT = "frame.openofflineproject";
    private static final String KEY_CLOSED_OFFLINE_PROJECT = "frame.closeofflineproject";
    private static final String KEY_UNIQUE_ELEMENT = "frame.uniqueelement";
    private static final String KEY_MODULE_DATA = "frame.moduledata";
    private static final String KEY_STAKEHOLDER_MGR = "frame.stakeholdermanager";
    private static final String KEY_STAKEHOLDER = "frame.stakeholder";
    private static final String KEY_STAKEHOLER_ROLE = "farme.stakeholderrole";
    private static final String KEY_ADDED_ITEMS = "frame.addedItem";
    private static final String KEY_MODIFIED_ITEMS = "frame.modifiedItems";
    private static final String KEY_DELETED_ITEMS = "frame.deletedItems";
    private static Map<String, Image> images;
    private final ModuleLinkViewContribution moduleLinkViewContribution;

    private static synchronized Map<String, Image> getImageCache() {
        if (images == null) {
            images = new HashMap<String, Image>(20, 0.5f);
            images.put(KEY_SECTION, Icons.getImageDescriptorForSection().createImage());
            images.put(KEY_OPENED_PROJECT, Icons.getImageDescriptorForProject("open").createImage());
            images.put(KEY_CLOSED_PROJECT, Icons.getImageDescriptorForProject("close").createImage());
            images.put(KEY_OPENED_OFFLINE_PROJECT, Icons.getImageDescriptorForProject("openoffline").createImage());
            images.put(KEY_CLOSED_OFFLINE_PROJECT, Icons.getImageDescriptorForProject("closeoffline").createImage());
            images.put(KEY_UNIQUE_ELEMENT, FramePlugin.getImageDescriptor("Unique-Element.gif").createImage());
            images.put(KEY_MODULE_DATA, FramePlugin.getImageDescriptor("ModuleData.gif").createImage());
            images.put(KEY_SERVER_CONNECTED, FramePlugin.getImageDescriptor("server_connected.gif").createImage());
            images.put(KEY_SERVER_DISCONNECTED, FramePlugin.getImageDescriptor("server_disconnected.gif").createImage());
            images.put(KEY_STAKEHOLER_ROLE, Icons.getImageDescriptorForStakeholderRole().createImage());
            images.put(KEY_STAKEHOLDER, Icons.getImageDescriptorForStakeholder().createImage());
            images.put(KEY_STAKEHOLDER_MGR, FramePlugin.getImageDescriptor("stakeholder.gif").createImage());
            images.put(KEY_ADDED_ITEMS, FramePlugin.getImageDescriptor("plus.gif").createImage());
            images.put(KEY_MODIFIED_ITEMS, FramePlugin.getImageDescriptor("editor_view.gif").createImage());
            images.put(KEY_DELETED_ITEMS, FramePlugin.getImageDescriptor("Delete.gif").createImage());
            images.put(KEY_UNKNOWN_ICON, Icons.getUnknownImageDescriptor().createImage());
            List planTypes = PlanAgentExtensionMgr.getDefault().getPlanTypeDescriptions();
            for (PlanTypeDescription planTypeDescription : planTypes) {
                images.put(planTypeDescription.getPlanTypeID(), Icons.getImageDescriptorForPlanType(planTypeDescription.getPlanTypeID()).createImage());
            }
            List<IConstructionElementTypeDescription> constructionElementTypes = ExtensionMgr.getDefault().getCurrentAndDeprecatedConstructionElementTypes();
            for (IConstructionElementTypeDescription td : constructionElementTypes) {
                Image image = ImageDescriptor.createFromURL((URL)td.getIconURL()).createImage();
                images.put(td.getConstructionElementTypeID(), image);
            }
        }
        return images;
    }

    public ProjectTreeContentProvider(ModuleLinkViewContribution moduleLinkViewContribution) {
        this.moduleLinkViewContribution = moduleLinkViewContribution;
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof ServerConnection) {
            ServerConnection server = (ServerConnection)parentElement;
            return ProjectMgr.getProjectMgr().getConfiguredProjectsOfServer(server.getServerID()).toArray();
        }
        if (parentElement instanceof IFrameProjectAgent) {
            IFrameProjectAgent projectAgent = (IFrameProjectAgent)parentElement;
            if (projectAgent.isOpened()) {
                boolean bl;
                boolean bl2;
                ISection rootSection = projectAgent.getFrameSectionManager().getRootSection();
                ArrayList<? extends IAttributeOwner> children = new ArrayList<IAttributeOwner>(projectAgent.getFrameSectionManager().getChildren((IAttributeOwner)rootSection));
                if (projectAgent.getServerLicenseManager().isLicenseOperationAllowed(ClientFunctionLicenseTypeShowStakeholderTree.getInstance())) {
                    children.add((IAttributeOwner)projectAgent.getFrameStakeholderManager());
                }
                if (projectAgent.getServerLicenseManager().isLicenseOperationAllowed(ClientFunctionLicenseTypeShowReportTree.getInstance())) {
                    Collection<? extends IAttributeOwner> collection = projectAgent.getProjectMetaDataManager().getChildren((IAttributeOwner)projectAgent.getProject());
                    for (ICockpitProjectData iCockpitProjectData : collection) {
                        if (!iCockpitProjectData.getTypeID().equals(FrameDataTypeIDs.DATA_TYPE_REPORT_TEMPLATE_FOLDER)) continue;
                        children.add((IAttributeOwner)iCockpitProjectData);
                    }
                }
                boolean bl3 = false;
                for (IFrameDataManager iFrameDataManager : projectAgent.getDataManagers()) {
                    ILocalModificationContainer[] modItems = iFrameDataManager.getLocalModifications(true);
                    if (modItems != null) {
                        ILocalModificationContainer[] iLocalModificationContainerArray = modItems;
                        int n = modItems.length;
                        int n2 = 0;
                        while (n2 < n) {
                            ILocalModificationContainer container = iLocalModificationContainerArray[n2];
                            if (!container.isEmpty()) {
                                bl2 = true;
                                break;
                            }
                            ++n2;
                        }
                    }
                    if (bl2) break;
                }
                if (!bl2 && projectAgent.getSequencerManager().getLocalModificationsForProjectView() != null) {
                    bl = true;
                }
                if (bl) {
                    children.add((IAttributeOwner)projectAgent.getModificationRootItem());
                }
                return children.toArray();
            }
            return null;
        }
        if (parentElement instanceof RootEntry) {
            ArrayList<ICockpitProjectData> children = new ArrayList<ICockpitProjectData>();
            RootEntry rootEntry = (RootEntry)parentElement;
            IFrameDataManager dataManager = rootEntry.getProjectAgent().getDataManager(rootEntry.getParent().getTypeID());
            for (ICockpitProjectData iCockpitProjectData : dataManager.getChildren(rootEntry.getParent())) {
                if (!iCockpitProjectData.getTypeID().equals(rootEntry.getDataTypeID())) continue;
                children.add(iCockpitProjectData);
            }
            return children.toArray();
        }
        if (parentElement instanceof ISection) {
            ISection section = (ISection)parentElement;
            ProjectAgent projectAgent = ProjectMgr.getProjectMgr().getProjectAgent(section.getProjectUID());
            return projectAgent.getFrameSectionManager().getChildren((IAttributeOwner)section).toArray();
        }
        if (parentElement instanceof IPlan) {
            return null;
        }
        if (parentElement instanceof ModificationRootItem) {
            ModificationRootItem rootItem = (ModificationRootItem)parentElement;
            ArrayList<ILocalModificationContainer> modificationEntries = new ArrayList<ILocalModificationContainer>();
            List<IFrameDataManager> dataManagers = rootItem.getProjectAgent().getDataManagers();
            for (IFrameDataManager iFrameDataManager : dataManagers) {
                ILocalModificationContainer[] modItems = iFrameDataManager.getLocalModifications(true);
                if (modItems == null) continue;
                int nr = 0;
                while (nr < modItems.length) {
                    if (!modItems[nr].isEmpty()) {
                        modificationEntries.add(modItems[nr]);
                    }
                    ++nr;
                }
            }
            ILocalModificationContainer iLocalModificationContainer = rootItem.getProjectAgent().getSequencerManager().getLocalModificationsForProjectView();
            if (iLocalModificationContainer != null) {
                modificationEntries.add(iLocalModificationContainer);
            }
            return modificationEntries.toArray();
        }
        if (parentElement instanceof ILocalModificationContainer) {
            IDeletedItem[] iDeletedItemArray;
            IModifiedItem[] iModifiedItemArray;
            ILocalModificationContainer item = (ILocalModificationContainer)parentElement;
            int nr = 0;
            IAddedItem[] added = item.getAddedItems();
            if (added != null && added.length > 0) {
                ++nr;
            }
            if ((iModifiedItemArray = item.getModifiedItems()) != null && iModifiedItemArray.length > 0) {
                ++nr;
            }
            if ((iDeletedItemArray = item.getDeletedItems()) != null && iDeletedItemArray.length > 0) {
                ++nr;
            }
            Object[] children = new Object[nr];
            nr = 0;
            if (added != null && added.length > 0) {
                children[nr++] = added;
            }
            if (iModifiedItemArray != null && iModifiedItemArray.length > 0) {
                children[nr++] = iModifiedItemArray;
            }
            if (iDeletedItemArray != null && iDeletedItemArray.length > 0) {
                children[nr++] = iDeletedItemArray;
            }
            return children;
        }
        if (parentElement instanceof IAddedItem[]) {
            Object[] items = (IAddedItem[])parentElement;
            return items;
        }
        if (parentElement instanceof IModifiedItem[]) {
            return (IModifiedItem[])parentElement;
        }
        if (parentElement instanceof IDeletedItem[]) {
            return (IDeletedItem[])parentElement;
        }
        if (parentElement instanceof IFrameStakeholderManager) {
            IFrameStakeholderManager stakeholderMgr = (IFrameStakeholderManager)parentElement;
            StakeholderList stakeholderList = stakeholderMgr.getStakeholderList();
            RoleList roleList = stakeholderMgr.getRoleList();
            Object[] objectArray = new Object[]{stakeholderList, roleList};
            return objectArray;
        }
        if (parentElement instanceof StakeholderList) {
            StakeholderList list = (StakeholderList)parentElement;
            return list.getStakeholders();
        }
        if (parentElement instanceof RoleList) {
            RoleList list = (RoleList)parentElement;
            return list.getRoles();
        }
        if (parentElement instanceof IStakeholderRole && !(parentElement instanceof Stakeholder_RelationContribution)) {
            IStakeholderRole role = (IStakeholderRole)parentElement;
            ProjectAgent projectAgent = ProjectMgr.getProjectMgr().getProjectAgent(role.getProjectUID());
            Collection<IStakeholder> stakeholders = projectAgent.getFrameStakeholderManager().getStakeholdersOfRole(role);
            Object[] objectArray = new Stakeholder_RelationContribution[stakeholders.size()];
            boolean bl = false;
            for (IStakeholder stakeholder : stakeholders) {
                objectArray[++var6_60] = new Stakeholder_RelationContribution(stakeholder);
            }
            return objectArray;
        }
        if (parentElement instanceof IStakeholder && !(parentElement instanceof Stakeholder_RelationContribution)) {
            IStakeholder stakeholder = (IStakeholder)parentElement;
            ProjectAgent projectAgent = ProjectMgr.getProjectMgr().getProjectAgent(stakeholder.getProjectUID());
            Collection roles = projectAgent.getFrameStakeholderManager().getRolesOfStakeholder(stakeholder);
            Object[] objectArray = new StakeholderRole_RelationContribution[roles.size()];
            boolean bl = false;
            for (IStakeholderRole role : roles) {
                objectArray[++var6_62] = new StakeholderRole_RelationContribution(role);
            }
            return objectArray;
        }
        if (parentElement instanceof IReportTemplateFolderRW) {
            ArrayList<ICockpitProjectData> children = new ArrayList<ICockpitProjectData>();
            IReportTemplateFolderRW reportTemplateFolder = (IReportTemplateFolderRW)parentElement;
            ProjectAgent projectAgent = ProjectMgr.getProjectMgr().getProjectAgent(reportTemplateFolder.getProjectUID());
            IFrameDataManager iFrameDataManager = projectAgent.getDataManager(reportTemplateFolder.getTypeID());
            for (ICockpitProjectData iCockpitProjectData : iFrameDataManager.getChildren(reportTemplateFolder)) {
                if (!iCockpitProjectData.getTypeID().equals(FrameDataTypeIDs.DATA_TYPE_REPORT_TEMPLATE) && !iCockpitProjectData.getTypeID().equals(FrameDataTypeIDs.DATA_TYPE_REPORT_TEMPLATE_FOLDER)) continue;
                children.add(iCockpitProjectData);
            }
            children.add(new RootEntry(FrameDataTypeIDs.DATA_TYPE_REPORT_OUTPUT_TEMPLATE, reportTemplateFolder, FrameDataTypes.getDataType(FrameDataTypeIDs.DATA_TYPE_REPORT_OUTPUT_TEMPLATE).getIcon(), Messages.getString("ProjectTreeContentProvider.outputtemplates"), projectAgent));
            return children.toArray();
        }
        if (parentElement instanceof IAttributeOwner) {
            IAttributeOwner attributeOwner = (IAttributeOwner)parentElement;
            ProjectAgent projectAgent = ProjectMgr.getProjectMgr().getProjectAgent(attributeOwner.getProjectUID());
            IFrameDataManager dataManager = projectAgent.getDataManager(attributeOwner.getTypeID());
            if (dataManager != null) {
                return dataManager.getChildren(attributeOwner).toArray();
            }
        }
        return null;
    }

    public Object getParent(Object element) {
        ProjectAgent projectAgent;
        if (element instanceof IFrameProjectAgent) {
            IFrameProjectAgent projectAgent2 = (IFrameProjectAgent)element;
            return ProjectMgr.getProjectMgr().getServerConnection(projectAgent2.getServerID());
        }
        if (element instanceof ModificationRootItem) {
            ModificationRootItem item = (ModificationRootItem)element;
            return item.getProjectAgent();
        }
        if (element instanceof RootEntry) {
            RootEntry rootEntry = (RootEntry)element;
            return rootEntry.getProjectAgent().getProjectMetaDataManager().getProject();
        }
        if (element instanceof ISection) {
            ISection section = (ISection)element;
            projectAgent = ProjectMgr.getProjectMgr().getProjectAgent(section.getProjectUID());
            if (projectAgent != null && projectAgent.isOpened()) {
                if (section.isRootSection()) {
                    return projectAgent;
                }
                return projectAgent.getFrameSectionManager().getParent((IAttributeOwner)section);
            }
        }
        if (element instanceof IPlan) {
            IPlan plan = (IPlan)element;
            projectAgent = ProjectMgr.getProjectMgr().getProjectAgent(plan.getProjectUID());
            if (projectAgent != null && projectAgent.isOpened()) {
                return projectAgent.getFrameSectionManager().getParentSection(plan);
            }
        }
        if (element instanceof IFrameUniqueElementManager) {
            IFrameUniqueElementManager ueMgr = (IFrameUniqueElementManager)element;
            return ueMgr.getFrameProjectAgent().getModificationRootItem();
        }
        if (element instanceof IFrameStakeholderManager) {
            IFrameStakeholderManager stakeholderMgr = (IFrameStakeholderManager)element;
            return stakeholderMgr.getFrameProjectAgent().getModificationRootItem();
        }
        if (element instanceof IReportTemplateFolderRW) {
            IAttributeOwner parent;
            IReportTemplateFolderRW templateFolder = (IReportTemplateFolderRW)element;
            projectAgent = ProjectMgr.getProjectMgr().getProjectAgent(templateFolder.getProjectUID());
            if (projectAgent != null && projectAgent.isOpened() && (parent = projectAgent.getDataManager(templateFolder.getTypeID()).getParent(templateFolder)) instanceof ICockpitProject) {
                return new RootEntry(FrameDataTypeIDs.DATA_TYPE_REPORT_TEMPLATE_FOLDER, projectAgent.getProjectMetaDataManager().getProject(), Icons.getImageForReportTemplates(), Messages.getString("ProjectTreeContentProvider.report_templates"), projectAgent);
            }
        }
        if (element instanceof IAttributeOwner) {
            IAttributeOwner attributeOwner = (IAttributeOwner)element;
            projectAgent = ProjectMgr.getProjectMgr().getProjectAgent(attributeOwner.getProjectUID());
            if (projectAgent != null && projectAgent.isOpened()) {
                IFrameDataManager dataManager = projectAgent.getDataManager(attributeOwner.getTypeID());
                return dataManager.getParent(attributeOwner);
            }
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        ProjectAgent projectAgent;
        Object list;
        ModuleController moduleCtrl;
        if (element instanceof ServerConnection) {
            ServerConnection server = (ServerConnection)element;
            return !ProjectMgr.getProjectMgr().getConfiguredProjectsOfServer(server.getServerID()).isEmpty();
        }
        if (element instanceof IFrameProjectAgent) {
            IFrameProjectAgent projectAgent2 = (IFrameProjectAgent)element;
            if (projectAgent2.isOpened()) {
                ISection rootSection = projectAgent2.getFrameSectionManager().getRootSection();
                if (rootSection != null) {
                    return true;
                }
            } else {
                return false;
            }
        }
        if (element instanceof ISection) {
            ISection section = (ISection)element;
            IFrameSectionManager sectionManager = ProjectMgr.getProjectMgr().getProjectAgent(section.getProjectUID()).getFrameSectionManager();
            boolean hasChildren = !sectionManager.getChildSections(section).isEmpty() || !sectionManager.getChildPlans(section).isEmpty();
            return hasChildren;
        }
        if (element instanceof IPlan) {
            return false;
        }
        if (element instanceof ModificationRootItem) {
            return true;
        }
        if (element instanceof ILocalModificationContainer) {
            ILocalModificationContainer item = (ILocalModificationContainer)element;
            return !item.isEmpty();
        }
        if (element instanceof Object[]) {
            return true;
        }
        if (element instanceof ModuleController && (moduleCtrl = (ModuleController)element).hasLocalModifications()) {
            return true;
        }
        if (element instanceof IFrameStakeholderManager) {
            IFrameStakeholderManager mgr = (IFrameStakeholderManager)element;
            return !mgr.getRoles().isEmpty() || !mgr.getStakeholders().isEmpty();
        }
        if (element instanceof StakeholderList) {
            list = (StakeholderList)element;
            return ((StakeholderList)list).containsStakeholders();
        }
        if (element instanceof RoleList) {
            list = (RoleList)element;
            return ((RoleList)list).containsRoles();
        }
        if (element instanceof IStakeholderRole && !(element instanceof StakeholderRole_RelationContribution)) {
            IStakeholderRole role = (IStakeholderRole)element;
            projectAgent = ProjectMgr.getProjectMgr().getProjectAgent(role.getProjectUID());
            return !projectAgent.getFrameStakeholderManager().getStakeholdersOfRole(role).isEmpty();
        }
        if (element instanceof IStakeholder && !(element instanceof Stakeholder_RelationContribution)) {
            IStakeholder stakeholder = (IStakeholder)element;
            projectAgent = ProjectMgr.getProjectMgr().getProjectAgent(stakeholder.getProjectUID());
            return !projectAgent.getFrameStakeholderManager().getRolesOfStakeholder(stakeholder).isEmpty();
        }
        if (element instanceof RootEntry) {
            RootEntry rootEntry = (RootEntry)element;
            IFrameDataManager dataManager = rootEntry.getProjectAgent().getDataManager(rootEntry.getParent().getTypeID());
            Collection<? extends IAttributeOwner> children = dataManager.getChildren(rootEntry.getParent());
            for (ICockpitProjectData iCockpitProjectData : children) {
                if (!iCockpitProjectData.getTypeID().equals(rootEntry.getDataTypeID())) continue;
                return true;
            }
            return false;
        }
        if (element instanceof IReportTemplateFolderRW) {
            return true;
        }
        if (element instanceof IAttributeOwner) {
            IAttributeOwner attributeOwner = (IAttributeOwner)element;
            projectAgent = ProjectMgr.getProjectMgr().getProjectAgent(attributeOwner.getProjectUID());
            IFrameDataManager dataManager = projectAgent.getDataManager(attributeOwner.getTypeID());
            if (dataManager != null) {
                return !dataManager.getChildren(attributeOwner).isEmpty();
            }
        }
        return false;
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof ProjectMgr) {
            return ProjectMgr.getProjectMgr().getConfiguredServerConnections().toArray();
        }
        if (inputElement instanceof Collection) {
            Collection parents = (Collection)inputElement;
            ArrayList<Object> children = new ArrayList<Object>();
            Iterator i = parents.iterator();
            while (i.hasNext()) {
                Object[] directChildren = this.getChildren(i.next());
                if (directChildren == null) continue;
                children.addAll(Arrays.asList(directChildren));
            }
            return children.toArray();
        }
        return this.getChildren(inputElement);
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public Image getImage(Object element) {
        return ProjectTreeContentProvider.getImage_static(element, this.moduleLinkViewContribution);
    }

    public static Image getImage_static(Object element, ModuleLinkViewContribution moduleLinkViewContribution) {
        Image image = ProjectTreeContentProvider.getImage_staticGeneral(element, moduleLinkViewContribution);
        if (image != null) {
            return image;
        }
        if (element != null) {
            logger.error("invalid entry in project view of type " + element.getClass());
        }
        return null;
    }

    public static Image getImage_staticGeneral(Object element, ModuleLinkViewContribution moduleLinkViewContribution) {
        IFrameDataManager dataManager;
        Object projectAgent;
        if (element instanceof AbstractFrameData) {
            AbstractFrameData abstractFrameData = (AbstractFrameData)element;
            Image categoryIconImage = ObjectTypeCategoryIconProvider.getDefault().getObjectTypeCategoryIcon(abstractFrameData.getProjectUID(), abstractFrameData.getCategoryID());
            if (categoryIconImage != null) {
                return categoryIconImage;
            }
        }
        if (element instanceof ServerConnection) {
            ServerConnection serverConnection = (ServerConnection)element;
            if (serverConnection.isConnected()) {
                return ProjectTreeContentProvider.getImage(KEY_SERVER_CONNECTED);
            }
            return ProjectTreeContentProvider.getImage(KEY_SERVER_DISCONNECTED);
        }
        if (element instanceof ProjectAgent) {
            ProjectAgent projectAgent2 = (ProjectAgent)element;
            Image image = projectAgent2.getOfflineModeManager().isInOfflineMode() ? (projectAgent2.isOpened() ? ProjectTreeContentProvider.getImage(KEY_OPENED_OFFLINE_PROJECT) : ProjectTreeContentProvider.getImage(KEY_CLOSED_OFFLINE_PROJECT)) : (projectAgent2.isOpened() ? ProjectTreeContentProvider.getImage(KEY_OPENED_PROJECT) : ProjectTreeContentProvider.getImage(KEY_CLOSED_PROJECT));
            return image;
        }
        if (element instanceof IReportTemplateFolderRW) {
            IReportTemplateFolderRW iReportTemplateFolderRW = (IReportTemplateFolderRW)element;
            projectAgent = ProjectMgr.getProjectMgr().getProjectAgent(iReportTemplateFolderRW.getProjectUID());
            dataManager = projectAgent.getDataManager(iReportTemplateFolderRW.getTypeID());
            IAttributeOwner parent = dataManager.getParent(iReportTemplateFolderRW);
            if (parent != null && parent.equals(projectAgent.getProject())) {
                return Icons.getImageForReportTemplates();
            }
        }
        if (element instanceof ISection) {
            return ProjectTreeContentProvider.getImage(KEY_SECTION);
        }
        if (element instanceof IPlan) {
            IPlan iPlan = (IPlan)element;
            return ProjectTreeContentProvider.getImage(iPlan.getPlantypeUID());
        }
        if (element instanceof IUniqueElement) {
            IUniqueElement iUniqueElement = (IUniqueElement)element;
            return ProjectTreeContentProvider.getImage(iUniqueElement.getElementTypeID());
        }
        if (element instanceof ModuleController) {
            return ProjectTreeContentProvider.getImage(KEY_MODULE_DATA);
        }
        if (element instanceof ModificationRootItem) {
            return ProjectTreeContentProvider.getImage(KEY_MODULE_DATA);
        }
        if (element instanceof RootEntry) {
            RootEntry rootEntry = (RootEntry)element;
            return rootEntry.getImage();
        }
        if (element instanceof ILocalModificationContainer) {
            ILocalModificationContainer iLocalModificationContainer = (ILocalModificationContainer)element;
            return iLocalModificationContainer.getGeneralImage();
        }
        if (element instanceof UniqueElementMgr) {
            return ProjectTreeContentProvider.getImage(KEY_UNIQUE_ELEMENT);
        }
        if (element instanceof StakeholderManager) {
            return ProjectTreeContentProvider.getImage(KEY_STAKEHOLDER_MGR);
        }
        if (element instanceof IStakeholderRole || element instanceof RoleList) {
            return ProjectTreeContentProvider.getImage(KEY_STAKEHOLER_ROLE);
        }
        if (element instanceof IStakeholder || element instanceof StakeholderList) {
            return ProjectTreeContentProvider.getImage(KEY_STAKEHOLDER);
        }
        if (element instanceof IAddedItem[]) {
            return ProjectTreeContentProvider.getImage(KEY_ADDED_ITEMS);
        }
        if (element instanceof IModifiedItem[]) {
            return ProjectTreeContentProvider.getImage(KEY_MODIFIED_ITEMS);
        }
        if (element instanceof IDeletedItem[]) {
            return ProjectTreeContentProvider.getImage(KEY_DELETED_ITEMS);
        }
        if (element instanceof IAddedItem) {
            if (element instanceof IChangedItemWithImageAndLabel) {
                IChangedItemWithImageAndLabel iChangedItemWithImageAndLabel = (IChangedItemWithImageAndLabel)element;
                return iChangedItemWithImageAndLabel.getImage();
            }
            IAddedItem iAddedItem = (IAddedItem)element;
            return ProjectTreeContentProvider.getImage_static(iAddedItem.getData(), moduleLinkViewContribution);
        }
        if (element instanceof IModifiedItem) {
            if (element instanceof IChangedItemWithImageAndLabel) {
                IChangedItemWithImageAndLabel iChangedItemWithImageAndLabel = (IChangedItemWithImageAndLabel)element;
                return iChangedItemWithImageAndLabel.getImage();
            }
            IModifiedItem iModifiedItem = (IModifiedItem)element;
            return ProjectTreeContentProvider.getImage_static(iModifiedItem.getData(), moduleLinkViewContribution);
        }
        if (element instanceof IDeletedItem) {
            if (element instanceof IChangedItemWithImageAndLabel) {
                IChangedItemWithImageAndLabel iChangedItemWithImageAndLabel = (IChangedItemWithImageAndLabel)element;
                return iChangedItemWithImageAndLabel.getImage();
            }
            IDeletedItem iDeletedItem = (IDeletedItem)element;
            return ProjectTreeContentProvider.getImage_static(iDeletedItem.getData(), moduleLinkViewContribution);
        }
        if (moduleLinkViewContribution != null) {
            for (ILabelProvider iLabelProvider : moduleLinkViewContribution.getModuleLabelProviders()) {
                Image image = iLabelProvider.getImage(element);
                if (image == null) continue;
                return image;
            }
        }
        if (element instanceof ICockpitProjectData) {
            ICockpitProjectData iCockpitProjectData = (ICockpitProjectData)element;
            projectAgent = ProjectMgr.getProjectMgr().getProjectAgent(iCockpitProjectData.getProjectUID());
            dataManager = projectAgent.getDataManager(iCockpitProjectData.getTypeID());
            if (dataManager != null) {
                return dataManager.getDataLabelProvider().getImage((Object)iCockpitProjectData);
            }
        }
        if (element instanceof IAttributeType) {
            return Icons.getImageForUserDefinedAttributeTypes();
        }
        return null;
    }

    public static Image getImage(String key) {
        Image image = ProjectTreeContentProvider.getImageCache().get(key);
        if (image == null) {
            image = ProjectTreeContentProvider.getImageCache().get(KEY_UNKNOWN_ICON);
        }
        return image;
    }

    public String getText(Object element) {
        Object list;
        IAttributeOwner data;
        IFrameDataManager dataManager;
        String text = "";
        IFrameProjectAgent projectAgent = null;
        if (element instanceof IReportTemplateFolderRW) {
            IReportTemplateFolderRW reportTemplateFolder = (IReportTemplateFolderRW)element;
            projectAgent = ProjectMgr.getProjectMgr().getProjectAgent(reportTemplateFolder.getProjectUID());
            dataManager = projectAgent.getDataManager(reportTemplateFolder.getTypeID());
            IAttributeOwner parent = dataManager.getParent(reportTemplateFolder);
            if (parent != null && parent.equals(projectAgent.getProject())) {
                return Messages.getString("ProjectTreeContentProvider.report_templates");
            }
        }
        if (element instanceof ServerConnection) {
            ServerConnection server = (ServerConnection)element;
            String serverName = server.getServerName();
            if (server.isConnected()) {
                String username = server.getUserData().getUser().getDisplayName();
                serverName = String.valueOf(serverName) + " (" + Messages.getString("ProjectTreeLabelProvider.(connected)_9") + " " + username + ")";
            }
            text = serverName;
        } else if (element instanceof IFrameProjectAgent) {
            projectAgent = (IFrameProjectAgent)element;
            String projectName = projectAgent.getProjectName();
            if (projectAgent.getOfflineModeManager().isInOfflineMode()) {
                try {
                    OfflineProjectProperties offlineProjectProperties = projectAgent.getOfflineModeManager().getOfflineProjectProperties();
                    String user = offlineProjectProperties.getUserName();
                    projectName = String.valueOf(projectName) + NLS.bind((String)Messages.getString("ProjectTreeLabelProvider.OfflineAsUser"), (Object)user);
                }
                catch (EXOfflineDataNotAvailable e) {
                    logger.error("Cannot access offline project properties to show offline user.", (Throwable)e);
                }
            }
            text = projectName;
        } else if (element instanceof RootEntry) {
            RootEntry rootEntry = (RootEntry)element;
            text = rootEntry.getLabel();
            projectAgent = rootEntry.getProjectAgent();
        } else if (element instanceof IAttributeOwner) {
            data = (IAttributeOwner)element;
            projectAgent = ProjectMgr.getProjectMgr().getProjectAgent(data.getProjectUID());
            ICockpitDataType dataType = FrameDataTypes.getDataType(data.getTypeID());
            if (dataType != null) {
                text = dataType.getDisplayName((ICockpitProjectData)data);
            }
        } else if (element instanceof IAttributeType) {
            IAttributeType attributeType = (IAttributeType)element;
            text = attributeType.getDisplayName();
        } else if (element instanceof ModuleController) {
            ModuleController moduleCtrl = (ModuleController)element;
            boolean ueChanges = moduleCtrl.getProjectAgent().getModuleUniqueElementManager().hasLocalModifications();
            if (moduleCtrl.hasLocalModifications() || ueChanges) {
                text = Messages.getString("ProjectTreeLabelProvider.>Project_Modifications_13");
            }
            text = Messages.getString("ProjectTreeLabelProvider.Project_Modifications_14");
        } else if (element instanceof ModificationRootItem) {
            text = Messages.getString("ProjectTreeLabelProvider.Project_Modifications_14");
        } else if (element instanceof IAddedItem[]) {
            text = Messages.getString("ProjectTreeContentProvider.added");
        } else if (element instanceof IModifiedItem[]) {
            text = Messages.getString("ProjectTreeContentProvider.modified");
        } else if (element instanceof IDeletedItem[]) {
            text = Messages.getString("ProjectTreeContentProvider.deleted");
        } else if (element instanceof IAddedItem) {
            IChangedItemWithImageAndLabel addedItem;
            if (element instanceof IChangedItemWithImageAndLabel) {
                addedItem = (IChangedItemWithImageAndLabel)element;
                return addedItem.getText();
            }
            addedItem = (IAddedItem)element;
            text = this.getText(addedItem.getData());
        } else if (element instanceof IModifiedItem) {
            IChangedItemWithImageAndLabel modifiedItem;
            if (element instanceof IChangedItemWithImageAndLabel) {
                modifiedItem = (IChangedItemWithImageAndLabel)element;
                return modifiedItem.getText();
            }
            modifiedItem = (IModifiedItem)element;
            text = this.getText(modifiedItem.getData());
        } else if (element instanceof IDeletedItem) {
            IChangedItemWithImageAndLabel deletedItem;
            if (element instanceof IChangedItemWithImageAndLabel) {
                deletedItem = (IChangedItemWithImageAndLabel)element;
                return deletedItem.getText();
            }
            deletedItem = (IDeletedItem)element;
            text = this.getText(deletedItem.getData());
        } else if (element instanceof ILocalModificationContainer) {
            ILocalModificationContainer item = (ILocalModificationContainer)element;
            text = item.getGeneralDescription();
        } else if (element instanceof UniqueElementMgr) {
            UniqueElementMgr ueMgr = (UniqueElementMgr)element;
            text = Messages.getString("ProjectTreeLabelProvider.Unique_Elements_17");
            projectAgent = ueMgr.getFrameProjectAgent();
        } else if (element instanceof StakeholderManager) {
            StakeholderManager mgr = (StakeholderManager)element;
            text = Messages.getString("ProjectTreeLabelProvider.Stakeholders_2");
            projectAgent = mgr.getFrameProjectAgent();
        } else if (element instanceof StakeholderList) {
            list = (StakeholderList)element;
            text = Messages.getString("ProjectTreeContentProvider.stakeholders");
            projectAgent = ProjectMgr.getProjectMgr().getProjectAgent(((StakeholderList)list).getProjectUID());
        } else if (element instanceof RoleList) {
            list = (RoleList)element;
            text = Messages.getString("ProjectTreeContentProvider.roles");
            projectAgent = ProjectMgr.getProjectMgr().getProjectAgent(((RoleList)list).getProjectUID());
        } else if (element instanceof ICockpitProjectData) {
            data = (ICockpitProjectData)element;
            projectAgent = ProjectMgr.getProjectMgr().getProjectAgent(data.getProjectUID());
            dataManager = projectAgent.getDataManager(data.getTypeID());
            if (dataManager != null) {
                text = dataManager.getDataLabelProvider().getText((Object)data);
            }
        } else {
            text = Messages.getString("ProjectTreeLabelProvider.ERROR_!_18");
        }
        return text;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    static class StakeholderRole_RelationContribution
    implements IStakeholderRole,
    ICachedItem {
        private final IStakeholderRole role;

        StakeholderRole_RelationContribution(IStakeholderRole role) {
            this.role = role;
        }

        public String getName() {
            return this.role.getName();
        }

        public String getDescription() {
            return this.role.getDescription();
        }

        public String getProjectUID() {
            return this.role.getProjectUID();
        }

        public String getTypeID() {
            return this.role.getTypeID();
        }

        public String getUID() {
            return this.role.getUID();
        }

        public String getPermissionOwnerID() {
            return this.role.getPermissionOwnerID();
        }

        public int getPermissionOwnerType() {
            return this.role.getPermissionOwnerType();
        }

        public String getPermissionOwnerName() {
            return this.role.getPermissionOwnerName();
        }

        public Collection<IAttribute> getAllAttributes() {
            return this.role.getAllAttributes();
        }

        public IAttribute getAttribute(IAttributeTypeID attributeTypeID) throws ExInvalidAttributeType {
            return this.role.getAttribute(attributeTypeID);
        }

        public IAttributeType getAttributeType(IAttributeTypeID attributeTypeID) throws ExInvalidAttributeType {
            return this.role.getAttributeType(attributeTypeID);
        }

        public IAttributeType getAttributeTypeByHumanreadableID(String humanreadableID) {
            return this.role.getAttributeTypeByHumanreadableID(humanreadableID);
        }

        public ObjectTypeCategoryID getCategoryID() {
            return this.role.getCategoryID();
        }

        public int getModificationCount() {
            return this.role.getModificationCount();
        }

        public int getCommitCount() {
            return this.role.getCommitCount();
        }

        public boolean testAttribute(Object target, String name, String value) {
            return false;
        }

        public String getIconID() {
            ObjectTypeCategoryID categoryID = this.getCategoryID();
            String categoryIDAsString = categoryID == null ? null : categoryID.getUID();
            return categoryIDAsString;
        }
    }

    static class Stakeholder_RelationContribution
    implements IStakeholder,
    ICachedItem {
        private final IStakeholder stakeholder;

        Stakeholder_RelationContribution(IStakeholder stakeholder) {
            this.stakeholder = stakeholder;
        }

        public String getStakeholderName() {
            return this.stakeholder.getStakeholderName();
        }

        public String getStakeholderDescription() {
            return this.stakeholder.getStakeholderDescription();
        }

        public String getStakeholderAddress() {
            return this.stakeholder.getStakeholderAddress();
        }

        public String getStakeholderCompany() {
            return this.stakeholder.getStakeholderCompany();
        }

        public String getStakeholderEMail() {
            return this.stakeholder.getStakeholderEMail();
        }

        public String getStakeholderFax() {
            return this.stakeholder.getStakeholderFax();
        }

        public String getStakeholderTelephone() {
            return this.stakeholder.getStakeholderTelephone();
        }

        public String getUsername() {
            return this.stakeholder.getUsername();
        }

        public String getProjectUID() {
            return this.stakeholder.getProjectUID();
        }

        public String getTypeID() {
            return this.stakeholder.getTypeID();
        }

        public String getUID() {
            return this.stakeholder.getUID();
        }

        public Collection<IAttribute> getAllAttributes() {
            return this.stakeholder.getAllAttributes();
        }

        public IAttribute getAttribute(IAttributeTypeID attributeTypeID) throws ExInvalidAttributeType {
            return this.stakeholder.getAttribute(attributeTypeID);
        }

        public IAttributeType getAttributeType(IAttributeTypeID attributeTypeID) throws ExInvalidAttributeType {
            return this.stakeholder.getAttributeType(attributeTypeID);
        }

        public IAttributeType getAttributeTypeByHumanreadableID(String humanreadableID) {
            return this.stakeholder.getAttributeTypeByHumanreadableID(humanreadableID);
        }

        public ObjectTypeCategoryID getCategoryID() {
            return this.stakeholder.getCategoryID();
        }

        public int getModificationCount() {
            return this.stakeholder.getModificationCount();
        }

        public int getCommitCount() {
            return this.stakeholder.getCommitCount();
        }

        public boolean testAttribute(Object target, String name, String value) {
            return false;
        }

        public String getIconID() {
            ObjectTypeCategoryID categoryID = this.getCategoryID();
            String categoryIDAsString = categoryID == null ? null : categoryID.getUID();
            return categoryIDAsString;
        }
    }
}

