/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.global.gui.views.project;

import com.arcway.cockpit.frame.client.global.FramePlugin;
import com.arcway.cockpit.frame.client.global.Messages;
import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.global.ServerPermissionChecker;
import com.arcway.cockpit.frame.client.global.gui.dnd.IFileDropListener;
import com.arcway.cockpit.frame.client.global.gui.views.project.CreateProjectFromFileHelper;
import com.arcway.cockpit.frame.client.global.gui.views.project.IPasteListener;
import com.arcway.cockpit.frame.client.global.gui.wizards.newproject.CreateNewProjectWizard;
import com.arcway.cockpit.frame.client.global.license.IClientFunctionLicense;
import com.arcway.cockpit.frame.client.global.license.licensetypes.ClientFunctionLicenseTypeProjectsCreate;
import com.arcway.cockpit.frame.client.global.license.licensetypes.ClientFunctionLicenseTypeProjectsLoad;
import com.arcway.cockpit.frame.client.global.license.licensetypes.ClientFunctionLicenseTypeProjectsNumber;
import com.arcway.cockpit.frame.client.project.Project;
import com.arcway.cockpit.frame.client.project.core.serverproxy.IProjectManagerServerProxy;
import com.arcway.cockpit.frame.client.project.datainterchange.ProjectFileAccess;
import com.arcway.cockpit.frame.client.project.datainterchange.ProjectFileFormatVersionIncompatibleException;
import com.arcway.cockpit.frame.shared.message.EOProject;
import com.arcway.lib.eclipse.gui.EclipseSWTHelper;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.resource.IStreamResource;
import de.plans.lib.util.FileHelper;
import de.plans.psc.client.communication.ServerConnection;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;

public class ProjectTemplateFileDropListener
implements IFileDropListener,
IPasteListener {
    private static final ILogger logger = Logger.getLogger(ProjectTemplateFileDropListener.class);
    private final IWorkbenchWindow workbenchWindow;

    public ProjectTemplateFileDropListener(IWorkbenchWindow workbenchPage) {
        this.workbenchWindow = workbenchPage;
    }

    @Override
    public boolean supportsDropOnTarget(Object target) {
        if (target instanceof ServerConnection) {
            ServerConnection serverConnection = (ServerConnection)target;
            return serverConnection.isConnected();
        }
        return false;
    }

    @Override
    public boolean fileDropped(File file, Object target) {
        boolean success = false;
        if (this.supportsDropOnTarget(target)) {
            ServerConnection serverConnection = (ServerConnection)target;
            IProjectManagerServerProxy serverProxy = ProjectMgr.getProjectMgr().getProjectManagerServerProxy(serverConnection.getServerID());
            int nrOfProjects = ProjectMgr.getProjectMgr().getConfiguredProjects().length;
            int maxProjects = 0;
            maxProjects = ClientFunctionLicenseTypeProjectsNumber.getMaxNumberOfProjects(serverProxy.getFunctionLicenseManager());
            IClientFunctionLicense createProjectLicense = serverProxy.getFunctionLicenseManager().findClientFunctionLicense(ClientFunctionLicenseTypeProjectsCreate.getInstance());
            IClientFunctionLicense loadProjectLicense = serverProxy.getFunctionLicenseManager().findClientFunctionLicense(ClientFunctionLicenseTypeProjectsLoad.getInstance());
            if (maxProjects < 0 || maxProjects > nrOfProjects) {
                String fileType = FileHelper.getFileType((File)file);
                if ((createProjectLicense == null || createProjectLicense.getValue().equals(Boolean.FALSE)) && loadProjectLicense != null && loadProjectLicense.getValue().equals(Boolean.TRUE)) {
                    if (serverProxy.canReaderCreateProjectsOnThisServer()) {
                        if (fileType.equals(FramePlugin.getFileExtensionForTemplate()) || fileType.equals(FramePlugin.getFileExtensionForProjectData())) {
                            this.createFromExportFileDelayed(file, serverConnection);
                            success = true;
                        } else {
                            ProjectTemplateFileDropListener.openErrorDelayed(this.workbenchWindow.getShell(), Messages.getString("ProjectTemplateFileDropListener.FileTypeNotSupported.Title"), Messages.getString("ProjectTemplateFileDropListener.FileTypeNotSupported.Message"));
                            success = false;
                        }
                    } else {
                        ProjectTemplateFileDropListener.openErrorDelayed(this.workbenchWindow.getShell(), Messages.getString("ProjectTemplateFileDropListener.project_cannot_be_created"), Messages.getString("ProjectTemplateFileDropListener.current_license_allows_not3"));
                        success = true;
                    }
                } else if (fileType.equals(FramePlugin.getFileExtensionForTemplate())) {
                    this.createFromTemplateDelayed(file, serverConnection);
                    success = true;
                } else if (fileType.equals(FramePlugin.getFileExtensionForProjectData())) {
                    this.createFromExportFileDelayed(file, serverConnection);
                    success = true;
                } else {
                    ProjectTemplateFileDropListener.openErrorDelayed(this.workbenchWindow.getShell(), Messages.getString("ProjectTemplateFileDropListener.FileTypeNotSupported.Title"), Messages.getString("ProjectTemplateFileDropListener.FileTypeNotSupported.Message"));
                    success = false;
                }
            } else {
                ProjectTemplateFileDropListener.openErrorDelayed(this.workbenchWindow.getShell(), Messages.getString("ProjectTemplateFileDropListener.project_cannot_be_created"), String.valueOf(Messages.getString("ProjectTemplateFileDropListener.current_license_allows_not1")) + maxProjects + Messages.getString("ProjectTemplateFileDropListener.current_license_allows_not2"));
                success = true;
            }
        }
        return success;
    }

    private static void openErrorDelayed(final Shell parent, final String title, final String message) {
        Display display = parent.getDisplay();
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!parent.isDisposed()) {
                    MessageDialog.openError((Shell)parent, (String)title, (String)message);
                } else {
                    MessageDialog.openError(null, (String)title, (String)message);
                }
            }
        });
    }

    private void createFromTemplateDelayed(final File file, final ServerConnection serverConnection) {
        this.workbenchWindow.getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!ProjectTemplateFileDropListener.this.workbenchWindow.getShell().isDisposed()) {
                    ProjectTemplateFileDropListener.this.createFromTemplate(file, serverConnection);
                }
            }
        });
    }

    private boolean createFromTemplate(File file, ServerConnection serverConnection) {
        if (ServerPermissionChecker.mayCreateProjects(serverConnection.getServerID(), true)) {
            IWorkbenchPage page = this.workbenchWindow.getActivePage();
            if (page != null) {
                try {
                    ProjectFileAccess projectFileAccess = new ProjectFileAccess(file, 1, this.workbenchWindow.getShell());
                    EOProject project = projectFileAccess.getProjectMetaData();
                    if (project != null) {
                        String description = Project.getDescription(project);
                        String copyright = Project.getCopyright(project);
                        IStreamResource logoFile = projectFileAccess.getProjectLogo();
                        CreateNewProjectWizard createNewProjectWizard = new CreateNewProjectWizard(page, description, copyright, logoFile, projectFileAccess, serverConnection);
                        WizardDialog dialog = new WizardDialog(this.workbenchWindow.getShell(), (IWizard)createNewProjectWizard);
                        dialog.open();
                        return true;
                    }
                }
                catch (SecurityException e) {
                    logger.error("could not execute", (Throwable)e);
                }
                catch (ProjectFileAccess.ProjectFileAccessException pfaE) {
                    logger.error("could not execute", (Throwable)pfaE);
                    String title = "";
                    String msg = "";
                    if (pfaE.getCause() instanceof FileNotFoundException) {
                        title = Messages.getString("ProjectTemplateFileDropListener.file_not_found");
                        msg = String.valueOf(Messages.getString("ProjectTemplateFileDropListener.file")) + file.getAbsolutePath() + Messages.getString("ProjectTemplateFileDropListener.not_found");
                    } else if (pfaE.getCause() instanceof IOException) {
                        title = Messages.getString("ProjectTemplateFileDropListener.error");
                        msg = String.valueOf(Messages.getString("ProjectTemplateFileDropListener.could_not_read_file")) + file.getAbsolutePath() + Messages.getString("ProjectTemplateFileDropListener.reason") + pfaE.getCause().getLocalizedMessage();
                    } else {
                        title = Messages.getString("ProjectTemplateFileDropListener.invalid_file");
                        msg = String.valueOf(Messages.getString("ProjectTemplateFileDropListener.the_file")) + file.getAbsolutePath() + Messages.getString("ProjectTemplateFileDropListener.does_not_contain_valid_data");
                    }
                    MessageDialog.openError((Shell)this.workbenchWindow.getShell(), (String)title, (String)msg);
                }
                catch (ProjectFileFormatVersionIncompatibleException pffviE) {
                    logger.error("could not execute", (Throwable)pffviE);
                    String title = Messages.getString("ProjectTemplateFileDropListener.file_format_incompatible");
                    String msg = NLS.bind((String)Messages.getString("ProjectTemplateFileDropListener.SpecificFileHasIncompatibleVersion.Message"), (Object)file.getAbsolutePath());
                    MessageDialog.openError((Shell)this.workbenchWindow.getShell(), (String)title, (String)msg);
                }
            }
            return false;
        }
        MessageDialog mDialog = new MessageDialog(EclipseSWTHelper.getShell(), Messages.getString("ProjectMgr.NoPermissionToCreateProject"), null, Messages.getString("ProjectMgr.NoPermissionToCreateProject.Detailed"), 1, new String[]{IDialogConstants.OK_LABEL}, 0);
        mDialog.open();
        return false;
    }

    private void createFromExportFileDelayed(final File file, final ServerConnection serverConnection) {
        this.workbenchWindow.getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!ProjectTemplateFileDropListener.this.workbenchWindow.getShell().isDisposed()) {
                    IWorkbenchPage currentPage = EclipseSWTHelper.getWorkbenchPage((IWorkbenchWindow)ProjectTemplateFileDropListener.this.workbenchWindow);
                    CreateProjectFromFileHelper.createProjectFromFile(currentPage, serverConnection, file);
                }
            }
        });
    }

    @Override
    public boolean supportsPaste(Object objectToBePasted, Object target) {
        String[] fileNames;
        if (this.supportsDropOnTarget(target) && objectToBePasted instanceof String[] && (fileNames = (String[])objectToBePasted).length == 1) {
            String extension = FileHelper.getFileType((String)fileNames[0]);
            return extension.equals(FramePlugin.getFileExtensionForProjectData()) || extension.equals(FramePlugin.getFileExtensionForTemplate());
        }
        return false;
    }

    @Override
    public boolean paste(Object objectToBePasted, Object target) {
        File file;
        String[] fileNames;
        if (objectToBePasted instanceof String[] && (fileNames = (String[])objectToBePasted).length == 1 && (file = new File(fileNames[0])).exists()) {
            return this.fileDropped(file, target);
        }
        return false;
    }

    @Override
    public Transfer getTransfer() {
        return FileTransfer.getInstance();
    }
}

