/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.global.gui.views.project;

import com.arcway.cockpit.frame.client.global.Messages;
import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.global.ServerPermissionChecker;
import com.arcway.cockpit.frame.client.project.ExProjectOpenAbortWithMessage;
import com.arcway.cockpit.frame.client.project.Project;
import com.arcway.cockpit.frame.client.project.ProjectAgent;
import com.arcway.cockpit.frame.client.project.core.framedata.ModificationProblem;
import com.arcway.cockpit.frame.client.project.core.serverproxy.IProjectManagerServerProxy;
import com.arcway.cockpit.frame.client.project.datainterchange.ImportFailedException;
import com.arcway.cockpit.frame.client.project.datainterchange.ProjectFileAccess;
import com.arcway.cockpit.frame.client.project.datainterchange.ProjectFileFormatVersionIncompatibleException;
import com.arcway.cockpit.frame.shared.message.EOProject;
import com.arcway.cockpit.frame.shared.userdefinedattributes.ExInvalidAttributeType;
import com.arcway.lib.eclipse.gui.ModificationProblemsDialog;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import de.plans.psc.client.communication.ExPrematureEndOfTransfer;
import de.plans.psc.client.communication.LoginCanceledException;
import de.plans.psc.client.communication.ServerConnection;
import de.plans.psc.client.communication.ServerNotAvailableException;
import de.plans.psc.client.communication.UnknownServerException;
import de.plans.psc.shared.serverexceptions.EXServerException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Locale;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;

public class CreateProjectFromFileHelper {
    private static final ILogger logger = Logger.getLogger(CreateProjectFromFileHelper.class);

    public static boolean createProjectFromFile(IWorkbenchPage currentPage, ServerConnection serverConnection, File file) {
        Shell shell = currentPage == null ? null : currentPage.getWorkbenchWindow().getShell();
        boolean success = false;
        if (ServerPermissionChecker.mayCreateProjects(serverConnection.getServerID(), true)) {
            Throwable th = null;
            ProjectAgent projectAgent = null;
            try {
                ProjectFileAccess projectFileAccess = new ProjectFileAccess(file, 2, shell);
                EOProject eoProject = projectFileAccess.getProjectMetaData();
                if (eoProject != null) {
                    boolean projectExists = false;
                    projectExists = ProjectMgr.getProjectMgr().getProjectAgent(eoProject.getProjectUID()) != null;
                    IProjectManagerServerProxy serverProxy = ProjectMgr.getProjectMgr().getProjectManagerServerProxy(serverConnection.getServerID());
                    if (!projectExists) {
                        EOProject[] allProjectsOfServer;
                        EOProject[] eOProjectArray = allProjectsOfServer = serverProxy.getAllProjectsOfServer();
                        int n = allProjectsOfServer.length;
                        int n2 = 0;
                        while (n2 < n) {
                            EOProject element = eOProjectArray[n2];
                            if (element.getUID().equals(eoProject.getUID())) {
                                projectExists = true;
                            }
                            ++n2;
                        }
                    }
                    if (projectExists) {
                        MessageBox mb = new MessageBox(shell, 257);
                        mb.setText(serverProxy.getGetProjectFromServerLabel());
                        mb.setMessage(Messages.getString("GetProjectFromServerDialog.project_exists"));
                        mb.open();
                    } else {
                        String name = Project.getProjectName(eoProject);
                        String language = Project.getLanguage(eoProject);
                        IInputValidator nameValidator = ProjectMgr.getProjectMgr().getProjectManagerServerProxy(serverConnection.getServerID()).getProjectNameValidatorForCreatingNewProjectOnServer();
                        if (nameValidator.isValid(name) != null) {
                            InputDialog dialog = new InputDialog(shell, Messages.getString("ProjectTemplateFileDropListener.name_new_project"), Messages.getString("ProjectTemplateFileDropListener.please_choose_another_name"), name, nameValidator);
                            int answer = dialog.open();
                            name = answer == 0 ? dialog.getValue() : null;
                        }
                        if (name != null) {
                            if (language == null) {
                                language = Locale.ENGLISH.getLanguage();
                            }
                            boolean triggerUserOnOpenActions = false;
                            projectAgent = ProjectMgr.getProjectMgr().createNewProject(eoProject.getProjectUID(), name, language, serverConnection.getServerID(), 1, triggerUserOnOpenActions, currentPage);
                            if (projectAgent != null) {
                                if (!projectAgent.getFrameLockManager().setExclusiveProjectLock().wasSuccessful()) {
                                    logger.error("A project was locked by another client, while this client was trying to create the project");
                                }
                                projectAgent.getFramePermissionManager().permissionOperandCreated(projectAgent);
                                projectAgent.getFramePermissionManager().permissionOperandCreated(projectAgent.getFrameSectionManager().getRootSection());
                                projectAgent.getFramePermissionManager().commit();
                                projectAgent.getFrameDataImporter().loadProjectFromACP(projectFileAccess, shell);
                                if (projectAgent.isCommitable()) {
                                    projectAgent.commitProject(String.valueOf(Messages.getString("ProjectTemplateFileDropListener.created_project_from_file1")) + file.getName() + Messages.getString("ProjectTemplateFileDropListener.created_project_from_file2"), false, true, shell);
                                }
                                projectAgent.triggerUserOnOpenActions(currentPage);
                            }
                        }
                    }
                    success = true;
                }
            }
            catch (IOException e) {
                logger.error("Error while creating (importing) project from export file (.acp/.act) due to IOException.", (Throwable)e);
                th = e;
            }
            catch (ImportFailedException e) {
                logger.error("Error while creating (importing) project from export file (.acp/.act) due to Import Failure.", (Throwable)e);
                th = e;
            }
            catch (ServerNotAvailableException e) {
                logger.error("Error while creating (importing) project from export file (.acp/.act) due to ServerNotAvailableException.", (Throwable)e);
                th = e;
            }
            catch (EXServerException e) {
                logger.error("Error while creating (importing) project from export file (.acp/.act) due to EXServerException.", (Throwable)e);
                th = e;
            }
            catch (LoginCanceledException e) {
            }
            catch (UnknownServerException e) {
                logger.error("Error while creating (importing) project from export file (.acp/.act) due to UnknownServerException.", (Throwable)e);
                th = e;
            }
            catch (ExInvalidAttributeType e) {
                logger.error("Error while creating (importing) project from export file (.acp/.act) due to ExInvalidAttributeType.", (Throwable)e);
                th = e;
            }
            catch (ExPrematureEndOfTransfer e) {
                logger.error("Error while creating (importing) project from export file (.acp/.act) due to ExPrematureEndOfTransfer.", (Throwable)e);
                th = e;
            }
            catch (ProjectFileAccess.ProjectFileAccessException pfaE) {
                logger.error("Error while creating (importing) project from export file (.acp/.act) due to ProjectFileAccessException.", (Throwable)pfaE);
                th = pfaE;
            }
            catch (ProjectFileFormatVersionIncompatibleException pffviE) {
                logger.error("Could not import project from export file (.acp/.act), because the file format is incompatible.", (Throwable)pffviE);
                String title = Messages.getString("ProjectTemplateFileDropListener.file_format_incompatible");
                String msg = NLS.bind((String)Messages.getString("ProjectTemplateFileDropListener.SpecificFileHasIncompatibleVersion.Message"), (Object)file.getAbsolutePath());
                MessageDialog.openError((Shell)shell, (String)title, (String)msg);
            }
            catch (ExProjectOpenAbortWithMessage e) {
                logger.error(e.getLocalizedMessage(), (Throwable)e);
                th = e;
            }
            if (th != null) {
                String descriptionOfConsequence = Messages.getString("ProjectTemplateFileDropListener.CreateProjectFailed.DescriptionOfConsequence");
                String genericMessage = Messages.getString("ProjectTemplateFileDropListener.CreateProjectFailed.genericMessage");
                String dialogTitle = Messages.getString("ProjectTemplateFileDropListener.CreateProjectFailed.dialogTitle");
                CreateProjectFromFileHelper.handleCreateFromExportFileThrowable(th, shell, descriptionOfConsequence, genericMessage, dialogTitle);
                if (projectAgent != null) {
                    ProjectMgr.getProjectMgr().deleteProjectOnServer(projectAgent, currentPage);
                }
            }
        } else {
            MessageDialog mDialog = new MessageDialog(shell, Messages.getString("ProjectMgr.NoPermissionToCreateProject"), null, Messages.getString("ProjectMgr.NoPermissionToCreateProject.Detailed"), 1, new String[]{IDialogConstants.OK_LABEL}, 0);
            mDialog.open();
        }
        return success;
    }

    private static void handleCreateFromExportFileThrowable(Throwable th, Shell parentShell, String humanReadableDescriptionOfConsequence, String exGenericMessage, String dialogTitle) {
        Exception userShownEx;
        Throwable thToHandle = th instanceof ExPrematureEndOfTransfer && th.getCause() != null ? th.getCause() : (th instanceof ImportFailedException && th.getCause() != null ? th.getCause() : th);
        if (thToHandle instanceof Exception) {
            userShownEx = (Exception)thToHandle;
        } else {
            userShownEx = new Exception(exGenericMessage);
            userShownEx.initCause(thToHandle);
        }
        ModificationProblem mProblem = new ModificationProblem(userShownEx, 2, humanReadableDescriptionOfConsequence);
        ArrayList<ModificationProblem> mProblems = new ArrayList<ModificationProblem>();
        mProblems.add(mProblem);
        ModificationProblemsDialog mpDialog = new ModificationProblemsDialog(mProblems, dialogTitle, parentShell);
        mpDialog.open();
    }
}

