/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.global.gui.views.linkview;

import com.arcway.cockpit.frame.client.global.FramePlugin;
import com.arcway.cockpit.frame.client.global.Messages;
import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.global.gui.views.linkview.ILinkContentProvider;
import com.arcway.cockpit.frame.client.global.gui.views.linkview.ModuleLinkViewContribution;
import com.arcway.cockpit.frame.client.global.license.IClientFunctionLicense;
import com.arcway.cockpit.frame.client.global.license.IClientFunctionLicenseType2;
import com.arcway.cockpit.frame.client.project.ProjectAgent;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.lib.eclipse.gui.DecoratedImageDescriptor;
import java.util.Collection;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IWorkbenchPartSite;

public class UnlinkAction
extends Action {
    private static ImageDescriptor enabledImage = FramePlugin.getImageDescriptor("BrokenLink.gif");
    private static ImageDescriptor disabledImage = ImageDescriptor.createWithFlags((ImageDescriptor)enabledImage, (int)1);
    private static DecoratedImageDescriptor disabledImageNoLicense = new DecoratedImageDescriptor(ImageDescriptor.createWithFlags((ImageDescriptor)enabledImage, (int)2));
    private final IWorkbenchPartSite site;
    private final ModuleLinkViewContribution moduleLinkViewContribution;
    private ICockpitProjectData currentUniqueElement;
    private ICockpitProjectData currentModuleDataItem;
    private ILinkContentProvider currentContentProvider;

    static {
        disabledImageNoLicense.addDecorator(FramePlugin.getImageDescriptor("license_restriction.gif"), 3);
    }

    public UnlinkAction(ModuleLinkViewContribution moduleLinkViewContribution, IWorkbenchPartSite site) {
        this.moduleLinkViewContribution = moduleLinkViewContribution;
        this.site = site;
        this.setImageDescriptor(enabledImage);
        this.setToolTipText(Messages.getString("LinkViewMenuController.Unlink_data._4"));
        this.setText(Messages.getString("LinkViewMenuController.Unlink_5"));
        super.setEnabled(false);
    }

    public void update(ICockpitProjectData uniqueElement, ICockpitProjectData moduleDataItem) {
        assert (uniqueElement != null);
        assert (moduleDataItem != null);
        boolean enable = false;
        IClientFunctionLicenseType2 requiredLicense = null;
        Collection<ILinkContentProvider> providers = this.moduleLinkViewContribution.getModuleContentProviders();
        for (ILinkContentProvider cp : providers) {
            if (!cp.canDeleteInfoLink(uniqueElement, moduleDataItem)) continue;
            enable = true;
            requiredLicense = cp.getRequiredLicenseTypeForUnlinking();
            this.currentContentProvider = cp;
            this.currentUniqueElement = uniqueElement;
            this.currentModuleDataItem = moduleDataItem;
            break;
        }
        boolean hasLicense = true;
        if (enable) {
            String projectUID = uniqueElement.getProjectUID();
            ProjectAgent projectAgent = ProjectMgr.getProjectMgr().getProjectAgent(projectUID);
            if (requiredLicense != null) {
                IClientFunctionLicense license = projectAgent.getServerLicenseManager().findClientFunctionLicense(requiredLicense);
                hasLicense = !requiredLicense.isDenial(license);
            }
        }
        this.setEnabled(enable, hasLicense);
    }

    public void disable() {
        this.setEnabled(false, true);
    }

    private void setEnabled(boolean enabled, boolean hasLicense) {
        if (enabled && !hasLicense) {
            this.setImageDescriptor((ImageDescriptor)disabledImageNoLicense);
            this.setDisabledImageDescriptor((ImageDescriptor)disabledImageNoLicense);
            super.setEnabled(false);
        } else {
            this.setImageDescriptor(enabledImage);
            this.setDisabledImageDescriptor(disabledImage);
            super.setEnabled(enabled);
        }
    }

    public void setEnabled(boolean enabled) {
        throw new UnsupportedOperationException("Use update() or disable() to set the enabled state.");
    }

    public void run() {
        MessageDialog confirmDeletionDialog;
        if (this.currentContentProvider != null && (confirmDeletionDialog = new MessageDialog(this.site.getShell(), Messages.getString("LinkViewMenuController.Unlink_data_6"), null, Messages.getString("LinkViewMenuController.Do_you_really_want_to_delete_the_selected_links__7"), 3, new String[]{Messages.getString("LinkViewMenuController.Yes_8"), Messages.getString("LinkViewMenuController.No_9")}, 0)).open() == 0) {
            this.currentContentProvider.deleteInfoLink(this.currentUniqueElement, this.currentModuleDataItem);
        }
    }
}

