/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.global.gui.views.linkview;

import com.arcway.cockpit.frame.client.global.gui.UserInterfaceManager;
import com.arcway.cockpit.frame.client.global.gui.views.linkview.ILinkContentProvider;
import com.arcway.cockpit.frame.client.global.gui.views.linkview.IModuleLinkLabelProvider;
import com.arcway.cockpit.frame.client.project.modules.IModuleUserInterface;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.ui.IWorkbenchPartSite;

public class ModuleLinkViewContribution {
    private final IWorkbenchPartSite site;
    private Collection<ILinkContentProvider> moduleContentProviders;
    private Collection<IModuleLinkLabelProvider> moduleLabelProviders;

    public ModuleLinkViewContribution(IWorkbenchPartSite site) {
        this.site = site;
        this.init();
    }

    private void init() {
        Collection<IModuleUserInterface> moduleUserInterfaces = UserInterfaceManager.getDefault().getModuleUserInterfaces(this.site.getWorkbenchWindow());
        this.moduleContentProviders = new HashSet<ILinkContentProvider>(moduleUserInterfaces.size());
        this.moduleLabelProviders = new HashSet<IModuleLinkLabelProvider>(moduleUserInterfaces.size());
        for (IModuleUserInterface userInterface : moduleUserInterfaces) {
            if (userInterface == null) continue;
            this.moduleContentProviders.add(userInterface.getLinkContentProvider());
            this.moduleLabelProviders.add(userInterface.getLinkLabelProvider());
        }
    }

    public Collection<ILinkContentProvider> getModuleContentProviders() {
        return this.moduleContentProviders;
    }

    public Collection<IModuleLinkLabelProvider> getModuleLabelProviders() {
        return this.moduleLabelProviders;
    }
}

