/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.global.gui.views.linkview;

import com.arcway.cockpit.client.base.interfaces.frame.propertychanges.IPropertyChanges;
import com.arcway.cockpit.client.base.interfaces.frame.propertychanges.IPropertyChangesListener;
import com.arcway.cockpit.cockpitlib.client.gui.DeferredRefresher;
import com.arcway.cockpit.cockpitlib.client.gui.IRefreshableDisplay;
import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.global.gui.views.linkview.ApplyModuleFilterAction;
import com.arcway.cockpit.frame.client.global.gui.views.linkview.FilterForLinkTypeAction;
import com.arcway.cockpit.frame.client.global.gui.views.linkview.FilterIndirectLinksAction;
import com.arcway.cockpit.frame.client.global.gui.views.linkview.ILinkContentProvider;
import com.arcway.cockpit.frame.client.global.gui.views.linkview.IndirectLinksContainer;
import com.arcway.cockpit.frame.client.global.gui.views.linkview.LinkViewContentProvider;
import com.arcway.cockpit.frame.client.global.gui.views.linkview.ModuleLinkViewContribution;
import com.arcway.cockpit.frame.client.global.gui.views.linkview.UnlinkAction;
import com.arcway.cockpit.frame.client.global.gui.views.uniqueelement2.UniqueElementLabelDecorator;
import com.arcway.cockpit.frame.client.global.selection.CockpitSelectionManager;
import com.arcway.cockpit.frame.client.global.selection.CockpitSelectionService;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.ProjectAgent;
import com.arcway.cockpit.frame.client.project.core.sectionsandplans.plan.IPlan;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.IUniqueElement;
import com.arcway.cockpit.frame.client.project.planeditors.PlanEditorLauncher;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.lib.stringtools.StringUtil;
import de.plans.lib.util.gui.DecoratingLabelProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class LinkView
extends ViewPart
implements ISelectionListener,
ISelectionChangedListener,
IMenuListener,
IPropertyChangesListener,
IRefreshableDisplay,
IPartListener {
    public static final String VIEW_ID = "de.plans.fmca.frame.client.gui.links.LinkView";
    private static final String LINKVIEW_CONTEXTMENU_ID = "de.plans.fmca.frame.client.gui.links.LinkView.contextmenu";
    private static final String XML_LINKVIEW_ACTION_STATE = "linkview.actionstate";
    private static final String XML_FILTER_INDIRECTLINKS_STATE = "indirect_links";
    private static final String XML_FILTER_LINK_TYPE = "linktypes";
    private static Set<LinkView> openLinkViews = new HashSet<LinkView>();
    private TreeViewer linkViewer;
    private UnlinkAction unlinkAction;
    private boolean isUnlinkActionToBeShown;
    private FilterIndirectLinksAction filterIndirectLinksAction;
    private List<FilterForLinkTypeAction> filterForLinkTypeActions;
    private final Map<Class, Boolean> expandedReminder = new HashMap<Class, Boolean>();
    private IFrameProjectAgent currentProjectAgent;
    private List<ICockpitProjectData> elementsToShow;
    private DeferredRefresher refresher;
    private LinkViewContentProvider contentProvider;
    private IMemento initMemento;
    private final PlanEditorLauncher projectorLauncher = new PlanEditorLauncher(3, false);
    private final Separator separator = new Separator();
    private ModuleLinkViewContribution moduleLinkViewContribution;

    public static void clearAllLinkViews() {
        for (LinkView linkView : openLinkViews) {
            linkView.clear();
        }
    }

    public void createPartControl(Composite parent) {
        this.init();
        openLinkViews.add(this);
        CockpitSelectionManager.getSelectionService(this.getSite().getWorkbenchWindow().getSelectionService()).addSelectionListener(this);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.arcway.cockpit.frame.help.infolink_view_index");
        this.linkViewer = new TreeViewer(parent, 2);
        this.contentProvider = new LinkViewContentProvider(this.moduleLinkViewContribution, true);
        this.linkViewer.setContentProvider((IContentProvider)this.contentProvider);
        DecoratingLabelProvider lp = new DecoratingLabelProvider((ILabelProvider)this.contentProvider);
        lp.addLabelDecorator((ILabelDecorator)new UniqueElementLabelDecorator());
        this.linkViewer.setLabelProvider((IBaseLabelProvider)lp);
        this.linkViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        Menu ctxMenu = this.createContextMenu(this.linkViewer.getControl());
        this.linkViewer.getControl().setMenu(ctxMenu);
        this.linkViewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                Object element;
                IStructuredSelection sel;
                ISelection selection = event.getSelection();
                if (selection instanceof IStructuredSelection && (sel = (IStructuredSelection)selection).size() == 1 && (element = sel.getFirstElement()) instanceof ICockpitProjectData) {
                    LinkView.this.openEntry((ICockpitProjectData)element);
                }
            }
        });
        this.linkViewer.setSorter((ViewerSorter)new LinkViewerSorter());
        this.linkViewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof Collection) {
                    Collection collection = (Collection)element;
                    for (Object colElement : collection) {
                        if (LinkView.this.isFiltered(viewer, colElement)) continue;
                        return true;
                    }
                    return false;
                }
                return true;
            }
        });
        this.setupActions();
        this.getSite().setSelectionProvider((ISelectionProvider)this.linkViewer);
        this.getSite().getPage().addPartListener((IPartListener)this);
        this.linkViewer.setAutoExpandLevel(2);
    }

    private boolean isFiltered(Viewer viewer, Object element) {
        ViewerFilter[] filters = this.linkViewer.getFilters();
        int i = 0;
        while (i < filters.length) {
            if (!filters[i].select(viewer, null, element)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void openEntry(ICockpitProjectData data) {
        if (data instanceof IPlan) {
            this.projectorLauncher.openOrShowPlanEditors(this.getSite().getPage(), this.linkViewer.getSelection());
        }
    }

    public void dispose() {
        openLinkViews.remove((Object)this);
        CockpitSelectionManager.getSelectionService(this.getSite().getWorkbenchWindow().getSelectionService()).removeSelectionListener(this);
        if (this.currentProjectAgent != null) {
            this.currentProjectAgent.getPropertyChangesListenerManager().deregister((IPropertyChangesListener)this);
        }
        if (this.refresher != null) {
            this.refresher.halt();
        }
        super.dispose();
    }

    private void setupActions() {
        String s;
        this.unlinkAction = new UnlinkAction(this.moduleLinkViewContribution, this.getSite());
        this.getViewSite().getActionBars().getToolBarManager().add((IAction)this.unlinkAction);
        this.getViewSite().getActionBars().getMenuManager().add((IAction)this.unlinkAction);
        this.filterIndirectLinksAction = new FilterIndirectLinksAction(this);
        if (this.initMemento != null && (s = this.initMemento.getString(XML_FILTER_INDIRECTLINKS_STATE)) != null) {
            Boolean b = Boolean.valueOf(s);
            this.filterIndirectLinksAction.setOn(b);
        }
        this.getViewSite().getActionBars().getToolBarManager().add((IAction)this.filterIndirectLinksAction);
        this.getViewSite().getActionBars().getMenuManager().add((IContributionItem)this.separator);
        IMemento filterForTypeMemento = null;
        if (this.initMemento != null) {
            filterForTypeMemento = this.initMemento.getChild(XML_FILTER_LINK_TYPE);
        }
        this.filterForLinkTypeActions = new ArrayList<FilterForLinkTypeAction>();
        Iterator<ILinkContentProvider> iterator = this.moduleLinkViewContribution.getModuleContentProviders().iterator();
        while (iterator.hasNext()) {
            String type;
            String s2;
            ILinkContentProvider element;
            ILinkContentProvider cp = element = iterator.next();
            boolean startShow = true;
            if (filterForTypeMemento != null && (s2 = filterForTypeMemento.getString(type = StringUtil.normalize((String)cp.getTypeName(), (boolean)true))) != null && s2.trim().length() > 0) {
                Boolean b = Boolean.valueOf(s2);
                startShow = b;
            }
            FilterForLinkTypeAction action = new FilterForLinkTypeAction(cp, startShow, this.contentProvider, this);
            this.getViewSite().getActionBars().getMenuManager().add((IAction)action);
            this.filterForLinkTypeActions.add(action);
        }
        ApplyModuleFilterAction dataViewFilterAction = new ApplyModuleFilterAction(this.moduleLinkViewContribution.getModuleContentProviders(), this);
        this.getViewSite().getActionBars().getToolBarManager().add((IAction)dataViewFilterAction);
    }

    private Menu createContextMenu(Control parent) {
        MenuManager contextMenuMgr = new MenuManager("LinkViewContextMenu");
        contextMenuMgr.setRemoveAllWhenShown(true);
        contextMenuMgr.addMenuListener((IMenuListener)this);
        this.getSite().registerContextMenu(LINKVIEW_CONTEXTMENU_ID, contextMenuMgr, (ISelectionProvider)this.linkViewer);
        Menu menu = contextMenuMgr.createContextMenu(parent);
        return menu;
    }

    public void menuAboutToShow(IMenuManager manager) {
        manager.add((IContributionItem)new Separator("new.ext"));
        if (this.isUnlinkActionToBeShown) {
            manager.add((IAction)this.unlinkAction);
        }
        manager.add((IContributionItem)new Separator("additions"));
    }

    private void updateUnlinkAction() {
        this.isUnlinkActionToBeShown = false;
        TreeItem[] currentSelection = this.linkViewer.getTree().getSelection();
        if (currentSelection.length == 1) {
            TreeItem selectedTreeItem = currentSelection[0];
            Object selectedElement = selectedTreeItem.getData();
            Object rootElementOfSelection = this.getRootParentElement(selectedTreeItem);
            if (selectedElement instanceof IUniqueElement) {
                if (rootElementOfSelection instanceof ICockpitProjectData && selectedElement != rootElementOfSelection) {
                    this.unlinkAction.update((ICockpitProjectData)((IUniqueElement)selectedElement), (ICockpitProjectData)rootElementOfSelection);
                    this.isUnlinkActionToBeShown = true;
                }
            } else if (selectedElement instanceof ICockpitProjectData && rootElementOfSelection instanceof IUniqueElement && selectedElement != rootElementOfSelection) {
                this.unlinkAction.update((ICockpitProjectData)rootElementOfSelection, (ICockpitProjectData)selectedElement);
                this.isUnlinkActionToBeShown = true;
            }
        }
        if (!this.isUnlinkActionToBeShown) {
            this.unlinkAction.disable();
        }
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (part == null || selection == null || selection.isEmpty()) {
            return;
        }
        boolean projectChanged = false;
        if (part != this && selection instanceof IStructuredSelection) {
            IStructuredSelection sel = (IStructuredSelection)selection;
            for (Object o : sel.toList()) {
                if (o instanceof ICockpitProjectData) {
                    ICockpitProjectData pd = (ICockpitProjectData)o;
                    ProjectAgent pa = ProjectMgr.getProjectMgr().getProjectAgent(pd.getProjectUID());
                    if (pa == this.currentProjectAgent || !pa.isOpened()) break;
                    if (this.currentProjectAgent != null) {
                        this.currentProjectAgent.getPropertyChangesListenerManager().deregister((IPropertyChangesListener)this);
                    }
                    this.currentProjectAgent = pa;
                    pa.getPropertyChangesListenerManager().register((IPropertyChangesListener)this, ICockpitProjectData.class);
                    projectChanged = true;
                    break;
                }
                projectChanged = true;
            }
            if (this.currentProjectAgent != null && this.currentProjectAgent.isOpened()) {
                ArrayList<ICockpitProjectData> relevantSelectedElements = new ArrayList<ICockpitProjectData>();
                for (Object o : sel) {
                    if (!(o instanceof ICockpitProjectData) || relevantSelectedElements.contains(o)) continue;
                    relevantSelectedElements.add((ICockpitProjectData)o);
                }
                if (relevantSelectedElements.size() != 0 || projectChanged) {
                    this.elementsToShow = relevantSelectedElements;
                    this.showElements();
                } else {
                    this.clear();
                }
            }
        }
    }

    private void clear() {
        this.elementsToShow = new ArrayList<ICockpitProjectData>();
        this.showElements();
    }

    public void refresh() {
        if (!this.linkViewer.getTree().isDisposed()) {
            this.expandedReminder.putAll(this.setExpandedState());
            this.linkViewer.setInput(this.elementsToShow);
            List<Object> toExpand = this.restoreExpandedState();
            if (toExpand.isEmpty()) {
                this.linkViewer.expandAll();
            } else {
                this.linkViewer.setExpandedElements(this.restoreExpandedState().toArray());
            }
        }
    }

    protected void showElements() {
        if (this.refresher == null) {
            this.refresher = new DeferredRefresher((IRefreshableDisplay)this);
            this.refresher.start();
        }
        this.refresher.scheduleDeferredRefresh();
    }

    public void setFocus() {
        this.linkViewer.getTree().setFocus();
    }

    private Map<Class, Boolean> setExpandedState() {
        return this.setExpandedState(this.linkViewer.getTree().getItems());
    }

    private Map<Class, Boolean> setExpandedState(TreeItem[] elements) {
        HashMap<Class, Boolean> status = new HashMap<Class, Boolean>();
        if (elements != null) {
            TreeItem[] treeItemArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                Object data;
                TreeItem item = treeItemArray[n2];
                if (item.getItemCount() > 0 && (data = item.getData()) != null) {
                    status.put(data.getClass(), item.getExpanded());
                    status.putAll(this.setExpandedState(item.getItems()));
                }
                ++n2;
            }
        }
        return status;
    }

    private List<Object> restoreExpandedState() {
        return this.restoreExpandedState(this.linkViewer.getTree().getItems());
    }

    private List<Object> restoreExpandedState(TreeItem[] items) {
        ArrayList<Object> expandedElements = new ArrayList<Object>();
        if (items != null) {
            TreeItem[] treeItemArray = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                Boolean b;
                Class<?> clazz;
                TreeItem element = treeItemArray[n2];
                Object data = element.getData();
                if (data != null && this.expandedReminder.containsKey(clazz = data.getClass()) && (b = this.expandedReminder.get(clazz)).booleanValue()) {
                    expandedElements.add(data);
                }
                expandedElements.addAll(this.restoreExpandedState(element.getItems()));
                ++n2;
            }
        }
        return expandedElements;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.updateUnlinkAction();
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        if (memento != null) {
            this.initMemento = memento.getChild(XML_LINKVIEW_ACTION_STATE);
        }
    }

    public void saveState(IMemento memento) {
        if (memento != null) {
            IMemento child = memento.createChild(XML_LINKVIEW_ACTION_STATE);
            child.putString(XML_FILTER_INDIRECTLINKS_STATE, Boolean.toString(this.filterIndirectLinksAction.isOn()));
            child = child.createChild(XML_FILTER_LINK_TYPE);
            Iterator<FilterForLinkTypeAction> iterator = this.filterForLinkTypeActions.iterator();
            while (iterator.hasNext()) {
                FilterForLinkTypeAction element;
                FilterForLinkTypeAction action = element = iterator.next();
                String s = Boolean.toString(action.getShow());
                String type = StringUtil.normalize((String)action.getLinkTypeName(), (boolean)true);
                child.putString(type, s);
            }
        }
        super.saveState(memento);
    }

    public void modelRefreshed(IPropertyChanges<?> changes, Class<?> clazz, String projectUID) {
        if (this.currentProjectAgent != null && this.currentProjectAgent.isOpened()) {
            Collection elements = changes.getDeletedElements();
            if (elements != null) {
                for (Object o : elements) {
                    if (!this.elementsToShow.contains(o)) continue;
                    this.elementsToShow.remove(o);
                }
            }
            if ((elements = changes.getModifiedElements()) != null) {
                for (Object o : elements) {
                    if (!(o instanceof ICockpitProjectData)) continue;
                    ICockpitProjectData modData = (ICockpitProjectData)o;
                    this.replaceElementInElementsToShow(modData);
                }
            }
            this.showElements();
        }
    }

    private void replaceElementInElementsToShow(ICockpitProjectData data) {
        Iterator<ICockpitProjectData> i = this.elementsToShow.iterator();
        while (i.hasNext()) {
            ICockpitProjectData containedData = i.next();
            if (!containedData.getTypeID().equals(data.getTypeID()) || !containedData.getUID().equals(data.getUID()) || !containedData.getProjectUID().equals(data.getProjectUID())) continue;
            i.remove();
            this.elementsToShow.add(data);
            return;
        }
    }

    public Display getDisplay() {
        return this.getSite().getShell().getDisplay();
    }

    public void partActivated(IWorkbenchPart part) {
    }

    public void partBroughtToTop(IWorkbenchPart part) {
    }

    public void partClosed(IWorkbenchPart part) {
    }

    public void partDeactivated(IWorkbenchPart part) {
    }

    public void partOpened(IWorkbenchPart part) {
        if (part == this) {
            CockpitSelectionService sService = CockpitSelectionManager.getSelectionService(this.getSite().getWorkbenchWindow().getSelectionService());
            this.selectionChanged(sService.getPartOfLastSelection(), (ISelection)sService.getLastSelection());
        }
    }

    public boolean isDisposed() {
        return this.linkViewer.getTree().isDisposed();
    }

    protected TreeViewer getTreeViewer() {
        return this.linkViewer;
    }

    private void init() {
        this.moduleLinkViewContribution = new ModuleLinkViewContribution(this.getSite());
    }

    protected IFrameProjectAgent getProjectAgent() {
        return this.currentProjectAgent;
    }

    private Object getRootParentElement(TreeItem item) {
        TreeItem currentItem = item;
        TreeItem parentItem = item;
        do {
            currentItem = parentItem;
        } while ((parentItem = parentItem.getParentItem()) != null);
        return currentItem.getData();
    }

    private class LinkViewerSorter
    extends ViewerSorter {
        private LinkViewerSorter() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            if (e1 instanceof IndirectLinksContainer) {
                if (e2 instanceof IndirectLinksContainer) {
                    IndirectLinksContainer lc1 = (IndirectLinksContainer)e1;
                    if (lc1.isLinkedToComponent()) {
                        return -1;
                    }
                    return 1;
                }
                return -1;
            }
            return super.compare(viewer, e1, e2);
        }
    }
}

