/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.global.gui.views.linkview;

import com.arcway.cockpit.client.base.interfaces.frame.propertychanges.IPropertyChangesListener;
import com.arcway.cockpit.cockpitlib.client.filter.gui.IFilterItem;
import com.arcway.cockpit.frame.client.global.Icons;
import com.arcway.cockpit.frame.client.global.Messages;
import com.arcway.cockpit.frame.client.global.gui.views.linkview.ILinkContentProvider;
import com.arcway.cockpit.frame.client.global.gui.views.linkview.LinkView;
import java.util.Collection;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;

public class ApplyModuleFilterAction
extends Action {
    private final Collection<ILinkContentProvider> moduleContentProviders;
    private final LinkView linkView;
    private static final String MSG = Messages.getString("ApplyModuleFilterAction.ActionTitle");
    private static final ImageDescriptor IMG = Icons.getImageDescriptorForFilter();

    public ApplyModuleFilterAction(Collection<ILinkContentProvider> moduleContentProviders, LinkView linkView) {
        super(MSG, 2);
        assert (moduleContentProviders != null) : "moduleContentProviders must not be null";
        assert (linkView != null) : "linkView must not be null";
        this.setImageDescriptor(IMG);
        this.setToolTipText(MSG);
        this.moduleContentProviders = moduleContentProviders;
        this.linkView = linkView;
    }

    public void run() {
        boolean checked = this.isChecked();
        this.setChecked(checked);
        for (ILinkContentProvider cp : this.moduleContentProviders) {
            cp.toggleDataViewFilters();
        }
        if (checked) {
            this.linkView.getProjectAgent().getPropertyChangesListenerManager().register((IPropertyChangesListener)this.linkView, IFilterItem.class);
        } else {
            this.linkView.getProjectAgent().getPropertyChangesListenerManager().deregister((IPropertyChangesListener)this.linkView, IFilterItem.class);
        }
        this.linkView.showElements();
    }
}

