/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.global.gui.views.lib.dataview;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttribute;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeOwner;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeType;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeTypeDataType;
import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.global.gui.views.lib.dataview.CockpitTreeDataViewProvider;
import com.arcway.cockpit.frame.client.lib.dataviews.view.jfaceviewer.tree.IColumnDescription;
import com.arcway.cockpit.frame.client.lib.dataviews.view.jfaceviewer.tree.IDataViewColumnComparator;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.core.categories.ObjectTypeCategories;
import com.arcway.cockpit.frame.client.project.core.userdefinedattributetypes.IFrameUserDefinedAttributeTypesManager;
import com.arcway.cockpit.frame.client.project.modules.IProjectCloseListener;
import com.arcway.cockpit.frame.shared.userdefinedattributes.ExInvalidAttributeType;
import com.arcway.lib.java.collectionmaps.MapMap;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.eclipse.swt.graphics.Image;

public class CustomPropertiesTreeDataViewProvider<ContentType> {
    private static final ILogger logger = Logger.getLogger(CustomPropertiesTreeDataViewProvider.class);
    public static final String ID_PREFIX = "customproperty.";
    private static final int CP_POSITION_OFFSET = 1000;
    private static final MapMap<String, String, CustomPropertiesTreeDataViewProvider<?>> instanceCache = new MapMap();
    private final Collection<String> dataTypeIDs;
    private final CockpitTreeDataViewProvider.ICustomPropertyColumnProvider<ContentType> customPropertyColumnProvider;
    private final IFrameUserDefinedAttributeTypesManager typesManager;
    private final List<ColumnDescription<ContentType>> columnDescriptions;
    private final Map<String, ColumnDescription<ContentType>> map_displayName_columnDescription;
    private final Map<String, ColumnDescription<ContentType>> map_id_columnDescription;

    public static <ContentType> CustomPropertiesTreeDataViewProvider<ContentType> getInstance(final String projectUID, final String fullModuleID, CockpitTreeDataViewProvider.ICustomPropertyColumnProvider<ContentType> customPropertyColumnProvider, boolean forceCreationOfNewInstance) {
        CustomPropertiesTreeDataViewProvider<ContentType> instance = null;
        if (!forceCreationOfNewInstance) {
            instance = (CustomPropertiesTreeDataViewProvider<ContentType>)instanceCache.get((Object)projectUID, (Object)fullModuleID);
        }
        if (instance == null) {
            instance = new CustomPropertiesTreeDataViewProvider<ContentType>(projectUID, customPropertyColumnProvider);
            instanceCache.put((Object)projectUID, (Object)fullModuleID, instance);
            ProjectMgr.getProjectMgr().getProjectAgent(projectUID).addProjectCloseListener(new IProjectCloseListener(){

                @Override
                public void closeProject(IFrameProjectAgent projectAgent) {
                    instanceCache.remove((Object)projectUID, (Object)fullModuleID);
                }
            });
        }
        return instance;
    }

    private CustomPropertiesTreeDataViewProvider(String projectUID, CockpitTreeDataViewProvider.ICustomPropertyColumnProvider<ContentType> customPropertyColumnProvider_) {
        this.typesManager = ProjectMgr.getProjectMgr().getProjectAgent(projectUID).getFrameUserDefinedAttributeTypesManager();
        this.columnDescriptions = new ArrayList<ColumnDescription<ContentType>>();
        this.map_displayName_columnDescription = new HashMap<String, ColumnDescription<ContentType>>();
        this.map_id_columnDescription = new HashMap<String, ColumnDescription<ContentType>>();
        this.dataTypeIDs = customPropertyColumnProvider_.getDatatypesForWhichCustomPropertyColumnsAreToBeCreated();
        this.customPropertyColumnProvider = customPropertyColumnProvider_;
        int cpColumnCount = 0;
        for (String typeID : this.dataTypeIDs) {
            for (IAttributeType attributeType : this.typesManager.getSortedAttributeTypes(typeID)) {
                ColumnDescription<ContentType> columnDescription;
                String displayName = attributeType.getDisplayName();
                if (this.map_displayName_columnDescription.containsKey(displayName)) {
                    columnDescription = this.map_displayName_columnDescription.get(displayName);
                    columnDescription.addAttributeType(typeID, attributeType);
                    continue;
                }
                columnDescription = new ColumnDescription<ContentType>(cpColumnCount, displayName, typeID, attributeType, customPropertyColumnProvider_);
                this.map_displayName_columnDescription.put(displayName, columnDescription);
                this.map_id_columnDescription.put(columnDescription.getId(), columnDescription);
                this.columnDescriptions.add(columnDescription);
                ++cpColumnCount;
            }
        }
    }

    public Collection<IColumnDescription> getColumnDescriptions() {
        return new ArrayList<IColumnDescription>(this.columnDescriptions);
    }

    public IAttributeType getAttributeType(String columnID, String cockpitTypeID) {
        return this.map_id_columnDescription.get(columnID).getAttributeType(cockpitTypeID);
    }

    public final Image getColumnImage(ContentType element, String columnID) {
        return null;
    }

    public final String getColumnText(ContentType element, String columnID) {
        IAttributeOwner attributeOwner = this.customPropertyColumnProvider.getAttributeOwner(element);
        if (attributeOwner != null) {
            IAttributeType attributeType = this.getAttributeType(columnID, attributeOwner.getTypeID());
            if (attributeType != null) {
                if (ObjectTypeCategories.isUserDefinedAttributeTypeVisibleForItem(attributeOwner, attributeType)) {
                    IAttribute attribute;
                    try {
                        attribute = attributeOwner.getAttribute(attributeType.getAttributeTypeID());
                    }
                    catch (ExInvalidAttributeType e) {
                        logger.error((Throwable)e);
                        return null;
                    }
                    return attributeType.getDataType().getValueAsSingleLineString(attribute.getAttributeValue(), attributeType.getValueRange(), ", ", Locale.getDefault());
                }
                return null;
            }
            return null;
        }
        return null;
    }

    private static class ColumnDescription<ContentType>
    implements IColumnDescription {
        private final int cpColumnIndex;
        private final String name;
        private final Map<String, IAttributeType> map_cockpitTypeID_attributeType;
        private final CockpitTreeDataViewProvider.ICustomPropertyColumnProvider<ContentType> customPropertyColumnProvider;

        public ColumnDescription(int cpColumnIndex_, String name_, String cockpitTypeID, IAttributeType attributeType, CockpitTreeDataViewProvider.ICustomPropertyColumnProvider<ContentType> customPropertyColumnProvider_) {
            this.cpColumnIndex = cpColumnIndex_;
            this.name = name_;
            this.map_cockpitTypeID_attributeType = new HashMap<String, IAttributeType>();
            this.map_cockpitTypeID_attributeType.put(cockpitTypeID, attributeType);
            this.customPropertyColumnProvider = customPropertyColumnProvider_;
        }

        public void addAttributeType(String cockpitTypeID, IAttributeType attributeType) {
            this.map_cockpitTypeID_attributeType.put(cockpitTypeID, attributeType);
        }

        @Override
        public String getId() {
            return CustomPropertiesTreeDataViewProvider.ID_PREFIX + this.name;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getDescription() {
            return "";
        }

        @Override
        public int getDefaultWidth() {
            return 100;
        }

        @Override
        public int getDefaultPosition() {
            return 1000 + this.cpColumnIndex;
        }

        @Override
        public boolean isToBeShownByDefault() {
            return true;
        }

        @Override
        public int getDefaultSortingDirection() {
            return 1;
        }

        @Override
        public int getDefaultSortingOrderRank() {
            return 1000 + this.cpColumnIndex;
        }

        @Override
        public IDataViewColumnComparator getComparator() {
            return new CustomPropertyComparator<ContentType>(this, this.customPropertyColumnProvider);
        }

        public IAttributeType getAttributeType(String cockpitTypeID) {
            return this.map_cockpitTypeID_attributeType.get(cockpitTypeID);
        }
    }

    private static class CustomPropertyComparator<ContentType>
    implements IDataViewColumnComparator {
        private final ColumnDescription<ContentType> columnDescription;
        private final CockpitTreeDataViewProvider.ICustomPropertyColumnProvider<ContentType> customPropertyColumnProvider;

        CustomPropertyComparator(ColumnDescription<ContentType> columnDescription, CockpitTreeDataViewProvider.ICustomPropertyColumnProvider<ContentType> customPropertyColumnProvider) {
            this.columnDescription = columnDescription;
            this.customPropertyColumnProvider = customPropertyColumnProvider;
        }

        @Override
        public int compare(Object o1, Object o2) {
            IAttributeOwner attributeOwner1 = this.customPropertyColumnProvider.getAttributeOwner(o1);
            IAttributeOwner attributeOwner2 = this.customPropertyColumnProvider.getAttributeOwner(o2);
            if (attributeOwner1 != null && attributeOwner2 != null) {
                String cockpitTypeID;
                IAttributeType attributeType;
                if (attributeOwner1.getTypeID().equals(attributeOwner2.getTypeID()) && (attributeType = this.columnDescription.getAttributeType(cockpitTypeID = attributeOwner1.getTypeID())) != null) {
                    try {
                        IAttribute attribute1 = attributeOwner1.getAttribute(attributeType.getAttributeTypeID());
                        IAttribute attribute2 = attributeOwner2.getAttribute(attributeType.getAttributeTypeID());
                        IAttributeTypeDataType dataType = attributeType.getDataType();
                        return dataType.getComparator(attributeType.getValueRange()).compare(attribute1.getAttributeValue(), attribute2.getAttributeValue());
                    }
                    catch (ExInvalidAttributeType e) {
                        logger.error((Throwable)e);
                    }
                }
            } else {
                if (attributeOwner1 == null && attributeOwner2 != null) {
                    return 1;
                }
                if (attributeOwner2 == null && attributeOwner1 != null) {
                    return -1;
                }
            }
            return 0;
        }
    }
}

