/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.global.gui.views.details.element;

import com.arcway.cockpit.client.base.interfaces.frame.gui.DetailsElement;
import com.arcway.cockpit.client.base.interfaces.frame.gui.IDetailsResourceProvider;
import com.arcway.cockpit.frame.client.global.Messages;
import com.arcway.cockpit.frame.client.global.gui.views.details.DetailsViewHyperlinkListener;
import com.arcway.cockpit.frame.client.global.gui.views.details.element.ListEntryParameter;
import com.arcway.cockpit.frame.client.global.gui.views.details.value.DetailsValue;
import com.arcway.cockpit.frame.client.global.gui.views.details.value.DetailsValueList;
import com.arcway.lib.UUIDGenerator;
import com.arcway.lib.eclipse.gui.widgets.UsableHyperlink;
import com.arcway.lib.eclipse.transfer.dnd.IDragSourceListener;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;

public class DetailsElementList
extends DetailsElement {
    private static final ILogger LOGGER = Logger.getLogger(DetailsElementList.class);
    private static final int MAX_ENTRY_WIDGETS = 25;
    private static final String CONTEXT_MENU_ID_PREFIX = "DetailsView.ElementTypeSelectableList.ContextMenu.";
    private final String label;
    private final DetailsValue detailsValue;
    private IDetailsResourceProvider currentRessourceProvider;
    private Composite detailsField;
    private StyledText labelWidget;
    protected Composite valueField;
    private List<Control> valueWidgets;
    private IDragSourceListener dragListener;

    public DetailsElementList(String id, String label, DetailsValueList detailsValue) {
        super(id);
        this.label = label;
        this.detailsValue = detailsValue;
    }

    protected DetailsElementList(String id, String label, DetailsValue detailsValue) {
        super(id);
        this.label = label;
        this.detailsValue = detailsValue;
    }

    public Control createWidget(Composite parent, IWorkbenchPartSite site, IDetailsResourceProvider resourceProvider) {
        this.detailsField = new Composite(parent, 0);
        this.detailsField.setBackground(parent.getDisplay().getSystemColor(1));
        GridLayout layout = new GridLayout(1, false);
        layout.horizontalSpacing = 0;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.marginTop = 8;
        this.detailsField.setLayout((Layout)layout);
        this.labelWidget = new StyledText(this.detailsField, 8);
        this.labelWidget.setText(this.label);
        this.labelWidget.setFont(resourceProvider.getLabelFont());
        StyleRange styleRange = new StyleRange();
        styleRange.start = 0;
        styleRange.length = this.label.length();
        styleRange.fontStyle = 1;
        this.labelWidget.setStyleRange(styleRange);
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = false;
        gridData.horizontalAlignment = 4;
        this.labelWidget.setLayoutData((Object)gridData);
        this.valueField = new Composite(this.detailsField, 0);
        this.valueField.setBackground(parent.getDisplay().getSystemColor(1));
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        this.valueField.setLayoutData((Object)gridData);
        this.valueWidgets = new ArrayList<Control>();
        return this.detailsField;
    }

    public void fillWidget(IDetailsResourceProvider resourceProvider) {
        this.currentRessourceProvider = resourceProvider;
        int c = 0;
        while (c < this.valueWidgets.size()) {
            this.valueWidgets.get(c).dispose();
            ++c;
        }
        this.valueWidgets.clear();
        List<Control> entryWidgets = this.createEntryWidgets(this.valueField, this.detailsValue.getSubItems(), resourceProvider);
        this.valueWidgets.addAll(entryWidgets);
        int valueFieldHeightHint = this.detailsValue.getSubItemCount() == 0 ? 10 : -1;
        GridData valueFieldGridData = (GridData)this.valueField.getLayoutData();
        valueFieldGridData.heightHint = valueFieldHeightHint;
        Color listBackground = resourceProvider.getColour(this.detailsValue.getBackgroundType());
        this.labelWidget.setBackground(listBackground);
        this.valueField.setBackground(listBackground);
        this.detailsField.setBackground(listBackground);
        this.valueField.pack();
        this.valueField.layout();
        this.detailsField.pack();
        this.detailsField.layout();
        this.detailsField.redraw();
    }

    protected List<Control> createEntryWidgets(Composite parent, List<DetailsValue> detailsValues, IDetailsResourceProvider resourceProvider) {
        ArrayList<Control> listEntryControls;
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 5;
        layout.marginWidth = 15;
        layout.horizontalSpacing = 5;
        parent.setLayout((Layout)layout);
        int entrySize = detailsValues.size();
        if (entrySize > 25) {
            listEntryControls = new ArrayList<Control>(1);
            Control showAllWidget = this.createShowAllWidget(parent, detailsValues, entrySize, resourceProvider);
            listEntryControls.add(showAllWidget);
        } else {
            listEntryControls = new ArrayList(25);
            for (DetailsValue subItem : detailsValues) {
                Control listEntryWidget = this.createSelectableEntryWidgetWithContextMenu(parent, subItem, 250, resourceProvider);
                listEntryControls.add(listEntryWidget);
            }
        }
        return listEntryControls;
    }

    private Control createShowAllWidget(final Composite parent, final List<DetailsValue> detailsValues, final int i, final IDetailsResourceProvider resourceProvider) {
        Color backgroundColor = resourceProvider.getColour(100);
        String text = NLS.bind((String)Messages.getString("DetailsElementList.ShowAll_title"), (Object)i);
        String tooltiptext = NLS.bind((String)Messages.getString("DetailsElementList.ShowAll_tooltip"), (Object)i);
        final Composite valueFieldLine = new Composite(parent, 0);
        valueFieldLine.setBackground(backgroundColor);
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        valueFieldLine.setLayoutData((Object)gridData);
        GridLayout layout = new GridLayout(2, false);
        layout.verticalSpacing = 0;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        valueFieldLine.setLayout((Layout)layout);
        valueFieldLine.setToolTipText(tooltiptext);
        Label iconLabel = new Label(valueFieldLine, 0);
        iconLabel.setImage(resourceProvider.getShowAllImage());
        iconLabel.setBackground(backgroundColor);
        iconLabel.setToolTipText(tooltiptext);
        gridData = new GridData();
        gridData.horizontalIndent = 0;
        gridData.verticalIndent = 0;
        iconLabel.setLayoutData((Object)gridData);
        Hyperlink showAllLabel = new Hyperlink(valueFieldLine, 0);
        showAllLabel.setBackground(backgroundColor);
        showAllLabel.setText(text);
        showAllLabel.setToolTipText(tooltiptext);
        showAllLabel.setFont(resourceProvider.getLabelFont());
        showAllLabel.setForeground(resourceProvider.getColour(4));
        showAllLabel.setUnderlined(true);
        showAllLabel.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
                IRunnableWithProgress runnable = new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        monitor.beginTask(NLS.bind((String)Messages.getString("DetailsElementList.progress"), (Object)i), i);
                        int worked = 0;
                        valueFieldLine.dispose();
                        for (DetailsValue subItem : detailsValues) {
                            DetailsElementList.this.createSelectableEntryWidgetWithContextMenu(parent, subItem, 250, resourceProvider);
                            monitor.worked(worked++);
                        }
                    }
                };
                ProgressMonitorDialog progressDialog = new ProgressMonitorDialog(parent.getShell());
                progressDialog.setOpenOnRun(true);
                try {
                    progressDialog.run(false, false, runnable);
                }
                catch (InvocationTargetException ex) {
                    LOGGER.error("InvocationTargetException", (Throwable)ex);
                }
                catch (InterruptedException ex) {
                    LOGGER.error("InterruptedException", (Throwable)ex);
                }
                resourceProvider.resourceResized();
            }
        });
        return valueFieldLine;
    }

    protected final Control createSelectableEntryWidgetWithContextMenu(Composite parent, DetailsValue detailsValueForEntry, int maxWidth, IDetailsResourceProvider resourceProvider) {
        String shortenedLabel;
        String nextLabel = detailsValueForEntry.getDisplayText();
        if (nextLabel == null || nextLabel.equals("")) {
            nextLabel = "-";
        }
        String toolTipText = (shortenedLabel = this.getShortenedLabel(nextLabel, maxWidth, resourceProvider)) != nextLabel ? detailsValueForEntry.getDisplayText() : null;
        Color backgroundColor = resourceProvider.getColour(detailsValueForEntry.getBackgroundType());
        ListEntryParameter parameter = null;
        if (detailsValueForEntry.getParameter() != null && detailsValueForEntry.getParameter() instanceof ListEntryParameter) {
            parameter = (ListEntryParameter)detailsValueForEntry.getParameter();
        }
        boolean needsContextMenu = parameter != null && parameter.getContextMenuActions() != null && !parameter.getContextMenuActions().isEmpty();
        MenuManager contextMenu = null;
        if (needsContextMenu) {
            contextMenu = this.createContextMenu(parameter.getContextMenuActions());
        }
        if (parameter != null && parameter.getDragSourceListener() != null) {
            this.dragListener = parameter.getDragSourceListener();
        }
        Composite valueFieldLine = new Composite(parent, 0);
        valueFieldLine.setBackground(backgroundColor);
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        valueFieldLine.setLayoutData((Object)gridData);
        GridLayout layout = new GridLayout(2, false);
        layout.verticalSpacing = 0;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        valueFieldLine.setLayout((Layout)layout);
        if (needsContextMenu) {
            this.registerContextMenu((Control)valueFieldLine, contextMenu);
        }
        valueFieldLine.setToolTipText(toolTipText);
        if (detailsValueForEntry.getIcon() != null) {
            Label iconLabel = new Label(valueFieldLine, 0);
            iconLabel.setImage(detailsValueForEntry.getIcon());
            iconLabel.setBackground(backgroundColor);
            iconLabel.setToolTipText(toolTipText);
            gridData = new GridData();
            gridData.horizontalIndent = 0;
            gridData.verticalIndent = 0;
            iconLabel.setLayoutData((Object)gridData);
            if (needsContextMenu) {
                this.registerContextMenu((Control)iconLabel, contextMenu);
            }
            if (this.dragListener != null) {
                this.addDragSourceListener((Control)iconLabel);
            }
        }
        if (parameter != null && parameter.getRunnableOnSelection() != null) {
            Composite hyperlinkField = new Composite(valueFieldLine, 0);
            gridData = new GridData();
            gridData.grabExcessHorizontalSpace = true;
            gridData.horizontalAlignment = 4;
            hyperlinkField.setLayoutData((Object)gridData);
            layout = new GridLayout();
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            hyperlinkField.setLayout((Layout)layout);
            hyperlinkField.setBackground(backgroundColor);
            if (needsContextMenu) {
                this.registerContextMenu((Control)hyperlinkField, contextMenu);
            }
            hyperlinkField.setToolTipText(toolTipText);
            UsableHyperlink valueWidget = new UsableHyperlink(hyperlinkField, 8);
            valueWidget.setLayoutData((Object)new GridData(4, 2, true, false));
            valueWidget.setText(shortenedLabel);
            this.applyLabel((Control)valueWidget, nextLabel, shortenedLabel, new ITextInControlSetter(){

                @Override
                public void setTextForControl(Control control, String text) {
                    ((UsableHyperlink)control).setText(text);
                }
            }, resourceProvider);
            valueWidget.setFont(resourceProvider.getValueFont());
            valueWidget.setForeground(valueWidget.getDisplay().getSystemColor(9));
            valueWidget.setUnderlined(true);
            valueWidget.setBackground(backgroundColor);
            valueWidget.setToolTipText(toolTipText);
            valueWidget.addHyperlinkListener((IHyperlinkListener)new DetailsViewHyperlinkListener(parameter.getRunnableOnSelection()));
            if (needsContextMenu) {
                this.registerContextMenu((Control)valueWidget, contextMenu);
            }
            if (this.dragListener != null) {
                this.addDragSourceListener((Control)valueWidget);
            }
        } else {
            StyledText valueWidget = new StyledText(valueFieldLine, 8);
            valueWidget.setLayoutData((Object)new GridData(4, 2, true, false));
            valueWidget.setText("");
            this.applyLabel((Control)valueWidget, nextLabel, shortenedLabel, new ITextInControlSetter(){

                @Override
                public void setTextForControl(Control control, String text) {
                    ((StyledText)control).setText(text);
                }
            }, resourceProvider);
            valueWidget.setFont(resourceProvider.getValueFont());
            valueWidget.setToolTipText(toolTipText);
            valueWidget.setBackground(backgroundColor);
            if (needsContextMenu) {
                this.registerContextMenu((Control)valueWidget, contextMenu);
            }
            if (this.dragListener != null) {
                this.addDragSourceListener((Control)valueWidget);
            }
        }
        return valueFieldLine;
    }

    private void applyLabel(final Control control, final String label_, String fixShortenedLabel, final ITextInControlSetter textInControlSetter, final IDetailsResourceProvider resourceProvider) {
        resourceProvider.addControlResizeDelayedTask(new Runnable(){

            @Override
            public void run() {
                int newWidth = control.getSize().x - 5;
                String shortenedLabel = DetailsElementList.this.getShortenedLabel(label_, newWidth, resourceProvider);
                textInControlSetter.setTextForControl(control, shortenedLabel);
            }
        });
    }

    private String getShortenedLabel(String label_, int maxWidth, IDetailsResourceProvider resourceProvider) {
        String shortenedLabel = label_;
        if (maxWidth > 0 && FigureUtilities.getTextExtents((String)label_, (Font)resourceProvider.getValueFont()).width > maxWidth) {
            shortenedLabel = String.valueOf(label_.substring(0, Math.max(0, label_.length() - 2))) + "...";
            while (shortenedLabel.length() > 3 && FigureUtilities.getTextExtents((String)shortenedLabel, (Font)resourceProvider.getValueFont()).width > maxWidth) {
                shortenedLabel = String.valueOf(shortenedLabel.substring(0, shortenedLabel.length() - 4)) + "...";
            }
        }
        return shortenedLabel;
    }

    private void addDragSourceListener(Control control) {
        DragSource dragSource = new DragSource(control, this.dragListener.getSupportedOperations());
        dragSource.addDragListener((DragSourceListener)this.dragListener);
        this.dragListener.setSWTDragAgent(dragSource);
    }

    private MenuManager createContextMenu(List<? extends IContributionItem> contributionItems) {
        MenuManager contextMenuManager = new MenuManager("#PopUp", CONTEXT_MENU_ID_PREFIX + UUIDGenerator.getUniqueID());
        for (IContributionItem iContributionItem : contributionItems) {
            contextMenuManager.add(iContributionItem);
        }
        return contextMenuManager;
    }

    private void registerContextMenu(Control widget, MenuManager contextMenu) {
        Menu contextMenuInstance = contextMenu.createContextMenu(widget);
        widget.setMenu(contextMenuInstance);
        contextMenu.setVisible(true);
    }

    public int getMinimumWidth() {
        return this.detailsField.computeSize((int)-1, (int)-1).x;
    }

    public void setHighlighted(boolean highlighted) {
        if (this.detailsValue != null) {
            Color background = highlighted ? this.currentRessourceProvider.getColour(101) : this.currentRessourceProvider.getColour(100);
            this.labelWidget.setBackground(background);
            this.valueField.setBackground(background);
            this.detailsField.setBackground(background);
            int c = 0;
            while (c < this.valueWidgets.size()) {
                Control valueWidget = this.valueWidgets.get(c);
                this.setBackgroundOnComposite(valueWidget, background);
                ++c;
            }
        }
    }

    private void setBackgroundOnComposite(Control control, Color background) {
        control.setBackground(background);
        if (control instanceof Composite) {
            Control[] controlArray = ((Composite)control).getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                this.setBackgroundOnComposite(child, background);
                ++n2;
            }
        }
    }

    public boolean showsEqualValues(DetailsElement detailsElement) {
        if (!(detailsElement instanceof DetailsElementList)) {
            return false;
        }
        DetailsElementList elementToCompare = (DetailsElementList)detailsElement;
        if (this.detailsValue == null || elementToCompare.detailsValue == null) {
            return false;
        }
        if (this.detailsValue.getSubItemCount() != elementToCompare.detailsValue.getSubItemCount()) {
            return false;
        }
        int c = 0;
        while (c < this.detailsValue.getSubItemCount()) {
            if (!this.isLineShowingEqualValues(this.detailsValue.getSubItem(c), elementToCompare.detailsValue.getSubItem(c))) {
                return false;
            }
            ++c;
        }
        return true;
    }

    protected boolean isLineShowingEqualValues(DetailsValue detailsValueForLine1, DetailsValue detailsValueForLine2) {
        if (detailsValueForLine1.getDisplayText() != null) {
            return detailsValueForLine1.getDisplayText().equals(detailsValueForLine2.getDisplayText());
        }
        return detailsValueForLine2.getDisplayText() == null;
    }

    private static interface ITextInControlSetter {
        public void setTextForControl(Control var1, String var2);
    }
}

