/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.global.gui.views.details.element;

import com.arcway.cockpit.client.base.interfaces.frame.gui.DetailsElement;
import com.arcway.cockpit.client.base.interfaces.frame.gui.IDetailsResourceProvider;
import com.arcway.cockpit.frame.client.global.gui.views.details.element.ImageElementParameter;
import com.arcway.cockpit.frame.client.global.gui.views.details.value.DetailsValue;
import com.arcway.cockpit.frame.client.global.gui.views.details.value.DetailsValueImage;
import com.arcway.lib.eclipse.gui.ImageInCanvasPainter;
import com.arcway.lib.eclipse.gui.dialogs.ImageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPartSite;

public class DetailsElementImage
extends DetailsElement {
    private static final int IMAGE_HORIZONTAL_INDENT = 0;
    private static final int IMAGE_VERTICAL_INDENT = 0;
    private static final int IMAGE_MAX_HEIGHT = 100;
    private final String label;
    private final DetailsValue detailsValue;
    private IDetailsResourceProvider currentRessourceProvider;
    private Composite detailsField;
    private StyledText labelWidget;
    private Canvas imageWidget;
    private ImageInCanvasPainter painter;
    private Image currentImage = null;
    private int currentImageWidth;

    public DetailsElementImage(String id, String label, DetailsValueImage detailsValue) {
        super(id);
        this.label = label;
        this.detailsValue = detailsValue;
    }

    public Control createWidget(Composite parent, final IWorkbenchPartSite site, IDetailsResourceProvider resourceProvider) {
        this.detailsField = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginTop = 4;
        layout.marginBottom = 4;
        layout.horizontalSpacing = 14;
        this.detailsField.setLayout((Layout)layout);
        this.labelWidget = new StyledText(this.detailsField, 8);
        this.labelWidget.setText(this.label);
        this.labelWidget.setFont(resourceProvider.getLabelFont());
        StyleRange styleRange = new StyleRange();
        styleRange.start = 0;
        styleRange.length = this.label.length();
        styleRange.fontStyle = 1;
        this.labelWidget.setStyleRange(styleRange);
        GridData gridData = new GridData(16384, 128, false, false);
        this.labelWidget.setLayoutData((Object)gridData);
        this.imageWidget = new Canvas(this.detailsField, 0);
        this.painter = new ImageInCanvasPainter(this.imageWidget, false, false);
        this.imageWidget.addPaintListener((PaintListener)this.painter);
        this.imageWidget.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
                if (DetailsElementImage.this.currentImage != null && !DetailsElementImage.this.currentImage.isDisposed()) {
                    ImageDialog dialog = new ImageDialog(DetailsElementImage.this.currentImage, site.getShell());
                    dialog.open();
                }
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
            }
        });
        gridData = new GridData(16384, 128, true, false);
        gridData.horizontalIndent = 0;
        gridData.verticalIndent = 0;
        this.imageWidget.setLayoutData((Object)gridData);
        return this.detailsField;
    }

    public void fillWidget(IDetailsResourceProvider resourceProvider) {
        Object parameter;
        this.currentRessourceProvider = resourceProvider;
        if (this.currentImage != null && !this.currentImage.isDisposed()) {
            this.currentImage.dispose();
        }
        if ((parameter = this.detailsValue.getParameter()) != null && parameter instanceof ImageElementParameter) {
            ImageDescriptor imageDescriptor = ((ImageElementParameter)parameter).getImageDescriptor();
            this.currentImage = imageDescriptor.createImage();
        } else {
            this.currentImage = null;
        }
        this.painter.setImage(this.currentImage);
        GridData imageWidgetGridData = (GridData)this.imageWidget.getLayoutData();
        if (this.currentImage != null) {
            float horizontalScalingFactor = 300.0f / (float)this.currentImage.getImageData().width;
            float verticalScalingFactor = 100.0f / (float)this.currentImage.getImageData().height;
            float scalingFactor = Math.min(Math.min(horizontalScalingFactor, verticalScalingFactor), 1.0f);
            int width = (int)((float)this.currentImage.getImageData().width * scalingFactor);
            int height = (int)((float)this.currentImage.getImageData().height * scalingFactor);
            imageWidgetGridData.widthHint = width;
            imageWidgetGridData.heightHint = height;
            this.currentImageWidth = width;
        } else {
            imageWidgetGridData.widthHint = 1;
            imageWidgetGridData.heightHint = 1;
            this.currentImageWidth = 1;
        }
        Color backgroundColour = resourceProvider.getColour(this.detailsValue.getBackgroundType());
        this.detailsField.setBackground(backgroundColour);
        this.labelWidget.setBackground(backgroundColour);
        this.imageWidget.setBackground(backgroundColour);
    }

    public int getMinimumWidth() {
        int labelMinWidth = this.labelWidget.computeSize((int)-1, (int)-1).x + ((GridLayout)this.detailsField.getLayout()).marginWidth * 2 + ((GridLayout)this.detailsField.getLayout()).marginLeft + ((GridLayout)this.detailsField.getLayout()).marginRight;
        int imageMinWidth = 0;
        if (this.currentImage != null && !this.currentImage.isDisposed()) {
            imageMinWidth = this.currentImageWidth + 0;
        }
        return Math.max(labelMinWidth, imageMinWidth);
    }

    public void setHighlighted(boolean highlighted) {
        if (this.detailsValue != null) {
            Color background = highlighted ? this.currentRessourceProvider.getColour(101) : this.currentRessourceProvider.getColour(100);
            this.detailsField.setBackground(background);
            this.labelWidget.setBackground(background);
            this.imageWidget.setBackground(background);
        }
    }

    public boolean showsEqualValues(DetailsElement detailsElement) {
        if (!(detailsElement instanceof DetailsElementImage)) {
            return false;
        }
        DetailsElementImage elementToCompare = (DetailsElementImage)detailsElement;
        if (this.detailsValue == null || elementToCompare.detailsValue == null) {
            return false;
        }
        return ((ImageElementParameter)this.detailsValue.getParameter()).getImageDescriptor().equals(((ImageElementParameter)elementToCompare.detailsValue.getParameter()).getImageDescriptor());
    }

    public void dispose() {
        if (this.currentImage != null && !this.currentImage.isDisposed()) {
            this.currentImage.dispose();
        }
    }
}

