/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.global.gui.views.details.element;

import com.arcway.cockpit.client.base.interfaces.frame.gui.DetailsElement;
import com.arcway.cockpit.client.base.interfaces.frame.gui.IDetailsResourceProvider;
import com.arcway.cockpit.frame.client.global.gui.views.details.element.DetailsElementExpandableListStateCache;
import com.arcway.cockpit.frame.client.global.gui.views.details.element.DetailsElementList;
import com.arcway.cockpit.frame.client.global.gui.views.details.provider.AbstractDetailsProvider2;
import com.arcway.cockpit.frame.client.global.gui.views.details.value.DetailsValue;
import com.arcway.cockpit.frame.client.global.gui.views.details.value.DetailsValueList;
import com.arcway.lib.eclipse.resources.ImageCache;
import com.arcway.lib.resource.IStreamResource;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;

public class DetailsElementExpandableList
extends DetailsElementList {
    private final String label;
    private final DetailsValue detailsValue;
    private AbstractDetailsProvider2 currentRessourceProvider;
    private Composite detailsField;
    protected ExpandableComposite expandableValueComposite;
    private List<Control> valueWidgets;
    private Composite valueComposite;
    private IStreamResource image;
    private boolean filled;

    public DetailsElementExpandableList(String id, String label, DetailsValueList detailsValue) {
        super(id, label, detailsValue);
        this.label = label;
        this.detailsValue = detailsValue;
    }

    public DetailsElementExpandableList(String id, String label, DetailsValueList detailsValue, IStreamResource image) {
        super(id, label, detailsValue);
        this.label = label;
        this.detailsValue = detailsValue;
        this.image = image;
    }

    protected DetailsElementExpandableList(String id, String label, DetailsValue detailsValue) {
        super(id, label, detailsValue);
        this.label = label;
        this.detailsValue = detailsValue;
    }

    @Override
    public final Control createWidget(final Composite parent, IWorkbenchPartSite site, final IDetailsResourceProvider resourceProvider) {
        this.detailsField = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.marginTop = 4;
        layout.marginBottom = 4;
        layout.horizontalSpacing = 14;
        this.detailsField.setLayout((Layout)layout);
        this.expandableValueComposite = new ExpandableComposite(this.detailsField, 16);
        if (this.image != null) {
            Label textClient = new Label((Composite)this.expandableValueComposite, 0);
            textClient.setImage(ImageCache.getImage((Display)site.getShell().getDisplay(), (IStreamResource)this.image));
            this.expandableValueComposite.setTextClient((Control)textClient);
        }
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        this.expandableValueComposite.setLayoutData((Object)gridData);
        layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 8;
        this.expandableValueComposite.setLayout((Layout)layout);
        this.expandableValueComposite.setText(this.label);
        this.expandableValueComposite.setFont(resourceProvider.getLabelFont());
        final DetailsElementExpandableListStateCache expandableStateCache = DetailsElementExpandableListStateCache.getExpandableListStateCache();
        this.expandableValueComposite.setExpanded(expandableStateCache.isExpanded(this.getId()));
        this.valueComposite = new Composite((Composite)this.expandableValueComposite, 0);
        this.expandableValueComposite.setClient((Control)this.valueComposite);
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        this.valueComposite.setLayoutData((Object)gridData);
        this.valueComposite.setVisible(this.expandableValueComposite.isExpanded());
        this.valueWidgets = new ArrayList<Control>();
        this.expandableValueComposite.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                if (e.getState()) {
                    expandableStateCache.addExpandedList(DetailsElementExpandableList.this.getId());
                    if (!DetailsElementExpandableList.this.filled) {
                        DetailsElementExpandableList.this.fillWidget(resourceProvider);
                    }
                    DetailsElementExpandableList.this.valueComposite.setVisible(true);
                } else {
                    expandableStateCache.addCollapsedList(DetailsElementExpandableList.this.getId());
                    DetailsElementExpandableList.this.valueComposite.setVisible(false);
                }
                Point oldSize = parent.getSize();
                Point newSize = parent.computeSize(oldSize.x, -1);
                parent.setSize(newSize);
                resourceProvider.resourceResized();
            }
        });
        return this.detailsField;
    }

    @Override
    public final void fillWidget(IDetailsResourceProvider resourceProvider) {
        this.currentRessourceProvider = (AbstractDetailsProvider2)resourceProvider;
        int c = 0;
        while (c < this.valueWidgets.size()) {
            this.valueWidgets.get(c).dispose();
            ++c;
        }
        this.valueWidgets.clear();
        if (this.expandableValueComposite.isExpanded()) {
            List<Control> entryWidgets = this.createEntryWidgets(this.valueComposite, this.detailsValue.getSubItems(), resourceProvider);
            this.valueWidgets.addAll(entryWidgets);
            this.filled = true;
        }
        Color listBackground = resourceProvider.getColour(this.detailsValue.getBackgroundType());
        this.expandableValueComposite.setBackground(listBackground);
        this.valueComposite.setBackground(listBackground);
        this.detailsField.setBackground(listBackground);
        this.expandableValueComposite.pack();
        this.expandableValueComposite.layout();
        this.expandableValueComposite.redraw();
        this.valueComposite.pack();
        this.valueComposite.layout();
    }

    @Override
    public void setHighlighted(boolean highlighted) {
        if (this.detailsValue != null) {
            Color background = highlighted ? this.currentRessourceProvider.getColour(101) : this.currentRessourceProvider.getColour(100);
            this.expandableValueComposite.setBackground(background);
            this.detailsField.setBackground(background);
            int c = 0;
            while (c < this.valueWidgets.size()) {
                Control valueWidget = this.valueWidgets.get(c);
                this.setBackgroundOnComposite(valueWidget, background);
                ++c;
            }
        }
    }

    @Override
    public int getMinimumWidth() {
        return this.detailsField.computeSize((int)-1, (int)-1).x;
    }

    private void setBackgroundOnComposite(Control control, Color background) {
        control.setBackground(background);
        if (control instanceof Composite) {
            Control[] controlArray = ((Composite)control).getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                this.setBackgroundOnComposite(child, background);
                ++n2;
            }
        }
    }

    @Override
    public boolean showsEqualValues(DetailsElement detailsElement) {
        if (!(detailsElement instanceof DetailsElementExpandableList)) {
            return false;
        }
        DetailsElementExpandableList elementToCompare = (DetailsElementExpandableList)detailsElement;
        if (this.detailsValue == null || elementToCompare.detailsValue == null) {
            return false;
        }
        if (this.detailsValue.getSubItemCount() != elementToCompare.detailsValue.getSubItemCount()) {
            return false;
        }
        int c = 0;
        while (c < this.detailsValue.getSubItemCount()) {
            if (!this.isLineShowingEqualValues(this.detailsValue.getSubItem(c), elementToCompare.detailsValue.getSubItem(c))) {
                return false;
            }
            ++c;
        }
        return true;
    }

    @Override
    protected boolean isLineShowingEqualValues(DetailsValue detailsValueForLine1, DetailsValue detailsValueForLine2) {
        if (detailsValueForLine1.getDisplayText() != null) {
            return detailsValueForLine1.getDisplayText().equals(detailsValueForLine2.getDisplayText());
        }
        return detailsValueForLine2.getDisplayText() == null;
    }

    public void dispose() {
    }
}

