/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.global.gui.views.details;

import com.arcway.cockpit.frame.client.global.FramePlugin;
import com.arcway.lib.eclipse.resources.ImageCache;
import com.arcway.lib.resource.IStreamResource;
import com.arcway.lib.resource.URLResource;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.forms.FormColors;

public class DetailsViewResources {
    private static final RGB COLOR_HIGHLIGHT = new RGB(200, 200, 255);
    private static final RGB COLOR_FOOTER = new RGB(245, 247, 250);
    private final Display display;
    private final Font titleFont;
    private final Font labelFont;
    private final Font valueFont;
    private final Color black;
    private final Color white;
    private final Color highColor;
    private final Color mediumColor;
    private final Color lowColor;
    private final Color highlightColor;
    private final Color footerColor;
    private final FormColors formsToolkitColors;
    private final Color titleColor;
    private final Image showAllImage;
    private boolean isDisposed = false;

    public DetailsViewResources(Display display, String defaultFontName) {
        this.display = display;
        int titleFontSize = FramePlugin.getDefault().getPluginPreferences().getInt("DetailsView.TitleFontSize");
        int labelValueFontSize = FramePlugin.getDefault().getPluginPreferences().getInt("DetailsView.LabelValueFontSize");
        this.titleFont = new Font((Device)display, defaultFontName, titleFontSize, 1);
        this.labelFont = new Font((Device)display, defaultFontName, labelValueFontSize, 1);
        this.valueFont = new Font((Device)display, defaultFontName, labelValueFontSize, 0);
        this.black = display.getSystemColor(2);
        this.white = display.getSystemColor(1);
        this.highColor = display.getSystemColor(3);
        this.mediumColor = display.getSystemColor(8);
        this.lowColor = display.getSystemColor(6);
        this.highlightColor = new Color((Device)display, COLOR_HIGHLIGHT);
        this.footerColor = new Color((Device)display, COLOR_FOOTER);
        this.formsToolkitColors = new FormColors(display);
        this.titleColor = this.formsToolkitColors.getColor("org.eclipse.ui.forms.TITLE");
        this.showAllImage = ImageCache.getImage((Display)display, (IStreamResource)new URLResource(FramePlugin.getIconURL("showAll.png")));
    }

    public final Font getTitleFont() {
        return this.titleFont;
    }

    public final Font getLabelFont() {
        return this.labelFont;
    }

    public final Font getValueFont() {
        return this.valueFont;
    }

    public final Color getColor(int colorCode) {
        switch (colorCode) {
            case 0: {
                return this.black;
            }
            case 1: {
                return this.lowColor;
            }
            case 2: {
                return this.mediumColor;
            }
            case 3: {
                return this.highColor;
            }
            case 4: {
                return this.titleColor;
            }
            case 100: {
                return this.white;
            }
            case 101: {
                return this.highlightColor;
            }
            case 102: {
                return this.footerColor;
            }
        }
        return this.black;
    }

    public Image getShowAllImage() {
        return this.showAllImage;
    }

    public Image getImage(IStreamResource imageResource) {
        return ImageCache.getImage((Display)this.display, (IStreamResource)imageResource);
    }

    public final void dispose() {
        if (!this.isDisposed) {
            if (this.titleFont != null) {
                this.titleFont.dispose();
            }
            if (this.labelFont != null) {
                this.labelFont.dispose();
            }
            if (this.valueFont != null) {
                this.valueFont.dispose();
            }
            if (this.highlightColor != null) {
                this.highlightColor.dispose();
            }
            if (this.formsToolkitColors != null) {
                this.formsToolkitColors.dispose();
            }
            if (this.footerColor != null) {
                this.footerColor.dispose();
            }
            this.isDisposed = true;
        }
    }
}

