/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.global.gui.views.details;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAddedItem;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeType;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IItemToCommit;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IModifiedItem;
import com.arcway.cockpit.client.base.interfaces.frame.propertychanges.IPropertyChanges;
import com.arcway.cockpit.client.base.interfaces.frame.propertychanges.IPropertyChangesListener;
import com.arcway.cockpit.client.base.interfaces.frame.propertychanges.PropertyChanges;
import com.arcway.cockpit.cockpitlib.client.gui.DeferredRefresher;
import com.arcway.cockpit.cockpitlib.client.gui.IRefreshableDisplay;
import com.arcway.cockpit.frame.client.global.ExtensionMgr;
import com.arcway.cockpit.frame.client.global.FramePlugin;
import com.arcway.cockpit.frame.client.global.Icons;
import com.arcway.cockpit.frame.client.global.Messages;
import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.global.gui.views.details.CopyUIDAction;
import com.arcway.cockpit.frame.client.global.gui.views.details.DetailsViewResources;
import com.arcway.cockpit.frame.client.global.gui.views.details.provider.EmptyDetailsProvider;
import com.arcway.cockpit.frame.client.global.gui.views.details.provider.IDetailsProvider;
import com.arcway.cockpit.frame.client.global.selection.CockpitSelectionManager;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.IProjectAgent;
import com.arcway.cockpit.frame.client.project.IProjectOpenListener;
import com.arcway.cockpit.frame.client.project.ProjectAgent;
import com.arcway.cockpit.frame.client.project.core.PropertyChange_AsynchronousUpdateFinished;
import com.arcway.cockpit.frame.client.project.modules.IProjectCloseListener;
import com.arcway.cockpit.frame.shared.message.EOUniqueElementRelationship;
import com.arcway.cockpit.frame.shared.message.IUniqueElementOccurrence;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.lib.eclipse.gui.print.PrintSWTControlAction;
import com.arcway.lib.java.collections.CollectionUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.part.ViewPart;

public class DetailsView
extends ViewPart
implements ISelectionListener,
IPropertyChangesListener,
IRefreshableDisplay,
IPartListener,
ISelectionProvider,
IProjectCloseListener,
IProjectOpenListener {
    private static final int MAX_HISTORY_ENTRIES = 25;
    private Map<String, IDetailsProvider> registeredDetailProviders;
    private Map<String, Composite> createdDetailComposites;
    private IDetailsProvider currentDetailsProvider;
    private final Set<ProjectAgent> activeProjectCloseListenerRegistrations = new HashSet<ProjectAgent>();
    private IProjectAgent isPropertyChangesListenerRegistered;
    private int currentlyShownElement = -1;
    private final ElementHistory elementHistory = new ElementHistory();
    private boolean doesNotShowAnyElement = true;
    private Composite details;
    private StackLayout stackLayout;
    private Composite emptyParent;
    private final EmptyDetailsProvider emptyDetailsProvider = new EmptyDetailsProvider();
    private IProjectAgent currentProjectAgent;
    private IMemento memento;
    private DeferredRefresher refresher;
    private Action editAction;
    private Action backAction;
    private Action forwardAction;
    private PrintSWTControlAction printAction;
    private CopyUIDAction copyUIDAction;
    private ISelection refresh_bySelectionEvent_lastSelection;
    private boolean refresh_byPropertyChangeEvent_isUpdateRequired;
    private Set<ICockpitProjectData> refresh_byPropertyChangeEvent_deletedItems;
    private boolean isInitialised = false;
    private boolean isDisposed = false;
    private DetailsViewResources detailsResources;
    private final Collection<ISelectionChangedListener> selectionChangeListeners = new ArrayList<ISelectionChangedListener>();
    private IStructuredSelection currentSelection;
    private DeferredRefresher controlResizeTaskDelayer;
    private List<Runnable> controlResizeDelayedTasks;

    public void createPartControl(final Composite parent) {
        this.details = new Composite(parent, 0);
        this.stackLayout = new StackLayout();
        this.details.setLayout((Layout)this.stackLayout);
        TableWrapData td = new TableWrapData();
        td.grabHorizontal = true;
        td.grabVertical = true;
        this.details.setLayoutData((Object)td);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.details, "com.arcway.cockpit.frame.help.details_view_index");
        this.emptyParent = new Composite(this.details, 0);
        this.emptyParent.setLayoutData((Object)td);
        this.registeredDetailProviders = ExtensionMgr.getDetailProviders();
        this.createdDetailComposites = new HashMap<String, Composite>(this.registeredDetailProviders.size());
        this.backAction = new Action(){

            public void run() {
                if (DetailsView.this.currentlyShownElement > 0) {
                    ICockpitProjectData previousData = DetailsView.this.elementHistory.get(DetailsView.this.currentlyShownElement - 1);
                    DetailsView.this.refresh(previousData, false);
                    DetailsView detailsView = DetailsView.this;
                    detailsView.currentlyShownElement = detailsView.currentlyShownElement - 1;
                }
                this.setEnabled(DetailsView.this.currentlyShownElement > 0);
                DetailsView.this.forwardAction.setEnabled(DetailsView.this.currentlyShownElement < DetailsView.this.elementHistory.size() - 1);
            }
        };
        this.backAction.setImageDescriptor(Icons.getImageDescriptorForNavBackButton());
        this.backAction.setEnabled(false);
        this.forwardAction = new Action(){

            public void run() {
                if (DetailsView.this.currentlyShownElement < DetailsView.this.elementHistory.size() - 1) {
                    ICockpitProjectData nextData = DetailsView.this.elementHistory.get(DetailsView.this.currentlyShownElement + 1);
                    DetailsView.this.refresh(nextData, false);
                    DetailsView detailsView = DetailsView.this;
                    detailsView.currentlyShownElement = detailsView.currentlyShownElement + 1;
                }
                this.setEnabled(DetailsView.this.currentlyShownElement < DetailsView.this.elementHistory.size() - 1);
                DetailsView.this.backAction.setEnabled(DetailsView.this.currentlyShownElement > 0);
            }
        };
        this.forwardAction.setImageDescriptor(Icons.getImageDescriptorForNavForwardButton());
        this.forwardAction.setEnabled(false);
        this.editAction = new Action(){

            public void run() {
                if (DetailsView.this.currentDetailsProvider != null) {
                    DetailsView.this.currentDetailsProvider.edit();
                }
            }
        };
        this.editAction.setText(Messages.getString("DetailsView.Edit_1"));
        this.editAction.setToolTipText(Messages.getString("DetailsView.Edit_2"));
        this.editAction.setImageDescriptor(FramePlugin.getImageDescriptor("pencil.png"));
        this.printAction = new PrintSWTControlAction();
        this.printAction.setSWTControl((Control)this.details);
        this.getViewSite().getActionBars().getMenuManager().add((IAction)this.printAction);
        this.copyUIDAction = new CopyUIDAction(this.getSite().getShell().getDisplay());
        this.getViewSite().getActionBars().getMenuManager().add((IAction)this.copyUIDAction);
        Display compDisplay = this.details.getDisplay();
        String defaultFontName = this.details.getFont().getFontData()[0].getName();
        this.detailsResources = new DetailsViewResources(compDisplay, defaultFontName);
        Set<Map.Entry<String, IDetailsProvider>> detailProviderEntries = this.registeredDetailProviders.entrySet();
        for (Map.Entry<String, IDetailsProvider> detailProviderEntry : detailProviderEntries) {
            Composite detailComposite = new Composite(this.details, 0);
            detailComposite.setLayoutData((Object)td);
            GridLayout gd = new GridLayout();
            gd.marginWidth = 0;
            gd.marginHeight = 0;
            detailComposite.setLayout((Layout)gd);
            IDetailsProvider detailsProvider = detailProviderEntry.getValue();
            detailsProvider.createPartControl(detailComposite, this.getSite(), DetailsView.getMemento(detailsProvider, this.memento), this.detailsResources);
            this.createdDetailComposites.put(detailProviderEntry.getKey(), detailComposite);
        }
        this.stackLayout.topControl = this.emptyParent;
        this.refresh_bySelectionEvent_lastSelection = null;
        this.refresh_byPropertyChangeEvent_isUpdateRequired = false;
        this.refresh_byPropertyChangeEvent_deletedItems = new HashSet<ICockpitProjectData>();
        this.refresher = new DeferredRefresher((IRefreshableDisplay)this);
        this.refresher.start();
        this.getSite().getPage().addPartListener((IPartListener)this);
        CockpitSelectionManager.getSelectionService(this.getSite().getWorkbenchWindow().getSelectionService()).addSelectionListener(this);
        this.controlResizeDelayedTasks = new ArrayList<Runnable>(500);
        this.controlResizeTaskDelayer = new DeferredRefresher(new IRefreshableDisplay(){

            public void refresh() {
                for (Runnable task : DetailsView.this.controlResizeDelayedTasks) {
                    task.run();
                }
            }

            public boolean isDisposed() {
                return parent.isDisposed();
            }

            public Display getDisplay() {
                return parent.getDisplay();
            }
        }, 150L, "DetailsView - ControlResizeTaskDelayer");
        this.controlResizeTaskDelayer.start();
        parent.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                DetailsView.this.controlResizeTaskDelayer.scheduleDeferredRefresh();
            }
        });
        ProjectAgent.addProjectOpenListener(this);
        this.isInitialised = true;
    }

    private void updateSelection(IStructuredSelection selection) {
        assert (selection != null);
        this.currentSelection = selection;
        for (ISelectionChangedListener listener : this.selectionChangeListeners) {
            listener.selectionChanged(new SelectionChangedEvent((ISelectionProvider)this, (ISelection)selection));
        }
    }

    private static IMemento getMemento(IDetailsProvider detailsProvider, IMemento parentMemento) {
        IMemento childMemento = null;
        if (parentMemento != null && (childMemento = parentMemento.getChild(detailsProvider.getID())) == null) {
            childMemento = parentMemento.createChild(detailsProvider.getID());
        }
        return childMemento;
    }

    public void setFocus() {
        this.details.setFocus();
    }

    public void dispose() {
        this.isInitialised = false;
        this.isDisposed = true;
        if (this.refresher != null) {
            this.refresher.halt();
            this.refresher = null;
        }
        if (this.controlResizeTaskDelayer != null) {
            this.controlResizeTaskDelayer.halt();
            this.controlResizeTaskDelayer = null;
        }
        while (!this.activeProjectCloseListenerRegistrations.isEmpty()) {
            ProjectAgent projectAgent = this.activeProjectCloseListenerRegistrations.iterator().next();
            projectAgent.removeProjectCloseListener(this);
            this.activeProjectCloseListenerRegistrations.remove(projectAgent);
        }
        CockpitSelectionManager.getSelectionService(this.getSite().getWorkbenchWindow().getSelectionService()).removeSelectionListener(this);
        ProjectAgent.removeProjectOpenListener(this);
        if (this.currentProjectAgent != null && this.currentProjectAgent.isOpened()) {
            this.deregisterPropertyChangesListener();
        }
        for (Composite composite : this.createdDetailComposites.values()) {
            composite.dispose();
        }
        this.detailsResources.dispose();
        this.registeredDetailProviders = null;
        this.createdDetailComposites = null;
        this.currentDetailsProvider = null;
        super.dispose();
    }

    private void activateEmptyDetailsProvider(String title) {
        if (this.currentDetailsProvider != null) {
            this.currentDetailsProvider.stopShowingElement();
        }
        this.currentDetailsProvider = this.emptyDetailsProvider;
        if (this.currentProjectAgent != null && this.currentProjectAgent.isOpened()) {
            this.deregisterPropertyChangesListener();
        }
        this.currentProjectAgent = null;
        this.setContentDescription(title);
        this.getViewSite().getActionBars().getToolBarManager().removeAll();
        this.getViewSite().getActionBars().getToolBarManager().add((IAction)this.backAction);
        this.getViewSite().getActionBars().getToolBarManager().add((IAction)this.forwardAction);
        this.getViewSite().getActionBars().getToolBarManager().add((IAction)this.editAction);
        this.editAction.setEnabled(false);
        this.printAction.setEnabled(false);
        this.copyUIDAction.setEnabled(false);
        this.getViewSite().getActionBars().updateActionBars();
        this.stackLayout.topControl = this.emptyParent;
        this.details.layout();
        this.updateSelection((IStructuredSelection)StructuredSelection.EMPTY);
    }

    private void activateDetailsProvider(String typeID, ICockpitProjectData selectedObject) {
        assert (typeID != null) : "typeID can't be null";
        assert (selectedObject != null) : "selectedObject can't be null";
        if (this.currentDetailsProvider != null) {
            this.currentDetailsProvider.stopShowingElement();
        }
        if (this.currentProjectAgent != null && this.currentProjectAgent.isOpened()) {
            this.deregisterPropertyChangesListener();
        }
        this.currentProjectAgent = null;
        IDetailsProvider registeredDetailsProvider = this.registeredDetailProviders.get(typeID);
        if (registeredDetailsProvider != null && registeredDetailsProvider.canBeDisplayed(selectedObject)) {
            this.currentDetailsProvider = registeredDetailsProvider;
            ProjectAgent projectAgent = ProjectMgr.getProjectMgr().getProjectAgent(selectedObject.getProjectUID());
            this.currentProjectAgent = projectAgent;
            if (this.currentProjectAgent.isOpened()) {
                this.registerPropertyChangesListener();
            }
            registeredDetailsProvider.showElement(selectedObject);
            this.setContentDescription(registeredDetailsProvider.getTitle(selectedObject));
            this.getViewSite().getActionBars().getToolBarManager().removeAll();
            this.getViewSite().getActionBars().getToolBarManager().add((IAction)this.backAction);
            this.getViewSite().getActionBars().getToolBarManager().add((IAction)this.forwardAction);
            IAction customEditAction = registeredDetailsProvider.getEditAction();
            if (customEditAction != null) {
                this.getViewSite().getActionBars().getToolBarManager().add(customEditAction);
            } else {
                this.getViewSite().getActionBars().getToolBarManager().add((IAction)this.editAction);
                this.editAction.setEnabled(registeredDetailsProvider.isEditEnabled());
            }
            this.printAction.updateEnablement();
            this.copyUIDAction.enableForUid(selectedObject.getUID());
            IAction[] actions = registeredDetailsProvider.getToolbarActions();
            if (actions != null) {
                IAction[] iActionArray = actions;
                int n = actions.length;
                int n2 = 0;
                while (n2 < n) {
                    IAction element = iActionArray[n2];
                    this.getViewSite().getActionBars().getToolBarManager().add(element);
                    ++n2;
                }
            }
            this.getViewSite().getActionBars().updateActionBars();
            this.stackLayout.topControl = (Control)this.createdDetailComposites.get(typeID);
            this.details.layout();
            this.updateSelection((IStructuredSelection)new StructuredSelection((Object)selectedObject));
        } else {
            this.activateEmptyDetailsProvider(this.emptyDetailsProvider.getTitle(null));
        }
    }

    private void registerPropertyChangesListener() {
        assert (this.isPropertyChangesListenerRegistered == null);
        this.isPropertyChangesListenerRegistered = this.currentProjectAgent;
        this.currentProjectAgent.getPropertyChangesListenerManager().register((IPropertyChangesListener)this, ICockpitProjectData.class);
        this.currentProjectAgent.getPropertyChangesListenerManager().register((IPropertyChangesListener)this, IAttributeType.class);
        this.currentProjectAgent.getPropertyChangesListenerManager().register((IPropertyChangesListener)this, PropertyChange_AsynchronousUpdateFinished.class);
        for (Class<?> typeToBeRegistered : this.currentDetailsProvider.getDataTypesToBeRegisteredForPropertyChangeEvents()) {
            this.currentProjectAgent.getPropertyChangesListenerManager().register((IPropertyChangesListener)this, typeToBeRegistered);
        }
    }

    private void deregisterPropertyChangesListener() {
        assert (this.isPropertyChangesListenerRegistered == this.currentProjectAgent);
        this.isPropertyChangesListenerRegistered = null;
        this.currentProjectAgent.getPropertyChangesListenerManager().deregister((IPropertyChangesListener)this);
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (!part.equals(this)) {
            this.refresh_bySelectionEvent_lastSelection = selection;
            this.refresher.scheduleDeferredRefresh();
        }
    }

    public void itemSelectedInDetailsElement(ICockpitProjectData item) {
        StructuredSelection selection = new StructuredSelection((Object)item);
        this.refresh_bySelectionEvent_lastSelection = selection;
        this.refresher.scheduleDeferredRefresh();
        this.refresher.executePendingRefreshNow();
        for (ISelectionChangedListener listener : this.selectionChangeListeners) {
            listener.selectionChanged(new SelectionChangedEvent((ISelectionProvider)this, (ISelection)selection));
        }
    }

    public void modelRefreshed(IPropertyChanges<?> changes, Class<?> clazz, String projectUID) {
        assert (ICockpitProjectData.class.isAssignableFrom(clazz) || clazz == PropertyChange_AsynchronousUpdateFinished.class || clazz.isAssignableFrom(IAttributeType.class) || clazz.isAssignableFrom(IUniqueElementOccurrence.class) || clazz.isAssignableFrom(EOUniqueElementRelationship.class));
        if (this.currentlyShownElement > -1) {
            boolean isRefresherToBeTriggered = false;
            if (IProjectAgent.class.isAssignableFrom(clazz)) {
                ProjectAgent projectAgent = ProjectMgr.getProjectMgr().getProjectAgent(projectUID);
                if (projectAgent == null || !projectAgent.isOpened()) {
                    this.refresh_byPropertyChangeEvent_isUpdateRequired = true;
                    isRefresherToBeTriggered = true;
                } else if (this.elementHistory.isCurrent((ICockpitProjectData)projectAgent) || this.elementHistory.isCurrent((ICockpitProjectData)projectAgent.getProject())) {
                    this.refresh_byPropertyChangeEvent_isUpdateRequired = true;
                    isRefresherToBeTriggered = true;
                }
            } else if (clazz == PropertyChange_AsynchronousUpdateFinished.class) {
                this.refresh_byPropertyChangeEvent_isUpdateRequired = true;
                isRefresherToBeTriggered = true;
            } else if (IAttributeType.class.isAssignableFrom(clazz)) {
                ICockpitProjectData iCockpitProjectData = this.elementHistory.getCurrent();
                if (iCockpitProjectData != null) {
                    HashSet changedAttributeTypes = new HashSet();
                    changedAttributeTypes.addAll(changes.getCreatedElements());
                    changedAttributeTypes.addAll(changes.getModifiedElements());
                    changedAttributeTypes.addAll(changes.getDeletedElements());
                    for (Iterator attributeTypeObject : changedAttributeTypes) {
                        IAttributeType attributeType = (IAttributeType)attributeTypeObject;
                        if (!iCockpitProjectData.getTypeID().equals(attributeType.getCockpitDataTypeID())) continue;
                        this.refresh_byPropertyChangeEvent_isUpdateRequired = true;
                        isRefresherToBeTriggered = true;
                        break;
                    }
                }
            } else if (ICockpitProjectData.class.isAssignableFrom(clazz)) {
                Collection modifiedItems;
                Collection collection = CollectionUtils.getTypedCollection((Collection)changes.getDeletedElements(), ICockpitProjectData.class);
                if (collection != null && !collection.isEmpty()) {
                    for (Object o : collection) {
                        ICockpitProjectData element;
                        if (!(o instanceof ICockpitProjectData) || !this.elementHistory.isCurrent(element = (ICockpitProjectData)o)) continue;
                        this.elementHistory.remove(element);
                        this.refresh_byPropertyChangeEvent_isUpdateRequired = true;
                    }
                    this.refresh_byPropertyChangeEvent_deletedItems.addAll(collection);
                    isRefresherToBeTriggered = true;
                }
                if ((modifiedItems = CollectionUtils.getTypedCollection((Collection)changes.getModifiedElements(), ICockpitProjectData.class)) != null) {
                    for (ICockpitProjectData element : modifiedItems) {
                        this.elementHistory.replace(element);
                        if (!this.elementHistory.isCurrent(element)) continue;
                        this.refresh_byPropertyChangeEvent_isUpdateRequired = true;
                        isRefresherToBeTriggered = true;
                    }
                }
            }
            if (!this.refresh_byPropertyChangeEvent_isUpdateRequired && this.currentDetailsProvider != null) {
                for (Class<IAttributeType> clazz2 : this.currentDetailsProvider.getDataTypesThatTriggerRefresh()) {
                    if (!clazz2.isAssignableFrom(clazz)) continue;
                    this.refresh_byPropertyChangeEvent_isUpdateRequired = true;
                    isRefresherToBeTriggered = true;
                }
            }
            if (isRefresherToBeTriggered) {
                this.refresher.scheduleDeferredRefresh();
            }
        }
    }

    public void refresh() {
        if (this.isInitialised) {
            if (this.refresh_bySelectionEvent_lastSelection != null && !this.refresh_bySelectionEvent_lastSelection.isEmpty() && this.refresh_bySelectionEvent_lastSelection instanceof IStructuredSelection) {
                boolean suitableItemFound = false;
                IStructuredSelection structuredSelection = (IStructuredSelection)this.refresh_bySelectionEvent_lastSelection;
                for (Object selectedObject : structuredSelection.toList()) {
                    ICockpitProjectData selectedCockpitObject;
                    if (selectedObject instanceof IAddedItem || selectedObject instanceof IModifiedItem) {
                        IItemToCommit item = (IItemToCommit)selectedObject;
                        if (item.getData() == null || !(item.getData() instanceof ICockpitProjectData) || this.refresh_byPropertyChangeEvent_deletedItems.contains(item.getData())) continue;
                        if (!this.elementHistory.isCurrent((ICockpitProjectData)item.getData()) || this.refresh_byPropertyChangeEvent_isUpdateRequired) {
                            this.refresh((ICockpitProjectData)item.getData(), true);
                        }
                        suitableItemFound = true;
                        break;
                    }
                    if (!(selectedObject instanceof ICockpitProjectData) || this.refresh_byPropertyChangeEvent_deletedItems.contains(selectedCockpitObject = (ICockpitProjectData)selectedObject)) continue;
                    if (!this.elementHistory.isCurrent(selectedCockpitObject) || this.refresh_byPropertyChangeEvent_isUpdateRequired) {
                        this.refresh(selectedCockpitObject, true);
                    }
                    suitableItemFound = true;
                    break;
                }
                if (!suitableItemFound) {
                    this.refresh(null, true);
                }
            } else if (this.refresh_byPropertyChangeEvent_isUpdateRequired) {
                if (!this.refresh_byPropertyChangeEvent_deletedItems.contains(this.elementHistory.getCurrent())) {
                    this.refresh(this.elementHistory.getCurrent(), false);
                } else {
                    this.refresh(null, true);
                }
            }
        }
        this.refresh_bySelectionEvent_lastSelection = null;
        this.refresh_byPropertyChangeEvent_isUpdateRequired = false;
        this.refresh_byPropertyChangeEvent_deletedItems = new HashSet<ICockpitProjectData>();
    }

    private void refresh(ICockpitProjectData newCurrentData, boolean isNew) {
        if (newCurrentData != null) {
            String typeID = newCurrentData.getTypeID();
            if (this.registeredDetailProviders.containsKey(typeID)) {
                ProjectAgent projectAgent = ProjectMgr.getProjectMgr().getProjectAgent(newCurrentData.getProjectUID());
                if (projectAgent != null && (projectAgent.isOpened() || newCurrentData instanceof IProjectAgent)) {
                    if (newCurrentData instanceof DeletedProjectData) {
                        this.doesNotShowAnyElement = true;
                        this.activateEmptyDetailsProvider(Messages.getString("DetailsView.data_was_deleted"));
                    } else {
                        if (isNew) {
                            this.elementHistory.add(newCurrentData);
                            this.registerProjectCloseListenerIfNecessary(projectAgent);
                        }
                        this.doesNotShowAnyElement = false;
                        this.activateDetailsProvider(typeID, newCurrentData);
                        this.triggerControlResizeTasks();
                        this.printAction.setJobName(this.currentDetailsProvider.getTitle(newCurrentData));
                    }
                } else {
                    this.doesNotShowAnyElement = true;
                    this.activateEmptyDetailsProvider(Messages.getString("DetailsView.project_was_closed"));
                }
            } else {
                this.doesNotShowAnyElement = true;
                this.activateEmptyDetailsProvider(this.emptyDetailsProvider.getTitle(null));
            }
        } else {
            this.doesNotShowAnyElement = true;
            this.activateEmptyDetailsProvider(this.emptyDetailsProvider.getTitle(null));
        }
    }

    private void registerProjectCloseListenerIfNecessary(ProjectAgent projectAgent) {
        if (!this.activeProjectCloseListenerRegistrations.contains(projectAgent)) {
            projectAgent.addProjectCloseListener(this);
            this.activeProjectCloseListenerRegistrations.add(projectAgent);
        }
    }

    @Override
    public void closeProject(IFrameProjectAgent projectAgent) {
        projectAgent.removeProjectCloseListener(this);
        this.activeProjectCloseListenerRegistrations.remove(projectAgent);
        if (this.currentProjectAgent == projectAgent) {
            this.deregisterPropertyChangesListener();
        }
        ArrayList<ICockpitProjectData> elementsOfClosedProject = new ArrayList<ICockpitProjectData>(this.elementHistory.size());
        Iterator<ICockpitProjectData> elementIt = this.elementHistory.iterator();
        while (elementIt.hasNext()) {
            ICockpitProjectData element = elementIt.next();
            if (!element.getProjectUID().equals(projectAgent.getProjectUID())) continue;
            elementsOfClosedProject.add(element);
        }
        ICockpitProjectData currentElement = this.elementHistory.getCurrent();
        boolean currentElementAffected = false;
        for (ICockpitProjectData element : elementsOfClosedProject) {
            if (!DetailsView.elementRequiresHistoryCleanupAtProjectClose(element)) continue;
            this.elementHistory.remove(element);
            if (currentElement != element) continue;
            currentElementAffected = true;
        }
        if (currentElementAffected) {
            this.modelRefreshed((IPropertyChanges<?>)new PropertyChanges(null, null, (Object)currentElement), ICockpitProjectData.class, projectAgent.getProjectUID());
        }
        Iterator<ICockpitProjectData> elementIt2 = this.elementHistory.iterator();
        while (elementIt2.hasNext()) {
            ICockpitProjectData element = elementIt2.next();
            if (element.getProjectUID().equals(projectAgent.getProjectUID())) assert (!DetailsView.elementRequiresHistoryCleanupAtProjectClose(element));
        }
    }

    private static boolean elementRequiresHistoryCleanupAtProjectClose(ICockpitProjectData element) {
        if (IProjectAgent.class.isAssignableFrom(element.getClass())) {
            return false;
        }
        return !(element instanceof DeletedProjectData);
    }

    @Override
    public void projectOpened(IProjectAgent projectAgent) {
        if (this.currentProjectAgent == projectAgent) {
            this.registerPropertyChangesListener();
        }
    }

    public void init(IViewSite site, IMemento newMemento) throws PartInitException {
        super.init(site, newMemento);
        site.setSelectionProvider((ISelectionProvider)this);
        this.memento = newMemento;
    }

    public boolean isDisposed() {
        return this.isDisposed;
    }

    public Display getDisplay() {
        return this.getSite().getWorkbenchWindow().getWorkbench().getDisplay();
    }

    public void partActivated(IWorkbenchPart part) {
        if (part == this) {
            this.refresher.executePendingRefreshNow();
        }
    }

    public void partBroughtToTop(IWorkbenchPart part) {
        if (part == this) {
            this.refresher.executePendingRefreshNow();
        }
    }

    public void partClosed(IWorkbenchPart part) {
    }

    public void partDeactivated(IWorkbenchPart part) {
    }

    public void partOpened(IWorkbenchPart part) {
    }

    public void executeEditAction() {
        this.editAction.run();
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangeListeners.add(listener);
    }

    public ISelection getSelection() {
        return this.currentSelection;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangeListeners.remove(listener);
    }

    public void setSelection(ISelection selection) {
        throw new UnsupportedOperationException("The selection can not be set explicitely for the details view");
    }

    public void addControlResizeDelayedTask(Runnable task) {
        this.controlResizeDelayedTasks.add(task);
    }

    public void clearControlResizeDelayedTasks() {
        this.controlResizeDelayedTasks.clear();
    }

    public void triggerControlResizeTasks() {
        this.controlResizeTaskDelayer.scheduleDeferredRefresh();
        this.controlResizeTaskDelayer.executePendingRefreshNow();
    }

    private static class DeletedProjectData
    implements ICockpitProjectData {
        private final String projectUID;
        private final String typeID;
        private final String uID;

        public DeletedProjectData(ICockpitProjectData deletedData) {
            this.projectUID = deletedData.getProjectUID();
            this.typeID = deletedData.getTypeID();
            this.uID = deletedData.getUID();
        }

        public String getProjectUID() {
            return this.projectUID;
        }

        public String getTypeID() {
            return this.typeID;
        }

        public String getUID() {
            return this.uID;
        }
    }

    private class ElementHistory {
        private final ArrayList<ICockpitProjectData> elements = new ArrayList();

        private ElementHistory() {
        }

        public boolean add(ICockpitProjectData element) {
            boolean wasAdded = false;
            ICockpitProjectData lastElement = null;
            if (this.elements.size() > 0) {
                lastElement = this.elements.get(this.elements.size() - 1);
            }
            ICockpitProjectData selectedElement = element;
            if (lastElement == null || !selectedElement.getUID().equals(lastElement.getUID()) || !selectedElement.getProjectUID().equals(lastElement.getProjectUID())) {
                if (DetailsView.this.currentlyShownElement == 25) {
                    this.moveEntriesOnStepForward();
                } else {
                    DetailsView detailsView = DetailsView.this;
                    detailsView.currentlyShownElement = detailsView.currentlyShownElement + 1;
                }
                if (DetailsView.this.currentlyShownElement == this.elements.size()) {
                    wasAdded = this.elements.add(element);
                } else {
                    this.elements.set(DetailsView.this.currentlyShownElement, element);
                    int i = DetailsView.this.currentlyShownElement + 1;
                    while (i < this.elements.size()) {
                        this.elements.remove(i);
                        ++i;
                    }
                    wasAdded = true;
                }
            }
            if (wasAdded) {
                DetailsView.this.backAction.setEnabled(DetailsView.this.currentlyShownElement > 0);
                DetailsView.this.forwardAction.setEnabled(false);
            }
            return wasAdded;
        }

        public Iterator<ICockpitProjectData> iterator() {
            return this.elements.iterator();
        }

        public int size() {
            return this.elements.size();
        }

        public ICockpitProjectData get(int index) {
            return this.elements.get(index);
        }

        private void moveEntriesOnStepForward() {
            int i = 0;
            while (i < this.elements.size() - 1) {
                this.elements.set(i, this.elements.get(i + 1));
                ++i;
            }
            this.elements.remove(this.elements.size() - 1);
        }

        public boolean remove(ICockpitProjectData element) {
            return this.replace(new DeletedProjectData(element));
        }

        public boolean replace(ICockpitProjectData renewedData) {
            boolean wasReplaced = false;
            int i = 0;
            while (i < this.elements.size()) {
                ICockpitProjectData contained = this.elements.get(i);
                if (contained.getUID().equals(renewedData.getUID()) && contained.getProjectUID().equals(renewedData.getProjectUID())) {
                    this.elements.set(i, renewedData);
                    wasReplaced = true;
                }
                ++i;
            }
            return wasReplaced;
        }

        public boolean isCurrent(ICockpitProjectData projectData) {
            if (!DetailsView.this.doesNotShowAnyElement && DetailsView.this.currentlyShownElement > -1) {
                ICockpitProjectData shown = this.elements.get(DetailsView.this.currentlyShownElement);
                return shown.getUID().equals(projectData.getUID()) && shown.getTypeID().equals(projectData.getTypeID()) && shown.getProjectUID().equals(projectData.getProjectUID());
            }
            return false;
        }

        public ICockpitProjectData getCurrent() {
            if (!DetailsView.this.doesNotShowAnyElement && DetailsView.this.currentlyShownElement > -1) {
                return this.elements.get(DetailsView.this.currentlyShownElement);
            }
            return null;
        }
    }
}

