/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.global.gui.views.details;

import com.arcway.cockpit.frame.client.global.FramePlugin;
import com.arcway.cockpit.frame.client.global.Messages;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Display;

public class CopyUIDAction
extends Action {
    private final Display display;
    private String uid;

    public CopyUIDAction(Display display) {
        this.display = display;
        this.setText(Messages.getString("CopyUIDAction.Text"));
        this.setToolTipText(Messages.getString("CopyUIDAction.Tooltip"));
        this.setImageDescriptor(FramePlugin.getImageDescriptor("clipboard_uid.gif"));
        this.setEnabled(false);
    }

    public void run() {
        Clipboard clipboard = new Clipboard(this.display);
        try {
            clipboard.setContents(new Object[]{this.uid}, new Transfer[]{TextTransfer.getInstance()});
        }
        finally {
            clipboard.dispose();
        }
    }

    public void enableForUid(String p_uid) {
        this.uid = p_uid;
        super.setEnabled(true);
    }

    public void setEnabled(boolean enabled) {
        assert (!enabled) : "Must specify a uid to enable this action => use #enableForUid(String p_uid)";
        if (!enabled) {
            this.uid = null;
        }
        super.setEnabled(enabled);
    }
}

