/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.global.gui.validators;

import com.arcway.cockpit.frame.client.global.Messages;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.IUniqueElement;
import com.arcway.cockpit.frame.shared.UniqueElementNormalizer;
import java.util.List;
import org.eclipse.jface.dialogs.IInputValidator;

public class RenameUniqueElementValidator
implements IInputValidator {
    private final IUniqueElement elementToRename;
    private final IFrameProjectAgent projectAgent;

    public RenameUniqueElementValidator(IUniqueElement elementToRename, IFrameProjectAgent projectAgent) {
        assert (elementToRename != null);
        this.elementToRename = elementToRename;
        this.projectAgent = projectAgent;
    }

    public String isValid(String newText) {
        if (newText == null || newText.equals("")) {
            return Messages.getString("RenameUniqueElementValidator.Name_can__t_be_empty_2");
        }
        if (this.uniqueElementWithSameNameExists(newText)) {
            return Messages.getString("RenameUniqueElementValidator.A_Unique_Element_with_that_name_already_exists_3");
        }
        if (newText.length() > 255) {
            return String.valueOf(Messages.getString("RenameUniqueElementValidator.must_not_contain")) + 255 + Messages.getString("RenameUniqueElementValidator.characters");
        }
        if (this.containsInvalidCharacter(newText)) {
            return Messages.getString("RenameUniqueElementValidator.contains_invalid_character");
        }
        return null;
    }

    private boolean containsInvalidCharacter(String name) {
        if (name.indexOf(42) >= 0) {
            return true;
        }
        return name.indexOf(63) >= 0;
    }

    private boolean uniqueElementWithSameNameExists(String normalizedName) {
        List<IUniqueElement> uniqueElements = this.projectAgent.getFrameUniqueElementMgr().getUniqueElements(this.elementToRename.getElementTypeID());
        for (IUniqueElement ue : uniqueElements) {
            String name = UniqueElementNormalizer.normalizeValue((String)ue.getElementName());
            if (name == null) {
                name = "";
            }
            if (!name.equals(normalizedName) || ue.getUID().equals(this.elementToRename.getUID())) continue;
            return true;
        }
        return false;
    }
}

