/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.global.gui.validators;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.stakeholders.IStakeholder;
import com.arcway.cockpit.frame.client.global.Messages;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import java.util.Collection;
import org.eclipse.jface.dialogs.IInputValidator;

public class RenameStakeholderValidator
implements IInputValidator {
    private String stakeholderUID;
    private final IFrameProjectAgent projectAgent;

    public RenameStakeholderValidator(IFrameProjectAgent projectAgent) {
        this.projectAgent = projectAgent;
    }

    public RenameStakeholderValidator(IFrameProjectAgent projectAgent, String stakeholderUID) {
        this.projectAgent = projectAgent;
        this.stakeholderUID = stakeholderUID;
    }

    public void setStakeholder(IStakeholder stakeholder) {
        this.stakeholderUID = stakeholder == null ? null : stakeholder.getUID();
    }

    public String isValid(String newText) {
        if (newText == null || newText.trim().equals("")) {
            return Messages.getString("RenameStakeholderValidator.Please_enter_a_name_for_the_stakeholder_3");
        }
        if (this.stakeholderExists(newText.trim())) {
            return Messages.getString("RenameStakeholderValidator.There_is_already_a_stakeholder_with_the_same_name_4");
        }
        return null;
    }

    private boolean stakeholderExists(String name) {
        Collection stakeholders = this.projectAgent.getFrameStakeholderManager().getStakeholders();
        for (IStakeholder stakeholder : stakeholders) {
            if (!stakeholder.getStakeholderName().equalsIgnoreCase(name)) continue;
            if (this.stakeholderUID != null && !stakeholder.getUID().equals(this.stakeholderUID)) {
                return true;
            }
            if (this.stakeholderUID != null) continue;
            return true;
        }
        return false;
    }
}

