/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.global.gui.properties.providers;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttribute;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeOwner;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeType;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.stakeholders.IStakeholder;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.stakeholders.IStakeholderRole;
import com.arcway.cockpit.frame.client.global.gui.properties.providers.PropertyUserDefinedAttributes;
import com.arcway.cockpit.frame.client.global.license.IClientFunctionLicenseType2;
import com.arcway.cockpit.frame.client.global.license.licensetypes.ClientFunctionLicenseTypeModifyProjectsAndSectionsAndPlans;
import com.arcway.cockpit.frame.client.global.license.licensetypes.ClientFunctionLicenseTypeModifyReportTemplates;
import com.arcway.cockpit.frame.client.global.license.licensetypes.ClientFunctionLicenseTypeModifyRolesAndStakeholders;
import com.arcway.cockpit.frame.client.global.license.licensetypes.ClientFunctionLicenseTypeModifyUniqueElements;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.IProjectAgent;
import com.arcway.cockpit.frame.client.project.core.framedata.IAttributeOwnerRW;
import com.arcway.cockpit.frame.client.project.core.framedata.IReportOutputtemplate;
import com.arcway.cockpit.frame.client.project.core.framedata.IReportTemplate;
import com.arcway.cockpit.frame.client.project.core.framedata.IReportTemplateFolder;
import com.arcway.cockpit.frame.client.project.core.sectionsandplans.plan.IPlan;
import com.arcway.cockpit.frame.client.project.core.sectionsandplans.sections.ISection;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.IUniqueElement;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import java.util.Collection;
import java.util.Iterator;

public class PropertyUserDefinedAttributesFrame
extends PropertyUserDefinedAttributes {
    @Override
    public boolean providesPropertiesFor(ICockpitProjectData[] elements) {
        if (elements.length == 1) {
            if (elements[0] instanceof IAttributeOwnerRW) {
                return !this.getUserDefinedAttributeTypes((IAttributeOwner)elements[0]).isEmpty();
            }
            if (elements[0] instanceof IFrameProjectAgent) {
                IFrameProjectAgent pa = (IFrameProjectAgent)elements[0];
                return pa.isOpened();
            }
        }
        return false;
    }

    private Collection<IAttribute> getUserDefinedAttributeTypes(IAttributeOwner attrOwner) {
        Collection allTypes = attrOwner.getAllAttributes();
        Iterator i = allTypes.iterator();
        while (i.hasNext()) {
            IAttribute attribute = (IAttribute)i.next();
            IAttributeType type = attrOwner.getAttributeType(attribute.getAttributeTypeID());
            if (type.isUserDefined()) continue;
            i.remove();
        }
        return allTypes;
    }

    @Override
    public IClientFunctionLicenseType2 getRequiredLicenseTypeForModifying(ICockpitProjectData element) {
        if (element instanceof IProjectAgent || element instanceof ISection || element instanceof IPlan) {
            return ClientFunctionLicenseTypeModifyProjectsAndSectionsAndPlans.getInstance();
        }
        if (element instanceof IStakeholder || element instanceof IStakeholderRole) {
            return ClientFunctionLicenseTypeModifyRolesAndStakeholders.getInstance();
        }
        if (element instanceof IUniqueElement) {
            return ClientFunctionLicenseTypeModifyUniqueElements.getInstance();
        }
        if (element instanceof IReportTemplateFolder || element instanceof IReportTemplate || element instanceof IReportOutputtemplate) {
            return ClientFunctionLicenseTypeModifyReportTemplates.getInstance();
        }
        return null;
    }
}

