/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.global.gui.properties.providers;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttribute;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeOwner;
import com.arcway.cockpit.client.base.interfaces.frame.permissions.EXNoPermission;
import com.arcway.cockpit.frame.client.global.Icons;
import com.arcway.cockpit.frame.client.global.Messages;
import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.global.gui.properties.IObjectTypeCategoryChangeListener;
import com.arcway.cockpit.frame.client.global.gui.properties.IPropertiesDialog;
import com.arcway.cockpit.frame.client.global.gui.properties.IPropertiesListEntry;
import com.arcway.cockpit.frame.client.global.license.IClientFunctionLicenseType2;
import com.arcway.cockpit.frame.client.global.license.licensetypes.ClientFunctionLicenseTypeCustomProperties;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.ProjectAgent;
import com.arcway.cockpit.frame.client.project.core.categories.ObjectTypeCategory;
import com.arcway.cockpit.frame.client.project.core.framedata.CustomPropertiesForModuleData;
import com.arcway.cockpit.frame.client.project.core.framedata.IAttributeModificationManager;
import com.arcway.cockpit.frame.client.project.core.framedata.IAttributeOwnerRW;
import com.arcway.cockpit.frame.client.project.core.framedata.transactionmanagement.ILocksAndPermissionsTransactionController;
import com.arcway.cockpit.frame.client.project.core.framedata.transactionmanagement.LocksAndPermissionsTransactionController;
import com.arcway.cockpit.frame.client.project.core.locking.EXNoLock;
import com.arcway.cockpit.frame.client.project.core.userdefinedattributetypes.AttributeTypesComposite;
import com.arcway.cockpit.frame.client.project.modules.IFMCAModule;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.ui.IModificationProblem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.jface.dialogs.DialogTray;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.help.IWorkbenchHelpSystem;

public abstract class PropertyUserDefinedAttributes
implements IPropertiesListEntry,
IObjectTypeCategoryChangeListener {
    private static final ILogger logger = Logger.getLogger(PropertyUserDefinedAttributes.class);
    private IAttributeOwner attributeOwner;
    private AttributeTypesComposite attributeTypesComposite;
    private ILocksAndPermissionsTransactionController transactionController;
    private Collection<IAttribute> newAttributes;
    private IFrameProjectAgent projectAgent;
    private IPropertiesDialog dialog;
    private ScrolledComposite scrolledComposite;

    @Override
    public IModificationProblem init(ICockpitProjectData[] elements, IPropertiesDialog newDialog, boolean forCreation) {
        if (elements[0] instanceof IAttributeOwner) {
            this.attributeOwner = (IAttributeOwner)elements[0];
        } else if (elements[0] instanceof IFrameProjectAgent) {
            IFrameProjectAgent pa = (IFrameProjectAgent)elements[0];
            this.attributeOwner = pa.getProjectMetaDataManager().getProject();
        } else {
            ProjectAgent pa = ProjectMgr.getProjectMgr().getProjectAgent(elements[0].getProjectUID());
            IFMCAModule module = pa.getModuleController().getModuleForData(elements[0]);
            if (module != null) {
                IAttributeModificationManager modManager = module.getAttributeModificationManager(elements[0]);
                IAttributeOwner owner = module.getAttributeOwner(elements[0]);
                if (modManager != null && owner != null) {
                    this.attributeOwner = new CustomPropertiesForModuleData(owner, modManager);
                }
            }
        }
        this.setDialog(newDialog);
        return null;
    }

    @Override
    public void setDialog(IPropertiesDialog dialog) {
        this.projectAgent = ProjectMgr.getProjectMgr().getProjectAgent(dialog.getProjectUID());
        this.dialog = dialog;
    }

    @Override
    public String getPropertyName() {
        return Messages.getString("PropertyUserDefinedAttributes.custom_properties");
    }

    @Override
    public Image getPropertyImage() {
        return Icons.getImageForUserDefinedAttributeTypes();
    }

    @Override
    public Composite getPropertyPage(Composite parent) {
        this.dialog.setTitle(Messages.getString("PropertyUserDefinedAttributes.custom_properties"), this);
        this.dialog.setMessage(Messages.getString("PropertyUserDefinedAttributes.set_the_value"), 0, this);
        IWorkbenchHelpSystem helpSystem = this.dialog.getWorkbenchPage().getWorkbenchWindow().getWorkbench().getHelpSystem();
        if (this.dialog instanceof TrayDialog) {
            DialogTray tray = ((TrayDialog)this.dialog).getTray();
            if (tray != null) {
                helpSystem.displayHelp("com.arcway.cockpit.frame.help.properties_dialog");
            } else {
                helpSystem.setHelp((Control)this.dialog.getShell(), "com.arcway.cockpit.frame.help.properties_dialog");
            }
        }
        this.scrolledComposite = new ScrolledComposite(parent, 768);
        this.scrolledComposite.setLayout((Layout)new GridLayout());
        this.attributeTypesComposite = new AttributeTypesComposite(this.attributeOwner, (Composite)this.scrolledComposite, false, true, false, this.dialog, this);
        this.attributeTypesComposite.create(new GridData(1808));
        Composite attributeTypesCompositeBaseComposite = this.attributeTypesComposite.getComposite();
        this.scrolledComposite.setContent((Control)attributeTypesCompositeBaseComposite);
        this.scrolledComposite.setExpandHorizontal(true);
        this.scrolledComposite.setExpandVertical(true);
        this.adjustScrolledComposite();
        return this.scrolledComposite;
    }

    @Override
    public IPropertiesListEntry[] getPropertyChildren1() {
        return null;
    }

    @Override
    public boolean hasChanges() {
        return this.attributeTypesComposite.isModified();
    }

    public Collection<IModificationProblem> requestCommit() {
        ArrayList<IModificationProblem> modProblems = new ArrayList<IModificationProblem>();
        if (this.attributeOwner instanceof IAttributeOwnerRW) {
            IAttributeOwnerRW rw = (IAttributeOwnerRW)this.attributeOwner;
            this.newAttributes = this.attributeTypesComposite.getNewAttributes();
            this.transactionController = new LocksAndPermissionsTransactionController(this.projectAgent);
            for (IAttribute attribute : this.newAttributes) {
                rw.requestAttributeModificationPermission(attribute, this.transactionController);
            }
            modProblems.addAll(this.transactionController.execute());
        }
        modProblems.addAll(this.attributeTypesComposite.getModificationProblems(false));
        return modProblems;
    }

    @Override
    public void commitPropertyChanges1() {
        if (this.attributeOwner instanceof IAttributeOwnerRW) {
            IAttributeOwnerRW rw = (IAttributeOwnerRW)this.attributeOwner;
            for (IAttribute attribute : this.newAttributes) {
                try {
                    rw.setAttribute(attribute);
                }
                catch (EXNoPermission e) {
                    logger.error("could not execute", (Throwable)e);
                }
                catch (EXNoLock e) {
                    logger.error("could not execute", (Throwable)e);
                }
            }
        }
    }

    @Override
    public void rollbackCommitRequest() {
        this.transactionController.rollback();
        this.transactionController = null;
        this.newAttributes = null;
    }

    @Override
    public void cancelPropertyChanges1() {
    }

    @Override
    public void disposeResources() {
        if (this.attributeTypesComposite != null) {
            this.attributeTypesComposite.dispose();
        }
    }

    @Override
    public int getTypeOfPage() {
        return 30;
    }

    @Override
    public Collection<IModificationProblem> getModificationProblems() {
        if (this.attributeTypesComposite != null) {
            return this.attributeTypesComposite.getModificationProblems(true);
        }
        return Collections.emptySet();
    }

    @Override
    public IClientFunctionLicenseType2 getRequiredLicenseTypeForShowing(ICockpitProjectData element) {
        return ClientFunctionLicenseTypeCustomProperties.getInstance();
    }

    @Override
    public void categoryChanged(ObjectTypeCategory category) {
        this.attributeTypesComposite.categoryChanged(category);
        this.adjustScrolledComposite();
    }

    private void adjustScrolledComposite() {
        Point preferedSize = this.attributeTypesComposite.getComposite().computeSize(-1, -1);
        this.attributeTypesComposite.getComposite().setSize(preferedSize);
        this.scrolledComposite.setMinSize(0, preferedSize.y);
    }
}

