/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.global.gui.properties.providers;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.stakeholders.IStakeholder;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.stakeholders.IStakeholderRole;
import com.arcway.cockpit.client.base.interfaces.frame.permissions.EXNoPermission;
import com.arcway.cockpit.frame.client.global.Icons;
import com.arcway.cockpit.frame.client.global.Messages;
import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.global.gui.dialogs.stakeholder.StakeholderAssignmentPage;
import com.arcway.cockpit.frame.client.global.gui.properties.IPropertiesDialog;
import com.arcway.cockpit.frame.client.global.gui.properties.IPropertiesListEntry;
import com.arcway.cockpit.frame.client.global.license.IClientFunctionLicenseType2;
import com.arcway.cockpit.frame.client.global.license.licensetypes.ClientFunctionLicenseTypeModifyRolesAndStakeholders;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.IFrameStakeholderManager;
import com.arcway.cockpit.frame.client.project.core.locking.EXNoLock;
import com.arcway.cockpit.frame.client.project.core.stakeholders.IStakeholderRoleConnectionAddID;
import com.arcway.cockpit.frame.client.project.core.stakeholders.IStakeholderRoleRW;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.ui.IModificationProblem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;

public class PropertyStakeholdersOfRole
implements IPropertiesListEntry {
    private static final ILogger logger = Logger.getLogger(PropertyStakeholdersOfRole.class);
    private IFrameProjectAgent projectAgent;
    private IPropertiesDialog dialog;
    private IStakeholderRole role;
    private boolean mayEdit = false;
    private Image stakeholderImage;
    private final Set<IStakeholder> stakeholdersToAdd = new HashSet<IStakeholder>();
    private final Set<IStakeholder> stakeholdersToRemove = new HashSet<IStakeholder>();
    private final Collection<IModificationProblem> modificationProblems = new ArrayList<IModificationProblem>();
    private Collection<IStakeholderRoleConnectionAddID> stakeholderRoleConnectionAddIDs;
    private IFrameStakeholderManager.ILockReference deleteLockReference;

    @Override
    public IModificationProblem init(ICockpitProjectData[] elements, IPropertiesDialog newDialog, boolean forCreation) {
        this.modificationProblems.clear();
        this.dialog = newDialog;
        this.projectAgent = ProjectMgr.getProjectMgr().getProjectAgent(elements[0].getProjectUID());
        this.role = (IStakeholderRole)elements[0];
        IModificationProblem modProblem = this.projectAgent.getFrameStakeholderManager().checkStakeholderRoleConnectionChangePermission();
        if (modProblem != null) {
            this.modificationProblems.add(modProblem);
            this.mayEdit = false;
        } else {
            this.mayEdit = true;
        }
        return null;
    }

    @Override
    public Collection<IModificationProblem> getModificationProblems() {
        return this.modificationProblems;
    }

    @Override
    public void setDialog(IPropertiesDialog dialog) {
        this.dialog = dialog;
    }

    @Override
    public boolean providesPropertiesFor(ICockpitProjectData[] elements) {
        if (elements.length == 1) {
            return elements[0] instanceof IStakeholderRoleRW;
        }
        return false;
    }

    @Override
    public String getPropertyName() {
        return Messages.getString("PropertyStakeholdersOfRole.stakeholders");
    }

    @Override
    public Image getPropertyImage() {
        if (this.stakeholderImage == null) {
            this.stakeholderImage = Icons.getImageDescriptorForStakeholder().createImage();
        }
        return this.stakeholderImage;
    }

    @Override
    public Composite getPropertyPage(Composite parent) {
        this.stakeholdersToAdd.clear();
        this.stakeholdersToRemove.clear();
        this.dialog.setTitle(String.valueOf(Messages.getString("PropertyGeneralStakeholderRole.role")) + this.role.getName(), this);
        this.dialog.setMessage(Messages.getString("PropertyStakeholdersOfRole.view_add_remove"), 0, this);
        Composite composite = StakeholderAssignmentPage.createPropertyPage(parent, this.stakeholdersToAdd, this.stakeholdersToRemove, this.role, this.projectAgent);
        if (!this.mayEdit) {
            int i = 0;
            while (i < composite.getChildren().length) {
                composite.getChildren()[i].setEnabled(false);
                ++i;
            }
        }
        return composite;
    }

    @Override
    public IPropertiesListEntry[] getPropertyChildren1() {
        return null;
    }

    @Override
    public boolean hasChanges() {
        return !this.stakeholdersToAdd.isEmpty() || !this.stakeholdersToRemove.isEmpty();
    }

    public Collection<IModificationProblem> requestCommit() {
        ArrayList<IModificationProblem> modProblems = new ArrayList<IModificationProblem>();
        if (!this.stakeholdersToRemove.isEmpty()) {
            this.deleteLockReference = new IFrameStakeholderManager.ILockReference();
            IModificationProblem modProblem = this.projectAgent.getFrameStakeholderManager().requestStakeholderRoleConnectionDeletePermission(this.deleteLockReference);
            if (modProblem != null) {
                modProblems.add(modProblem);
            }
        }
        this.stakeholderRoleConnectionAddIDs = new ArrayList<IStakeholderRoleConnectionAddID>();
        for (IStakeholder stakeholderToAdd : this.stakeholdersToAdd) {
            IStakeholderRoleConnectionAddID stakeholderRoleConnectionAddID = this.projectAgent.getFrameStakeholderManager().requestStakeholderRoleConnectionAddPermission(stakeholderToAdd, this.role);
            if (stakeholderRoleConnectionAddID.getModificationProblem() == null) {
                this.stakeholderRoleConnectionAddIDs.add(stakeholderRoleConnectionAddID);
                continue;
            }
            modProblems.add(stakeholderRoleConnectionAddID.getModificationProblem());
        }
        return modProblems;
    }

    @Override
    public void commitPropertyChanges1() {
        for (IStakeholder iStakeholder : this.stakeholdersToRemove) {
            try {
                this.projectAgent.getFrameStakeholderManager().deleteStakeholderRoleConnection(iStakeholder, this.role);
            }
            catch (EXNoLock e) {
                logger.error("could not execute", (Throwable)e);
            }
            catch (EXNoPermission e) {
                logger.error("could not execute", (Throwable)e);
            }
        }
        for (IStakeholderRoleConnectionAddID iStakeholderRoleConnectionAddID : this.stakeholderRoleConnectionAddIDs) {
            try {
                this.projectAgent.getFrameStakeholderManager().addStakeholderRoleConnection(iStakeholderRoleConnectionAddID);
            }
            catch (EXNoPermission e) {
                logger.error("could not execute", (Throwable)e);
            }
        }
        this.destroy();
    }

    @Override
    public void rollbackCommitRequest() {
        if (this.deleteLockReference != null) {
            this.deleteLockReference.lock.release();
            this.deleteLockReference = null;
        }
        if (this.stakeholderRoleConnectionAddIDs != null) {
            for (IStakeholderRoleConnectionAddID addID : this.stakeholderRoleConnectionAddIDs) {
                addID.releaseLocks();
            }
            this.stakeholderRoleConnectionAddIDs.clear();
        }
    }

    @Override
    public void cancelPropertyChanges1() {
        this.destroy();
    }

    @Override
    public void disposeResources() {
    }

    private void destroy() {
        if (this.stakeholderImage != null) {
            this.stakeholderImage.dispose();
        }
        this.stakeholderImage = null;
    }

    @Override
    public int getTypeOfPage() {
        return 20;
    }

    @Override
    public IClientFunctionLicenseType2 getRequiredLicenseTypeForModifying(ICockpitProjectData element) {
        return ClientFunctionLicenseTypeModifyRolesAndStakeholders.getInstance();
    }

    @Override
    public IClientFunctionLicenseType2 getRequiredLicenseTypeForShowing(ICockpitProjectData element) {
        return null;
    }
}

