/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.global.gui.properties.providers;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.stakeholders.IStakeholder;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.stakeholders.IStakeholderRole;
import com.arcway.cockpit.client.base.interfaces.frame.permissions.EXNoPermission;
import com.arcway.cockpit.frame.client.global.Icons;
import com.arcway.cockpit.frame.client.global.Messages;
import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.global.gui.dialogs.stakeholder.StakeholderRolesAssignmentPage;
import com.arcway.cockpit.frame.client.global.gui.properties.IPropertiesDialog;
import com.arcway.cockpit.frame.client.global.gui.properties.IPropertiesListEntry;
import com.arcway.cockpit.frame.client.global.license.IClientFunctionLicenseType2;
import com.arcway.cockpit.frame.client.global.license.licensetypes.ClientFunctionLicenseTypeModifyRolesAndStakeholders;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.IFrameStakeholderManager;
import com.arcway.cockpit.frame.client.project.core.locking.EXNoLock;
import com.arcway.cockpit.frame.client.project.core.stakeholders.IStakeholderRW;
import com.arcway.cockpit.frame.client.project.core.stakeholders.IStakeholderRoleConnectionAddID;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.ui.IModificationProblem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;

public class PropertyRolesOfStakeholder
implements IPropertiesListEntry {
    private static final ILogger logger = Logger.getLogger(PropertyRolesOfStakeholder.class);
    private IFrameProjectAgent projectAgent;
    private IStakeholder stakeholder;
    private IPropertiesDialog dialog;
    private boolean mayEdit = false;
    private final Set<IStakeholderRole> rolesToAdd = new HashSet<IStakeholderRole>();
    private final Set<IStakeholderRole> rolesToRemove = new HashSet<IStakeholderRole>();
    private Image roleImage;
    private final Collection<IModificationProblem> modificationProblems = new ArrayList<IModificationProblem>();
    private Collection<IStakeholderRoleConnectionAddID> stakeholderRoleConnectionAddIDs;
    private IFrameStakeholderManager.ILockReference deleteLockReference;

    @Override
    public IModificationProblem init(ICockpitProjectData[] elements, IPropertiesDialog newDialog, boolean forCreation) {
        this.modificationProblems.clear();
        this.stakeholder = (IStakeholder)elements[0];
        this.dialog = newDialog;
        this.projectAgent = ProjectMgr.getProjectMgr().getProjectAgent(this.stakeholder.getProjectUID());
        IModificationProblem modProblem = this.projectAgent.getFrameStakeholderManager().checkStakeholderRoleConnectionChangePermission();
        if (modProblem == null) {
            this.mayEdit = true;
        } else {
            this.mayEdit = false;
            this.modificationProblems.add(modProblem);
        }
        return null;
    }

    @Override
    public void setDialog(IPropertiesDialog dialog) {
        this.dialog = dialog;
    }

    @Override
    public boolean providesPropertiesFor(ICockpitProjectData[] elements) {
        if (elements.length == 1) {
            return elements[0] instanceof IStakeholderRW;
        }
        return false;
    }

    @Override
    public String getPropertyName() {
        return Messages.getString("PropertyRolesOfStakeholder.roles");
    }

    @Override
    public Image getPropertyImage() {
        if (this.roleImage == null) {
            this.roleImage = Icons.getImageDescriptorForStakeholderRole().createImage();
        }
        return this.roleImage;
    }

    @Override
    public Composite getPropertyPage(Composite parent) {
        this.rolesToRemove.clear();
        this.rolesToAdd.clear();
        this.dialog.setTitle(String.valueOf(Messages.getString("PropertyRolesOfStakeholder.stakeholder")) + this.stakeholder.getStakeholderName(), this);
        this.dialog.setMessage(Messages.getString("PropertyRolesOfStakeholder.add_and_remove"), 0, this);
        if (this.mayEdit) {
            this.mayEdit = this.dialog.mayModify();
        }
        Composite composite = StakeholderRolesAssignmentPage.createPropertyPage(parent, this.rolesToAdd, this.rolesToRemove, this.stakeholder, this.projectAgent);
        if (!this.mayEdit) {
            int i = 0;
            while (i < composite.getChildren().length) {
                composite.getChildren()[i].setEnabled(false);
                ++i;
            }
        }
        return composite;
    }

    @Override
    public IPropertiesListEntry[] getPropertyChildren1() {
        return null;
    }

    @Override
    public boolean hasChanges() {
        return !this.rolesToAdd.isEmpty() || !this.rolesToRemove.isEmpty();
    }

    public Collection<IModificationProblem> requestCommit() {
        ArrayList<IModificationProblem> modProblems = new ArrayList<IModificationProblem>();
        if (!this.rolesToRemove.isEmpty()) {
            this.deleteLockReference = new IFrameStakeholderManager.ILockReference();
            IModificationProblem modProblem = this.projectAgent.getFrameStakeholderManager().requestStakeholderRoleConnectionDeletePermission(this.deleteLockReference);
            if (modProblem != null) {
                modProblems.add(modProblem);
            }
        }
        this.stakeholderRoleConnectionAddIDs = new ArrayList<IStakeholderRoleConnectionAddID>();
        for (IStakeholderRole roleToAdd : this.rolesToAdd) {
            IStakeholderRoleConnectionAddID stakeholderRoleConnectionAddID = this.projectAgent.getFrameStakeholderManager().requestStakeholderRoleConnectionAddPermission(this.stakeholder, roleToAdd);
            if (stakeholderRoleConnectionAddID.getModificationProblem() == null) {
                this.stakeholderRoleConnectionAddIDs.add(stakeholderRoleConnectionAddID);
                continue;
            }
            modProblems.add(stakeholderRoleConnectionAddID.getModificationProblem());
        }
        return modProblems;
    }

    @Override
    public void commitPropertyChanges1() {
        for (IStakeholderRole iStakeholderRole : this.rolesToRemove) {
            try {
                this.projectAgent.getFrameStakeholderManager().deleteStakeholderRoleConnection(this.stakeholder, iStakeholderRole);
            }
            catch (EXNoLock e) {
                logger.error("could not execute", (Throwable)e);
            }
            catch (EXNoPermission e) {
                logger.error("could not execute", (Throwable)e);
            }
        }
        for (IStakeholderRoleConnectionAddID iStakeholderRoleConnectionAddID : this.stakeholderRoleConnectionAddIDs) {
            try {
                this.projectAgent.getFrameStakeholderManager().addStakeholderRoleConnection(iStakeholderRoleConnectionAddID);
            }
            catch (EXNoPermission e) {
                logger.error("could not execute", (Throwable)e);
            }
        }
    }

    @Override
    public void rollbackCommitRequest() {
        if (this.deleteLockReference != null) {
            this.deleteLockReference.lock.release();
            this.deleteLockReference = null;
        }
        if (this.stakeholderRoleConnectionAddIDs != null) {
            for (IStakeholderRoleConnectionAddID addID : this.stakeholderRoleConnectionAddIDs) {
                addID.releaseLocks();
            }
            this.stakeholderRoleConnectionAddIDs.clear();
        }
    }

    @Override
    public void cancelPropertyChanges1() {
    }

    @Override
    public void disposeResources() {
        this.destroy();
    }

    private void destroy() {
        if (this.roleImage != null) {
            this.roleImage.dispose();
        }
        this.roleImage = null;
    }

    @Override
    public Collection<IModificationProblem> getModificationProblems() {
        return this.modificationProblems;
    }

    @Override
    public int getTypeOfPage() {
        return 40;
    }

    @Override
    public IClientFunctionLicenseType2 getRequiredLicenseTypeForModifying(ICockpitProjectData element) {
        return ClientFunctionLicenseTypeModifyRolesAndStakeholders.getInstance();
    }

    @Override
    public IClientFunctionLicenseType2 getRequiredLicenseTypeForShowing(ICockpitProjectData element) {
        return null;
    }
}

