/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.global.gui.properties.providers;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttribute;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeOwner;
import com.arcway.cockpit.client.base.interfaces.frame.permissions.EXNoPermission;
import com.arcway.cockpit.frame.client.global.Messages;
import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.global.gui.properties.IPropertiesDialog;
import com.arcway.cockpit.frame.client.global.gui.properties.IPropertiesListEntry;
import com.arcway.cockpit.frame.client.global.license.IClientFunctionLicenseType2;
import com.arcway.cockpit.frame.client.global.license.licensetypes.ClientFunctionLicenseTypeModifyUniqueElements;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.core.framedata.FrameDataTypes;
import com.arcway.cockpit.frame.client.project.core.framedata.transactionmanagement.ILocksAndPermissionsTransactionController;
import com.arcway.cockpit.frame.client.project.core.framedata.transactionmanagement.LocksAndPermissionsTransactionController;
import com.arcway.cockpit.frame.client.project.core.locking.EXNoLock;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.IUniqueElement;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.IUniqueElementRW;
import com.arcway.cockpit.frame.client.project.core.userdefinedattributetypes.AttributeTypesComposite;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.ui.IModificationProblem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.jface.dialogs.DialogTray;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.help.IWorkbenchHelpSystem;

public class PropertyGeneralUniqueElement
implements IPropertiesListEntry {
    private static final ILogger logger = Logger.getLogger(PropertyGeneralUniqueElement.class);
    private IUniqueElement uniqueElement;
    private IFrameProjectAgent projectAgent;
    private AttributeTypesComposite attributeTypesComposite;
    private IPropertiesDialog dialog;
    private ILocksAndPermissionsTransactionController transactionController;
    private Collection<IAttribute> newAttributes;

    @Override
    public IModificationProblem init(ICockpitProjectData[] elements, IPropertiesDialog newDialog, boolean forCreation) {
        this.uniqueElement = (IUniqueElement)elements[0];
        this.projectAgent = ProjectMgr.getProjectMgr().getProjectAgent(this.uniqueElement.getProjectUID());
        this.setDialog(newDialog);
        return null;
    }

    @Override
    public void setDialog(IPropertiesDialog dialog) {
        this.dialog = dialog;
    }

    @Override
    public boolean providesPropertiesFor(ICockpitProjectData[] elements) {
        if (elements.length == 1) {
            return elements[0] instanceof IUniqueElement;
        }
        return false;
    }

    @Override
    public String getPropertyName() {
        return Messages.getString("PropertyGeneral.General_1");
    }

    @Override
    public Image getPropertyImage() {
        return FrameDataTypes.getDataType("com.arcway.cockpit.uniqueelement").getIcon();
    }

    @Override
    public Composite getPropertyPage(Composite parent) {
        this.dialog.setTitle(this.uniqueElement.getElementName(), this);
        this.dialog.setMessage(Messages.getString("PropertyGeneral.Shows_all_general_properties_of_this__2"), 0, this);
        IWorkbenchHelpSystem helpSystem = this.dialog.getWorkbenchPage().getWorkbenchWindow().getWorkbench().getHelpSystem();
        if (this.dialog instanceof TrayDialog) {
            DialogTray tray = ((TrayDialog)this.dialog).getTray();
            if (tray != null) {
                helpSystem.displayHelp("com.arcway.cockpit.frame.help.properties_dialog");
            } else {
                helpSystem.setHelp((Control)this.dialog.getShell(), "com.arcway.cockpit.frame.help.properties_dialog");
            }
        }
        this.attributeTypesComposite = new AttributeTypesComposite((IAttributeOwner)this.uniqueElement, parent, true, false, false, this.dialog, this);
        this.attributeTypesComposite.create(new GridData(1808));
        return this.attributeTypesComposite.getComposite();
    }

    @Override
    public IPropertiesListEntry[] getPropertyChildren1() {
        return null;
    }

    @Override
    public boolean hasChanges() {
        return this.attributeTypesComposite.isModified();
    }

    @Override
    public void commitPropertyChanges1() {
        if (this.uniqueElement instanceof IUniqueElementRW) {
            IUniqueElementRW rw = (IUniqueElementRW)this.uniqueElement;
            if (this.newAttributes != null) {
                for (IAttribute attribute : this.newAttributes) {
                    try {
                        rw.setAttribute(attribute);
                    }
                    catch (EXNoPermission e) {
                        logger.error("could not execute", (Throwable)e);
                    }
                    catch (EXNoLock e) {
                        logger.error("could not execute", (Throwable)e);
                    }
                }
            }
        }
        this.transactionController = null;
        this.newAttributes = null;
    }

    public Collection<IModificationProblem> requestCommit() {
        Collection<IModificationProblem> modProblems = new ArrayList<IModificationProblem>();
        if (this.uniqueElement instanceof IUniqueElementRW) {
            IUniqueElementRW rw = (IUniqueElementRW)this.uniqueElement;
            this.transactionController = new LocksAndPermissionsTransactionController(this.projectAgent);
            this.newAttributes = this.attributeTypesComposite.getNewAttributes();
            for (IAttribute attribute : this.newAttributes) {
                rw.requestAttributeModificationPermission(attribute, this.transactionController);
            }
            modProblems = this.transactionController.execute();
        }
        return modProblems;
    }

    @Override
    public void rollbackCommitRequest() {
        if (this.transactionController != null) {
            this.transactionController.rollback();
        }
        this.transactionController = null;
        this.newAttributes = null;
    }

    @Override
    public void cancelPropertyChanges1() {
    }

    @Override
    public void disposeResources() {
        if (this.attributeTypesComposite != null) {
            this.attributeTypesComposite.dispose();
        }
    }

    @Override
    public int getTypeOfPage() {
        return 0;
    }

    @Override
    public Collection<IModificationProblem> getModificationProblems() {
        if (this.attributeTypesComposite != null) {
            return this.attributeTypesComposite.getModificationProblems(true);
        }
        return Collections.emptyList();
    }

    @Override
    public IClientFunctionLicenseType2 getRequiredLicenseTypeForModifying(ICockpitProjectData element) {
        return ClientFunctionLicenseTypeModifyUniqueElements.getInstance();
    }

    @Override
    public IClientFunctionLicenseType2 getRequiredLicenseTypeForShowing(ICockpitProjectData element) {
        return null;
    }
}

