/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.global.gui.properties.providers;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttribute;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeOwner;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeTypeID;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.ObjectTypeCategoryID;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.stakeholders.IStakeholder;
import com.arcway.cockpit.client.base.interfaces.frame.permissions.EXNoPermission;
import com.arcway.cockpit.frame.client.global.Icons;
import com.arcway.cockpit.frame.client.global.Messages;
import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.global.gui.dialogs.ChoosePermissionOwnerDialog;
import com.arcway.cockpit.frame.client.global.gui.properties.IPropertiesDialog;
import com.arcway.cockpit.frame.client.global.gui.properties.IPropertiesListEntry;
import com.arcway.cockpit.frame.client.global.gui.properties.providers.AbstractPropertyGeneralWithCategorySelection;
import com.arcway.cockpit.frame.client.global.gui.properties.providers.AttributeTextField;
import com.arcway.cockpit.frame.client.global.gui.validators.RenameStakeholderValidator;
import com.arcway.cockpit.frame.client.global.license.IClientFunctionLicenseType2;
import com.arcway.cockpit.frame.client.global.license.licensetypes.ClientFunctionLicenseTypeModifyRolesAndStakeholders;
import com.arcway.cockpit.frame.client.project.core.framedata.Attribute;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.DataTypeString;
import com.arcway.cockpit.frame.client.project.core.framedata.transactionmanagement.ILocksAndPermissionsTransactionController;
import com.arcway.cockpit.frame.client.project.core.framedata.transactionmanagement.LocksAndPermissionsTransactionController;
import com.arcway.cockpit.frame.client.project.core.locking.EXNoLock;
import com.arcway.cockpit.frame.client.project.core.stakeholders.IStakeholderRW;
import com.arcway.cockpit.frame.client.project.core.stakeholders.StakeholderAttributeTypesProvider;
import com.arcway.cockpit.frame.shared.userdefinedattributes.ExInvalidAttributeType;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.lib.eclipse.gui.LineSeparator;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.ui.IModificationProblem;
import com.arcway.lib.ui.editor.ObjectTypeCategoryLabels;
import de.plans.psc.shared.message.EOUser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.jface.dialogs.DialogTray;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.help.IWorkbenchHelpSystem;

public class PropertyGeneralStakeholder
extends AbstractPropertyGeneralWithCategorySelection {
    private static final ILogger logger = Logger.getLogger(PropertyGeneralStakeholder.class);
    private IStakeholder stakeholder;
    private RenameStakeholderValidator nameValidator;
    private Image stakeholderImage;
    private Collection<AttributeTextField> attributeFields;
    private AttributeTextField attributeFieldName;
    private Button selectUserButton;
    private ILocksAndPermissionsTransactionController transactionController;
    private Collection<IAttribute> newAttributes;
    private Combo categoryCombo;
    private Collection<IModificationProblem> initialCategoryModificationProblems;

    @Override
    public IModificationProblem init_internal(ICockpitProjectData element, boolean forCreation) {
        this.stakeholder = (IStakeholder)element;
        this.nameValidator = new RenameStakeholderValidator(this.projectAgent);
        this.nameValidator.setStakeholder(this.stakeholder);
        return null;
    }

    @Override
    public boolean providesPropertiesFor(ICockpitProjectData[] elements) {
        if (elements.length == 1) {
            return elements[0] instanceof IStakeholderRW;
        }
        return false;
    }

    @Override
    public String getPropertyName() {
        return Messages.getString("PropertyGeneralStakeholder.general");
    }

    @Override
    public Image getPropertyImage() {
        if (this.stakeholderImage == null) {
            this.stakeholderImage = Icons.getImageDescriptorForStakeholder().createImage();
        }
        return this.stakeholderImage;
    }

    @Override
    public Composite getPropertyPage_internal(Composite parent) {
        IPropertiesDialog dialog = this.getDialog();
        this.attributeFields = new ArrayList<AttributeTextField>();
        dialog.setMessage(Messages.getString("PropertyGeneralStakeholder.view_and_admin"), 0, this);
        IWorkbenchHelpSystem helpSystem = dialog.getWorkbenchPage().getWorkbenchWindow().getWorkbench().getHelpSystem();
        if (dialog instanceof TrayDialog) {
            DialogTray tray = ((TrayDialog)dialog).getTray();
            if (tray != null) {
                helpSystem.displayHelp("com.arcway.cockpit.frame.help.properties_dialog");
            } else {
                helpSystem.setHelp((Control)dialog.getShell(), "com.arcway.cockpit.frame.help.properties_dialog");
            }
        }
        Composite grpDetails = new Composite(parent, 0);
        grpDetails.setLayoutData((Object)new GridData(1808));
        grpDetails.setLayout((Layout)new GridLayout(3, false));
        Label label = new Label(grpDetails, 256);
        GridDataFactory.fillDefaults().align(4, 2).grab(false, false).applyTo((Control)label);
        label.setText(String.valueOf(ObjectTypeCategoryLabels.LABEL_CATEGORY) + ":");
        this.categoryCombo = new Combo(grpDetails, 12);
        GridDataFactory.fillDefaults().align(4, 2).grab(true, false).applyTo((Control)this.categoryCombo);
        LineSeparator line = new LineSeparator(grpDetails, 0);
        GridDataFactory.fillDefaults().align(4, 2).grab(true, false).span(3, 1).applyTo((Control)line);
        Label space = new Label(grpDetails, 0);
        GridDataFactory.fillDefaults().align(4, 2).grab(true, false).span(3, 1).applyTo((Control)space);
        Label detailNameLabel = new Label(grpDetails, 0);
        detailNameLabel.setLayoutData((Object)new GridData());
        detailNameLabel.setText(Messages.getString("StakeholdersAdminDialog.Name_10"));
        Text detailNameText = new Text(grpDetails, 2048);
        detailNameText.setLayoutData((Object)new GridData(768));
        AttributeTextField af = new AttributeTextField((IAttributeOwner)this.stakeholder, this.stakeholder.getAttributeType(StakeholderAttributeTypesProvider.ATTRID_NAME), detailNameText, dialog);
        this.attributeFields.add(af);
        this.attributeFieldName = af;
        Label dummy = new Label(grpDetails, 0);
        dummy.setVisible(false);
        Label detailUserLabel = new Label(grpDetails, 0);
        detailUserLabel.setLayoutData((Object)new GridData());
        detailUserLabel.setText(Messages.getString("StakeholdersAdminDialog.Server_User_11"));
        Text detailUserText = new Text(grpDetails, 2048);
        try {
            af = new AttributeTextField((IAttributeOwner)this.stakeholder, this.stakeholder.getAttributeType(StakeholderAttributeTypesProvider.ATTRID_USERNAME), detailUserText, dialog);
            this.attributeFields.add(af);
            detailUserText.setEnabled(ProjectMgr.getProjectMgr().getProjectManagerServerProxy(this.projectAgent.getServerID()).arePermissionsNeeded() && detailUserText.isEnabled());
        }
        catch (ExInvalidAttributeType e3) {
            logger.error("could not execute", (Throwable)e3);
        }
        detailUserText.setLayoutData((Object)new GridData(768));
        this.selectUserButton = new Button(grpDetails, 0);
        this.selectUserButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                PropertyGeneralStakeholder.this.getUserFromList();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.selectUserButton.setEnabled(false);
        this.selectUserButton.setLayoutData((Object)new GridData());
        this.selectUserButton.setText("...");
        Label detailCompanyLabel = new Label(grpDetails, 0);
        detailCompanyLabel.setLayoutData((Object)new GridData());
        detailCompanyLabel.setText(Messages.getString("StakeholdersAdminDialog.Company_2"));
        Text detailCompanyText = new Text(grpDetails, 2048);
        detailCompanyText.setLayoutData((Object)new GridData(768));
        try {
            af = new AttributeTextField((IAttributeOwner)this.stakeholder, this.stakeholder.getAttributeType(StakeholderAttributeTypesProvider.ATTRID_COMPANY), detailCompanyText, dialog);
            this.attributeFields.add(af);
        }
        catch (ExInvalidAttributeType e3) {
            logger.error("could not execute", (Throwable)e3);
        }
        dummy = new Label(grpDetails, 0);
        dummy.setVisible(false);
        Label detailPhoneLabel = new Label(grpDetails, 0);
        detailPhoneLabel.setLayoutData((Object)new GridData());
        detailPhoneLabel.setText(Messages.getString("StakeholdersAdminDialog.Telephone_3"));
        Text detailTelephoneText = new Text(grpDetails, 2048);
        detailTelephoneText.setLayoutData((Object)new GridData(768));
        try {
            af = new AttributeTextField((IAttributeOwner)this.stakeholder, this.stakeholder.getAttributeType(StakeholderAttributeTypesProvider.ATTRID_PHONE), detailTelephoneText, dialog);
            this.attributeFields.add(af);
        }
        catch (ExInvalidAttributeType e3) {
            logger.error("could not execute", (Throwable)e3);
        }
        dummy = new Label(grpDetails, 0);
        dummy.setVisible(false);
        Label detailFaxLabel = new Label(grpDetails, 0);
        detailFaxLabel.setLayoutData((Object)new GridData());
        detailFaxLabel.setText(Messages.getString("StakeholdersAdminDialog.Fax_4"));
        Text detailFaxText = new Text(grpDetails, 2048);
        detailFaxText.setLayoutData((Object)new GridData(768));
        try {
            af = new AttributeTextField((IAttributeOwner)this.stakeholder, this.stakeholder.getAttributeType(StakeholderAttributeTypesProvider.ATTRID_FAX), detailFaxText, dialog);
            this.attributeFields.add(af);
        }
        catch (ExInvalidAttributeType e3) {
            logger.error("could not execute", (Throwable)e3);
        }
        dummy = new Label(grpDetails, 0);
        dummy.setVisible(false);
        Label detailEMailLabel = new Label(grpDetails, 0);
        detailEMailLabel.setLayoutData((Object)new GridData());
        detailEMailLabel.setText(Messages.getString("StakeholdersAdminDialog.EMail_13"));
        Text detailEMailText = new Text(grpDetails, 2048);
        detailEMailText.setLayoutData((Object)new GridData(768));
        try {
            af = new AttributeTextField((IAttributeOwner)this.stakeholder, this.stakeholder.getAttributeType(StakeholderAttributeTypesProvider.ATTRID_EMAIL), detailEMailText, dialog);
            this.attributeFields.add(af);
        }
        catch (ExInvalidAttributeType e3) {
            logger.error("could not execute", (Throwable)e3);
        }
        dummy = new Label(grpDetails, 0);
        dummy.setVisible(false);
        Label detailAddressLabel = new Label(grpDetails, 0);
        detailAddressLabel.setLayoutData((Object)new GridData());
        detailAddressLabel.setText(Messages.getString("StakeholdersAdminDialog.Address_5"));
        Text detailAddressText = new Text(grpDetails, 2626);
        GridData data = new GridData(1808);
        data.heightHint = 50;
        detailAddressText.setLayoutData((Object)data);
        try {
            af = new AttributeTextField((IAttributeOwner)this.stakeholder, this.stakeholder.getAttributeType(StakeholderAttributeTypesProvider.ATTRID_ADDRESS), detailAddressText, dialog);
            this.attributeFields.add(af);
        }
        catch (ExInvalidAttributeType e2) {
            logger.error("could not execute", (Throwable)e2);
        }
        dummy = new Label(grpDetails, 0);
        dummy.setVisible(false);
        Label detailDescriptionLabel = new Label(grpDetails, 128);
        GridData detailDescriptionLabelData = new GridData();
        detailDescriptionLabelData.verticalAlignment = 2;
        detailDescriptionLabel.setLayoutData((Object)detailDescriptionLabelData);
        Text detailDescriptionText = new Text(grpDetails, 2626);
        data = new GridData(1808);
        data.heightHint = 50;
        detailDescriptionText.setLayoutData((Object)data);
        try {
            af = new AttributeTextField((IAttributeOwner)this.stakeholder, this.stakeholder.getAttributeType(StakeholderAttributeTypesProvider.ATTRID_DESCRIPTION), detailDescriptionText, dialog);
            detailDescriptionLabel.setText(af.getAttributeTypeDisplayName());
            this.attributeFields.add(af);
        }
        catch (ExInvalidAttributeType e1) {
            logger.error("could not execute", (Throwable)e1);
        }
        dummy = new Label(grpDetails, 0);
        dummy.setVisible(false);
        this.setOriginalValues();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)grpDetails, "com.arcway.cockpit.frame.help.admin_stakeholderadmindialog");
        if (this.stakeholder instanceof IStakeholderRW) {
            this.initialCategoryModificationProblems = ((IStakeholderRW)this.stakeholder).checkObjectTypeCategoryModificationPermission();
        }
        return grpDetails;
    }

    @Override
    public Collection<IModificationProblem> getModificationProblems() {
        ArrayList<IModificationProblem> problems = new ArrayList<IModificationProblem>();
        if (this.attributeFields != null) {
            for (AttributeTextField field : this.attributeFields) {
                problems.addAll(field.getModificationProblems());
            }
        }
        if (this.initialCategoryModificationProblems != null) {
            problems.addAll(this.initialCategoryModificationProblems);
        }
        return problems;
    }

    private void refresh() {
        IPropertiesDialog dialog = this.getDialog();
        dialog.setTitle(String.valueOf(Messages.getString("PropertyGeneralStakeholder.stakeholder")) + this.stakeholder.getStakeholderName(), this);
        String error = this.nameValidator.isValid(DataTypeString.getInstanceString().getValueAsSingleLineString(this.attributeFieldName.getText(), null, null, null));
        if (error != null) {
            error = String.valueOf(Messages.getString("PropertyGeneralStakeholder.attributes_cannot_be_changed")) + error;
            dialog.setMessage(error, 3, this);
            dialog.setIsCommitable(false, this);
        }
        AttributeTextField af = this.getAttributeField(StakeholderAttributeTypesProvider.ATTRID_USERNAME);
        this.selectUserButton.setEnabled(ProjectMgr.getProjectMgr().getProjectManagerServerProxy(this.projectAgent.getServerID()).arePermissionsNeeded() && af.mayModifyInGeneral());
    }

    private void getUserFromList() {
        Object[] serverUsers;
        ChoosePermissionOwnerDialog chooseUserDialog = new ChoosePermissionOwnerDialog(this.getDialog().getShell(), this.projectAgent, Messages.getString("PropertyGeneralStakeholder.select_user"), Messages.getString("PropertyGeneralStakeholder.select_existing_user"), 0, true);
        chooseUserDialog.setBlockOnOpen(true);
        int ok = chooseUserDialog.open();
        if (ok == 0 && (serverUsers = chooseUserDialog.getResult()).length > 0) {
            EOUser user = (EOUser)serverUsers[0];
            AttributeTextField af = this.getAttributeField(StakeholderAttributeTypesProvider.ATTRID_USERNAME);
            if (af.getModificationProblems().isEmpty()) {
                af.setText(user.getUserName());
            }
            if ((af = this.getAttributeField(StakeholderAttributeTypesProvider.ATTRID_DESCRIPTION)).getModificationProblems().isEmpty()) {
                af.setText(user.getDescription());
            }
            if ((af = this.getAttributeField(StakeholderAttributeTypesProvider.ATTRID_EMAIL)).getModificationProblems().isEmpty()) {
                af.setText(user.getEmail());
            }
        }
    }

    private AttributeTextField getAttributeField(IAttributeTypeID attributeTypeID) {
        for (AttributeTextField af : this.attributeFields) {
            if (!af.getAttributeTypeID().equals(attributeTypeID)) continue;
            return af;
        }
        return null;
    }

    @Override
    public IPropertiesListEntry[] getPropertyChildren1() {
        return null;
    }

    @Override
    public boolean hasChanges() {
        for (AttributeTextField af : this.attributeFields) {
            if (!af.isModified()) continue;
            return true;
        }
        return this.isCategoryChanged();
    }

    @Override
    public void commitPropertyChanges1() {
        if (this.stakeholder instanceof IStakeholderRW) {
            IStakeholderRW rw = (IStakeholderRW)this.stakeholder;
            if (this.newAttributes != null) {
                for (IAttribute attribute : this.newAttributes) {
                    try {
                        rw.setAttribute(attribute);
                    }
                    catch (EXNoPermission e) {
                        logger.error("could not execute", (Throwable)e);
                    }
                    catch (EXNoLock e) {
                        logger.error("could not execute", (Throwable)e);
                    }
                }
            }
            if (this.isCategoryChanged()) {
                try {
                    rw.setCategoryID(this.getSelectedCategoryID());
                }
                catch (EXNoPermission e) {
                    logger.error("could not execute", (Throwable)e);
                }
                catch (EXNoLock e) {
                    logger.error("could not execute", (Throwable)e);
                }
            }
        }
    }

    public Collection<IModificationProblem> requestCommit() {
        Collection<IModificationProblem> modProblems = Collections.emptyList();
        if (this.stakeholder instanceof IStakeholderRW) {
            IStakeholderRW rw = (IStakeholderRW)this.stakeholder;
            this.newAttributes = new ArrayList<IAttribute>();
            for (AttributeTextField af : this.attributeFields) {
                if (!af.isModified()) continue;
                Attribute newAttribute = new Attribute(af.getAttributeTypeID(), af.getText());
                this.newAttributes.add(newAttribute);
            }
            this.transactionController = new LocksAndPermissionsTransactionController(this.projectAgent);
            for (IAttribute attribute : this.newAttributes) {
                rw.requestAttributeModificationPermission(attribute, this.transactionController);
            }
            if (this.isCategoryChanged()) {
                rw.requestObjectTypeCategoryModificationPermission(this.transactionController);
            }
            modProblems = this.transactionController.execute();
        }
        return modProblems;
    }

    @Override
    public void rollbackCommitRequest() {
        if (this.transactionController != null) {
            this.transactionController.rollback();
        }
        this.transactionController = null;
        this.newAttributes = null;
    }

    @Override
    public void cancelPropertyChanges1() {
    }

    @Override
    public void disposeResources() {
        this.destroy();
    }

    private void destroy() {
        if (this.stakeholderImage != null) {
            this.stakeholderImage.dispose();
        }
        this.stakeholderImage = null;
        this.transactionController = null;
        this.newAttributes = null;
    }

    private void setOriginalValues() {
        for (AttributeTextField af : this.attributeFields) {
            af.reset();
        }
        this.refresh();
    }

    @Override
    public IClientFunctionLicenseType2 getRequiredLicenseTypeForModifying(ICockpitProjectData element) {
        return ClientFunctionLicenseTypeModifyRolesAndStakeholders.getInstance();
    }

    @Override
    public IClientFunctionLicenseType2 getRequiredLicenseTypeForShowing(ICockpitProjectData element) {
        return null;
    }

    @Override
    protected Combo getCategoryCombo() {
        return this.categoryCombo;
    }

    @Override
    protected ObjectTypeCategoryID getCategoryIDFromAttributeOwner() {
        return this.stakeholder.getCategoryID();
    }

    @Override
    protected boolean hasCategoryChangePermission() {
        if (this.initialCategoryModificationProblems != null) {
            return this.initialCategoryModificationProblems.isEmpty();
        }
        return false;
    }
}

