/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.frame.client.global.gui.properties.providers;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttribute;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IAttributeType;
import com.arcway.cockpit.client.base.interfaces.frame.permissions.EXNoPermission;
import com.arcway.cockpit.frame.client.global.Messages;
import com.arcway.cockpit.frame.client.global.gui.properties.IPropertiesDialog;
import com.arcway.cockpit.frame.client.global.gui.properties.IPropertiesListEntry;
import com.arcway.cockpit.frame.client.global.license.IClientFunctionLicenseType2;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.Project;
import com.arcway.cockpit.frame.client.project.ProjectAttributeTypeProvider;
import com.arcway.cockpit.frame.client.project.core.framedata.FrameDataTypes;
import com.arcway.cockpit.frame.client.project.core.framedata.transactionmanagement.ILocksAndPermissionsTransactionController;
import com.arcway.cockpit.frame.client.project.core.framedata.transactionmanagement.LocksAndPermissionsTransactionController;
import com.arcway.cockpit.frame.client.project.core.locking.EXNoLock;
import com.arcway.cockpit.frame.client.project.core.userdefinedattributetypes.AttributeTypesComposite;
import com.arcway.cockpit.frame.shared.userdefinedattributes.ExInvalidAttributeType;
import com.arcway.cockpit.frame.shared.userdefinedattributes.ExInvalidDataType;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.ui.IModificationProblem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.jface.dialogs.DialogTray;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.help.IWorkbenchHelpSystem;

public class PropertyGeneralProject
implements IPropertiesListEntry {
    private static final ILogger logger = Logger.getLogger(PropertyGeneralProject.class);
    private IFrameProjectAgent projectAgent;
    private IPropertiesDialog dialog;
    private AttributeTypesComposite attributeTypesComposite;
    private ILocksAndPermissionsTransactionController transactionController;
    private Collection<IAttribute> newAttributes;

    @Override
    public IModificationProblem init(ICockpitProjectData[] elements, IPropertiesDialog newDialog, boolean forCreation) {
        this.projectAgent = (IFrameProjectAgent)elements[0];
        this.setDialog(newDialog);
        return null;
    }

    @Override
    public void setDialog(IPropertiesDialog dialog) {
        this.dialog = dialog;
    }

    @Override
    public boolean providesPropertiesFor(ICockpitProjectData[] elements) {
        if (elements.length == 1 && elements[0] instanceof IFrameProjectAgent) {
            IFrameProjectAgent p = (IFrameProjectAgent)elements[0];
            return p.isOpened();
        }
        return false;
    }

    @Override
    public String getPropertyName() {
        return Messages.getString("PropertyGeneral.General_1");
    }

    @Override
    public Image getPropertyImage() {
        return FrameDataTypes.getDataType("frame.project").getIcon();
    }

    @Override
    public Composite getPropertyPage(Composite parent) {
        Project project = this.projectAgent.getProjectMetaDataManager().getProject();
        this.dialog.setTitle(project.getName(), this);
        this.dialog.setMessage(Messages.getString("PropertyGeneral.Shows_all_general_properties_of_this__2"), 0, this);
        IWorkbenchHelpSystem helpSystem = this.dialog.getWorkbenchPage().getWorkbenchWindow().getWorkbench().getHelpSystem();
        if (this.dialog instanceof TrayDialog) {
            DialogTray tray = ((TrayDialog)this.dialog).getTray();
            if (tray != null) {
                helpSystem.displayHelp("com.arcway.cockpit.frame.help.properties_dialog");
            } else {
                helpSystem.setHelp((Control)this.dialog.getShell(), "com.arcway.cockpit.frame.help.properties_dialog");
            }
        }
        ArrayList<IAttributeType> attributeTypesToShow = new ArrayList<IAttributeType>();
        attributeTypesToShow.add(project.getAttributeType(ProjectAttributeTypeProvider.ATTRID_NAME));
        attributeTypesToShow.add(project.getAttributeType(ProjectAttributeTypeProvider.ATTRID_DESCRIPTION));
        this.attributeTypesComposite = new AttributeTypesComposite(project, parent, attributeTypesToShow, false, this.dialog, this);
        this.attributeTypesComposite.create(new GridData(1808));
        return this.attributeTypesComposite.getComposite();
    }

    @Override
    public IPropertiesListEntry[] getPropertyChildren1() {
        return null;
    }

    @Override
    public boolean hasChanges() {
        return this.attributeTypesComposite.isModified();
    }

    public Collection<IModificationProblem> requestCommit() {
        Collection<IModificationProblem> modProblems = Collections.emptyList();
        if (this.attributeTypesComposite.isModified()) {
            this.transactionController = new LocksAndPermissionsTransactionController(this.projectAgent);
            this.newAttributes = this.attributeTypesComposite.getNewAttributes();
            Project project = this.projectAgent.getProjectMetaDataManager().getProject();
            for (IAttribute attribute : this.newAttributes) {
                project.requestAttributeModificationPermission(attribute, this.transactionController);
            }
            modProblems = this.transactionController.execute();
        }
        return modProblems;
    }

    @Override
    public void commitPropertyChanges1() {
        if (this.newAttributes != null) {
            Project project = this.projectAgent.getProjectMetaDataManager().getProject();
            for (IAttribute attribute : this.newAttributes) {
                try {
                    project.setAttribute(attribute);
                }
                catch (ExInvalidAttributeType e) {
                    logger.error("could not execute", (Throwable)e);
                }
                catch (ExInvalidDataType e) {
                    logger.error("could not execute", (Throwable)e);
                }
                catch (EXNoPermission e) {
                    logger.error("could not execute", (Throwable)e);
                }
                catch (EXNoLock e) {
                    logger.error("could not execute", (Throwable)e);
                }
            }
        }
        this.transactionController = null;
        this.newAttributes = null;
    }

    @Override
    public void rollbackCommitRequest() {
        if (this.transactionController != null) {
            this.transactionController.rollback();
        }
        this.transactionController = null;
        this.newAttributes = null;
    }

    @Override
    public void cancelPropertyChanges1() {
    }

    @Override
    public void disposeResources() {
        if (this.attributeTypesComposite != null) {
            this.attributeTypesComposite.dispose();
        }
    }

    @Override
    public int getTypeOfPage() {
        return 0;
    }

    @Override
    public Collection<IModificationProblem> getModificationProblems() {
        return this.attributeTypesComposite.getModificationProblems(true);
    }

    @Override
    public IClientFunctionLicenseType2 getRequiredLicenseTypeForModifying(ICockpitProjectData element) {
        return null;
    }

    @Override
    public IClientFunctionLicenseType2 getRequiredLicenseTypeForShowing(ICockpitProjectData element) {
        return null;
    }
}

